/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.server;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GHtmlRoot;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPreRenderedElement;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.popup.PopupModelFactory;
import org.eclipse.glsp.server.features.popup.RequestPopupModelAction;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GpioCfgPopupModelFactory
implements PopupModelFactory {
    @Inject
    protected GpioCfgModelState modelState;
    private static final String NL = "<br/>";

    public Pin lookupPin(GModelElement element) {
        Optional selectedPinConfigs = this.modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> Pin.class.isInstance(it);
        java.util.function.Function<EObject, Pin> _function_1 = it -> (Pin)Pin.class.cast(it);
        Optional<Pin> ps = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        return ps.orElse(null);
    }

    public PinSetting lookupPinSetting(GModelElement element) {
        Optional selectedPinConfigs = this.modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> Pin.class.isInstance(it);
        java.util.function.Function<EObject, Pin> _function_1 = it -> (Pin)Pin.class.cast(it);
        Optional<Pin> selectedPin = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        boolean _isPresent = selectedPin.isPresent();
        if (_isPresent) {
            PinConfiguration config = this.modelState.getPinConfiguration();
            Functions.Function1 _function_2 = it -> it.getPin().getName().equals(((Pin)selectedPin.get()).getName());
            PinSetting ps = (PinSetting)IterableExtensions.findFirst((Iterable)GpioCfgHelper.getAllPinSettings((PinConfiguration)config), (Functions.Function1)_function_2);
            return ps;
        }
        return null;
    }

    public String generateBody(Pin pin, PinSetting ps) {
        HashMap pinMap;
        HashMap tooltipMap;
        Function fct;
        String _xblockexpression = null;
        if (pin == null) {
            return null;
        }
        String psPeriph = "";
        String psFct = "";
        if (ps != null && (fct = ps.getConfig().getAlt()) != null) {
            psFct = fct.getName();
            psPeriph = fct.getPeripheralRef().getLabel();
        }
        if ((tooltipMap = (HashMap)(pinMap = new HashMap()).get(pin)) == null) {
            HashMap _hashMap = new HashMap();
            pinMap.put(pin, _hashMap);
            tooltipMap = (HashMap)pinMap.get(pin);
        }
        Object tooltips = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            Object tooltip = "";
            String periph = "";
            if (cfg instanceof SystemFunctionPin) {
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                periph = "System";
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip = tooltip;
                String _label = sfp.getRef().getLabel();
                String _plus = _label + " (";
                String _name = sfp.getDirection().getName();
                String _plus_1 = _plus + _name;
                String _plus_2 = _plus_1 + ")";
                String _plus_3 = _plus_2 + NL;
                tooltip = _oltip + _plus_3;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof SpecialPin) {
                SpecialPin sp = (SpecialPin)cfg;
                periph = "Special";
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip_1 = tooltip;
                String _label_1 = sp.getRef().getLabel();
                String _plus_4 = _label_1 + " (";
                String _name_1 = sp.getDirection().getName();
                String _plus_5 = _plus_4 + _name_1;
                String _plus_6 = _plus_5 + ")";
                Object _oltip_2 = tooltip = _oltip_1 + _plus_6;
                tooltip = (String)_oltip_2 + NL;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof ConfigurablePin) {
                Object _plus_10;
                boolean _lessThan;
                ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
                int _length = ((String)tooltips).length();
                boolean bl = _lessThan = _length < 1;
                if (_lessThan) {
                    String _name_2 = pin.getName();
                    String _plus_7 = "<b>" + _name_2;
                    String _plus_8 = _plus_7 + ": ";
                    String _label_2 = sfp_1.getRef().getLabel();
                    String _plus_9 = _plus_8 + _label_2;
                    tooltips = _plus_10 = _plus_9 + "</b><br/><pre>";
                }
                String functionName = psFct;
                Predicate<FunctionRef> _function = it -> it.getName().getName().equals(functionName);
                Optional<FunctionRef> configuredFunction = sfp_1.getRef().getFunctions().stream().filter(_function).findFirst();
                LinkedHashMap<String, List> alternateFunctions = new LinkedHashMap<String, List>();
                EList _functions = ((ConfigurablePin)cfg).getRef().getFunctions();
                _plus_10 = _functions.iterator();
                while (_plus_10.hasNext()) {
                    FunctionRef daf = (FunctionRef)_plus_10.next();
                    String _alt = daf.getAlt();
                    boolean _tripleNotEquals = _alt != null;
                    if (!_tripleNotEquals) continue;
                    List af = (List)alternateFunctions.get(daf.getAlt());
                    if (af == null) {
                        af = CollectionLiterals.newArrayList();
                        alternateFunctions.put(daf.getAlt(), af);
                    }
                    af.add(daf.getName());
                }
                boolean _isPresent = configuredFunction.isPresent();
                if (_isPresent) {
                    String configuredFunctionName = configuredFunction.get().getName().getName();
                    Iterator _function_1 = it -> this.isSelectedFunction((Map<String, List<Function>>)alternateFunctions, (FunctionRef)it, (FunctionRef)configuredFunction.get());
                    Iterable directAnalogFunctions = IterableExtensions.filter((Iterable)sfp_1.getRef().getFunctions(), (Functions.Function1)_function_1);
                    EList _functions_1 = sfp_1.getRef().getFunctions();
                    for (FunctionRef c : _functions_1) {
                        boolean _contains;
                        String fctName = c.getName().getName();
                        periph = c.getName().getPeripheralRef().getLabel();
                        Object t = (String)tooltipMap.get(periph);
                        if (t == null) {
                            tooltipMap.put(periph, "");
                            t = (String)tooltipMap.get(periph);
                        }
                        if (_contains = IterableExtensions.contains((Iterable)directAnalogFunctions, (Object)c)) {
                            String _t = t;
                            Direction _direction = c.getDirection();
                            String _plus_11 = "&#160;&#160;&#160;<b>(" + String.valueOf(_direction);
                            String _plus_12 = _plus_11 + ") ";
                            String _plus_13 = _plus_12 + fctName;
                            String _plus_14 = _plus_13 + "</b><br/>";
                            t = _t + _plus_14;
                        } else {
                            boolean _equals = configuredFunctionName.equals(fctName);
                            if (_equals) {
                                String _t_1 = t;
                                Direction _direction_1 = c.getDirection();
                                String _plus_15 = "&#160;&#160;&#160;<b>(" + String.valueOf(_direction_1);
                                String _plus_16 = _plus_15 + ") ";
                                String _plus_17 = _plus_16 + fctName;
                                String _plus_18 = _plus_17 + "</b><br/>";
                                t = _t_1 + _plus_18;
                            } else {
                                String _t_2 = t;
                                Direction _direction_2 = c.getDirection();
                                String _plus_19 = "&#160;&#160;&#160;(" + String.valueOf(_direction_2);
                                String _plus_20 = _plus_19 + ") ";
                                String _plus_21 = _plus_20 + fctName;
                                String _plus_22 = _plus_21 + NL;
                                t = _t_2 + _plus_22;
                            }
                        }
                        tooltipMap.put(periph, t);
                    }
                } else {
                    EList _functions_2 = sfp_1.getRef().getFunctions();
                    for (FunctionRef c_1 : _functions_2) {
                        periph = c_1.getName().getPeripheralRef().getLabel();
                        Object t = (String)tooltipMap.get(periph);
                        if (t == null) {
                            tooltipMap.put(periph, "");
                            t = (String)tooltipMap.get(periph);
                        }
                        String fctName = c_1.getName().getName();
                        String _t = t;
                        Direction _direction = c_1.getDirection();
                        String _plus_11 = "&#160;&#160;&#160;(" + String.valueOf(_direction);
                        String _plus_12 = _plus_11 + ") ";
                        String _plus_13 = _plus_12 + fctName;
                        String _plus_14 = _plus_13 + NL;
                        t = _t + _plus_14;
                        tooltipMap.put(periph, t);
                    }
                }
                Object _oltip_3 = tooltip;
                String _get = (String)tooltipMap.get(periph);
                tooltip = (String)_oltip_3 + _get;
                Object _oltips = tooltips;
                tooltips = (String)_oltips + "</pre>";
                continue;
            }
            String _oltip_4 = tooltip;
            String _string = cfg.toString();
            String _plus_11 = "&#160;&#160;&#160;" + _string;
            String _plus_12 = _plus_11 + NL;
            tooltip = _oltip_4 + _plus_12;
        }
        Set _keySet = tooltipMap.keySet();
        for (String key : _keySet) {
            boolean _equals = key.equals(psPeriph);
            if (_equals) {
                String _oltips = tooltips;
                tooltips = _oltips + "<b>" + key + "</b><br/>";
            } else {
                String _oltips_1 = tooltips;
                tooltips = _oltips_1 + "<em>" + key + "</em><br/>";
            }
            Object _oltips_2 = tooltips;
            String _get = (String)tooltipMap.get(key);
            tooltips = (String)_oltips_2 + _get;
        }
        _xblockexpression = tooltips;
        return _xblockexpression;
    }

    protected boolean isSelectedFunction(Map<String, List<Function>> functions, FunctionRef configuredFunction, FunctionRef searchedFunction) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        String _alt = configuredFunction.getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            return false;
        }
        String _alt_1 = searchedFunction.getAlt();
        boolean bl2 = _tripleEquals_1 = _alt_1 == null;
        if (_tripleEquals_1) {
            return false;
        }
        Functions.Function1 _function = it -> it.getName();
        return ListExtensions.map(functions.get(searchedFunction.getAlt()), (Functions.Function1)_function).contains(configuredFunction.getName().getName());
    }

    protected String _generateTitle(PinSetting ps) {
        return null;
    }

    protected String _generateTitle(EObject task) {
        return null;
    }

    public Optional<GHtmlRoot> createPopupModel(GModelElement element, RequestPopupModelAction action) {
        if (element != null) {
            boolean _not;
            boolean _popupState = this.modelState.getPopupState();
            boolean bl = _not = !_popupState;
            if (_not) {
                PinSetting pinSetting = this.lookupPinSetting(element);
                if (pinSetting != null) {
                    GHtmlRoot root = GraphFactory.eINSTANCE.createGHtmlRoot();
                    GBounds bounds = action.getBounds();
                    root.setCanvasBounds(GraphUtil.bounds((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight()));
                    root.setType("html");
                    root.setId("sprotty-popup");
                    String title = "";
                    GPreRenderedElement p1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                    p1.setType("pre-rendered");
                    p1.setId("popup-title");
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("<div class=\"sprotty-popup-title\">");
                    _builder.append("");
                    _builder.append("</div>");
                    p1.setCode(_builder.toString());
                    root.getChildren().add((Object)p1);
                    String body = this.generateBody(pinSetting.getPin(), pinSetting);
                    if (body != null) {
                        GPreRenderedElement p2 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                        p2.setType("pre-rendered");
                        p2.setId("popup-body");
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("<div class=\"sprotty-popup-body\">");
                        _builder_1.append(body);
                        _builder_1.append("</div>");
                        p2.setCode(_builder_1.toString());
                        root.getChildren().add((Object)p2);
                    }
                    return Optional.of(root);
                }
                Pin ps = this.lookupPin(element);
                if (ps != null) {
                    GHtmlRoot root_1 = GraphFactory.eINSTANCE.createGHtmlRoot();
                    GBounds bounds_1 = action.getBounds();
                    root_1.setCanvasBounds(GraphUtil.bounds((double)bounds_1.getX(), (double)bounds_1.getY(), (double)bounds_1.getWidth(), (double)bounds_1.getHeight()));
                    root_1.setType("html");
                    root_1.setId("sprotty-popup");
                    String title_1 = "";
                    GPreRenderedElement p1_1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                    p1_1.setType("pre-rendered");
                    p1_1.setId("popup-title");
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("<div class=\"sprotty-popup-title\">");
                    _builder_2.append("");
                    _builder_2.append("</div>");
                    p1_1.setCode(_builder_2.toString());
                    root_1.getChildren().add((Object)p1_1);
                    String body_1 = this.generateBody(ps, null);
                    if (body_1 != null) {
                        GPreRenderedElement p2_1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                        p2_1.setType("pre-rendered");
                        p2_1.setId("popup-body");
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("<div class=\"sprotty-popup-body\">");
                        _builder_3.append(body_1);
                        _builder_3.append("</div>");
                        p2_1.setCode(_builder_3.toString());
                        root_1.getChildren().add((Object)p2_1);
                    }
                    return Optional.of(root_1);
                }
            }
        }
        return Optional.empty();
    }

    @XbaseGenerated
    public String generateTitle(EObject ps) {
        if (ps instanceof PinSetting) {
            return this._generateTitle((PinSetting)ps);
        }
        if (ps != null) {
            return this._generateTitle(ps);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ps).toString());
    }
}

