/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.server.handlers;

import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.GpioCfgFactory;
import com.st.stellar.pinmap.gpioCfg.GpioCfgPackage;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.gpiocfg.glsp.server.operations.AssignPinFunctionOperation;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.helpers.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.server.emf.EMFOperationHandler;

public class AssignFunctionOperationHandler
extends EMFOperationHandler<AssignPinFunctionOperation> {
    public Optional<Command> createCommand(AssignPinFunctionOperation operation) {
        return this.assignFunctionToPin(operation.getPinConfiguration(), operation.getDirection(), operation.getPin(), operation.getFunction(), operation.getPinName());
    }

    private Optional<Command> assignFunctionToPin(PinConfiguration pinConfiguration, Direction direction, Pin pin, FunctionRef function, String pinName) {
        EditingDomain editingDomain = this.modelState.getEditingDomain();
        StrictCompoundCommand strictCompoundCommand = new StrictCompoundCommand();
        EList modules = pinConfiguration.getPinSetting().getModules();
        if (function == null) {
            block10: for (Module mod : modules) {
                EList pins = mod.getPins();
                for (PinSetting ps : pins) {
                    if (!ps.getPin().getName().equals(pin.getName())) continue;
                    Command commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)GpioCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                    strictCompoundCommand.append(commandRemovePin);
                    if (pins.size() >= 2) continue block10;
                    Command commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod.eContainer(), (Object)GpioCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)mod);
                    strictCompoundCommand.append(commandRemoveModule);
                    continue block10;
                }
            }
        } else {
            Module previousModule = null;
            block12: for (Module mod : modules) {
                if (previousModule != null) break;
                for (PinSetting ps : mod.getPins()) {
                    if (!ps.getPin().getName().equals(pin.getName())) continue;
                    previousModule = mod;
                    continue block12;
                }
            }
            String text = "assign pin " + pin.getName() + "' to function '" + function.getName().getName() + "' as '" + pinName + "' (direction = '" + direction.getLiteral() + "')";
            System.out.println(text);
            Peripheral periph = function.getName().getPeripheralRef();
            Optional<Module> module = modules.stream().filter(it -> it.getName().getName().equals(periph.getName())).findFirst();
            Optional<PinSetting> alreadyDefinedPinSetting = GpioCfgHelper.getAllPinSettings((PinConfiguration)pinConfiguration).stream().filter(it -> it.getConfig().getAlt().getName().equals(function.getName().getName())).findFirst();
            Module mod = null;
            if (module.isPresent()) {
                mod = module.get();
                if (alreadyDefinedPinSetting.isPresent()) {
                    Command removePreviousPinSetting = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)GpioCfgPackage.eINSTANCE.getModule_Pins(), (Object)alreadyDefinedPinSetting.get());
                    strictCompoundCommand.append(removePreviousPinSetting);
                }
                if (previousModule != null && mod != previousModule) {
                    pins = previousModule.getPins();
                    for (PinSetting ps : pins) {
                        if (!ps.getPin().getName().equals(pin.getName())) continue;
                        commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule, (Object)GpioCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                        strictCompoundCommand.append(commandRemovePin);
                        break;
                    }
                    if (previousModule.getPins().size() < 2) {
                        Iterator commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule.eContainer(), (Object)GpioCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)previousModule);
                        strictCompoundCommand.append((Command)commandRemoveModule);
                    }
                }
            } else {
                if (previousModule != null) {
                    pins = previousModule.getPins();
                    for (PinSetting ps : pins) {
                        if (!ps.getPin().getName().equals(pin.getName())) continue;
                        commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule, (Object)GpioCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                        strictCompoundCommand.append(commandRemovePin);
                    }
                }
                if (previousModule != null && previousModule.getPins().size() < 2) {
                    Command commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule.eContainer(), (Object)GpioCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)previousModule);
                    strictCompoundCommand.append(commandRemoveModule);
                }
                mod = GpioCfgFactory.eINSTANCE.createModule();
                PinSettings settings = pinConfiguration.getPinSetting();
                Command command = AddCommand.create((EditingDomain)editingDomain, (Object)settings, (Object)GpioCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)mod);
                strictCompoundCommand.append(command);
                Command commandSetModuleName = SetCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)GpioCfgPackage.eINSTANCE.getModule_Name(), (Object)periph);
                strictCompoundCommand.append(commandSetModuleName);
            }
            PinProperties config = null;
            boolean newConfig = false;
            Optional<PinSetting> pp = mod.getPins().stream().filter(it -> it.getPin().equals((Object)pin) || it.getName().equals(pinName)).findFirst();
            PinSetting ps = null;
            if (pp.isEmpty()) {
                config = GpioCfgFactory.eINSTANCE.createPinProperties();
                newConfig = true;
                ps = GpioCfgFactory.eINSTANCE.createPinSetting();
            } else if (alreadyDefinedPinSetting.isPresent()) {
                config = GpioCfgFactory.eINSTANCE.createPinProperties();
                newConfig = true;
                ps = GpioCfgFactory.eINSTANCE.createPinSetting();
            } else {
                ps = pp.get();
                config = ps.getConfig();
            }
            Command commandSetPSName = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)GpioCfgPackage.eINSTANCE.getPinSetting_Name(), (Object)pinName);
            strictCompoundCommand.append(commandSetPSName);
            Command commandSetPSPin = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), (Object)pin);
            strictCompoundCommand.append(commandSetPSPin);
            Command commandSetAlt = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Alt(), (Object)function.getName());
            strictCompoundCommand.append(commandSetAlt);
            switch (direction) {
                case INPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case INPUT_OR_OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case INPUT_ALTERNATE: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case GROUND: {
                    break;
                }
                case INPUT_OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case OUTPUT_ALTERNATE: {
                    break;
                }
                case POWER: {
                    break;
                }
            }
            IOFields iofields = GpioCfgFactory.eINSTANCE.createIOFields();
            Command commandSetIOFields = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)GpioCfgPackage.eINSTANCE.getPinSetting_IoFields(), (Object)iofields);
            strictCompoundCommand.append(commandSetIOFields);
            GpioCfgHelper hlp = GpioCfgHelper.instance;
            ConfigurablePin dslPin = hlp.getFirstConfigurablePin(pin);
            ArrayList fieldsList = new ArrayList();
            List registers = hlp.getDefaultFieldInstanceList(pinConfiguration, dslPin, function, fieldsList);
            for (Pair pair : registers) {
                FieldInstance reg = GpioCfgFactory.eINSTANCE.createFieldInstance();
                Command commandSetAttr = SetCommand.create((EditingDomain)editingDomain, (Object)reg, (Object)GpioCfgPackage.eINSTANCE.getFieldInstance_Attr(), (Object)pair.getKey());
                strictCompoundCommand.append(commandSetAttr);
                Command commandSetValue = SetCommand.create((EditingDomain)editingDomain, (Object)reg, (Object)GpioCfgPackage.eINSTANCE.getFieldInstance_Value(), (Object)pair.getValue());
                strictCompoundCommand.append(commandSetValue);
                Command commandAddRegister1 = AddCommand.create((EditingDomain)editingDomain, (Object)iofields, (Object)GpioCfgPackage.eINSTANCE.getIOFields_Reg(), (Object)reg);
                strictCompoundCommand.append(commandAddRegister1);
            }
            if (newConfig) {
                Command commandSetConfig = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)GpioCfgPackage.eINSTANCE.getPinSetting_Config(), (Object)config);
                strictCompoundCommand.append(commandSetConfig);
                Command commandAddPins = AddCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)GpioCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                strictCompoundCommand.append(commandAddPins);
            }
        }
        if (strictCompoundCommand.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(strictCompoundCommand);
    }
}

