/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.server.handlers;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.GpioCfgPackage;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.EMFOperationHandler;
import org.eclipse.glsp.server.features.directediting.ApplyLabelEditOperation;
import org.eclipse.glsp.server.types.GLSPServerException;

public class GpioCfgApplyLabelEditHandler
extends EMFOperationHandler<ApplyLabelEditOperation> {
    @Inject
    protected GpioCfgModelState modelState;

    public Optional<Command> createCommand(ApplyLabelEditOperation operation) {
        Optional label = this.modelState.getIndex().get(operation.getLabelId());
        if (label.isEmpty()) {
            throw new GLSPServerException("Label with ID " + operation.getLabelId() + " not found");
        }
        if (((GModelElement)label.get()).getType().equals("pin-name")) {
            return this.handlePinRename((GModelElement)label.get(), operation.getText());
        }
        return Optional.empty();
    }

    private Optional<Command> handlePinRename(GModelElement label, String text) {
        EMFModelIndex index = this.modelState.getIndex();
        Optional maybePinSetting = index.getEObject(label.getParent().getId());
        if (maybePinSetting.isPresent()) {
            Pin pin = (Pin)maybePinSetting.get();
            Optional<PinSetting> configuredPin = GpioCfgHelper.instance.getConfiguredPins(this.modelState.getPinConfiguration().getPinSetting()).stream().filter(it -> it.getPin().equals((Object)pin)).findFirst();
            return maybePinSetting.map(pinSetting -> SetCommand.create((EditingDomain)this.modelState.getEditingDomain(), configuredPin.get(), (Object)GpioCfgPackage.eINSTANCE.getPinSetting_Name(), (Object)text));
        }
        return Optional.empty();
    }
}

