/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.server.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.LQFPPackage;
import com.st.stellar.pinmap.gpio.gpioDsl.NotConnectedPin;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.PinNodeBuilder;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.PreferenceManager;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.validation.GpioValidationMessageAcceptor;
import com.st.stellar.pinmap.validation.GpiocfgValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;
import org.eclipse.glsp.graph.builder.impl.GNodeBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GeneratePinSettings {
    public final int pinWidth = 24;
    public final int pinHeight = 12;
    public final int pinMarginWidth = 7;
    public final int pinMarginHeight = 3;
    public final int fontSize = this.pinWidth / 2;
    public final int generalOffsetX = -25;
    public final int generalOffsetY = -15;
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private StringBuilder errors;
    private StringBuilder warnings;
    private static final LinkedHashMap<Direction, String> directionNames = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[]{Pair.of((Object)Direction.INPUT, (Object)"in"), Pair.of((Object)Direction.OUTPUT, (Object)"out"), Pair.of((Object)Direction.INPUT_OUTPUT, (Object)"inout"), Pair.of((Object)Direction.INPUT_OR_OUTPUT, (Object)"inout"), Pair.of((Object)Direction.GROUND, (Object)"ground"), Pair.of((Object)Direction.POWER, (Object)"power"), Pair.of((Object)Direction.INPUT_ALTERNATE, (Object)""), Pair.of((Object)Direction.OUTPUT_ALTERNATE, (Object)"")});

    protected String _getRefId(PinSettings settings) {
        String _xblockexpression = null;
        EObject _eContainer = GpioCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().eContainer();
        String n = ((Family)_eContainer).getName();
        n = n.replaceAll("x", GpioCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getName());
        int a = n.indexOf("_");
        _xblockexpression = n = n.substring(0, a);
        return _xblockexpression;
    }

    protected String _getRefId(PinSetting setting) {
        return this.getRefId((EObject)setting.getPin().getPinConfigurations().get(0));
    }

    protected String _getRefId(ConfigurablePin pin) {
        Configuration _ref;
        String _xblockexpression = null;
        Configuration cfg = _ref = pin.getRef();
        _xblockexpression = cfg.getName();
        return _xblockexpression;
    }

    public GeneratePinSettings() {
        StringBuilder _stringBuilder_1;
        StringBuilder _stringBuilder;
        this.errors = _stringBuilder = new StringBuilder("errors:\n");
        this.warnings = _stringBuilder_1 = new StringBuilder("warnings:\n");
    }

    public StringBuilder error(String message) {
        return this.errors.append("error: " + message + "\n");
    }

    public StringBuilder warning(String message) {
        return this.warnings.append("warning: " + message + "\n");
    }

    public StringBuilder generateReport() {
        return this.errors.append((CharSequence)this.warnings);
    }

    public int getPortNb(String s) {
        int portNb;
        int _xblockexpression = 0;
        char subString = s.charAt(1);
        int port = Character.getNumericValue(subString);
        int begin = Character.getNumericValue('A');
        _xblockexpression = portNb = port - begin;
        return _xblockexpression;
    }

    public int getBit(String s) {
        int _xblockexpression = 0;
        String subString = s.substring(2, s.length());
        _xblockexpression = Integer.parseInt(subString);
        return _xblockexpression;
    }

    public void generatePins(GModelRoot newRoot, GpioCfgModelState modelState, PinConfiguration pinConfiguration) {
        boolean _greaterThan;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        EList modules = GpioCfgHelper.getAllModules((PinSettings)pinConfiguration.getPinSetting());
        List configuredPins = CollectionLiterals.newArrayList();
        int _size = modules.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getPins();
            configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)modules, (Functions.Function1)_function));
        }
        Package pack = this._gpioCfgHelper.getPack(pinConfiguration.getPinSetting());
        this.generatePackageLQFP(newRoot, modelState, pack, configuredPins, "");
    }

    public GModelElement generateLegend(GModelElement parent, GpioCfgModelState modelState, int width) {
        GNode _xblockexpression = null;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        PinNodeBuilder node = (PinNodeBuilder)((PinNodeBuilder)new PinNodeBuilder("legend").position(width + this.pinWidth / 2, -50.0)).id("legend");
        node.addArgument("width", width);
        String state = this.getCurrentLegendState(modelState);
        node.addArgument("state", state);
        GNode res = (GNode)node.build();
        parent.getChildren().add((Object)res);
        _xblockexpression = res;
        return _xblockexpression;
    }

    public String getCurrentLegendState(GpioCfgModelState modelState) {
        String _xblockexpression = null;
        String key = modelState.getPinConfiguration().eResource().getURI().path();
        _xblockexpression = PreferenceManager.getPreference(key, "false");
        return _xblockexpression;
    }

    public boolean isBoardPin(PinSetting pin) {
        this._gpioCfgHelper = GpioCfgHelper.instance;
        return pin != null && pin.eContainer() != null && pin.eContainer().eContainer() instanceof Board;
    }

    public void generatePackageLQFP(GModelRoot newRoot, GpioCfgModelState modelState, Package p, List<PinSetting> configuredPins, String additional) {
        int nbColumns;
        String id = modelState.getIndex().indexEObject((EObject)p);
        int _size = p.getPins().size();
        int nbRows = nbColumns = _size / 4;
        int pinSize = Math.min(this.pinWidth, this.pinHeight);
        int width = (pinSize + 2 * this.pinMarginHeight) * nbRows + this.pinMarginHeight;
        int height = (pinSize + 2 * this.pinMarginHeight) * nbRows + this.pinMarginHeight;
        ArrayList cssClasses = CollectionLiterals.newArrayList();
        cssClasses.add("gpiocfg-package");
        GLabelBuilder _gLabelBuilder = new GLabelBuilder("package-name");
        EObject _eContainer = p.eContainer();
        String _label = ((Family)_eContainer).getLabel();
        String _name = p.getName();
        String _plus = _label + _name;
        GNodeBuilder packageNodeBuilder = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("package").size((double)width, (double)width)).add(((GLabelBuilder)((GLabelBuilder)((GLabelBuilder)((GLabelBuilder)_gLabelBuilder.text(_plus)).id("packageId")).addCssClasses((List)cssClasses)).position((double)(width / 2), (double)(height / 2))).build())).id(id)).size((double)width, (double)width);
        GNode packageNode = (GNode)packageNodeBuilder.build();
        this.generateLegend((GModelElement)packageNode, modelState, width);
        newRoot.getChildren().add((Object)packageNode);
        PinSettingsErrorManager errorsMap = this.generateErrors(newRoot, modelState, configuredPins);
        EList _pins = p.getPins();
        for (Pin pin : _pins) {
            PinConfig _get = (PinConfig)pin.getPinConfigurations().get(0);
            PinConfig config = _get;
            if (config instanceof NotConnectedPin) continue;
            this.generatePinLQFP(newRoot, modelState, configuredPins, pin, errorsMap);
        }
    }

    public Multimap<URI, PinSetting> getResources(Collection<PinSetting> settings) {
        boolean _greaterThan;
        HashMultimap resources = HashMultimap.create();
        int _size = settings.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (PinSetting d : settings) {
                URI boardUri;
                boolean _equals;
                boolean _not;
                URI pinResourceUri = d.eResource().getURI();
                resources.put((Object)pinResourceUri, (Object)d);
                Board board = GpioCfgHelper.getBoard((PinSetting)d);
                if (board == null || !(_not = !(_equals = (boardUri = board.eResource().getURI()).equals(pinResourceUri)))) continue;
                resources.put((Object)pinResourceUri, (Object)d);
            }
        } else {
            boolean _greaterThan_1;
            int _size_1 = settings.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                PinSetting d_1 = ((PinSetting[])Conversions.unwrapArray(settings, PinSetting.class))[0];
                resources.put((Object)d_1.eResource().getURI(), (Object)d_1);
            }
        }
        return resources;
    }

    public boolean generatePinLQFP(GModelRoot newRoot, GpioCfgModelState modelState, List<PinSetting> configuredPins, Pin pin, PinSettingsErrorManager errorsMap) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> it.getPin() != null && it.getPin().getName().equals(pin.getName());
        PinSetting ps = (PinSetting)IterableExtensions.findFirst(configuredPins, (Functions.Function1)_function);
        boolean _xifexpression = false;
        _xifexpression = ps == null ? this.generateNotConfiguredPinLQFP(newRoot, modelState, pin, errorsMap) : this.generateConfiguredPinLQFP(newRoot, modelState, ps, errorsMap);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean generateNotConfiguredPinLQFP(GModelRoot newRoot, GpioCfgModelState modelState, Pin pin, PinSettingsErrorManager errorsMap) {
        PinConfig _get;
        boolean _xblockexpression = false;
        ArrayList cssClasses = CollectionLiterals.newArrayList();
        ArrayList nodeClasses = CollectionLiterals.newArrayList();
        cssClasses.add("pinNone");
        nodeClasses.add("pinNone");
        PinConfig config = _get = (PinConfig)pin.getPinConfigurations().get(0);
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        String id = modelState.getIndex().indexEObject((EObject)pin);
        Matcher matcher = pattern.matcher(pin.getName());
        boolean _xifexpression = false;
        boolean _find = matcher.find();
        if (_find) {
            boolean _xblockexpression_1 = false;
            EObject _eContainer = pin.eContainer();
            LQFPPackage p = (LQFPPackage)_eContainer;
            int _size = p.getPins().size();
            int size = _size / 4;
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String side = "";
            if (index <= size) {
                side = "west";
            } else if (index <= size * 2 && index > size) {
                side = "south";
            } else if (index <= size * 3 && index > size * 2) {
                side = "east";
            } else if (index > size * 3) {
                side = "north";
            }
            PinNodeBuilder pinNode = null;
            GLabelBuilder gName = null;
            GLabelBuilder gLabel = null;
            GLabelBuilder gDirection = null;
            pinNode = (PinNodeBuilder)new PinNodeBuilder().id(id);
            pinNode.addArgument("side", side);
            pinNode.addArgument("name", pin.getName());
            gLabel = null;
            boolean _isInstance = SpecialPin.class.isInstance(config);
            if (_isInstance) {
                SpecialPin sp = (SpecialPin)SpecialPin.class.cast(config);
                String _get_1 = directionNames.get(sp.getDirection());
                String _plus = _get_1 + "_";
                String directionName = _plus + side;
                nodeClasses.add("nonConfigurablePin");
                gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").text(sp.getRef().getName())).id(id + "_pin_name");
                gName.addArgument("side", (Object)side);
                gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-id").text(this.getPinName(pin))).id(id + "_pin_label");
                gLabel.addArgument("side", (Object)side);
                gDirection = (GLabelBuilder)new GLabelBuilder("pin-direction").id(id + "_pin_direction");
                gDirection.addArgument("direction", (Object)directionName);
            } else {
                boolean _isInstance_1 = SystemFunctionPin.class.isInstance(config);
                if (_isInstance_1) {
                    SystemFunctionPin sp_1 = (SystemFunctionPin)SystemFunctionPin.class.cast(config);
                    String _get_2 = directionNames.get(sp_1.getDirection());
                    String _plus_1 = _get_2 + "_";
                    String directionName_1 = _plus_1 + side;
                    nodeClasses.add("nonConfigurablePin");
                    gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").text(sp_1.getRef().getName())).id(id + "_pin_name");
                    gName.addArgument("side", (Object)side);
                    gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-id").text(this.getPinName(pin))).id(id + "_pin_label");
                    gLabel.addArgument("side", (Object)side);
                    gDirection = (GLabelBuilder)new GLabelBuilder("pin-direction").id(id + "_pin_direction");
                    gDirection.addArgument("direction", (Object)directionName_1);
                } else {
                    boolean _isInstance_2 = NotConnectedPin.class.isInstance(config);
                    if (_isInstance_2) {
                        gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").text("not connected")).id(id + "_pin_name");
                        gName.addArgument("side", (Object)side);
                    } else {
                        boolean _isInstance_3 = ConfigurablePin.class.isInstance(config);
                        if (_isInstance_3) {
                            gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-id").text(this.getPinName(pin))).id(id + "_pin_label");
                            gLabel.addArgument("side", (Object)side);
                        }
                    }
                }
            }
            int imageOffsetX = 0;
            int imageOffsetY = 0;
            if (index <= size) {
                x = 0;
                y = index;
                int _x = x;
                int _x_1 = x = _x * (this.pinWidth + 2 * this.pinMarginWidth);
                x = _x_1 + -3;
                int _y = y;
                y = _y * (this.pinHeight + 2 * this.pinMarginHeight);
                imageOffsetY = 1;
                imageOffsetX = -this.pinWidth / 2;
                side = "west";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 2 && index > size) {
                int _y_1 = y = (size + 1) * (this.pinHeight + 2 * this.pinMarginHeight) + this.pinMarginHeight;
                y = _y_1 + 1;
                int _x_2 = x = index - size;
                int _x_3 = x = _x_2 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_3 + this.pinHeight;
                imageOffsetX = 0;
                int _imageOffsetY = imageOffsetY;
                imageOffsetY = _imageOffsetY + (this.pinWidth + 2);
                side = "south";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinHeight + this.pinMarginHeight), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 3 && index > size * 2) {
                x = size + 2;
                y = size * 3 - index + 1;
                int _x_4 = x;
                int _x_5 = x = _x_4 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_5 - 4;
                int _y_2 = y;
                y = _y_2 * (this.pinHeight + 2 * this.pinMarginHeight);
                imageOffsetX = this.pinWidth + 2;
                imageOffsetY = 1;
                side = "east";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinWidth + this.pinMarginWidth), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index > size * 3) {
                x = size * 4 - index + 1;
                y = 1;
                int _x_6 = x;
                int _x_7 = x = _x_6 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_7 + this.pinHeight;
                int _y_3 = y;
                int _y_4 = y = _y_3 * (this.pinHeight + 2 * this.pinMarginHeight);
                int _y_5 = y = _y_4 - 2 * (this.pinHeight + this.pinMarginHeight);
                y = _y_5 - 1;
                imageOffsetX = 0;
                imageOffsetY = -this.pinHeight - 2;
                side = "north";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            }
            nodeClasses.add(side);
            int _x_8 = x;
            x = _x_8 + this.generalOffsetX;
            int _y_6 = y;
            y = _y_6 + this.generalOffsetY;
            _xifexpression = _xblockexpression_1 = newRoot.getChildren().add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNode.addCssClasses(nodeClasses)).position(x, y)).build());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean generateConfiguredPinLQFP(GModelRoot newRoot, GpioCfgModelState modelState, PinSetting ps, PinSettingsErrorManager errorsMap) {
        boolean _xblockexpression = false;
        Pin pin = ps.getPin();
        ArrayList cssClasses = CollectionLiterals.newArrayList();
        ArrayList nodeClasses = CollectionLiterals.newArrayList();
        boolean _isBoardPin = this.isBoardPin(ps);
        if (_isBoardPin) {
            cssClasses.add("board");
            nodeClasses.add("board");
        } else {
            cssClasses.add("cPin");
            nodeClasses.add("cPin");
        }
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        String id = modelState.getIndex().indexEObject((EObject)pin);
        Matcher matcher = pattern.matcher(pin.getName());
        boolean _xifexpression = false;
        boolean _find = matcher.find();
        if (_find) {
            boolean _xblockexpression_1 = false;
            EObject _eContainer = pin.eContainer();
            LQFPPackage p = (LQFPPackage)_eContainer;
            int _size = p.getPins().size();
            int size = _size / 4;
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String side = "";
            if (index <= size) {
                side = "west";
            } else if (index <= size * 2 && index > size) {
                side = "south";
            } else if (index <= size * 3 && index > size * 2) {
                side = "east";
            } else if (index > size * 3) {
                side = "north";
            }
            PinNodeBuilder pinNode = null;
            GLabelBuilder gName = null;
            GLabelBuilder gLabel = null;
            GLabelBuilder gDirection = null;
            String _literal = ps.getConfig().getDirection().getLiteral();
            String _plus = _literal + "_";
            String directionName = _plus + side;
            gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").text(ps.getName())).id(id + "_pin_name");
            gName.addArgument("side", (Object)side);
            gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-id").text(this.getPinName(pin))).id(id + "_pin_label");
            gLabel.addArgument("side", (Object)side);
            gDirection = (GLabelBuilder)new GLabelBuilder("pin-direction").id(id + "_pin_direction");
            gDirection.addArgument("direction", (Object)directionName);
            Collection errors = errorsMap.errors.get((Object)ps);
            Collection warnings = errorsMap.warnings.get((Object)ps);
            Collection infos = errorsMap.infos.get((Object)ps);
            if (errors.size() > 0 || warnings.size() > 0 || infos.size() > 0) {
                boolean _greaterThan;
                pinNode = (PinNodeBuilder)new PinNodeBuilder("pin-error").id(id);
                pinNode.addArgument("name", pin.getName());
                int _size_1 = errors.size();
                boolean bl = _greaterThan = _size_1 > 0;
                if (_greaterThan) {
                    pinNode.addArgument("error", IterableExtensions.join((Iterable)errors, (CharSequence)","));
                    nodeClasses.add("error");
                    cssClasses.add("error");
                } else {
                    boolean _greaterThan_1;
                    int _size_2 = warnings.size();
                    boolean bl2 = _greaterThan_1 = _size_2 > 0;
                    if (_greaterThan_1) {
                        pinNode.addArgument("warning", IterableExtensions.join((Iterable)warnings, (CharSequence)","));
                        nodeClasses.add("warning");
                        cssClasses.add("warning");
                    } else {
                        boolean _greaterThan_2;
                        int _size_3 = infos.size();
                        boolean bl3 = _greaterThan_2 = _size_3 > 0;
                        if (_greaterThan_2) {
                            pinNode.addArgument("info", IterableExtensions.join((Iterable)infos, (CharSequence)","));
                            nodeClasses.add("info");
                            cssClasses.add("info");
                        }
                    }
                }
                pinNode.addArgument("side", side);
            } else {
                pinNode = (PinNodeBuilder)new PinNodeBuilder().id(id);
                pinNode.addArgument("side", side);
                pinNode.addArgument("name", pin.getName());
            }
            int imageOffsetX = 0;
            int imageOffsetY = 0;
            if (index <= size) {
                x = 0;
                y = index;
                int _x = x;
                int _x_1 = x = _x * (this.pinWidth + 2 * this.pinMarginWidth);
                x = _x_1 + -3;
                int _y = y;
                y = _y * (this.pinHeight + 2 * this.pinMarginHeight);
                imageOffsetY = 1;
                imageOffsetX = -this.pinWidth / 2;
                side = "west";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 2 && index > size) {
                int _y_1 = y = (size + 1) * (this.pinHeight + 2 * this.pinMarginHeight) + this.pinMarginHeight;
                y = _y_1 + 1;
                int _x_2 = x = index - size;
                int _x_3 = x = _x_2 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_3 + this.pinHeight;
                imageOffsetX = 0;
                int _imageOffsetY = imageOffsetY;
                imageOffsetY = _imageOffsetY + (this.pinWidth + 2);
                side = "south";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinHeight + this.pinMarginHeight), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 3 && index > size * 2) {
                x = size + 2;
                y = size * 3 - index + 1;
                int _x_4 = x;
                int _x_5 = x = _x_4 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_5 - 4;
                int _y_2 = y;
                y = _y_2 * (this.pinHeight + 2 * this.pinMarginHeight);
                imageOffsetX = this.pinWidth + 2;
                imageOffsetY = 1;
                side = "east";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinWidth + this.pinMarginWidth), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index > size * 3) {
                x = size * 4 - index + 1;
                y = 1;
                int _x_6 = x;
                int _x_7 = x = _x_6 * (this.pinHeight + 2 * this.pinMarginHeight);
                x = _x_7 + this.pinHeight;
                int _y_3 = y;
                int _y_4 = y = _y_3 * (this.pinHeight + 2 * this.pinMarginHeight);
                int _y_5 = y = _y_4 - 2 * (this.pinHeight + this.pinMarginHeight);
                y = _y_5 - 1;
                imageOffsetX = 0;
                imageOffsetY = -this.pinHeight - 2;
                side = "north";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            }
            nodeClasses.add(side);
            int _x_8 = x;
            x = _x_8 + this.generalOffsetX;
            int _y_6 = y;
            y = _y_6 + this.generalOffsetY;
            _xifexpression = _xblockexpression_1 = newRoot.getChildren().add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNode.addCssClasses(nodeClasses)).position(x, y)).build());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public EObject getEObject(GpioCfgModelState modelState, GModelElement element) {
        Optional selectedPinConfigs = modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> EObject.class.isInstance(it);
        Function<EObject, EObject> _function_1 = it -> (EObject)EObject.class.cast(it);
        Optional<EObject> ps = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        return ps.orElse(null);
    }

    public String getPinName(Pin pin) {
        String id;
        Pattern pattern = Pattern.compile("^(.*)_([0-9]+)$");
        Matcher matcher = pattern.matcher(id = pin.getName());
        boolean _find = matcher.find();
        if (_find) {
            String number = matcher.group(2);
            return number;
        }
        return "";
    }

    public boolean relatedToPinSetting(Diagnostic diag, PinSetting ps) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        if (ps == null) {
            return false;
        }
        PinProperties _config = ps.getConfig();
        boolean bl = _tripleEquals = _config == null;
        if (_tripleEquals) {
            return false;
        }
        IOFields _ioFields = ps.getIoFields();
        boolean bl2 = _tripleEquals_1 = _ioFields == null;
        if (_tripleEquals_1) {
            return false;
        }
        boolean res = false;
        ArrayList objList = CollectionLiterals.newArrayList();
        objList.add(ps);
        objList.add(ps.getConfig());
        objList.add(ps.getIoFields());
        EList _reg = ps.getIoFields().getReg();
        for (FieldInstance reg : _reg) {
            objList.add(reg);
        }
        boolean _contains = objList.contains(diag.getData().get(0));
        if (_contains) {
            res = true;
        }
        return res;
    }

    public PinSettingsErrorManager generateErrors(GModelRoot newRoot, GpioCfgModelState modelState, List<PinSetting> configuredPins) {
        PinConfiguration pinConfiguration = modelState.pinConfiguration;
        PinSettingsErrorManager errorManager = new PinSettingsErrorManager();
        GpiocfgValidator.checkNoDuplicatedPinNames((PinConfiguration)pinConfiguration, (GpioValidationMessageAcceptor)errorManager);
        GpiocfgValidator.checkUniqueFunctionUsage((PinConfiguration)pinConfiguration, (GpioValidationMessageAcceptor)errorManager);
        GpiocfgValidator.checkPinAlreadyUsed((PinConfiguration)pinConfiguration, (GpioValidationMessageAcceptor)errorManager);
        for (PinSetting ps : configuredPins) {
            int _size;
            boolean _greaterThan;
            ArrayList diags = new ArrayList();
            GpiocfgValidator.checkMissingRegInstances((PinSetting)ps, (GpioValidationMessageAcceptor)errorManager);
            boolean _isBoardPin = this.isBoardPin(ps);
            if (_isBoardPin) {
                Diagnostic errorCfg = Diagnostician.INSTANCE.validate((EObject)pinConfiguration);
                List errorsCfg = errorCfg.getChildren();
                Functions.Function1 _function = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsCfg, (Functions.Function1)_function));
                for (Diagnostic e : errorsCfg) {
                    Functions.Function1 _function_1 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e.getChildren(), (Functions.Function1)_function_1));
                }
            } else {
                Diagnostic errorPs = Diagnostician.INSTANCE.validate((EObject)ps);
                List errorsPs = errorPs.getChildren();
                Functions.Function1 _function_2 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsPs, (Functions.Function1)_function_2));
                for (Diagnostic e_1 : errorsPs) {
                    Functions.Function1 _function_3 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e_1.getChildren(), (Functions.Function1)_function_3));
                }
            }
            if (!(_greaterThan = (_size = diags.size()) > 0)) continue;
            Functions.Function1 _function_4 = d -> {
                int _severity = d.getSeverity();
                return _severity == 4;
            };
            Functions.Function1 _function_5 = it -> it.getMessage();
            Consumer<String> _function_6 = it -> errorManager.errors.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_4), (Functions.Function1)_function_5).forEach(_function_6);
            Functions.Function1 _function_7 = d -> {
                int _severity = d.getSeverity();
                return _severity == 2;
            };
            Functions.Function1 _function_8 = it -> it.getMessage();
            Consumer<String> _function_9 = it -> errorManager.warnings.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_7), (Functions.Function1)_function_8).forEach(_function_9);
            Functions.Function1 _function_10 = d -> {
                int _severity = d.getSeverity();
                return _severity == 1;
            };
            Functions.Function1 _function_11 = it -> it.getMessage();
            Consumer<String> _function_12 = it -> errorManager.infos.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_10), (Functions.Function1)_function_11).forEach(_function_12);
        }
        return errorManager;
    }

    @XbaseGenerated
    public String getRefId(EObject pin) {
        if (pin instanceof ConfigurablePin) {
            return this._getRefId((ConfigurablePin)pin);
        }
        if (pin instanceof PinSetting) {
            return this._getRefId((PinSetting)pin);
        }
        if (pin instanceof PinSettings) {
            return this._getRefId((PinSettings)pin);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pin).toString());
    }

    public static class PinSettingsErrorManager
    extends GpioValidationMessageAcceptor {
        public final Multimap<EObject, String> errors = HashMultimap.create();
        public final Multimap<EObject, String> infos = HashMultimap.create();
        public final Multimap<EObject, String> warnings = HashMultimap.create();

        public PinSettingsErrorManager() {
            super(null);
            this.acceptsExternalResource(true);
        }

        public void collectError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.errors.put((Object)object, (Object)message);
        }

        public void collectError(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.errors.put((Object)object, (Object)message);
        }

        public void collectInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.infos.put((Object)object, (Object)message);
        }

        public void collectInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.infos.put((Object)object, (Object)message);
        }

        public void collectWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.warnings.put((Object)object, (Object)message);
        }

        public void collectWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.warnings.put((Object)object, (Object)message);
        }
    }

    public static enum PinStatus {
        Configured,
        NotUsed,
        NotConnected,
        NotConfigurable;

    }
}

