package com.st.stellar.pinmap.gpiocfg.glsp.server.model

import org.eclipse.core.runtime.preferences.InstanceScope
import org.osgi.service.prefs.BackingStoreException

class PreferenceManager {

    static val String PLUGIN_ID = "com.st.stellar.pinmap.gpiocfg.glsp.server"

    def static void savePreference(String key, String value) {
        val preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID)
        preferences.put(key, value)
        try {
            preferences.flush
        } catch (BackingStoreException e) {
            e.printStackTrace
        }
        //println('''«key» -> «value»''')
    }

    def static String getPreference(String key, String defValue) {
        val preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID)
        val res = preferences.get(key, defValue)
        //println('''«key» = «res»''')
        res
    }
}