/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ide;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.st.stellar.pinmap.ide.CustomServerModule;
import com.st.stellar.pinmap.ide.ServerLauncher2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerLauncher;
import org.eclipse.xtext.ide.server.ServerModule;

public class MultiProjectServerLauncher {
    private static boolean IS_DEBUG = false;
    @Inject
    private LanguageServerImpl languageServer;

    public static void main(String[] args) throws Exception {
        InputStream stdin = System.in;
        PrintStream stdout = System.out;
        MultiProjectServerLauncher.redirectStandardStreams();
        ServerLauncher2 launcher = (ServerLauncher2)Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ServerModule()}).with(new Module[]{new CustomServerModule()})}).getInstance(ServerLauncher2.class);
        launcher.start(stdin, stdout);
    }

    public void start(InputStream in, OutputStream out) throws Exception {
        System.err.println("Starting Xtext Language Server.");
        Launcher launcher = Launcher.createLauncher((Object)this.languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (boolean)true, (PrintWriter)new PrintWriter(System.out));
        this.languageServer.connect((LanguageClient)launcher.getRemoteProxy());
        Future future = launcher.startListening();
        System.err.println("started.");
        while (!future.isDone()) {
            Thread.sleep(10000L);
        }
    }

    public static void redirectStandardStreams() throws Exception {
        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        System.setIn(_byteArrayInputStream);
        String id = ServerLauncher.class.getName() + "-" + String.valueOf(new Timestamp(System.currentTimeMillis()));
        if (IS_DEBUG) {
            FileOutputStream stdFileOut = new FileOutputStream("out-" + id + ".log");
            System.setOut(new PrintStream(stdFileOut));
            FileOutputStream stdFileErr = new FileOutputStream("error-" + id + ".log");
            System.setErr(new PrintStream(stdFileErr));
        } else {
            ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
            System.setOut(new PrintStream(_byteArrayOutputStream));
            ByteArrayOutputStream _byteArrayOutputStream_1 = new ByteArrayOutputStream();
            System.setErr(new PrintStream(_byteArrayOutputStream_1));
        }
    }
}

