/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ide;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.st.stellar.pinmap.GpiocfgRuntimeModule;
import com.st.stellar.pinmap.GpiocfgStandaloneSetup;
import com.st.stellar.pinmap.gpio.GpioDslStandaloneSetup;
import com.st.stellar.pinmap.ide.GpiocfgIdeModule;
import com.st.stellar.pinmap.ide.ServerLauncher2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.SpiritStandaloneSetup;

public class RunServer {
    private static List<String> all_other_filenames = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"platform:/plugin/com.st.register.sr5e1/lib/SR5E1/IOMUX.spirit", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/SR5E1.gpio_def", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000p.gpio_board", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000s.gpio_board"}));
    private String mainPath;
    private boolean eclipse;

    public RunServer(String mainPath) {
        this.mainPath = mainPath;
        int lastSeparatorIndex = mainPath.lastIndexOf(File.separator);
        String lastDir = mainPath.substring(lastSeparatorIndex + 1);
        this.eclipse = lastDir.equals("target");
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String mainPath = new File(RunServer.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        System.out.println(mainPath);
        new SpiritStandaloneSetup().createInjectorAndDoEMFRegistration();
        GpioDslStandaloneSetup.doSetup();
        new GpiocfgStandaloneSetup().createInjectorAndDoEMFRegistration();
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])new Module[]{new GpiocfgRuntimeModule(), new GpiocfgIdeModule(), new ServerModule()})});
        LanguageServerImpl languageServer = (LanguageServerImpl)injector.getInstance(LanguageServerImpl.class);
        RunServer rs = new RunServer(mainPath);
        rs.declarePlatformURIs(languageServer);
    }

    private void declarePlatformURIs(LanguageServerImpl languageServer) {
        ResourceSetImpl set = new ResourceSetImpl();
        for (String m : all_other_filenames) {
            URI uri = this.registerPlatformToFileURIMapping(URI.createURI((String)m));
            Resource other = set.getResource(uri, true);
            try {
                other.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Function<MessageConsumer, MessageConsumer> wrapper = consumer -> {
            MessageConsumer result = new MessageConsumer(){
                final /* synthetic */ MessageConsumer val$consumer;
                {
                    this.val$consumer = messageConsumer;
                }

                public void consume(Message message) throws MessageIssueException, JsonRpcException {
                    System.out.println(message);
                    this.val$consumer.consume(message);
                }
            };
            return result;
        };
        try {
            Launcher<LanguageClient> launcher = RunServer.createSocketLauncher(languageServer, LanguageClient.class, new InetSocketAddress("localhost", 5007), Executors.newCachedThreadPool(), wrapper);
            languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            while (!future.isDone()) {
                Thread.sleep(10000L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static <T> Launcher<T> createSocketLauncher(Object localService, Class<T> remoteInterface, SocketAddress socketAddress, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) throws IOException {
        AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(socketAddress);
        try {
            AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
            return Launcher.createIoLauncher((Object)localService, remoteInterface, (InputStream)Channels.newInputStream(socketChannel), (OutputStream)Channels.newOutputStream(socketChannel), (ExecutorService)executorService, wrapper);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private URI registerPlatformToFileURIMapping(URI uri) {
        Pattern pattern = Pattern.compile("(platform:/plugin/)([^/]+)(/lib/)([^/]+/)([^\\.]+)(\\..+)$");
        Matcher matcher = pattern.matcher(uri.toString());
        if (matcher.find()) {
            String prefix = "contriblib";
            int lastSeparatorIndex = this.mainPath.lastIndexOf(File.separator);
            String newPath = this.mainPath.substring(0, lastSeparatorIndex) + File.separator + "bin" + File.separator + prefix;
            URI uriOrig = URI.createURI((String)(matcher.group(1) + "com.st.stellar.model.lib" + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URI fileURI = URI.createFileURI((String)(newPath + "/" + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            String suffix = (String)IterableExtensions.last((Iterable)fileURI.segmentsList());
            File file = this.getFile(fileURI.toString(), suffix);
            Preconditions.checkArgument((boolean)file.exists());
            URI resURI = null;
            resURI = this.eclipse ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createFileURI((String)fileURI.toString().replaceAll("^file:/", ""));
            URIConverter.URI_MAP.put(uriOrig, resURI);
            System.out.println(String.valueOf(uriOrig) + " mapped to: " + String.valueOf(resURI));
            URI contribURI = URI.createURI((String)(matcher.group(1) + matcher.group(2) + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URIConverter.URI_MAP.put(contribURI, resURI);
            System.out.println(String.valueOf(contribURI) + " mapped to: " + String.valueOf(resURI));
            return resURI;
        }
        System.out.println("do not match");
        return null;
    }

    File getFile(String filePath, String suffix) {
        if (!this.eclipse) {
            filePath = filePath.replaceAll("^file:/", "");
        } else {
            filePath = filePath.replaceAll("^file:/", "");
            filePath = filePath.replaceAll("bin/contriblib", "toBeInstalled/contriblib");
        }
        File file = null;
        if (this.eclipse) {
            file = new File(filePath);
        } else {
            ClassLoader cl = ServerLauncher2.class.getClassLoader();
            InputStream res = cl.getResourceAsStream(filePath);
            if (res != null) {
                try {
                    int read;
                    file = File.createTempFile("tempfile", suffix);
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] bytes = new byte[1024];
                    while ((read = res.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.close();
                    file.deleteOnExit();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                file = new File(filePath);
            }
        }
        if (file != null && !file.exists()) {
            throw new RuntimeException("Error: File " + file.getAbsolutePath() + " not found!");
        }
        return file;
    }
}

