/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ide;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.st.stellar.pinmap.GpiocfgRuntimeModule;
import com.st.stellar.pinmap.GpiocfgStandaloneSetup;
import com.st.stellar.pinmap.gpio.GpioDslStandaloneSetup;
import com.st.stellar.pinmap.ide.GpiocfgIdeModule;
import com.st.stellar.pinmap.ide.RunServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.SpiritStandaloneSetup;

public class ServerLauncher2 {
    private static List<String> all_other_filenames = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"platform:/plugin/com.st.register.sr5e1/lib/SR5E1/IOMUX.spirit", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/SR5E1.gpio_def", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000p.gpio_board", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000s.gpio_board"}));
    private static boolean IS_DEBUG = true;
    private String mainPath;
    private boolean eclipse;
    @Inject
    private LanguageServerImpl languageServer;
    @Inject
    Provider<ResourceSet> resourceSetProvider;

    public void init(String mainPath) throws Exception {
        this.mainPath = mainPath;
        int lastSeparatorIndex = mainPath.lastIndexOf(File.separator);
        String lastDir = mainPath.substring(lastSeparatorIndex + 1);
        this.eclipse = lastDir.equals("target");
        this.redirectStandardStreams();
    }

    public static void main(String[] args) throws Exception {
        new SpiritStandaloneSetup().createInjectorAndDoEMFRegistration();
        GpioDslStandaloneSetup.doSetup();
        new GpiocfgStandaloneSetup().createInjectorAndDoEMFRegistration();
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])new Module[]{new GpiocfgRuntimeModule(), new GpiocfgIdeModule(), new ServerModule()})});
        String mainPath = new File(RunServer.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        InputStream stdin = System.in;
        PrintStream stdout = System.out;
        ServerLauncher2 launcher = (ServerLauncher2)injector.getInstance(ServerLauncher2.class);
        launcher.init(mainPath);
        launcher.start(stdin, stdout);
    }

    public void start(InputStream in, OutputStream out) throws Exception {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        try {
            for (String m : all_other_filenames) {
                URI uri = this.registerPlatformToFileURIMapping(URI.createURI((String)m));
                Resource other = set.getResource(uri, true);
                other.load(null);
            }
            System.err.println("Starting Xtext Language Server.");
            String id = ServerLauncher2.class.getName() + "-" + new Timestamp(System.currentTimeMillis()).toString().replaceAll(" ", "_");
            Launcher launcher = Launcher.createLauncher((Object)this.languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (boolean)true, (PrintWriter)new PrintWriter(new FileOutputStream("C:/tmp/logs/xxx-.log"), true));
            this.languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            System.err.println("started.");
            while (!future.isDone()) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void redirectStandardStreams() throws Exception {
        System.setIn(new ByteArrayInputStream(new byte[0]));
        String id = ServerLauncher2.class.getName() + "-" + new Timestamp(System.currentTimeMillis()).toString().replaceAll(" ", "_");
        if (IS_DEBUG) {
            FileOutputStream stdFileOut = new FileOutputStream("C:/tmp/logs/out-.log");
            System.setOut(new PrintStream(stdFileOut, true));
            FileOutputStream stdFileErr = new FileOutputStream("C:/tmp/logs/error-.log");
            System.setErr(new PrintStream(stdFileErr, true));
        } else {
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
    }

    private URI registerPlatformToFileURIMapping(URI uri) {
        Pattern pattern = Pattern.compile("(platform:/plugin/)([^/]+)(/lib/)([^/]+/)([^\\.]+)(\\..+)$");
        Matcher matcher = pattern.matcher(uri.toString());
        if (matcher.find()) {
            String prefix = "contriblib";
            int lastSeparatorIndex = this.mainPath.lastIndexOf(File.separator);
            String newPath = this.mainPath.substring(0, lastSeparatorIndex) + File.separator + "bin" + File.separator + prefix;
            URI uriOrig = URI.createURI((String)(matcher.group(1) + "com.st.stellar.model.lib" + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URI fileURI = URI.createFileURI((String)(newPath + "/" + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            String suffix = (String)IterableExtensions.last((Iterable)fileURI.segmentsList());
            File file = this.getFile(fileURI.toString(), suffix);
            Preconditions.checkArgument((boolean)file.exists());
            URI resURI = null;
            resURI = this.eclipse ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createFileURI((String)fileURI.toString().replaceAll("^file:/", ""));
            URIConverter.URI_MAP.put(uriOrig, resURI);
            System.out.println(String.valueOf(uriOrig) + " mapped to: " + String.valueOf(resURI));
            URI contribURI = URI.createURI((String)(matcher.group(1) + matcher.group(2) + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URIConverter.URI_MAP.put(contribURI, resURI);
            System.out.println(String.valueOf(contribURI) + " mapped to: " + String.valueOf(resURI));
            return resURI;
        }
        System.out.println("do not match");
        return null;
    }

    File getFile(String filePath, String suffix) {
        if (!this.eclipse) {
            filePath = filePath.replaceAll("^file:/", "");
        } else {
            filePath = filePath.replaceAll("^file:/", "");
            filePath = filePath.replaceAll("bin/contriblib", "toBeInstalled/contriblib");
        }
        File file = null;
        if (this.eclipse) {
            file = new File(filePath);
        } else {
            ClassLoader cl = ServerLauncher2.class.getClassLoader();
            InputStream res = cl.getResourceAsStream(filePath);
            if (res != null) {
                try {
                    int read;
                    file = File.createTempFile("tempfile", suffix);
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] bytes = new byte[1024];
                    while ((read = res.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.close();
                    file.deleteOnExit();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                file = new File(filePath);
            }
        }
        if (file != null && !file.exists()) {
            throw new RuntimeException("Error: File " + file.getAbsolutePath() + " not found!");
        }
        return file;
    }
}

