/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ide.server;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.st.stellar.pinmap.GpiocfgRuntimeModule;
import com.st.stellar.pinmap.GpiocfgStandaloneSetup;
import com.st.stellar.pinmap.gpio.GpioDslStandaloneSetup;
import com.st.stellar.pinmap.ide.GpiocfgIdeModule;
import com.st.stellar.pinmap.ide.ServerLauncher2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.xtext.ide.server.LaunchArgs;
import org.eclipse.xtext.ide.server.ServerLauncher;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.SpiritStandaloneSetup;

public class ServerLauncherGpio
extends ServerLauncher {
    private static List<String> all_other_filenames = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"platform:/plugin/com.st.register.sr5e1/lib/SR5E1/IOMUX.spirit", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/SR5E1.gpio_def", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000p.gpio_board", "platform:/plugin/com.st.stellar.pinmap.sr5e1/lib/SR5E1/evbe7000s.gpio_board"}));
    private String mainPath;
    private boolean eclipse;
    public static final String LOG = "-log";
    public static final String TRACE = "-trace";
    public static final String NO_VALIDATE = "-noValidate";

    public static void main(String[] args) {
        new SpiritStandaloneSetup().createInjectorAndDoEMFRegistration();
        GpioDslStandaloneSetup.doSetup();
        new GpiocfgStandaloneSetup().createInjectorAndDoEMFRegistration();
        ServerLauncherGpio.launch(ServerLauncherGpio.class.getName(), args, new Module[]{new GpiocfgRuntimeModule(), new GpiocfgIdeModule(), new ServerModule()});
    }

    public static void launch(String prefix, String[] args, Module ... modules) {
        LaunchArgs launchArgs = ServerLauncherGpio.createLaunchArgs((String)prefix, (String[])args);
        ServerLauncher launcher = (ServerLauncher)Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])modules)}).getInstance(ServerLauncherGpio.class);
        launcher.start(launchArgs);
    }

    public void start(LaunchArgs args) {
        this.mainPath = new File(ServerLauncherGpio.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        System.out.println(this.mainPath);
        int lastSeparatorIndex = this.mainPath.lastIndexOf(File.separator);
        String lastDir = this.mainPath.substring(lastSeparatorIndex + 1);
        this.eclipse = lastDir.equals("target");
        ResourceSetImpl set = new ResourceSetImpl();
        for (String m : all_other_filenames) {
            URI uri = this.registerPlatformToFileURIMapping(URI.createURI((String)m));
            System.out.println(uri.toFileString());
            Resource other = set.getResource(uri, true);
            try {
                other.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.start(args);
    }

    static <T> Launcher<T> createSocketLauncher(Object localService, Class<T> remoteInterface, SocketAddress socketAddress, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) throws IOException {
        AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(socketAddress);
        try {
            AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
            return Launcher.createIoLauncher((Object)localService, remoteInterface, (InputStream)Channels.newInputStream(socketChannel), (OutputStream)Channels.newOutputStream(socketChannel), (ExecutorService)executorService, wrapper);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private URI registerPlatformToFileURIMapping(URI uri) {
        Pattern pattern = Pattern.compile("(platform:/plugin/)([^/]+)(/lib/)([^/]+/)([^\\.]+)(\\..+)$");
        Matcher matcher = pattern.matcher(uri.toString());
        if (matcher.find()) {
            String prefix = "contriblib";
            int lastSeparatorIndex = this.mainPath.lastIndexOf(File.separator);
            String newPath = this.mainPath.substring(0, lastSeparatorIndex) + File.separator + "bin" + File.separator + prefix;
            URI uriOrig = URI.createURI((String)(matcher.group(1) + "com.st.stellar.model.lib" + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URI fileURI = URI.createFileURI((String)(newPath + "/" + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            String suffix = (String)IterableExtensions.last((Iterable)fileURI.segmentsList());
            File file = this.getFile(fileURI.toString(), suffix);
            Preconditions.checkArgument((boolean)file.exists());
            URI resURI = null;
            if (this.eclipse) {
                resURI = URI.createFileURI((String)file.getAbsolutePath());
            } else {
                String filePath = fileURI.toString().replaceAll("^file:/", "");
                filePath = filePath.replaceAll("build/classes/bin/contriblib", "toBeInstalled/contriblib");
                resURI = URI.createFileURI((String)filePath);
            }
            URIConverter.URI_MAP.put(uriOrig, resURI);
            InputOutput.println((Object)(String.valueOf(uriOrig) + " mapped to: " + String.valueOf(resURI)));
            URI contribURI = URI.createURI((String)(matcher.group(1) + matcher.group(2) + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6)));
            URIConverter.URI_MAP.put(contribURI, resURI);
            InputOutput.println((Object)(String.valueOf(contribURI) + " mapped to: " + String.valueOf(resURI)));
            return resURI;
        }
        InputOutput.println((Object)"do not match");
        return null;
    }

    File getFile(String filePath, String suffix) {
        System.out.println("Before: " + filePath);
        InputOutput.println((Object)("Before: " + filePath));
        if (!this.eclipse) {
            filePath = filePath.replaceAll("^file:/", "");
            filePath = filePath.replaceAll("build/classes/bin/contriblib", "toBeInstalled/contriblib");
            InputOutput.println((Object)filePath);
        } else {
            filePath = filePath.replaceAll("^file:/", "");
            filePath = filePath.replaceAll("bin/contriblib", "toBeInstalled/contriblib");
        }
        InputOutput.println((Object)("After: " + filePath));
        System.out.println("After: " + filePath);
        File file = null;
        if (this.eclipse) {
            file = new File(filePath);
        } else {
            ClassLoader cl = ServerLauncher2.class.getClassLoader();
            InputStream res = cl.getResourceAsStream(filePath);
            if (res != null) {
                try {
                    int read;
                    file = File.createTempFile("tempfile", suffix);
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] bytes = new byte[1024];
                    while ((read = res.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.close();
                    file.deleteOnExit();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                file = new File(filePath);
            }
        }
        if (file != null && !file.exists()) {
            throw new RuntimeException("Error: File " + file.getAbsolutePath() + " not found!");
        }
        return file;
    }
}

