/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.st.stellar.pinmap.gpiocfg.ui.PinmapOverview;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;

@Singleton
public class PinmapOverviewSelectionLinker
implements IPropertyChangeListener {
    private static final String XTEXT_LANGUAGE_NAME = "com.st.stellar.pinmap.gpiocfg";
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject
    private PinmapOverview view;
    private XtextEditor currentEditor;
    private ISelectable currentSelectedNode;
    private ISelectionChangedListener diagramSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (PinmapOverviewSelectionLinker.this.view.getControl().isFocusControl()) {
                PinmapOverviewSelectionLinker.this.diagramSelectionChanged(event);
            }
        }
    };
    private ISelectionChangedListener textSelectionChangeListener = new ISelectionChangedListener(this){

        public void selectionChanged(SelectionChangedEvent event) {
        }
    };

    public void activate() {
        this.view.getSite().getSelectionProvider().addSelectionChangedListener(this.diagramSelectionChangeListener);
    }

    public void deactivate() {
        this.view.getSite().getSelectionProvider().removeSelectionChangedListener(this.diagramSelectionChangeListener);
        if (this.currentEditor != null) {
            this.removeTextSelectionListener(this.currentEditor);
        }
    }

    public void diagramSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structuredSelection;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object object = structuredSelection.getFirstElement();
        }
    }

    public void textSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty()) {
            ITextSelection textSelection = (ITextSelection)selection;
            int n = textSelection.getOffset();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void setXtextEditor(XtextEditor xtextEditor) {
        if (this.currentEditor != null) {
            this.removeTextSelectionListener(this.currentEditor);
        }
        if (XTEXT_LANGUAGE_NAME.equals(xtextEditor.getLanguageName())) {
            this.currentEditor = xtextEditor;
            ISelectionProvider selectionProvider = xtextEditor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.textSelectionChangeListener);
            } else {
                selectionProvider.addSelectionChangedListener(this.textSelectionChangeListener);
            }
        }
    }

    protected void removeTextSelectionListener(XtextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.textSelectionChangeListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.textSelectionChangeListener);
            }
        }
    }
}

