/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.st.stellar.pinmap.gpiocfg.ui.PinmapOverview;
import com.st.stellar.pinmap.gpiocfg.ui.PinmapOverviewSelectionLinker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@Singleton
public class PinmapOverviewSynchronizer
implements IPartListener,
IXtextModelListener {
    @Inject
    private PinmapOverview view;
    @Inject
    private PinmapOverviewSelectionLinker selectionLinker;
    private IXtextDocument lastActiveDocument;

    public void start(IWorkbenchPartSite site) {
        this.updateView((IWorkbenchPart)site.getPage().getActiveEditor());
        site.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void stop(IWorkbenchPartSite site) {
        site.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        if (this.lastActiveDocument != null) {
            this.lastActiveDocument.removeModelListener((IXtextModelListener)this);
        }
        this.lastActiveDocument = null;
    }

    private void updateView(IWorkbenchPart part) {
        XtextEditor xtextEditor;
        IXtextDocument xtextDocument;
        if (part instanceof XtextEditor && (xtextDocument = (xtextEditor = (XtextEditor)part).getDocument()) != this.lastActiveDocument) {
            this.selectionLinker.setXtextEditor(xtextEditor);
            EObject contents = (EObject)xtextDocument.tryReadOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource resource) throws Exception {
                    return PinmapOverviewSynchronizer.this.createFigure(resource);
                }
            });
            if (contents != null) {
                this.view.setContents(contents);
                if (this.lastActiveDocument != null) {
                    this.lastActiveDocument.removeModelListener((IXtextModelListener)this);
                }
                this.lastActiveDocument = xtextDocument;
                this.lastActiveDocument.addModelListener((IXtextModelListener)this);
            }
        }
    }

    private EObject createFigure(XtextResource state) {
        EList contents = state.getContents();
        if (!contents.isEmpty()) {
            EObject rootObject = (EObject)contents.get(0);
            System.out.println(rootObject.toString());
            return rootObject;
        }
        return null;
    }

    public void modelChanged(XtextResource resource) {
        this.view.setContents(this.createFigure(resource));
    }

    @Deprecated
    public Font getFont() {
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.updateView(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

