/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.editor;

import com.st.stellar.pinmap.gpiocfg.ui.editor.GpioCfgEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.swt.graphics.Image;

public class GpioBoardDecorator
extends LabelDecorator
implements ILightweightLabelDecorator {
    private static Image boardErrorImage = GpioCfgEditor.getImageDescriptor("icons/board_error.png").createImage();
    private static Image boardWarningImage = GpioCfgEditor.getImageDescriptor("icons/board_warning.png").createImage();
    private static Image boardImage = GpioCfgEditor.getImageDescriptor("icons/board.png").createImage();

    public Image decorateImage(Image image, Object element) {
        String regex;
        IFile file;
        String fileName;
        if (element instanceof IFile && (fileName = (file = (IFile)element).getName()).matches(regex = "^.*\\.(gpio_board)$")) {
            try {
                IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                if (markers.length > 0) {
                    int warnings = 0;
                    int errors = 0;
                    for (IMarker iMarker : markers) {
                        if (iMarker.getAttribute("severity", 0) == 2) {
                            ++errors;
                        }
                        if (iMarker.getAttribute("severity", 0) != 1) continue;
                        ++warnings;
                    }
                    if (errors > 0) {
                        return boardErrorImage;
                    }
                    if (warnings > 0) {
                        return boardWarningImage;
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return boardImage;
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        return null;
    }

    public String decorateText(String text, Object element, IDecorationContext context) {
        return null;
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
    }
}

