/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpiocfg.ui.autoedit.GpioCfgEditStrategyProvider;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.osgi.framework.Bundle;

public class GpioCfgEditor
extends XtextEditor {
    static final Logger LOGGER = Logger.getLogger(GpioCfgEditor.class);
    private static final String PLUGIN_ID = "com.st.stellar.pinmap.gpiocfg.ui";
    private IPartListener partListener;
    private MyDocumentListener documentListener = null;
    @Inject
    Provider<EObjectAtOffsetHelper> helper;
    static String CONFIG_EDITOR_ID = "com.st.stellar.pinmap.Gpiocfg";

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput fei = (FileEditorInput)FileEditorInput.class.cast(input);
        final boolean enabled = fei.getPath().lastSegment().endsWith(".gpio");
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart p) {
                if (p.equals((Object)GpioCfgEditor.this)) {
                    Stream<ActionContributionItem> items = Arrays.stream(GpioCfgEditor.this.getEditorSite().getActionBars().getToolBarManager().getItems()).filter(ActionContributionItem.class::isInstance).map(ActionContributionItem.class::cast);
                    Optional<ActionContributionItem> open = items.filter(item -> item.getId().equals("com.st.stellar.pinmap.gpiocfg.ui.editor.OpenDiagram")).findFirst();
                    open.ifPresent(item -> item.getAction().setEnabled(enabled));
                    open.ifPresent(item -> item.setVisible(enabled));
                    IXtextDocument document = GpioCfgEditor.this.getDocument();
                    if (document != null && GpioCfgEditor.this.documentListener == null) {
                        GpioCfgEditor.this.documentListener = new MyDocumentListener(GpioCfgEditor.this);
                        document.addDocumentListener((IDocumentListener)GpioCfgEditor.this.documentListener);
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        site.getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        IXtextDocument document;
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        if ((document = this.getDocument()) != null && this.documentListener != null) {
            document.removeDocumentListener((IDocumentListener)this.documentListener);
        }
        super.dispose();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return GpioCfgEditor.imageDescriptorFromPlugin(PLUGIN_ID, path);
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor;
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        IWorkbench workbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
        ImageDescriptor imageDescriptor2 = imageDescriptor = workbench == null ? null : workbench.getSharedImages().getImageDescriptor(imageFilePath);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtility.isReady((Bundle)bundle)) {
            return null;
        }
        return ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)imageFilePath).orElse(null);
    }

    public PinSetting getPinSettingNearby(XtextResource resource, int startPosition) {
        int position = startPosition;
        EObject selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, position);
        if (selectedElement instanceof PinProperties) {
            return (PinSetting)selectedElement.eContainer();
        }
        if (selectedElement instanceof Function || selectedElement instanceof Pin || selectedElement instanceof Module) {
            while (!(position >= startPosition + 2000 || selectedElement != null && selectedElement instanceof PinSetting)) {
                selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, ++position);
            }
        }
        while (!(position <= 1 || selectedElement != null && selectedElement instanceof PinSetting)) {
            selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, --position);
        }
        if (selectedElement instanceof PinSetting) {
            return (PinSetting)selectedElement;
        }
        return null;
    }

    protected void updateStatusLine() {
        super.updateStatusLine();
        new UIJob("setFocus"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                int nbConfigEditors = 0;
                if (window != null && (page = window.getActivePage()) != null) {
                    IEditorReference[] editorReferences;
                    for (IEditorReference editorRef : editorReferences = page.getEditorReferences()) {
                        IEditorPart editorPart = editorRef.getEditor(false);
                        if (editorPart == null || !page.isPartVisible((IWorkbenchPart)editorPart) || !editorPart.getSite().getId().equals(CONFIG_EDITOR_ID)) continue;
                        ++nbConfigEditors;
                    }
                }
                if ((page = GpioCfgEditor.this.getEditorSite().getPage()) != null && nbConfigEditors > 0) {
                    page.activate((IWorkbenchPart)GpioCfgEditor.this);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    class MyDocumentListener
    implements IDocumentListener {
        MyDocumentListener(GpioCfgEditor this$0) {
        }

        public void documentChanged(final DocumentEvent event) {
            IXtextDocument doc;
            PinSetting ps;
            if (event.fDocument instanceof IXtextDocument && event.fLength > 0 && event.fText.length() > 2 && (ps = GpioCfgEditStrategyProvider.instance.getPinSetting(doc = (IXtextDocument)event.fDocument, event.getOffset())) != null && ps.getPin().getName().equals(event.getText())) {
                new UIJob(this, "showConsole"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        GpioCfgEditStrategyProvider.instance.adaptFieldInstances(doc, event.getOffset(), event.getLength(), event.getText() + " ");
                        return Status.OK_STATUS;
                    }
                }.schedule(100L);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }
}

