/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.handler;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.GpioCfgPackage;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.PlainMessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class CopyBoardIntoProject {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private static final Logger logger = LogManager.getLogger(CopyBoardIntoProject.class);
    private boolean canExecute = false;

    @Execute
    public void execute() {
        this._gpioCfgHelper = GpioCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            _document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            PinConfiguration config = CopyBoardIntoProject.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                CopyBoardIntoProject.this.copyBoardIntoProject(config.getPinSetting());
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
            IXtextDocument _document_1 = editor.getDocument();
            _document_1.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(this){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression = null;
                    IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        service.executeCommand("org.eclipse.xtext.ui.FormatAction", null);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            e.printStackTrace();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }
    }

    @CanExecute
    public boolean canExecute() {
        boolean _xblockexpression = false;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            _document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            PinConfiguration config = CopyBoardIntoProject.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                CopyBoardIntoProject.this.canExecute = CopyBoardIntoProject.this.isPlatformPlugin(config);
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }
        _xblockexpression = this.canExecute;
        return _xblockexpression;
    }

    public PinConfiguration getElementAt(XtextResource resource, int offsetStart) {
        boolean found;
        EObjectAtOffsetHelper eObjectAtOffsetHelper = new EObjectAtOffsetHelper();
        int offset = offsetStart;
        EObject selectedElement = eObjectAtOffsetHelper.resolveContainedElementAt(resource, offset);
        if (selectedElement != null) {
            selectedElement = this.getPinConfiguration(selectedElement);
        }
        if (found = PinConfiguration.class.isInstance(selectedElement)) {
            return (PinConfiguration)PinConfiguration.class.cast(selectedElement);
        }
        return null;
    }

    public PinConfiguration getPinConfiguration(EObject current) {
        EObject parent;
        for (parent = current; parent != null && !PinConfiguration.class.isInstance(parent); parent = parent.eContainer()) {
        }
        if (parent instanceof PinConfiguration) {
            return (PinConfiguration)parent;
        }
        return null;
    }

    public boolean isPlatformPlugin(PinConfiguration cfg) {
        PinSettings ps = cfg.getPinSetting();
        if (ps == null) {
            return false;
        }
        Board board = GpioCfgHelper.getBoard((PinSettings)ps);
        URI sourceURI = board.eResource().getURI();
        return sourceURI.isPlatformPlugin();
    }

    public void copyBoardIntoProject(PinSettings ps) {
        CopyBoardIntoProject.copyBoardIntoProject(ps, null, null, null);
    }

    public static String copyBoardIntoProject(PinSettings ps, Resource r, URI s, URIConverter c) {
        try {
            boolean _not;
            if (ps == null) {
                return null;
            }
            Board board = GpioCfgHelper.getBoard((PinSettings)ps);
            URI sourceURI = null;
            sourceURI = s != null ? s : board.eResource().getURI();
            boolean _isPlatformPlugin = sourceURI.isPlatformPlugin();
            boolean bl = _not = !_isPlatformPlugin;
            if (_not) {
                return null;
            }
            URIConverter converter = null;
            converter = c != null ? c : ps.eResource().getResourceSet().getURIConverter();
            InputStream inputStream = converter.createInputStream(sourceURI);
            Shell _activeShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(_activeShell, 8192);
            dlg.setOverwrite(true);
            dlg.setFilterPath("");
            IProject project = null;
            project = r != null ? CopyBoardIntoProject.getProject(r.getURI()) : CopyBoardIntoProject.getProject((EObject)ps);
            IPath base = project.getLocation();
            dlg.setFilterPath(base.toString());
            dlg.setText("Select an output file");
            dlg.setFileName(CopyBoardIntoProject.fileName(sourceURI));
            String outFile = dlg.open();
            if (outFile == null) {
                return null;
            }
            CopyBoardFileRunnable runnable = new CopyBoardFileRunnable(ps, project, inputStream, outFile);
            SafeRunner.run((ISafeRunnable)runnable);
            return runnable.getOutputFile();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String copyBoardIntoConfig(PinSettings ps, Resource r, URI s, URIConverter c) {
        try {
            boolean _not;
            if (ps == null) {
                return null;
            }
            Board board = GpioCfgHelper.getBoard((PinSettings)ps);
            URI sourceURI = null;
            sourceURI = s != null ? s : board.eResource().getURI();
            boolean _isPlatformPlugin = sourceURI.isPlatformPlugin();
            boolean bl = _not = !_isPlatformPlugin;
            if (_not) {
                return null;
            }
            URIConverter converter = null;
            converter = c != null ? c : ps.eResource().getResourceSet().getURIConverter();
            InputStream inputStream = converter.createInputStream(sourceURI);
            Shell _activeShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(_activeShell, 8192);
            dlg.setOverwrite(true);
            dlg.setFilterPath("");
            IProject project = null;
            project = r != null ? CopyBoardIntoProject.getProject(r.getURI()) : CopyBoardIntoProject.getProject((EObject)ps);
            IPath base = project.getLocation();
            dlg.setFilterPath(base.toString());
            dlg.setText("Select an output file");
            String _name = ps.getName();
            String _plus = _name + "_";
            String _fileName = CopyBoardIntoProject.fileName(sourceURI);
            String _plus_1 = _plus + _fileName;
            dlg.setFileName(_plus_1);
            String outFile = dlg.open();
            if (outFile == null) {
                return null;
            }
            CopyBoardIntoConfigRunnable runnable = new CopyBoardIntoConfigRunnable(ps, r, project, inputStream, outFile);
            SafeRunner.run((ISafeRunnable)runnable);
            return runnable.getOutputFile();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IProject getProject(EObject model) {
        return CopyBoardIntoProject.getProject(model.eResource().getURI());
    }

    public static IProject getProject(URI uri) {
        IProject project = null;
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    private static String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        return lastSegment;
    }

    public static class CopyBoardFileRunnable
    extends SafeRunnable {
        private IPath base;
        private IProject project;
        private InputStream inputStream;
        private PinSettings ps;
        private String outFile = null;

        public CopyBoardFileRunnable(PinSettings ps, IProject project, InputStream inputStream, String outFile) {
            this.outFile = outFile;
            this.project = project;
            this.base = project.getLocation();
            this.inputStream = inputStream;
            this.ps = ps;
        }

        public void run() throws Exception {
            Path _path;
            boolean _isPrefixOf;
            boolean _not;
            boolean _tripleEquals;
            IPath projectPath = this.base;
            Path location = new Path(this.outFile);
            location = location.makeRelativeTo(this.base);
            String _string = location.toString();
            File dest = new File(_string);
            boolean insideGoodProject = true;
            location = location.makeRelativeTo(this.base);
            IFile ifile = this.project.getFile(dest.getPath());
            IPath _rawLocation = ifile.getRawLocation();
            boolean bl = _tripleEquals = _rawLocation == null;
            if (_tripleEquals) {
                insideGoodProject = false;
            }
            boolean bl2 = _not = !(_isPrefixOf = projectPath.isPrefixOf((IPath)(_path = new Path(this.outFile))));
            if (_not) {
                insideGoodProject = false;
            }
            if (insideGoodProject) {
                boolean _not_1;
                File file = ifile.getRawLocation().makeAbsolute().toFile();
                boolean _exists = file.exists();
                boolean bl3 = _not_1 = !_exists;
                if (_not_1) {
                    file.createNewFile();
                }
                FileUtils.copyInputStreamToFile((InputStream)this.inputStream, (File)file);
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                this.project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
                IncludeBoard inc = GpioCfgPackage.eINSTANCE.getGpioCfgFactory().createIncludeBoard();
                String decodedUri = URLDecoder.decode(ifile.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                if (this.ps.getIncludedBoard() == null || this.ps.getIncludedBoard().getImportURI() == null) {
                    inc.setVersion("2.0.0");
                    inc.setIsSetVersion(true);
                } else {
                    boolean _tripleNotEquals;
                    PinConfiguration boardConfig;
                    String boardURI = this.ps.getIncludedBoard().getImportURI();
                    Resource r = EcoreUtil2.getResource((Resource)this.ps.eResource(), (String)boardURI.toString());
                    Resource boardResource = EcoreUtil2.getResource((Resource)r, (String)(boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0))).getBoard().getIncludes().getImportURI());
                    PinmapModel model = (PinmapModel)PinmapModel.class.cast(boardResource.getContents().get(0));
                    String _version = model.getVersion();
                    boolean bl4 = _tripleNotEquals = _version != null;
                    if (_tripleNotEquals) {
                        inc.setVersion(model.getVersion());
                        inc.setIsSetVersion(true);
                    } else {
                        inc.setIsSetVersion(false);
                    }
                }
                inc.setImportURI(uri.toString());
                this.outFile = uri.toString();
                this.ps.setIncludedBoard(inc);
            } else {
                boolean _notEquals;
                PlainMessageDialog dialog = PlainMessageDialog.getBuilder((Shell)Display.getDefault().getActiveShell(), (String)"Copy board file").message(NLS.bind((String)"''{0}'' is not a valid destination...\n\nDestination location must be inside your project", (Object)this.outFile)).build();
                int _open = dialog.open();
                boolean bl5 = _notEquals = _open != 0;
                if (_notEquals) {
                    return;
                }
            }
            this.inputStream.close();
        }

        public String getOutputFile() {
            return this.outFile;
        }
    }

    public static class CopyBoardIntoConfigRunnable
    extends SafeRunnable {
        private IPath base;
        private IProject project;
        private InputStream inputStream;
        private PinSettings pinConfigDefinitions;
        private Resource resource;
        private String outFile = null;

        public CopyBoardIntoConfigRunnable(PinSettings ps, Resource resource, IProject project, InputStream inputStream, String outFile) {
            this.outFile = outFile;
            this.project = project;
            this.base = project.getLocation();
            this.inputStream = inputStream;
            this.resource = resource;
            this.pinConfigDefinitions = ps;
        }

        public void run() throws Exception {
            Path _path;
            boolean _isPrefixOf;
            boolean _not;
            boolean _tripleEquals;
            IPath projectPath = this.base;
            Path location = new Path(this.outFile);
            location = location.makeRelativeTo(this.base);
            String _string = location.toString();
            File dest = new File(_string);
            boolean insideGoodProject = true;
            location = location.makeRelativeTo(this.base);
            IFile ifile = this.project.getFile(dest.getPath());
            IPath _rawLocation = ifile.getRawLocation();
            boolean bl = _tripleEquals = _rawLocation == null;
            if (_tripleEquals) {
                insideGoodProject = false;
            }
            boolean bl2 = _not = !(_isPrefixOf = projectPath.isPrefixOf((IPath)(_path = new Path(this.outFile))));
            if (_not) {
                insideGoodProject = false;
            }
            if (insideGoodProject) {
                boolean _tripleNotEquals;
                boolean _not_1;
                File file = ifile.getRawLocation().makeAbsolute().toFile();
                boolean _exists = file.exists();
                boolean bl3 = _not_1 = !_exists;
                if (_not_1) {
                    file.createNewFile();
                }
                FileUtils.copyInputStreamToFile((InputStream)this.inputStream, (File)file);
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                this.project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
                this.inputStream.close();
                URI localBoardUri = URI.createFileURI((String)file.getAbsolutePath());
                Resource localBoardResource = GpioCfgHelper.getResource((Resource)this.resource, (String)localBoardUri.toString());
                EObject _get = (EObject)localBoardResource.getContents().get(0);
                PinConfiguration boardConfigDefinitions = (PinConfiguration)_get;
                this.pinConfigDefinitions.getModules().addAll(EcoreUtil.copyAll((Collection)boardConfigDefinitions.getBoard().getModules()));
                boardConfigDefinitions.getBoard().getModules().clear();
                try {
                    localBoardResource.save(this.resource.getResourceSet().getLoadOptions());
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException e = (IOException)_t;
                        e.printStackTrace();
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                IncludeBoard ps_inc = GpioCfgPackage.eINSTANCE.getGpioCfgFactory().createIncludeBoard();
                String decodedUri = URLDecoder.decode(ifile.getProjectRelativePath().toOSString(), "UTF-8");
                URI targetUri = URI.createFileURI((String)decodedUri);
                ps_inc.setImportURI(targetUri.toString());
                this.pinConfigDefinitions.setIncludedBoard(ps_inc);
                String _version = boardConfigDefinitions.getBoard().getIncludes().getVersion();
                boolean bl4 = _tripleNotEquals = _version != null;
                if (_tripleNotEquals) {
                    ps_inc.setVersion(boardConfigDefinitions.getBoard().getIncludes().getVersion());
                    ps_inc.setIsSetVersion(true);
                } else {
                    ps_inc.setIsSetVersion(false);
                }
                this.outFile = targetUri.toString();
            } else {
                boolean _notEquals;
                PlainMessageDialog dialog = PlainMessageDialog.getBuilder((Shell)Display.getDefault().getActiveShell(), (String)"Copy board file").message(NLS.bind((String)"''{0}'' is not a valid destination...\n\nDestination location must be inside your project", (Object)this.outFile)).build();
                int _open = dialog.open();
                boolean bl5 = _notEquals = _open != 0;
                if (_notEquals) {
                    return;
                }
            }
        }

        public String getOutputFile() {
            return this.outFile;
        }
    }

    public static class MyRunnable
    extends SafeRunnable {
        private IPath base;
        private IProject project;
        private InputStream inputStream;
        private PinSettings ps;
        private String outFile = null;

        public MyRunnable(PinSettings ps, IProject project, InputStream inputStream, String outFile) {
            this.outFile = outFile;
            this.project = project;
            this.base = project.getLocation();
            this.inputStream = inputStream;
            this.ps = ps;
        }

        public void run() throws Exception {
            Path _path;
            boolean _isPrefixOf;
            boolean _not;
            boolean _tripleEquals;
            IPath projectPath = this.base;
            Path location = new Path(this.outFile);
            location = location.makeRelativeTo(this.base);
            String _string = location.toString();
            File dest = new File(_string);
            boolean insideGoodProject = true;
            location = location.makeRelativeTo(this.base);
            IFile ifile = this.project.getFile(dest.getPath());
            IPath _rawLocation = ifile.getRawLocation();
            boolean bl = _tripleEquals = _rawLocation == null;
            if (_tripleEquals) {
                insideGoodProject = false;
            }
            boolean bl2 = _not = !(_isPrefixOf = projectPath.isPrefixOf((IPath)(_path = new Path(this.outFile))));
            if (_not) {
                insideGoodProject = false;
            }
            if (insideGoodProject) {
                boolean _not_1;
                File file = ifile.getRawLocation().makeAbsolute().toFile();
                boolean _exists = file.exists();
                boolean bl3 = _not_1 = !_exists;
                if (_not_1) {
                    file.createNewFile();
                }
                FileUtils.copyInputStreamToFile((InputStream)this.inputStream, (File)file);
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                this.project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
                IncludeBoard inc = GpioCfgPackage.eINSTANCE.getGpioCfgFactory().createIncludeBoard();
                String decodedUri = URLDecoder.decode(ifile.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                if (this.ps.getIncludedBoard() == null || this.ps.getIncludedBoard().getImportURI() == null) {
                    inc.setVersion("2.0.0");
                    inc.setIsSetVersion(true);
                } else {
                    boolean _tripleNotEquals;
                    PinConfiguration boardConfig;
                    String boardURI = this.ps.getIncludedBoard().getImportURI();
                    Resource r = EcoreUtil2.getResource((Resource)this.ps.eResource(), (String)boardURI.toString());
                    Resource boardResource = EcoreUtil2.getResource((Resource)r, (String)(boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0))).getBoard().getIncludes().getImportURI());
                    PinmapModel model = (PinmapModel)PinmapModel.class.cast(boardResource.getContents().get(0));
                    String _version = model.getVersion();
                    boolean bl4 = _tripleNotEquals = _version != null;
                    if (_tripleNotEquals) {
                        inc.setVersion(model.getVersion());
                        inc.setIsSetVersion(true);
                    } else {
                        inc.setIsSetVersion(false);
                    }
                }
                inc.setImportURI(uri.toString());
                this.outFile = uri.toString();
                this.ps.setIncludedBoard(inc);
            } else {
                boolean _notEquals;
                PlainMessageDialog dialog = PlainMessageDialog.getBuilder((Shell)Display.getDefault().getActiveShell(), (String)"Copy board file").message(NLS.bind((String)"''{0}'' is not a valid destination...\n\nDestination location must be inside your project", (Object)this.outFile)).build();
                int _open = dialog.open();
                boolean bl5 = _notEquals = _open != 0;
                if (_notEquals) {
                    return;
                }
            }
            this.inputStream.close();
        }

        public String getOutputFile() {
            return this.outFile;
        }
    }
}

