/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.handler;

import com.google.inject.Inject;
import com.st.stellar.model.lib.ModelsLib;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.gpiocfg.ui.handler.CopyBoardIntoProject;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class MigrateConfiguration {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private static final Logger logger = LogManager.getLogger(CopyBoardIntoProject.class);
    private EModelService modelService;
    private EPartService partService;
    private MApplication application;
    private boolean canExecute = true;

    public Object refreshProject() {
        Object _xblockexpression = null;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        Object _xifexpression = null;
        if (iworkbench != null) {
            Object _xblockexpression_1 = null;
            IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
            Object _xifexpression_1 = null;
            if (iworkbenchwindow != null) {
                Object _xblockexpression_2 = null;
                IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
                Object _xifexpression_2 = null;
                if (iworkbenchpage != null) {
                    Object _xblockexpression_3 = null;
                    IEditorPart ieditorpart = iworkbenchpage.getActiveEditor();
                    Object _xifexpression_3 = null;
                    if (ieditorpart != null) {
                        Object _xblockexpression_4 = null;
                        IEditorInput editorinput = ieditorpart.getEditorInput();
                        Object _xifexpression_4 = null;
                        boolean _isInstance = IFileEditorInput.class.isInstance(editorinput);
                        if (_isInstance) {
                            Object _xblockexpression_5 = null;
                            IFileEditorInput fei = (IFileEditorInput)IFileEditorInput.class.cast(editorinput);
                            IProject project = fei.getFile().getProject();
                            Object _xtrycatchfinallyexpression = null;
                            try {
                                project.refreshLocal(2, null);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof CoreException) {
                                    _xtrycatchfinallyexpression = null;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            _xifexpression_4 = _xblockexpression_5 = _xtrycatchfinallyexpression;
                        }
                        _xifexpression_3 = _xblockexpression_4 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Execute
    public void execute(EModelService modelService, EPartService partService, MApplication application) {
        this.modelService = modelService;
        this.application = application;
        this.partService = partService;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            _document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            PinConfiguration config = MigrateConfiguration.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                MigrateConfiguration.this.migrateProject(config);
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
            IXtextDocument _document_1 = editor.getDocument();
            _document_1.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(this){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression = null;
                    IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        service.executeCommand("org.eclipse.xtext.ui.FormatAction", null);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            e.printStackTrace();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }
    }

    @CanExecute
    public boolean canExecute() {
        boolean _xblockexpression = false;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            abstract class __MigrateConfiguration_3
            implements IUnitOfWork<XtextResource, XtextResource> {
                __MigrateConfiguration_3(MigrateConfiguration this$0) {
                }

                public abstract String getPinSettingVersion(PinConfiguration var1);

                public abstract String getBoardVersion(PinConfiguration var1);
            }
            __MigrateConfiguration_3 ___MigrateConfiguration_3 = new __MigrateConfiguration_3(){
                {
                    super(MigrateConfiguration.this);
                }

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block8: {
                        _xblockexpression = null;
                        try {
                            MigrateConfiguration.this.canExecute = false;
                            PinConfiguration config = MigrateConfiguration.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                boolean _tripleNotEquals;
                                PinSettings _pinSetting = config.getPinSetting();
                                boolean bl = _tripleNotEquals = _pinSetting != null;
                                if (_tripleNotEquals) {
                                    MigrateConfiguration.this.canExecute = true;
                                    boolean _isIsSetVersion = config.getPinSetting().getIncludedBoard().isIsSetVersion();
                                    if (_isIsSetVersion) {
                                        boolean _not;
                                        String configVersion = config.getPinSetting().getIncludedBoard().getVersion();
                                        String boardVersion = this.getPinSettingVersion(config);
                                        boolean _equals = boardVersion.equals(configVersion);
                                        MigrateConfiguration.this.canExecute = _not = !_equals;
                                    }
                                } else {
                                    boolean _tripleNotEquals_1;
                                    Board _board = config.getBoard();
                                    boolean bl2 = _tripleNotEquals_1 = _board != null;
                                    if (_tripleNotEquals_1) {
                                        MigrateConfiguration.this.canExecute = true;
                                        boolean _isIsSetVersion_1 = config.getBoard().getIncludes().isIsSetVersion();
                                        if (_isIsSetVersion_1) {
                                            boolean _not_1;
                                            String pinmapModelVersion = this.getBoardVersion(config);
                                            Board board = config.getBoard();
                                            String _elvis = null;
                                            String _version = board.getIncludes().getVersion();
                                            _elvis = _version != null ? _version : "";
                                            String usedVersion = _elvis;
                                            boolean _equals_1 = usedVersion.equals(pinmapModelVersion);
                                            MigrateConfiguration.this.canExecute = _not_1 = !_equals_1;
                                        }
                                    }
                                }
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block8;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }

                @Override
                public String getPinSettingVersion(PinConfiguration config) {
                    String _xblockexpression = null;
                    PinSettings ps = config.getPinSetting();
                    Resource r = GpioCfgHelper.getResource((Resource)config.eResource(), (String)ps.getIncludedBoard().getImportURI());
                    boolean _isInstance = PinConfiguration.class.isInstance(r.getContents().get(0));
                    if (_isInstance) {
                        PinConfiguration boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0));
                        return MigrateConfiguration.this._gpioCfgHelper.getIncludes(boardConfig).getVersion();
                    }
                    _xblockexpression = "";
                    return _xblockexpression;
                }

                @Override
                public String getBoardVersion(PinConfiguration config) {
                    String _xblockexpression = null;
                    Board board = config.getBoard();
                    Resource r = GpioCfgHelper.getResource((Resource)config.eResource(), (String)board.getIncludes().getImportURI());
                    boolean _isInstance = PinmapModel.class.isInstance(r.getContents().get(0));
                    if (_isInstance) {
                        PinmapModel pinmapModel = (PinmapModel)PinmapModel.class.cast(r.getContents().get(0));
                        String pinmapModelVersion = pinmapModel.getVersion();
                        return pinmapModelVersion;
                    }
                    _xblockexpression = "";
                    return _xblockexpression;
                }
            };
            _document.readOnly((IUnitOfWork)___MigrateConfiguration_3);
        }
        _xblockexpression = this.canExecute;
        return _xblockexpression;
    }

    public PinConfiguration getElementAt(XtextResource resource, int offsetStart) {
        boolean found;
        EObjectAtOffsetHelper eObjectAtOffsetHelper = new EObjectAtOffsetHelper();
        int offset = offsetStart;
        EObject selectedElement = eObjectAtOffsetHelper.resolveContainedElementAt(resource, offset);
        if (selectedElement != null) {
            selectedElement = this.getPinConfiguration(selectedElement);
        }
        if (found = PinConfiguration.class.isInstance(selectedElement)) {
            return (PinConfiguration)PinConfiguration.class.cast(selectedElement);
        }
        return null;
    }

    public PinConfiguration getPinConfiguration(EObject current) {
        EObject parent;
        for (parent = current; parent != null && !PinConfiguration.class.isInstance(parent); parent = parent.eContainer()) {
        }
        if (parent instanceof PinConfiguration) {
            return (PinConfiguration)parent;
        }
        return null;
    }

    public boolean isPlatformPlugin(PinSettings ps) {
        if (ps == null) {
            return false;
        }
        Board board = GpioCfgHelper.getBoard((PinSettings)ps);
        URI sourceURI = board.eResource().getURI();
        return sourceURI.isPlatformPlugin();
    }

    public IFile getGpioFile(PinConfiguration pinSettings) {
        IFile res;
        IFile _xblockexpression = null;
        URI uri = pinSettings.eResource().getURI();
        uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        String _platformString = uri.toPlatformString(true);
        Path _path = new Path(_platformString);
        _xblockexpression = res = _root.getFile((IPath)_path);
        return _xblockexpression;
    }

    public void migrateProject(PinConfiguration config) {
        boolean _openQuestion;
        if (config != null && (_openQuestion = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Migrate configuration", (String)"Pinmap configuration is going to be migrated to latest version. Do you agree?"))) {
            boolean _tripleNotEquals;
            PinSettings _pinSetting = config.getPinSetting();
            boolean bl = _tripleNotEquals = _pinSetting != null;
            if (_tripleNotEquals) {
                PinSettings ps = config.getPinSetting();
                IFile file = this.getGpioFile(config);
                Resource r = GpioCfgHelper.getResource((Resource)config.eResource(), (String)ps.getIncludedBoard().getImportURI());
                boolean _isInstance = PinConfiguration.class.isInstance(r.getContents().get(0));
                if (_isInstance) {
                    PinConfiguration boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0));
                    String version = this._gpioCfgHelper.getIncludes(boardConfig).getVersion();
                    Resource rboard = GpioCfgHelper.getResource((Resource)config.eResource(), (String)this._gpioCfgHelper.getIncludes(boardConfig).getImportURI());
                    boolean _isInstance_1 = PinmapModel.class.isInstance(rboard.getContents().get(0));
                    if (_isInstance_1) {
                        PinmapModel pinmapModel = (PinmapModel)PinmapModel.class.cast(rboard.getContents().get(0));
                        String pinmapModelVersion = pinmapModel.getVersion();
                        ModelsLib.applyMigration((String)"http://www.st.com/stellar/pinmap/gpio/GpioDsl", (String)version, (String)pinmapModelVersion, (String)file.getLocation().toOSString());
                    }
                }
            } else {
                boolean _tripleNotEquals_1;
                Board _board = config.getBoard();
                boolean bl2 = _tripleNotEquals_1 = _board != null;
                if (_tripleNotEquals_1) {
                    Board board = config.getBoard();
                    String version_1 = board.getIncludes().getVersion();
                    IFile file_1 = this.getGpioFile(config);
                    Resource r_1 = GpioCfgHelper.getResource((Resource)config.eResource(), (String)board.getIncludes().getImportURI());
                    boolean _isInstance_2 = PinmapModel.class.isInstance(r_1.getContents().get(0));
                    if (_isInstance_2) {
                        PinmapModel pinmapModel_1 = (PinmapModel)PinmapModel.class.cast(r_1.getContents().get(0));
                        String pinmapModelVersion_1 = pinmapModel_1.getVersion();
                        ModelsLib.applyMigration((String)"http://www.st.com/stellar/pinmap/gpio/GpioDsl", (String)version_1, (String)pinmapModelVersion_1, (String)file_1.getLocation().toOSString());
                    }
                }
            }
        }
        this.refreshProject();
    }
}

