/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.handler;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Collection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class OpenPackageDiagram {
    private EModelService modelService;
    private EPartService partService;
    private MApplication application;
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private static final Logger LOG = LogManager.getLogger(OpenPackageDiagram.class);
    private static final String ID_STACK = "org.eclipse.e4.primaryDataStack";

    @CanExecute
    public boolean canExecute() {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor();
        if (xtextEditor != null) {
            IXtextDocument document = xtextEditor.getDocument();
            PinSettings pinSettings = this.getGetPinSettings(document);
            return pinSettings != null;
        }
        return false;
    }

    @Execute
    public void execute(EModelService modelService, EPartService partService, MApplication application) {
        this.modelService = modelService;
        this.application = application;
        this.partService = partService;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor();
        if (xtextEditor != null) {
            boolean _tripleEquals;
            boolean _greaterThan;
            IXtextDocument document = xtextEditor.getDocument();
            PinSettings pinSettings = this.getGetPinSettings(document);
            int _size = pinSettings.eResource().getErrors().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Package Diagram", (String)NLS.bind((String)"There are errors in the configuration file ''{0}''\n\nPackage diagram is not updated", (Object)pinSettings.eResource().getURI().toPlatformString(true)));
                return;
            }
            Package _package = GpioCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage();
            boolean bl2 = _tripleEquals = _package == null;
            if (_tripleEquals) {
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                String editorId = "com.st.stellar.pinmap.gpiocfg.glsp.editor.GpioCfgGLSPDiagramEditor";
                IFile file = this.getGpioFile(pinSettings);
                boolean _exists = file.exists();
                if (_exists) {
                    int mask = 3;
                    FileEditorInput _fileEditorInput = new FileEditorInput(file);
                    page.openEditor((IEditorInput)_fileEditorInput, "com.st.stellar.pinmap.gpiocfg.glsp.editor.GpioCfgGLSPDiagramEditor", true, 3);
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Package Diagram", (String)NLS.bind((String)"Cannot open ''{0}''\n\n Pinmap configuration diagram...\n\n", (Object)file.toString().replace("L/", "")));
                }
                this.splitWindow();
            }
            catch (Throwable _t) {
                if (_t instanceof PartInitException) {
                    PartInitException e = (PartInitException)_t;
                    LOG.error((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public IFile getGpioFile(PinSettings pinSettings) {
        IFile res;
        IFile _xblockexpression = null;
        URI uri = pinSettings.eResource().getURI();
        uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        String _platformString = uri.toPlatformString(true);
        Path _path = new Path(_platformString);
        _xblockexpression = res = _root.getFile((IPath)_path);
        return _xblockexpression;
    }

    public PinSettings getGetPinSettings(IXtextDocument document) {
        PinSettings pinSettings;
        PinSettings _xblockexpression = null;
        _xblockexpression = pinSettings = (PinSettings)document.tryReadOnly((IUnitOfWork)new IUnitOfWork<PinSettings, XtextResource>(this){

            public PinSettings exec(XtextResource state) throws Exception {
                boolean _not;
                PinSettings _xblockexpression = null;
                PinSettings rootObject = null;
                EList contents = state.getContents();
                boolean _isEmpty = contents.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _tripleNotEquals;
                    EObject _get = (EObject)contents.get(0);
                    PinConfiguration cfg = (PinConfiguration)_get;
                    PinSettings _pinSetting = cfg.getPinSetting();
                    boolean bl2 = _tripleNotEquals = _pinSetting != null;
                    if (_tripleNotEquals) {
                        rootObject = cfg.getPinSetting();
                    }
                }
                _xblockexpression = rootObject;
                return _xblockexpression;
            }
        });
        return _xblockexpression;
    }

    public boolean splitWindow() {
        boolean _xblockexpression = false;
        MUIElement _find = this.modelService.find(ID_STACK, (MUIElement)this.application);
        MPartStack stack = (MPartStack)_find;
        Collection parts = this.partService.getParts();
        MPart browserPart = null;
        for (MPart p : parts) {
            if (p.getLabel() == null || !p.getLabel().equals("Web Browser")) continue;
            browserPart = p;
        }
        boolean _xifexpression = false;
        if (browserPart != null) {
            boolean _xblockexpression_1 = false;
            InputOutput.println(browserPart);
            MElementContainer curParent = stack.getParent();
            MElementContainer browserParent = browserPart.getParent();
            boolean _xifexpression_1 = false;
            if (browserParent.getContainerData() == null || browserParent.getContainerData().isEmpty()) {
                boolean _xblockexpression_2 = false;
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setElementId("newSashContainer");
                newSash.setHorizontal(true);
                curParent.getChildren().add(newSash);
                newSash.getChildren().add(stack);
                stack.setContainerData("5000");
                MPartStack newstack = BasicFactoryImpl.eINSTANCE.createPartStack();
                newstack.setElementId("newPartStack");
                newstack.getChildren().add(browserPart);
                newstack.setSelectedElement((MUIElement)browserPart);
                newstack.setContainerData("5000");
                _xifexpression_1 = _xblockexpression_2 = newSash.getChildren().add(newstack);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IFile getHtmlFile(PinSettings pinSettings) {
        IFile ifile;
        IFile _xblockexpression = null;
        this._gpioCfgHelper = GpioCfgHelper.instance;
        _xblockexpression = ifile = this._gpioCfgHelper.getGenerationFile(pinSettings, "html");
        return _xblockexpression;
    }
}

