/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.ui.wizard;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class PinmapConfigWizGeneralPage
extends WizardPage {
    private Button projectLocation;
    private Text projectLocationText;
    private Text projectNameText;
    private Button browseFS;
    private ISelection selection;
    private IProject project;
    private WorkingSetGroup _workingSetGroup;
    public static String REGEX_PROJECT_NAME = "[a-zA-Z0-9\\-_ ]+";

    public PinmapConfigWizGeneralPage(ISelection selection) {
        super("Pinmap configuration");
        this.setTitle("Pinmap configuration");
        this.setDescription("Specify the project model to be used");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("Project name");
        this.projectNameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.projectNameText.setLayoutData((Object)gd);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PinmapConfigWizGeneralPage.this.dialogChanged();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.projectNameText.setLayoutData((Object)gd);
        this.projectLocation = new Button(container, 32);
        this.projectLocation.setText("Use default location");
        this.projectLocation.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PinmapConfigWizGeneralPage.this.projectLocation.getSelection()) {
                    PinmapConfigWizGeneralPage.this.projectLocationText.setEnabled(false);
                    PinmapConfigWizGeneralPage.this.browseFS.setEnabled(false);
                    PinmapConfigWizGeneralPage.this.projectLocationText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                } else {
                    PinmapConfigWizGeneralPage.this.projectLocationText.setEnabled(true);
                    PinmapConfigWizGeneralPage.this.browseFS.setEnabled(true);
                    PinmapConfigWizGeneralPage.this.projectLocationText.setText("");
                }
                PinmapConfigWizGeneralPage.this.dialogChanged();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.projectLocation.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Location");
        this.projectLocationText = new Text(container, 2052);
        gd = new GridData(768);
        this.projectLocationText.setLayoutData((Object)gd);
        this.projectLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PinmapConfigWizGeneralPage.this.dialogChanged();
            }
        });
        this.browseFS = new Button(container, 8);
        this.browseFS.setText("Browse...");
        this.browseFS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PinmapConfigWizGeneralPage.this.handleBrowseFS(PinmapConfigWizGeneralPage.this.projectLocationText);
            }
        });
        Composite wsContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        wsContainer.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        wsContainer.setLayoutData((Object)gd);
        IWorkingSet[] wsList = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        String[] supportedWorkingSetTypes = (String[])Arrays.stream(wsList).map(IWorkingSet::getId).distinct().toArray(String[]::new);
        if (supportedWorkingSetTypes.length < 1) {
            supportedWorkingSetTypes = new String[]{"org.eclipse.cdt.ui.CElementWorkingSetPage"};
        }
        this._workingSetGroup = new WorkingSetGroup(wsContainer, (IStructuredSelection)(this.selection instanceof IStructuredSelection ? (IStructuredSelection)this.selection : StructuredSelection.EMPTY), supportedWorkingSetTypes);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection == null) {
            this.projectNameText.setText("Project name");
        } else if (!this.selection.isEmpty()) {
            Object sel = ((IStructuredSelection)this.selection).getFirstElement();
            if (sel instanceof IProject) {
                this.project = (IProject)sel;
                this.projectNameText.setText(this.project.getName());
            }
        } else {
            this.projectNameText.setText("Project name");
        }
        this.projectLocation.setSelection(true);
        this.projectLocationText.setEnabled(false);
        this.projectLocationText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        this.browseFS.setEnabled(false);
    }

    private void handleBrowseFS(Text text) {
        DirectoryDialog fd = new DirectoryDialog(this.getShell(), 4096);
        fd.setFilterPath("");
        fd.setText("Platform plugin");
        String selected = fd.open();
        if (selected != null) {
            text.setText(selected);
        }
    }

    private void dialogChanged() {
        IResource project = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.projectNameText.getText()));
        if (this.projectNameText.getText().length() == 0) {
            this.updateStatus("Please choose a valid project name");
            return;
        }
        if (this.projectNameText.getText().length() != 0 && !Pattern.matches(REGEX_PROJECT_NAME, this.projectNameText.getText())) {
            this.updateStatus("Invalid project name !");
            return;
        }
        if (project != null && this.project == null) {
            this.updateStatus("Project already exists !");
            return;
        }
        this.updateStatus(null);
    }

    public Text getProjectNameText() {
        return this.projectNameText;
    }

    public Text getProjectLocationText() {
        return this.projectLocationText;
    }

    public Button getProjectLocation() {
        return this.projectLocation;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this._workingSetGroup == null ? new IWorkingSet[]{} : this._workingSetGroup.getSelectedWorkingSets();
    }
}

