/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.services.GpiocfgGrammarAccess;
import com.st.stellar.pinmap.ui.contentassist.AbstractGpiocfgProposalProvider;
import com.st.stellar.pinmap.validation.GpiocfgValidator;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class GpiocfgProposalProvider
extends AbstractGpiocfgProposalProvider {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    @Inject
    private GpiocfgGrammarAccess grammar;

    @Override
    public void completeInclude_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"gpio_def"}));
            for (URI uri : _localModels) {
                String decodedUri = URLDecoder.decode(uri.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
            Collection<URI> _models = this.getModels(model, "gpio_def");
            for (URI uri_1 : _models) {
                String decodedUri = URLDecoder.decode(uri_1.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void completeIncludeBoard_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"gpio_board"}));
            for (URI uri : _localModels) {
                String decodedUri = URLDecoder.decode(uri.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
            Collection<URI> _models = this.getModels(model, "gpio_board");
            for (URI uri_1 : _models) {
                String decodedUri = URLDecoder.decode(uri_1.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Collection<URI> getModels(EObject model, String ext) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        List _models = ModelProvider.getInstance().getModels(ext);
        for (ExtensionDescription desc : _models) {
            list.add(desc.getURI());
        }
        List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{ext}));
        for (URI uri : _localModels) {
            list.add(uri);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    @Override
    public void completePinProperties_Alt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinProperties pinProperties = (PinProperties)model;
        com.st.stellar.pinmap.gpioCfg.Direction direction = pinProperties.getDirection();
        EObject _eContainer = pinProperties.eContainer();
        PinSetting pinSetting = (PinSetting)_eContainer;
        EObject _eContainer_1 = pinSetting.eContainer();
        Module module = (Module)_eContainer_1;
        Package pack = this._gpioCfgHelper.getPack(module);
        if (pack == null) {
            return;
        }
        EList _pins = pack.getPins();
        for (Pin packagePin : _pins) {
            EList _pinConfigurations = packagePin.getPinConfigurations();
            for (PinConfig pinConfig : _pinConfigurations) {
                if (!(pinConfig instanceof ConfigurablePin)) continue;
                Configuration cfg = ((ConfigurablePin)pinConfig).getRef();
                EList _functions = cfg.getFunctions();
                for (FunctionRef fct : _functions) {
                    boolean _equals;
                    boolean _directionsAreCompatible;
                    if (fct.getName().getName().startsWith("GPI") && !fct.getName().getName().contains("GPIO")) {
                        InputOutput.println((Object)fct.getName().getName());
                    }
                    if (!(_directionsAreCompatible = GpiocfgValidator.directionsAreCompatible((Function)fct.getName(), (Direction)fct.getDirection(), (com.st.stellar.pinmap.gpioCfg.Direction)direction)) || !(_equals = module.getName().getName().equals(fct.getName().getPeripheralRef().getName()))) continue;
                    String fctName = fct.getName().getName();
                    String pinName = "Pin_" + fctName;
                    Map missingInstances = this._gpioCfgHelper.getDefaultFieldInstances(module, (ConfigurablePin)pinConfig, fctName, Collections.unmodifiableList(CollectionLiterals.newArrayList()));
                    Object registers = "";
                    Set _entrySet = missingInstances.entrySet();
                    for (Map.Entry entry : _entrySet) {
                        boolean _greaterThan;
                        int _length = ((String)registers).length();
                        boolean bl = _greaterThan = _length > 0;
                        if (_greaterThan) {
                            String _registers = registers;
                            registers = _registers + ",\n\t\t";
                        }
                        String _registers_1 = registers;
                        String _key = (String)entry.getKey();
                        String _plus = _key + " = ";
                        String _value = (String)entry.getValue();
                        String _plus_1 = _plus + _value;
                        registers = _registers_1 + _plus_1;
                    }
                    Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{fctName, packagePin.getName(), pinName, registers}).toArray();
                    String proposal = NLS.bind((String)"{0} -> {1} as {2}\n\tIO\n\t\t{3}\n\t\n;", (Object[])objs);
                    String _name = fct.getName().getName();
                    String _plus = _name + " on pin ";
                    String _name_1 = packagePin.getName();
                    String _plus_1 = _plus + _name_1;
                    String _plus_2 = _plus_1 + " (pad: ";
                    String _label = cfg.getLabel();
                    String _plus_3 = _plus_2 + _label;
                    String _plus_4 = _plus_3 + ")";
                    acceptor.accept(this.createCompletionProposal(proposal, _plus_4, null, context));
                }
            }
        }
    }

    @Override
    public void completePinSetting_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinSetting pinSetting = (PinSetting)model;
        PinProperties config = pinSetting.getConfig();
        if (config == null) {
            super.completePinSetting_Name(model, assignment, context, acceptor);
        } else {
            String _name = config.getAlt().getName();
            String nameFct = "Pin_" + _name;
            acceptor.accept(this.createCompletionProposal(nameFct, nameFct, null, context));
            String _name_1 = pinSetting.getPin().getName();
            String namePin = "Pin_" + _name_1;
            acceptor.accept(this.createCompletionProposal(namePin, namePin, null, context));
        }
    }

    @Override
    public void completeModule_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof PinSettings) {
            boolean _tripleEquals;
            PinSettings pinSettings = (PinSettings)model;
            IncludeBoard _includedBoard = pinSettings.getIncludedBoard();
            boolean bl = _tripleEquals = _includedBoard == null;
            if (_tripleEquals) {
                return;
            }
            Board board = GpioCfgHelper.getBoard((PinSettings)pinSettings);
            if (board != null) {
                Package pack = board.getPackage();
                this.completeModule_Name(pack, assignment, context, acceptor);
            }
        } else if (model instanceof Board) {
            Board board_1 = (Board)model;
            Package pack_1 = board_1.getPackage();
            this.completeModule_Name(pack_1, assignment, context, acceptor);
        }
    }

    public void completeModule_Name(Package pack, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _eContainer = pack.eContainer();
        Family family = (Family)_eContainer;
        if (family != null) {
            EList _peripherals = family.getPeripherals();
            for (Peripheral module : _peripherals) {
                HashSet<com.st.stellar.pinmap.gpioCfg.Direction> directions = new HashSet<com.st.stellar.pinmap.gpioCfg.Direction>();
                if (pack == null) continue;
                EList _pins = pack.getPins();
                for (Pin packagePin : _pins) {
                    Iterable _filter = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                    for (ConfigurablePin pinConfig : _filter) {
                        Configuration cfg = pinConfig.getRef();
                        EList _functions = cfg.getFunctions();
                        for (FunctionRef fct : _functions) {
                            Direction _direction;
                            boolean _equals = fct.getName().getPeripheralRef().getName().equals(module.getName());
                            if (!_equals || (_direction = fct.getDirection()) == null) continue;
                            switch (_direction) {
                                case INPUT: {
                                    directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                    break;
                                }
                                case INPUT_OR_OUTPUT: {
                                    directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                    directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                    break;
                                }
                                case INPUT_OUTPUT: {
                                    directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                                    break;
                                }
                                case GROUND: {
                                    break;
                                }
                                case INPUT_ALTERNATE: {
                                    break;
                                }
                                case OUTPUT: {
                                    directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                    break;
                                }
                                case OUTPUT_ALTERNATE: {
                                    break;
                                }
                                case POWER: {
                                    break;
                                }
                            }
                        }
                    }
                    int _size = directions.size();
                    boolean _greaterThan = _size > 0;
                    if (!_greaterThan) continue;
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = module.getName();
                    _builder.append(_name);
                    _builder.append(" {");
                    _builder.newLineIfNotEmpty();
                    String proposal = _builder.toString();
                    acceptor.accept(this.createCompletionProposal(proposal, module.getName(), null, context));
                }
            }
        }
    }

    @Override
    public void completePinSetting_Pin(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        PinSetting pinSetting = (PinSetting)model;
        EObject _eContainer = model.eContainer();
        Module module = (Module)_eContainer;
        Package pack = this._gpioCfgHelper.getPack(module);
        if (pack == null) {
            return;
        }
        EObject _eContainer_1 = pack.eContainer();
        Family family = (Family)_eContainer_1;
        String fname = this.functionName(pinSetting.getConfig());
        if (family != null) {
            String moduleName = module.getName().getName();
            EList _pins = pack.getPins();
            for (Pin p : _pins) {
                Iterable _filter = Iterables.filter((Iterable)p.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : _filter) {
                    Functions.Function1 _function = it -> it.getName().getPeripheralRef().getName().equals(moduleName);
                    Iterable functions = IterableExtensions.filter((Iterable)pinConfig.getRef().getFunctions(), (Functions.Function1)_function);
                    for (FunctionRef fct : functions) {
                        if (fname == null || !fct.getName().getName().equals(fname)) continue;
                        String proposal = NLS.bind((String)"{0}", (Object)p.getName());
                        String _name = p.getName();
                        String _plus = _name + " (pad: ";
                        String _label = pinConfig.getRef().getLabel();
                        String _plus_1 = _plus + _label;
                        String _plus_2 = _plus_1 + ")";
                        acceptor.accept(this.createCompletionProposal(proposal, _plus_2, null, context));
                    }
                }
            }
        }
    }

    public String functionName(PinProperties properties) {
        boolean _tripleNotEquals;
        Object _xblockexpression = null;
        Function _alt = properties.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            Function fr = properties.getAlt();
            return fr.getName();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        EObject model = context.getCurrentModel();
        if (model instanceof Module) {
            boolean _equals = this.grammar.getModuleAccess().getLeftCurlyBracketKeyword_2().getValue().equals(proposal);
            if (_equals) {
                return true;
            }
            boolean _equals_1 = proposal.equals("\"Comment\"");
            if (_equals_1) {
                return true;
            }
            Module module = (Module)model;
            return this.isValidProposal(module, proposal, prefix, context);
        }
        if (model instanceof PinSetting) {
            boolean _equals_2 = this.grammar.getPinSettingAccess().getSemicolonKeyword_1_1().getValue().equals(proposal);
            if (_equals_2) {
                return true;
            }
            boolean _equals_3 = "IO".equals(proposal);
            if (_equals_3) {
                return true;
            }
            EObject _eContainer = ((PinSetting)model).eContainer();
            Module module_1 = (Module)_eContainer;
            return this.isValidProposal(module_1, proposal, prefix, context);
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    public boolean isValidProposal(Module module, String proposal, String prefix, ContentAssistContext context) {
        Package pack = this._gpioCfgHelper.getPack(module);
        HashSet<com.st.stellar.pinmap.gpioCfg.Direction> directions = new HashSet<com.st.stellar.pinmap.gpioCfg.Direction>();
        if (pack != null) {
            boolean valid = false;
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                Iterable _filter = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : _filter) {
                    Configuration cfg = pinConfig.getRef();
                    EList _functions = cfg.getFunctions();
                    for (FunctionRef fct : _functions) {
                        Direction _direction;
                        boolean _equals = fct.getName().getPeripheralRef().getName().equals(module.getName().getName());
                        if (!_equals || (_direction = fct.getDirection()) == null) continue;
                        switch (_direction) {
                            case INPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                break;
                            }
                            case INPUT_OR_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                boolean _isGPIO = this._gpioCfgHelper.isGPIO(fct.getName());
                                if (!_isGPIO) break;
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                                break;
                            }
                            case INPUT_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                                break;
                            }
                            case GROUND: {
                                break;
                            }
                            case INPUT_ALTERNATE: {
                                break;
                            }
                            case OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                break;
                            }
                            case OUTPUT_ALTERNATE: {
                                break;
                            }
                            case POWER: {
                                break;
                            }
                        }
                    }
                }
                String proposalDir = proposal.split(" ")[0];
                Functions.Function1 _function = it -> proposalDir.equals(it.getLiteral());
                com.st.stellar.pinmap.gpioCfg.Direction d = (com.st.stellar.pinmap.gpioCfg.Direction)IterableExtensions.findFirst((Iterable)IterableExtensions.toList(directions), (Functions.Function1)_function);
                valid = valid || d != null;
            }
            return valid;
        }
        return false;
    }

    private static String ellipsis(String text, int max) {
        boolean _lessEqualsThan;
        String _xblockexpression = null;
        int _length = text.length();
        boolean bl = _lessEqualsThan = _length <= max;
        if (_lessEqualsThan) {
            return text;
        }
        int end = text.indexOf("\n", 0);
        String _xifexpression = null;
        if (end > 0) {
            String _substring = text.substring(0, end);
            _xifexpression = _substring + "...";
        } else {
            String _substring_1 = text.substring(0, max);
            _xifexpression = _substring_1 + "...";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public void completeFieldInstance_Attr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _eContainer = model.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        EObject _eContainer_1 = ps.eContainer();
        Module module = (Module)_eContainer_1;
        ArrayList alreadyThere = CollectionLiterals.newArrayList();
        if (model instanceof IOFields && ps.getIoFields() != null) {
            alreadyThere = ps.getIoFields().getReg();
            ConfigurablePin pin = GpioCfgHelper.getFirstConfigurablePin((PinSetting)ps);
            String id = pin.getRef().getName();
            Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
            Matcher matcher = pattern.matcher(id);
            boolean _find = matcher.find();
            if (_find) {
                ConfigurablePin rootObject;
                String bank = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                for (rootObject = pin; rootObject != null && !(rootObject instanceof Family); rootObject = rootObject.eContainer()) {
                }
                Family root = (Family)rootObject;
                Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
                Iterable registerList = IterableExtensions.filter((Iterable)((AddressBlockType)root.getRef().getAddressBlock().get(0)).getRegister(), (Functions.Function1)_function);
                Functions.Function1 _function_1 = it -> this._gpioCfgHelper.isSupported(it);
                Iterable _filter = IterableExtensions.filter((Iterable)registerList, (Functions.Function1)_function_1);
                for (RegisterType reg : _filter) {
                    Functions.Function1 _function_3;
                    FieldInstance there;
                    Functions.Function1 _function_2 = it -> it.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index));
                    FieldType bf = (FieldType)IterableExtensions.findFirst((Iterable)reg.getField(), (Functions.Function1)_function_2);
                    if (bf == null || (there = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)(_function_3 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(bf.getName())))) != null) continue;
                    String kept = GpiocfgProposalProvider.ellipsis(bf.getDescription().strip(), 25);
                    String _name = bf.getName();
                    String _name_1 = bf.getName();
                    String _plus = _name_1 + " -> ";
                    String _plus_1 = _plus + kept;
                    ICompletionProposal proposal = this.createCompletionProposal(_name, _plus_1, null, context);
                    acceptor.accept(proposal);
                }
                Functions.Function1 _function_2 = it -> {
                    FieldType _attr = it.getAttr();
                    return _attr != null;
                };
                Functions.Function1 _function_3 = it -> it.getAttr().getName();
                List iofields = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)ps.getIoFields().getReg(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                Map missingInstances = this._gpioCfgHelper.getDefaultFieldInstances(module, pin, ps.getConfig().getAlt().getName(), IterableExtensions.toList((Iterable)iofields));
                Object registers = "";
                Map entries = missingInstances;
                List instanceList = IterableExtensions.toList(entries.entrySet());
                Collections.sort(instanceList, new Comparator<Map.Entry<String, String>>(this){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                for (Map.Entry entry : instanceList) {
                    boolean _greaterThan;
                    int _length = ((String)registers).length();
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        String _registers = registers;
                        registers = _registers + ",\n\t\t";
                    }
                    String _registers_1 = registers;
                    String _key = (String)entry.getKey();
                    String _plus = _key + " = ";
                    String _value = (String)entry.getValue();
                    String _plus_1 = _plus + _value;
                    registers = _registers_1 + _plus_1;
                }
                ICompletionProposal proposal = this.createCompletionProposal((String)registers, "-- Add missing attributes with their default values", null, context);
                acceptor.accept(proposal);
            }
        }
    }

    public FieldType getField(RegisterType r, String index) {
        FieldType field;
        FieldType _xblockexpression;
        block6: {
            _xblockexpression = null;
            field = null;
            try {
                field = (FieldType)r.getField().get(Integer.parseInt(index));
            }
            catch (Throwable _t) {
                if (_t instanceof IndexOutOfBoundsException) {
                    field = null;
                    try {
                        EList _field = r.getField();
                        int _parseInt = Integer.parseInt(index);
                        int _minus = 8 - _parseInt;
                        field = (FieldType)_field.get(_minus);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof Exception) {
                            field = null;
                            break block6;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        _xblockexpression = field;
        return _xblockexpression;
    }

    @Override
    public void completeFieldInstance_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _isInstance = FieldInstance.class.isInstance(model);
        if (_isInstance) {
            FieldInstance regInstance = (FieldInstance)model;
            this.completeValues(regInstance, context, acceptor);
        }
    }

    public void completeValues(FieldInstance regInstance, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        PinProperties _config;
        FieldType _attr;
        FieldType field = _attr = regInstance.getAttr();
        EObject _eContainer = regInstance.eContainer();
        IOFields ioFields = (IOFields)_eContainer;
        EObject _eContainer_1 = ioFields.eContainer();
        PinSetting ps = (PinSetting)_eContainer_1;
        PinProperties pp = _config = ps.getConfig();
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            boolean _equals;
            FunctionRef functionRef;
            Object value;
            boolean _startsWith = field.getName().startsWith("MODER");
            if (_startsWith && (value = (functionRef = GpioCfgHelper.getFunctionRef((PinSetting)ps)).getAlt()) != null && (_equals = "Direct_Analog".equals(value))) {
                value = "Analog";
                String _name = pp.getAlt().getName();
                String desc = "The only possible value for function: " + _name;
                acceptor.accept(this.createCompletionProposal("'" + (String)value + "'", "'" + (String)value + "' -> " + desc, null, context));
                return;
            }
            EList _enumeratedValue = field.getEnumeratedValues().getEnumeratedValue();
            for (EnumeratedValueType enum_ : _enumeratedValue) {
                String value_1 = enum_.getValue();
                String desc_1 = enum_.getDescription();
                String _xifexpression = null;
                _xifexpression = desc_1 != null ? GpiocfgProposalProvider.ellipsis(desc_1.strip(), 25) : value_1;
                String kept = _xifexpression;
                String _name_1 = enum_.getName();
                String _plus = "'" + _name_1;
                String _plus_1 = _plus + "'";
                acceptor.accept(this.createCompletionProposal(_plus_1, "\"" + value_1 + "\" -> " + kept, null, context));
            }
        } else {
            boolean _tripleNotEquals_1;
            String _name_1 = field.getName();
            boolean bl2 = _tripleNotEquals_1 = _name_1 != null;
            if (_tripleNotEquals_1) {
                boolean _startsWith_1 = field.getName().startsWith("AFR");
                if (_startsWith_1) {
                    boolean _equals_1;
                    Functions.Function1 _function = it -> it.getName().getName().equals(pp.getAlt().getName());
                    Iterable functionRefs = IterableExtensions.filter((Iterable)GpioCfgHelper.getFunctionRefs((PinSetting)ps), (Functions.Function1)_function);
                    int _size = IterableExtensions.size((Iterable)functionRefs);
                    boolean bl3 = _equals_1 = _size == 1;
                    if (_equals_1) {
                        boolean _equals_2;
                        FunctionRef functionRef_1 = ((FunctionRef[])Conversions.unwrapArray((Object)functionRefs, FunctionRef.class))[0];
                        String value_1 = functionRef_1.getAlt();
                        if (value_1 != null && (_equals_2 = "Direct_Analog".equals(value_1))) {
                            value_1 = "0";
                        }
                        int a = this.getModerValue(ioFields);
                        Object desc_1 = "";
                        if (a != 2) {
                            value_1 = "0";
                            String _name_2 = pp.getAlt().getName();
                            String _plus = "The only possible value for function: " + _name_2;
                            String _plus_1 = _plus + " when MODER is not Alternate";
                            desc_1 = _plus_1;
                        } else {
                            String _name_3 = pp.getAlt().getName();
                            String _plus_2 = "The only possible value for function: " + _name_3;
                            desc_1 = _plus_2;
                        }
                        acceptor.accept(this.createCompletionProposal("\"" + value_1 + "\"", "\"" + value_1 + "\" -> " + (String)desc_1, null, context));
                    } else {
                        Functions.Function1 _function_1 = it -> {
                            boolean _equals_3 = "Direct_Analog".equals(it.getAlt());
                            return !_equals_3;
                        };
                        Iterable _filter = IterableExtensions.filter((Iterable)functionRefs, (Functions.Function1)_function_1);
                        for (FunctionRef functionRef_2 : _filter) {
                            String value_2 = functionRef_2.getAlt();
                            acceptor.accept(this.createCompletionProposal(value_2, value_2, null, context));
                        }
                    }
                }
            } else {
                boolean _equals_3;
                int _bitLength = field.getBitWidth().getValue().bitLength();
                boolean bl4 = _equals_3 = _bitLength == 1;
                if (_equals_3) {
                    acceptor.accept(this.createCompletionProposal("'0x0'", "\"" + Integer.valueOf(0) + "'", null, context));
                    acceptor.accept(this.createCompletionProposal("'0x1'", "\"" + Integer.valueOf(1) + "'", null, context));
                }
            }
        }
    }

    public int getModerValue(IOFields ioFields) {
        PinProperties _config;
        int _xblockexpression = 0;
        int moderValue = -1;
        EObject _eContainer = ioFields.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        PinProperties pp = _config = ps.getConfig();
        Iterable pinConfigs = Iterables.filter((Iterable)ps.getPin().getPinConfigurations(), ConfigurablePin.class);
        ConfigurablePin pin = ((ConfigurablePin[])Conversions.unwrapArray((Object)pinConfigs, ConfigurablePin.class))[0];
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        boolean _find = matcher.find();
        if (_find) {
            String bank = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2));
            EObject _eContainer_1 = ps.eContainer();
            Module module = (Module)_eContainer_1;
            EObject _eContainer_2 = module.eContainer().eContainer();
            PinConfiguration conf = (PinConfiguration)_eContainer_2;
            List registersList = this._gpioCfgHelper.getRegisters(conf);
            Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
            Iterable registers = IterableExtensions.filter((Iterable)registersList, (Functions.Function1)_function);
            EList moderValues = this._gpioCfgHelper.getRegisterValues(registers, index, "MODER");
            Functions.Function1 _function_1 = it -> it.getAttr().getName().startsWith("MODER");
            FieldInstance moderCurrentValue = (FieldInstance)IterableExtensions.findFirst((Iterable)ioFields.getReg(), (Functions.Function1)_function_1);
            String moderValueStr = "";
            if (moderCurrentValue != null) {
                String nameStr = moderCurrentValue.getValue().replaceAll("'", "").replaceAll("\"", "");
                try {
                    Integer.parseInt(nameStr);
                    moderValueStr = nameStr;
                }
                catch (Throwable _t) {
                    if (_t instanceof NumberFormatException) {
                        Functions.Function1 _function_2 = it -> it.getName().equals(nameStr);
                        EnumeratedValueType enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)moderValues, (Functions.Function1)_function_2);
                        moderValueStr = enumValue.getValue();
                        boolean _startsWith = moderValueStr.startsWith("0x");
                        if (_startsWith) {
                            int hexValue;
                            moderValue = hexValue = Integer.parseInt(moderValueStr.substring(2), 16);
                        }
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        _xblockexpression = moderValue;
        return _xblockexpression;
    }

    @Override
    public void complete_Direction(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _isInstance = PinSetting.class.isInstance(model);
        if (_isInstance) {
            this.complete_Direction(model, ruleCall, context, acceptor);
        } else {
            boolean _isInstance_1 = Module.class.isInstance(model);
            if (_isInstance_1) {
                this.complete_Direction((Module)model, ruleCall, context, acceptor);
            }
        }
    }

    public void complete_Direction(PinSetting model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _eContainer = model.eContainer();
        Module module = (Module)_eContainer;
        this.complete_Direction(module, ruleCall, context, acceptor);
    }

    public void complete_Direction(Module module, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList directions = CollectionLiterals.newArrayList((Object[])com.st.stellar.pinmap.gpioCfg.Direction.values());
        Package pack = this._gpioCfgHelper.getPack(module);
        if (pack != null) {
            Functions.Function1 _function = it -> {
                Function _alt = it.getConfig().getAlt();
                String _name = null;
                if (_alt != null) {
                    _name = _alt.getName();
                }
                return _name;
            };
            List alreadyUsedFunctions = ListExtensions.map((List)module.getPins(), (Functions.Function1)_function);
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                EList _pinConfigurations = packagePin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration cfg = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = cfg.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _contains = alreadyUsedFunctions.contains(fct.getName().getName());
                        boolean _not = !_contains;
                        if (!_not) continue;
                        for (com.st.stellar.pinmap.gpioCfg.Direction direction : directions) {
                            String directionStr;
                            boolean _directionsAreCompatible = GpiocfgValidator.directionsAreCompatible((Function)fct.getName(), (Direction)fct.getDirection(), (com.st.stellar.pinmap.gpioCfg.Direction)direction);
                            if (!_directionsAreCompatible || module.getName().getName() == null || !module.getName().getName().equals(fct.getName().getPeripheralRef().getName())) continue;
                            String proposal = directionStr = direction.getLiteral();
                            acceptor.accept(this.createCompletionProposal(proposal, directionStr, null, context));
                        }
                    }
                }
            }
        }
    }

    public void complete_PinSetting(Module module, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList directions = CollectionLiterals.newArrayList((Object[])com.st.stellar.pinmap.gpioCfg.Direction.values());
        Package pack = this._gpioCfgHelper.getPack(module);
        if (pack != null) {
            Functions.Function1 _function = it -> {
                Function _alt = it.getConfig().getAlt();
                return _alt != null;
            };
            Functions.Function1 _function_1 = it -> it.getConfig().getAlt().getName();
            Iterable alreadyUsedFunctions = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)module.getPins(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                EList _pinConfigurations = packagePin.getPinConfigurations();
                for (PinConfig configurableConfig : _pinConfigurations) {
                    if (!(configurableConfig instanceof ConfigurablePin)) continue;
                    Configuration cfg = ((ConfigurablePin)configurableConfig).getRef();
                    EList _functions = cfg.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _contains = IterableExtensions.contains((Iterable)alreadyUsedFunctions, (Object)fct.getName().getName());
                        boolean _not = !_contains;
                        if (!_not) continue;
                        for (com.st.stellar.pinmap.gpioCfg.Direction direction : directions) {
                            boolean _equals;
                            boolean _directionsAreCompatible = GpiocfgValidator.directionsAreCompatible((Function)fct.getName(), (Direction)fct.getDirection(), (com.st.stellar.pinmap.gpioCfg.Direction)direction);
                            if (!_directionsAreCompatible || fct.getName().getPeripheralRef().getName() == null || module.getName().getName() == null || !(_equals = module.getName().getName().equals(fct.getName().getPeripheralRef().getName()))) continue;
                            String directionStr = direction.getLiteral();
                            String fctName = fct.getName().getName();
                            String pinName = "Pin_" + fctName;
                            Map missingInstances = this._gpioCfgHelper.getDefaultFieldInstances(module, (ConfigurablePin)configurableConfig, fctName, Collections.unmodifiableList(CollectionLiterals.newArrayList()));
                            Object registers = "";
                            Set entries = missingInstances.entrySet();
                            List instanceList = IterableExtensions.toList(entries);
                            Collections.sort(instanceList, new Comparator<Map.Entry<String, String>>(this){

                                @Override
                                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                                    return o1.getKey().compareTo(o2.getKey());
                                }
                            });
                            for (Map.Entry entry : instanceList) {
                                boolean _greaterThan;
                                int _length = ((String)registers).length();
                                boolean bl = _greaterThan = _length > 0;
                                if (_greaterThan) {
                                    String _registers = registers;
                                    registers = _registers + ",\n\t\t";
                                }
                                String _registers_1 = registers;
                                String _key = (String)entry.getKey();
                                String _plus = _key + " = ";
                                String _value = (String)entry.getValue();
                                String _plus_1 = _plus + _value;
                                registers = _registers_1 + _plus_1;
                            }
                            Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{directionStr, fctName, packagePin.getName(), pinName, registers}).toArray();
                            String proposal = NLS.bind((String)"{0} {1} -> {2} as {3}\n\tIO\n\t\t{4}\n\t\n;", (Object[])objs);
                            String _name = fct.getName().getName();
                            String _plus = directionStr + " " + _name;
                            String _plus_1 = _plus + " on pin ";
                            String _name_1 = packagePin.getName();
                            String _plus_2 = _plus_1 + _name_1;
                            String _plus_3 = _plus_2 + " (pad: ";
                            String _label = cfg.getLabel();
                            String _plus_4 = _plus_3 + _label;
                            String _plus_5 = _plus_4 + ")";
                            acceptor.accept(this.createCompletionProposal(proposal, _plus_5, null, context));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void complete_PinSetting(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Module module = (Module)model;
        this.complete_PinSetting(module, ruleCall, context, acceptor);
    }
}

