/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpioCfg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Direction implements Enumerator
{
    INPUT(0, "Input", "in"),
    OUTPUT(1, "Output", "out"),
    INPUT_OUTPUT(2, "InputOutput", "inout");

    public static final int INPUT_VALUE = 0;
    public static final int OUTPUT_VALUE = 1;
    public static final int INPUT_OUTPUT_VALUE = 2;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Direction get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Direction result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Direction getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Direction result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return INPUT;
            }
            case 1: {
                return OUTPUT;
            }
            case 2: {
                return INPUT_OUTPUT;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Direction[]{INPUT, OUTPUT, INPUT_OUTPUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

