/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.helpers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Include;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpio.helpers.ResourceUtils;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.GpioCfgFactory;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.Pair;
import com.st.stellar.pinmap.validation.GpiocfgValidator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AccessType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ResetType1;

public class GpioCfgHelper {
    public static String GPIOCFG_VERSION = "2.1.0";
    @Inject
    private IResourceServiceProvider.Registry rspr;
    @Inject
    private IQualifiedNameProvider qnprovider;
    @Inject
    private IQualifiedNameConverter converter;
    public static GpioCfgHelper instance = new GpioCfgHelper();
    private static Map<String, Resource> _resourceCache = new HashMap<String, Resource>();
    private static final Logger logger = Logger.getLogger(GpioCfgHelper.class);
    private final List<String> REGISTERS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"MODER", "OTYPER", "OSPEEDR", "PUPDR", "AFRL", "AFRH", "TRIGENR", "IHYSTR", "SAFESELR", "SAFEVALR"}));
    private static final HashMap<Direction, String[]> directionMap = CollectionLiterals.newLinkedHashMap((org.eclipse.xtext.xbase.lib.Pair[])new org.eclipse.xtext.xbase.lib.Pair[]{org.eclipse.xtext.xbase.lib.Pair.of((Object)Direction.INPUT_OUTPUT, (Object)((String[])Conversions.unwrapArray(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"inout"})), String.class))), org.eclipse.xtext.xbase.lib.Pair.of((Object)Direction.OUTPUT, (Object)((String[])Conversions.unwrapArray(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"out"})), String.class))), org.eclipse.xtext.xbase.lib.Pair.of((Object)Direction.INPUT, (Object)((String[])Conversions.unwrapArray(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"in"})), String.class))), org.eclipse.xtext.xbase.lib.Pair.of((Object)Direction.INPUT_OR_OUTPUT, (Object)((String[])Conversions.unwrapArray(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"in", "out"})), String.class)))});

    public void printExportedObjects(Resource resource) {
        IResourceServiceProvider resServiceProvider = this.rspr.getResourceServiceProvider(resource.getURI());
        IResourceDescription.Manager manager = resServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(resource);
        Iterable _exportedObjects = description.getExportedObjects();
        for (IEObjectDescription eod : _exportedObjects) {
            QualifiedName _name = eod.getName();
            String _plus = String.valueOf(_name) + ": ";
            String _string = this.converter.toString(eod.getQualifiedName());
            String _plus_1 = _plus + _string;
            InputOutput.println((Object)_plus_1);
        }
    }

    public Iterable<IEObjectDescription> getExportedObjects(Resource resource) {
        Iterable _xblockexpression = null;
        IResourceServiceProvider resServiceProvider = this.rspr.getResourceServiceProvider(resource.getURI());
        IResourceDescription.Manager manager = resServiceProvider.getResourceDescriptionManager();
        IResourceDescription description = manager.getResourceDescription(resource);
        _xblockexpression = description.getExportedObjects();
        return _xblockexpression;
    }

    public static String bits(FieldType field) {
        int _intValue_1;
        boolean _tripleEquals;
        String _xblockexpression = null;
        Object res = "";
        BigInteger _bitOffset = field.getBitOffset();
        boolean bl = _tripleEquals = _bitOffset == null;
        if (_tripleEquals) {
            return res;
        }
        int start = field.getBitOffset().intValue();
        int _intValue = field.getBitOffset().intValue();
        int _plus = _intValue + (_intValue_1 = field.getBitWidth().getValue().intValue());
        int end = _plus - 1;
        if (end == start) {
            res = String.valueOf(31 - start);
        } else {
            String _valueOf = String.valueOf(31 - end);
            String _plus_1 = _valueOf + ":";
            String _valueOf_1 = String.valueOf(31 - start);
            String _plus_2 = _plus_1 + _valueOf_1;
            res = _plus_2;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static String bitsBigEndian(FieldType field) {
        String _xblockexpression = null;
        int start = field.getBitOffset().intValue();
        int _intValue = field.getBitOffset().intValue();
        int _intValue_1 = field.getBitWidth().getValue().intValue();
        int _plus = _intValue + _intValue_1;
        int end = _plus - 1;
        Object res = "";
        if (end == start) {
            res = String.valueOf(start);
        } else {
            String _valueOf = String.valueOf(start);
            String _plus_1 = _valueOf + ":";
            String _valueOf_1 = String.valueOf(end);
            String _plus_2 = _plus_1 + _valueOf_1;
            res = _plus_2;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static String ellipsis(String text, int max) {
        String _xifexpression = null;
        if (text == null || text.length() <= max) {
            return text;
        }
        String _xblockexpression = null;
        int end = text.indexOf("\n", 0);
        String _xifexpression_1 = null;
        if (end > 0) {
            String _substring = text.substring(0, end);
            _xifexpression_1 = _substring + "...";
        } else {
            String _substring_1 = text.substring(0, max);
            _xifexpression_1 = _substring_1 + "...";
        }
        _xifexpression = _xblockexpression = _xifexpression_1;
        return _xifexpression;
    }

    public String toHex(PinProperties pin) {
        String hexValueStr = "0x0";
        return hexValueStr;
    }

    public String toIOHex(PinProperties pin) {
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        Object hexValueStr = null;
        hexValueStr = "0x0";
        long hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
        if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            EList<FieldInstance> regInstances = ps.getIoFields().getReg();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = GpioCfgHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    long input = hexValue;
                    hexValue = this.getBitFieldValue(field, inst.getValue(), input, from, to);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
            }
        }
        String _hexString = Long.toHexString(hexValue);
        String _plus = "0x" + _hexString;
        hexValueStr = _plus;
        return hexValueStr;
    }

    public String addMODER(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_MODER_INPUT", "GPIO_MODE_MODER_OUTPUT", "GPIO_MODE_MODER_ALTERNATE", "GPIO_MODE_MODER_ANALOG"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addOTYPER(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_OTYPER_PUSHPULL", "GPIO_MODE_OTYPER_OPENDRAIN"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addOSPEEDR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_OSPEEDR_LOW", "GPIO_MODE_OSPEEDR_MEDIUM", "GPIO_MODE_OSPEEDR_HIGH", "GPIO_MODE_OSPEEDR_VERYHIGH"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addPUPDR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_PUPDR_FLOATING", "GPIO_MODE_PUPDR_PULLUP", "GPIO_MODE_PUPDR_PULLDOWN"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addAFRL(FieldInstance inst) {
        String _xblockexpression = null;
        String index = Long.toString(this.getFieldValue(inst));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GPIO_MODE_AFR(");
        _builder.append(index);
        _builder.append("U)");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String addAFRH(FieldInstance inst) {
        String _xblockexpression = null;
        String index = Long.toString(this.getFieldValue(inst));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GPIO_MODE_AFR(");
        _builder.append(index);
        _builder.append("U)");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String addTRIGENR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_TRIGENR_IN_DISABLED", "GPIO_MODE_TRIGENR_IN_ENABLED"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addIHYSTR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_IHYSTR_CMOS", "GPIO_MODE_IHYSTR_AUTO", "GPIO_MODE_IHYSTR_TTL"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addSAFESELR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_SAFESELR_DISABLED", "GPIO_MODE_SAFESELR_ENABLED"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public String addSAFEVALR(FieldInstance inst) {
        String res;
        String _xblockexpression = null;
        List modes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_MODE_SAFEVALR_LOW", "GPIO_MODE_SAFEVALR_HIGH"}));
        String index = Long.toString(this.getFieldValue(inst));
        _xblockexpression = res = (String)modes.get(Integer.parseInt(index));
        return _xblockexpression;
    }

    public boolean isSupported(RegisterType reg) {
        boolean _xblockexpression = false;
        if (reg == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("([\\d]+)_(\\w+)");
        Matcher matcher = pattern.matcher(reg.getName());
        boolean _xifexpression = false;
        boolean _find = matcher.find();
        if (_find) {
            boolean _xblockexpression_1 = false;
            String regName = matcher.group(2);
            boolean _xifexpression_1 = false;
            boolean _contains = this.REGISTERS.contains(regName);
            _xifexpression_1 = _contains;
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            boolean _xblockexpression_2 = false;
            String _name = reg.getName();
            String _plus = _name + " is not supported";
            logger.error((Object)_plus);
            _xifexpression = _xblockexpression_2 = false;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String toIO(FieldInstance inst) {
        Pattern pattern;
        Matcher matcher;
        boolean _find;
        String _xblockexpression = null;
        String res = "";
        FieldType _attr = inst.getAttr();
        FieldType field = _attr;
        EObject _eContainer = field.eContainer();
        RegisterType reg = (RegisterType)_eContainer;
        boolean _isSupported = this.isSupported(reg);
        if (_isSupported && (_find = (matcher = (pattern = Pattern.compile("([\\d]+)_(\\w+)")).matcher(reg.getName())).find())) {
            String regName = matcher.group(2);
            Functions.Function1 _function = it -> it.getName().equals("add" + regName);
            Method addMethod = (Method)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)this.getClass().getMethods())), (Functions.Function1)_function);
            if (addMethod != null) {
                try {
                    Object _invoke = addMethod.invoke((Object)this, inst);
                    res = (String)_invoke;
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalAccessException || _t instanceof InvocationTargetException || _t instanceof NoSuchMethodException) {
                        ReflectiveOperationException e = (ReflectiveOperationException)_t;
                        logger.error((Object)("Cannot find method 'add" + regName + "()'"));
                        logger.error((Object)e.getMessage());
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            } else {
                logger.error((Object)("Cannot find method 'add" + regName + "()'"));
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public String getFieldName(FieldInstance inst) {
        FieldType _attr;
        String _xblockexpression = null;
        String res = "";
        FieldType field = _attr = inst.getAttr();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("getFieldName ");
        String _name = field.getName();
        _builder.append(_name);
        InputOutput.println((Object)_builder.toString());
        EObject _eContainer = field.eContainer();
        RegisterType reg = (RegisterType)_eContainer;
        Pattern pattern = Pattern.compile("([\\d]+)_(\\w+)");
        Matcher matcher = pattern.matcher(reg.getName());
        boolean _find = matcher.find();
        if (_find) {
            String regName = matcher.group(2);
            InputOutput.println((Object)(regName + " matches"));
            res = regName;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public String toIOHex(FieldInstance inst) {
        FieldType field;
        String bits;
        Object hexValueStr = null;
        hexValueStr = "0x0";
        long hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
        if (inst.getAttr() != null && inst.getValue() != null && (bits = GpioCfgHelper.bits(field = inst.getAttr())) != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                String _hexString = Long.toHexString(hexValue);
                String _plus = "toIOHex before: " + _hexString;
                InputOutput.println((Object)_plus);
                long input = hexValue;
                hexValue = this.getBitFieldValue(field, inst.getValue(), input, from, to);
                String _hexString_1 = Long.toHexString(hexValue);
                String _plus_1 = "toIOHex after: " + _hexString_1;
                InputOutput.println((Object)_plus_1);
            } else {
                int from_1 = Integer.parseInt(bits);
                String _hexString_2 = Long.toHexString(hexValue);
                String _plus_2 = "toIOHex before1: " + _hexString_2;
                InputOutput.println((Object)_plus_2);
                hexValue = this.getBitFieldValue(field, inst.getValue(), hexValue, from_1);
                String _hexString_3 = Long.toHexString(hexValue);
                String _plus_3 = "toIOHex after1: " + _hexString_3;
                InputOutput.println((Object)_plus_3);
            }
        }
        String _hexString_4 = Long.toHexString(hexValue);
        String _plus_4 = "0x" + _hexString_4;
        hexValueStr = _plus_4;
        return hexValueStr;
    }

    public AddressBlockType getRoot(PinProperties properties) {
        PinProperties rootObject;
        AddressBlockType _xblockexpression = null;
        for (rootObject = properties; rootObject != null && !(rootObject instanceof Family); rootObject = rootObject.eContainer()) {
        }
        Family root = (Family)rootObject;
        _xblockexpression = (AddressBlockType)root.getRef().getAddressBlock().get(0);
        return _xblockexpression;
    }

    public long addFieldValue(FieldType field, String instValue, long hexValueInput) {
        long _xblockexpression = 0L;
        String bits = GpioCfgHelper.bits(field);
        long _xifexpression = 0L;
        if (bits != null) {
            long _xifexpression_1 = 0L;
            boolean _contains = bits.contains(":");
            if (_contains) {
                long hexValue;
                boolean _notEquals;
                long _xblockexpression_1 = 0L;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                long input = hexValueInput;
                _xifexpression_1 = _xblockexpression_1 = (hexValue = this.getBitFieldValue(field, instValue, input, from, to));
            } else {
                long hexValue;
                long _xblockexpression_2 = 0L;
                int from = Integer.parseInt(bits);
                _xifexpression_1 = _xblockexpression_2 = (hexValue = this.getBitFieldValue(field, instValue, hexValueInput, from));
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = 0L;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String IOValues(FieldInstance inst) {
        String _xblockexpression = null;
        Object fieldStr = "";
        if (inst.getAttr() != null && inst.getValue() != null) {
            FieldType field = inst.getAttr();
            String attr = field.getName();
            String value = inst.getValue();
            String _fieldStr = fieldStr;
            fieldStr = _fieldStr + ", " + attr + " -> " + value;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String IOValues(PinProperties pin) {
        return this.getValues(pin);
    }

    public String getValues(PinProperties pin) {
        long hexValue;
        Object fieldStr = "";
        EObject _eContainer = pin.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        String hexValueStr = null;
        if (hexValueStr == null) {
            hexValueStr = "0x0";
        }
        if ((hexValue = Long.parseLong(hexValueStr.substring(2), 16)) == 0L) {
            // empty if block
        }
        EList<FieldInstance> regInstances = CollectionLiterals.newArrayList();
        if (ps.getIoFields() != null && ps.getIoFields().getReg() != null) {
            regInstances = ps.getIoFields().getReg();
        }
        for (FieldInstance inst : regInstances) {
            if (inst.getAttr() == null || inst.getValue() == null) continue;
            FieldType field = inst.getAttr();
            String attr = field.getName();
            String value = inst.getValue();
            String _fieldStr = fieldStr;
            fieldStr = _fieldStr + ", " + attr + " -> " + value;
        }
        return fieldStr;
    }

    public List<RegisterType> getRef(PinProperties properties) {
        Resource resource;
        Resource r;
        ArrayList _xblockexpression = null;
        ArrayList res = CollectionLiterals.newArrayList();
        if (properties == null) {
            return res;
        }
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)properties);
        PinConfiguration pinSettings = (PinConfiguration)_rootContainer;
        com.st.stellar.pinmap.gpioCfg.Include includes = this.getIncludes(pinSettings);
        if (includes != null && includes.getImportURI() != null && (r = EcoreUtil2.getResource((Resource)(resource = pinSettings.eResource()), (String)includes.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            PinConfig config;
            boolean _not;
            EObject _get = (EObject)r.getContents().get(0);
            PinmapModel model = (PinmapModel)_get;
            MemoryMapType memoryMap = ((Family)model.getFamilies().get(0)).getRef();
            EObject _eContainer = properties.eContainer();
            PinSetting ps = (PinSetting)_eContainer;
            Pin pin = ps.getPin();
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)pin.getPinConfigurations());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not && (config = (PinConfig)pin.getPinConfigurations().get(0)) instanceof ConfigurablePin) {
                ConfigurablePin cfg = (ConfigurablePin)config;
                String id = cfg.getRef().getName();
                Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
                Matcher matcher = pattern.matcher(id);
                boolean _find = matcher.find();
                if (_find) {
                    boolean _greaterThan;
                    String bank = matcher.group(1);
                    int _size = memoryMap.getAddressBlock().size();
                    boolean bl2 = _greaterThan = _size > 0;
                    if (_greaterThan) {
                        Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
                        Iterable registerList = IterableExtensions.filter((Iterable)((AddressBlockType)memoryMap.getAddressBlock().get(0)).getRegister(), (Functions.Function1)_function);
                        for (RegisterType reg : registerList) {
                            res.add(reg);
                        }
                    } else {
                        InputOutput.println((Object)id);
                    }
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public long getBitFieldValue(FieldType field, String instValue, long hexInput, int from, int to) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return 0L;
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = GpioCfgHelper.longValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        long enumvalue = GpioCfgHelper.longValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                if (enumDisplay == null) {
                    hexValue = 0L;
                    _xifexpression_2 = 0L;
                } else {
                    long _xblockexpression_3 = 0L;
                    long longValue = GpioCfgHelper.longValue(enumDisplay.getValue());
                    long _xifexpression_3 = 0L;
                    if (longValue > 0L) {
                        long _xblockexpression_4 = 0L;
                        long valmask = longValue << 31 - to;
                        _xifexpression_3 = _xblockexpression_4 = (hexValue |= valmask);
                    } else {
                        _xifexpression_3 = hexValue;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            long longValue = GpioCfgHelper.longValue(instValue);
            long valmask = longValue << 31 - to;
            longValue = mask & valmask;
            _xifexpression = _xblockexpression_2 = (hexValue |= valmask);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long getRawBitFieldValue(FieldType field, String instValue, int from, int to) {
        long _xblockexpression = 0L;
        long hexValue = 0L;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return 0L;
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = GpioCfgHelper.longValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        long enumvalue = GpioCfgHelper.longValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                if (enumDisplay == null) {
                    hexValue = 0L;
                    _xifexpression_2 = 0L;
                } else {
                    long _xblockexpression_3 = 0L;
                    long longValue = GpioCfgHelper.longValue(enumDisplay.getValue());
                    long _xifexpression_3 = 0L;
                    _xifexpression_3 = longValue > 0L ? (hexValue = longValue) : hexValue;
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long longValue;
            long _xblockexpression_2 = 0L;
            _xifexpression = _xblockexpression_2 = (hexValue = (longValue = GpioCfgHelper.longValue(instValue)));
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long getFieldValue(FieldInstance inst) {
        long _xblockexpression = 0L;
        long hexValue = 0L;
        FieldType field = inst.getAttr();
        String bits = GpioCfgHelper.bits(field);
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValue = this.getRawBitFieldValue(field, inst.getValue(), from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getRawBitFieldValue(field, inst.getValue(), from_1);
            }
        }
        _xblockexpression = hexValue;
        return _xblockexpression;
    }

    public long getBitFieldValue(FieldType field, String instValue, long hexInput, int from) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        long mask = 1L << 31 - from;
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = GpioCfgHelper.longValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = GpioCfgHelper.longValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                _xifexpression_2 = enumDisplay != null ? Long.parseLong(enumDisplay.getValue().substring(2), 16) : -1L;
                long index = _xifexpression_2;
                long _xifexpression_3 = 0L;
                if (index != -1L) {
                    long _xblockexpression_3 = 0L;
                    long valmask = index << 31 - from;
                    _xifexpression_3 = _xblockexpression_3 = (hexValue |= valmask);
                } else {
                    hexValue = 0L;
                    _xifexpression_3 = 0L;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_3;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            String rawValue = instValue.replace("\"", "");
            boolean _startsWith = rawValue.startsWith("0x");
            if (_startsWith) {
                long value = Long.parseLong(rawValue.substring(2), 16);
                long valmask = value << 31 - from;
                value = mask & valmask;
                hexValue |= valmask;
            }
            _xifexpression = _xblockexpression_2 = hexValue;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long getRawBitFieldValue(FieldType field, String instValue, int from) {
        long _xblockexpression = 0L;
        long hexValue = 0L;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        long mask = 1L << 31 - from;
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = instValue;
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = GpioCfgHelper.longValue(instValue);
                if (valueLong < 0L) {
                    String nameStr = instValue.replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = GpioCfgHelper.longValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                _xifexpression_2 = enumDisplay != null ? Long.parseLong(enumDisplay.getValue().substring(2), 16) : -1L;
                long index = _xifexpression_2;
                long _xifexpression_3 = 0L;
                if (index != -1L) {
                    _xifexpression_3 = hexValue = index;
                } else {
                    hexValue = 0L;
                    _xifexpression_3 = 0L;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_3;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            String rawValue = instValue.replace("\"", "");
            boolean _startsWith = rawValue.startsWith("0x");
            if (_startsWith) {
                long value;
                hexValue = value = Long.parseLong(rawValue.substring(2), 16);
            }
            _xifexpression = _xblockexpression_2 = hexValue;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Object decode(RegisterType reg, String hexValue) {
        EList _field = reg.getField();
        for (FieldType bitField : _field) {
            int to = 0;
            long mask = 0L;
            String bits = GpioCfgHelper.bits(bitField);
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.replaceAll("\"", "").split(":");
                int _length = bitlist.length;
                boolean bl = _notEquals = _length != 2;
                if (_notEquals) {
                    return null;
                }
                int from = Integer.parseInt(bitlist[0]);
                to = Integer.parseInt(bitlist[1]);
                if (from >= 32 || from < 0) {
                    return null;
                }
                if (to >= 32 || to < 0) {
                    return null;
                }
                if (from >= to) {
                    return null;
                }
                mask = 1L << 31 - from;
                for (int i = from + 1; i <= to; ++i) {
                    mask |= 1L << 31 - i;
                }
                long decValue = Long.parseLong(hexValue.substring(2), 16);
                decValue &= mask;
                decValue >>= 31 - to;
                continue;
            }
            to = Integer.parseInt(bits.replaceAll("\"", ""));
            if (to >= 32 || to < 0) {
                return null;
            }
            mask = 1L << 31 - to;
            long decValue_1 = Long.parseLong(hexValue.substring(2), 16);
            decValue_1 &= mask;
            decValue_1 >>= 31 - to;
        }
        return null;
    }

    public static String getFunctionName(PinSetting pinSetting) {
        return pinSetting.getConfig().getAlt().getName();
    }

    public static FunctionRef getFunctionRef(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        EObject _eContainer = pinSetting.eContainer();
        Module module = (Module)_eContainer;
        if (pin != null) {
            EList _pinConfigurations = pin.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                if (!(cfg instanceof ConfigurablePin)) continue;
                ConfigurablePin GpioCfg = (ConfigurablePin)cfg;
                Functions.Function1 _function = it -> it.getName().getPeripheralRef().getName().equals(module.getName().getName());
                Iterable _filter = IterableExtensions.filter((Iterable)GpioCfg.getRef().getFunctions(), (Functions.Function1)_function);
                for (FunctionRef f : _filter) {
                    boolean _equals = f.getName().getName().equals(GpioCfgHelper.getFunctionName(pinSetting));
                    if (!_equals) continue;
                    return f;
                }
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static List<FunctionRef> getFunctionRefs(PinSetting pinSetting) {
        ArrayList _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        ArrayList list = CollectionLiterals.newArrayList();
        EObject _eContainer = pinSetting.eContainer();
        Module module = (Module)_eContainer;
        if (pin != null) {
            Iterable _filter = Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class);
            for (ConfigurablePin cfg : _filter) {
                Functions.Function1 _function = it -> it.getName().getPeripheralRef().getName().equals(module.getName().getName());
                Iterables.addAll((Collection)list, (Iterable)IterableExtensions.filter((Iterable)cfg.getRef().getFunctions(), (Functions.Function1)_function));
            }
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static List<Pin> getPinsForFunction(PinSetting pinSetting, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        ArrayList _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        ArrayList list = CollectionLiterals.newArrayList();
        if (pin != null) {
            Iterable _filter = Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class);
            for (ConfigurablePin cfg : _filter) {
                Functions.Function1 _function = it -> it.getName().getName().equals(function.getName());
                int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)cfg.getRef().getFunctions(), (Functions.Function1)_function));
                boolean _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                EObject _eContainer = cfg.eContainer();
                list.add((Pin)_eContainer);
            }
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static ConfigurablePin getFirstConfigurablePin(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        if (pin != null) {
            EList _pinConfigurations = pin.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                if (!(cfg instanceof ConfigurablePin)) continue;
                ConfigurablePin GpioCfg = (ConfigurablePin)cfg;
                return GpioCfg;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public ConfigurablePin getFirstConfigurablePin(Pin pin) {
        Object _xblockexpression = null;
        if (pin != null) {
            EList _pinConfigurations = pin.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                boolean _isInstance = ConfigurablePin.class.isInstance(cfg);
                if (!_isInstance) continue;
                return (ConfigurablePin)cfg;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public FunctionRef getFirstFunctionRef(PinSetting pinSetting) {
        Object _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        if (pin != null) {
            EList _pinConfigurations = pin.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                if (!(cfg instanceof ConfigurablePin)) continue;
                ConfigurablePin GpioCfg = (ConfigurablePin)cfg;
                return (FunctionRef)GpioCfg.getRef().getFunctions().get(0);
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public QualifiedName getQualifiedFunctionName(PinSetting pinSetting) {
        if (this.qnprovider != null) {
            return this.qnprovider.getFullyQualifiedName((EObject)pinSetting.getConfig().getAlt());
        }
        return null;
    }

    public String getAssociatedPeripheral(PinSetting pinSetting) {
        String _xblockexpression = null;
        FunctionRef funcRef = GpioCfgHelper.getFunctionRef(pinSetting);
        _xblockexpression = funcRef.getName().getPeripheralRef().getName();
        return _xblockexpression;
    }

    public FunctionRef siulFunction(PinSetting pinSetting) {
        EObject _eContainer;
        Module peripheral;
        Package pack;
        Object _xblockexpression = null;
        Pin pin = pinSetting.getPin();
        if (pin != null && (pack = this.getPack(peripheral = (Module)(_eContainer = pinSetting.eContainer()))) != null) {
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                boolean _equals = packagePin.getName().equals(pin.getName());
                if (!_equals) continue;
                Functions.Function1 _function = it -> it instanceof ConfigurablePin;
                Iterable configurablePins = IterableExtensions.filter((Iterable)packagePin.getPinConfigurations(), (Functions.Function1)_function);
                Iterator iterator = configurablePins.iterator();
                if (!iterator.hasNext()) continue;
                PinConfig pinConfig = (PinConfig)iterator.next();
                Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                Functions.Function1 _function_1 = it -> {
                    String _alt = it.getAlt();
                    return Objects.equals(_alt, 0);
                };
                FunctionRef siul = (FunctionRef)IterableExtensions.findFirst((Iterable)ref.getFunctions(), (Functions.Function1)_function_1);
                return siul;
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ArrayList<String> getDirections(PinSetting ps, String proposal) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> directions = new ArrayList<String>();
        EList _pinConfigurations = ps.getPin().getPinConfigurations();
        for (PinConfig pinConfig : _pinConfigurations) {
            SystemFunctionPin fct_1;
            boolean comp;
            if (pinConfig instanceof ConfigurablePin) {
                Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                EList _functions = ref.getFunctions();
                for (FunctionRef fct : _functions) {
                    boolean comp2 = GpiocfgValidator.directionsAreCompatible(ps, fct.getDirection(), com.st.stellar.pinmap.gpioCfg.Direction.get(proposal));
                    if (!comp2 || directions.contains(fct.getDirection().getLiteral())) continue;
                    directions.add(fct.getDirection().getLiteral());
                }
                continue;
            }
            if (!(pinConfig instanceof SystemFunctionPin) || !(comp = GpiocfgValidator.directionsAreCompatible(ps, (fct_1 = (SystemFunctionPin)pinConfig).getDirection(), com.st.stellar.pinmap.gpioCfg.Direction.get(proposal))) || directions.contains(fct_1.getDirection().getLiteral())) continue;
            directions.add(fct_1.getDirection().getLiteral());
        }
        _xblockexpression = directions;
        return _xblockexpression;
    }

    public static ArrayList<String> getDirections(PinSetting ps) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> directions = new ArrayList<String>();
        Functions.Function1 _function = it -> it instanceof ConfigurablePin;
        Iterable _filter = IterableExtensions.filter((Iterable)ps.getPin().getPinConfigurations(), (Functions.Function1)_function);
        for (PinConfig pinConfig : _filter) {
            Configuration ref = ((ConfigurablePin)pinConfig).getRef();
            Functions.Function1 _function_1 = it -> it.getName().getName().equals(ps.getConfig().getAlt().getName());
            Iterable _filter_1 = IterableExtensions.filter((Iterable)ref.getFunctions(), (Functions.Function1)_function_1);
            for (FunctionRef fct : _filter_1) {
                CollectionExtensions.addAll(directions, (Object[])directionMap.get(fct.getDirection()));
            }
        }
        _xblockexpression = directions;
        return _xblockexpression;
    }

    public static List<Package> getPackages(PinSettings ps) {
        EList _xblockexpression = null;
        Board board = GpioCfgHelper.getBoard(ps);
        com.st.stellar.pinmap.gpioCfg.Include inc = board.getIncludes();
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)inc.eResource(), (String)inc.getImportURI()));
        PinmapModel importedPinmap = (PinmapModel)_resourceToEObject;
        _xblockexpression = ((Family)importedPinmap.getFamilies().get(0)).getPackages();
        return _xblockexpression;
    }

    public static List<PinSetting> getPins(PinSettings settings) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        if (settings == null) {
            return pins;
        }
        EList<Module> _modules = settings.getModules();
        for (Module mod : _modules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getAllPinSettings(PinSettings settings) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        EList<Module> _allModules = GpioCfgHelper.getAllModules(settings);
        for (Module mod : _allModules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                Functions.Function1 _function = it -> it.getName() != null && it.getName().equals(pin.getName());
                Iterable filter = IterableExtensions.filter(pins, (Functions.Function1)_function);
                int _size = IterableExtensions.size((Iterable)filter);
                boolean _equals = _size == 0;
                if (!_equals) continue;
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getAllPinSettings(PinConfiguration cfg) {
        Board board_1;
        boolean _tripleNotEquals;
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        PinSettings _pinSetting = cfg.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            EList<Module> _modules = cfg.getPinSetting().getModules();
            for (Module mod : _modules) {
                EList<PinSetting> _pins = mod.getPins();
                Iterator iterator = _pins.iterator();
                while (iterator.hasNext()) {
                    PinSetting pin = (PinSetting)iterator.next();
                    pins.add(pin);
                }
            }
            Board board = GpioCfgHelper.getBoard(cfg.getPinSetting());
            if (board != null) {
                EList<Module> _modules_1 = board.getModules();
                for (Module mod_1 : _modules_1) {
                    EList<PinSetting> _pins_1 = mod_1.getPins();
                    for (PinSetting pin_1 : _pins_1) {
                        pins.add(pin_1);
                    }
                }
            }
        }
        if ((board_1 = cfg.getBoard()) != null) {
            EList<Module> _modules_2 = board_1.getModules();
            for (Module mod_2 : _modules_2) {
                EList<PinSetting> _pins_2 = mod_2.getPins();
                for (PinSetting pin_2 : _pins_2) {
                    pins.add(pin_2);
                }
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public static List<PinSetting> getPins(Board board) {
        ArrayList<PinSetting> _xblockexpression = null;
        ArrayList<PinSetting> pins = new ArrayList<PinSetting>();
        if (board == null) {
            return pins;
        }
        EList<Module> _modules = board.getModules();
        for (Module mod : _modules) {
            EList<PinSetting> _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                pins.add(pin);
            }
        }
        _xblockexpression = pins;
        return _xblockexpression;
    }

    public String getIndex(PinProperties properties) {
        EObject _eContainer = properties.eContainer();
        PinSetting ps = (PinSetting)_eContainer;
        FunctionRef functionRef = GpioCfgHelper.getFunctionRef(ps);
        return functionRef.getAlt();
    }

    public static List<com.st.stellar.pinmap.gpioCfg.Direction> getFunctionDirections(Module module, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        List _xblockexpression = null;
        HashSet<com.st.stellar.pinmap.gpioCfg.Direction> directions = new HashSet<com.st.stellar.pinmap.gpioCfg.Direction>();
        try {
            EObject _eContainer = module.eContainer();
            Board board = GpioCfgHelper.getBoard((PinSettings)_eContainer);
            EList _pins = board.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        Direction _direction;
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals || (_direction = fct.getDirection()) == null) continue;
                        switch (_direction) {
                            case INPUT_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT_OUTPUT);
                                break;
                            }
                            case INPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                break;
                            }
                            case OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                break;
                            }
                            case INPUT_OR_OUTPUT: {
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
                                directions.add(com.st.stellar.pinmap.gpioCfg.Direction.OUTPUT);
                                break;
                            }
                            case GROUND: {
                                break;
                            }
                            case INPUT_ALTERNATE: {
                                break;
                            }
                            case OUTPUT_ALTERNATE: {
                                break;
                            }
                            case POWER: {
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(directions);
        return _xblockexpression;
    }

    public static List<Pin> getFunctionPins(PinSettings pinSettings, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        List _xblockexpression = null;
        HashSet<Pin> pins = new HashSet<Pin>();
        Board includeBoard = GpioCfgHelper.getBoard(pinSettings);
        try {
            EList _pins = includeBoard.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals) continue;
                        pins.add(pin);
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(pins);
        return _xblockexpression;
    }

    public static List<Pin> getFunctionPins(Board includeBoard, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        List _xblockexpression = null;
        HashSet<Pin> pins = new HashSet<Pin>();
        try {
            EList _pins = includeBoard.getPackage().getPins();
            for (Pin pin : _pins) {
                EList _pinConfigurations = pin.getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof ConfigurablePin)) continue;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef fct : _functions) {
                        boolean _equals = fct.getName().getName().equals(function.getName());
                        if (!_equals) continue;
                        pins.add(pin);
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = IterableExtensions.toList(pins);
        return _xblockexpression;
    }

    public String defaultValue(RegisterType reg, FieldType field) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String hexValueStr = "";
        String bits = GpioCfgHelper.bits(field);
        long resetValue = 0L;
        ResetType1 _reset = reg.getReset();
        boolean bl = _tripleNotEquals = _reset != null;
        if (_tripleNotEquals) {
            resetValue = Long.parseLong(reg.getReset().getValue().getValue().substring(2), 16);
        }
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl2 = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from_1);
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public static void binaryFormat(long value, String label) {
        String _replace = String.format("%64s", Long.toBinaryString(value)).replace(" ", "0");
        String _plus = label + ": 0b" + _replace;
        logger.debug((Object)_plus);
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        GpioCfgHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        long mask = 1L << 31 - from;
        GpioCfgHelper.binaryFormat(hexValue &= mask, "value");
        GpioCfgHelper.binaryFormat(hexValue >>= 31 - from, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = GpioCfgHelper.longValue(it.getValue());
                return _longValue == compval;
            };
            String enumName = ((EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function)).getName();
            return enumName;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from, int to) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        GpioCfgHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return "";
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        GpioCfgHelper.binaryFormat(mask, "mask ");
        GpioCfgHelper.binaryFormat(hexValue &= mask, "value");
        GpioCfgHelper.binaryFormat(hexValue >>= 31 - to, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = GpioCfgHelper.longValue(it.getValue());
                return _longValue == compval;
            };
            String enumName = ((EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function)).getName();
            return enumName;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getValues(RegisterType reg) {
        String _xblockexpression = null;
        Object fieldStr = "";
        String regName = reg.getName();
        Functions.Function1 _function = it -> {
            AccessType _access = it.getAccess();
            return !Objects.equals(_access, AccessType.READ_ONLY);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
        for (FieldType field : _filter) {
            boolean _equals;
            String _name = field.getName();
            String attr = regName + "." + _name;
            String value = this.defaultValue(reg, field);
            int _length = ((String)fieldStr).length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                String _fieldStr = fieldStr;
                fieldStr = _fieldStr + attr + " -> " + value;
                continue;
            }
            String _fieldStr_1 = fieldStr;
            fieldStr = _fieldStr_1 + ", " + attr + " -> " + value;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String getValues(RegisterType reg, List<FieldInstance> fields) {
        String _xblockexpression = null;
        Object fieldStr = "";
        for (FieldInstance field : fields) {
            boolean _equals;
            String regName = reg.getName();
            String _name = field.getAttr().getName();
            String attr = regName + "." + _name;
            String fieldValue = field.getValue();
            fieldValue = this.valueAsString(field.getAttr(), field.getValue());
            int _length = ((String)fieldStr).length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                String _fieldStr = fieldStr;
                fieldStr = _fieldStr + attr + " -> " + fieldValue;
                continue;
            }
            String _fieldStr_1 = fieldStr;
            fieldStr = _fieldStr_1 + ", " + attr + " -> " + fieldValue;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String valueAsString(FieldType field, String value) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        if (value == null) {
            return "";
        }
        String fieldValue = value;
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            EnumeratedValueType enumDisplay = null;
            long valueLong = GpioCfgHelper.longValue(value);
            if (valueLong < 0L) {
                String nameStr = value.replaceAll("'", "").replaceAll("\"", "");
                Functions.Function1 _function = it -> it.getName().equals(nameStr);
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            } else {
                Functions.Function1 _function_1 = it -> {
                    boolean _xblockexpression_1 = false;
                    long enumvalue = GpioCfgHelper.longValue(it.getValue());
                    _xblockexpression_1 = Long.valueOf(enumvalue).equals(valueLong);
                    return _xblockexpression_1;
                };
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
            }
            if (enumDisplay != null) {
                fieldValue = enumDisplay.getName();
            }
        }
        _xblockexpression = fieldValue;
        return _xblockexpression;
    }

    public static long longValue(String valueIn) {
        long _xblockexpression = 0L;
        if (valueIn == null) {
            return 0L;
        }
        long longValue = 0L;
        String value = valueIn;
        try {
            boolean _startsWith = value.startsWith("\"");
            if (_startsWith) {
                value = value.replaceAll("\"", "");
            } else {
                boolean _startsWith_1 = value.startsWith("'");
                if (_startsWith_1) {
                    value = value.replaceAll("'", "");
                }
            }
            boolean _startsWith_2 = value.startsWith("0x");
            longValue = _startsWith_2 ? Long.parseLong(value.substring(2), 16) : Long.parseLong(value);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                longValue = -1L;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = longValue;
        return _xblockexpression;
    }

    public String getGenerationFileName(PinSettings pinSettings, String ext) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        Object outputFolder = "";
        String _outputFolder = pinSettings.getOutputFolder();
        boolean bl = _tripleNotEquals = _outputFolder != null;
        if (_tripleNotEquals) {
            String _outputFolder_1 = pinSettings.getOutputFolder();
            String _plus = "../" + _outputFolder_1;
            String _plus_1 = _plus + "/";
            outputFolder = _plus_1;
        } else {
            outputFolder = "./src-gen/";
            outputFolder = "../" + (String)outputFolder;
        }
        String _name = pinSettings.getName();
        String _plus_2 = (String)outputFolder + _name;
        String _plus_3 = _plus_2 + ".";
        _xblockexpression = _plus_3 + ext;
        return _xblockexpression;
    }

    public IFile getGenerationFile(PinSettings pinSettings, String ext) {
        IFile res;
        boolean _tripleNotEquals;
        IFile _xblockexpression = null;
        URI uri = pinSettings.eResource().getURI();
        uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
        IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
        String _platformString = uri.toPlatformString(true);
        Path _path = new Path(_platformString);
        IFile file = _root.getFile((IPath)_path);
        IProject project = file.getProject();
        IPath _fullPath = project.getFullPath();
        String filePath = String.valueOf(_fullPath) + "/";
        Object outputFolder = "";
        String _outputFolder = pinSettings.getOutputFolder();
        boolean bl = _tripleNotEquals = _outputFolder != null;
        if (_tripleNotEquals) {
            String _outputFolder_1 = pinSettings.getOutputFolder();
            String _plus = _outputFolder_1 + "/";
            outputFolder = _plus;
        } else {
            outputFolder = "src-gen/";
        }
        String _filePath = filePath;
        String _name = pinSettings.getName();
        String _plus_1 = (String)outputFolder + _name;
        String _plus_2 = _plus_1 + ".";
        String _plus_3 = _plus_2 + ext;
        filePath = _filePath + _plus_3;
        uri = URI.createPlatformResourceURI((String)filePath, (boolean)true);
        IWorkspaceRoot _root_1 = ResourcesPlugin.getWorkspace().getRoot();
        Path _path_1 = new Path(filePath);
        _xblockexpression = res = _root_1.getFile((IPath)_path_1);
        return _xblockexpression;
    }

    public Package getPack(Module module) {
        Package _xblockexpression = null;
        Package pack = null;
        EObject _eContainer = module.eContainer();
        if (_eContainer instanceof PinSettings) {
            EObject _eContainer_1 = module.eContainer();
            IncludeBoard _includedBoard = ((PinSettings)_eContainer_1).getIncludedBoard();
            Board _board = null;
            if (_includedBoard != null) {
                _board = GpioCfgHelper.getBoard(_includedBoard);
            }
            Package _package = null;
            if (_board != null) {
                _package = _board.getPackage();
            }
            pack = _package;
        } else {
            EObject _eContainer_2 = module.eContainer();
            if (_eContainer_2 instanceof Board) {
                EObject _eContainer_3 = module.eContainer();
                pack = ((Board)_eContainer_3).getPackage();
            }
        }
        _xblockexpression = pack;
        return _xblockexpression;
    }

    public Package getPack(PinConfiguration config) {
        boolean _tripleNotEquals;
        Package _xblockexpression = null;
        Package pack = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            Board _board = null;
            if (_includedBoard != null) {
                _board = GpioCfgHelper.getBoard(_includedBoard);
            }
            Package _package = null;
            if (_board != null) {
                _package = _board.getPackage();
            }
            pack = _package;
        } else {
            boolean _tripleNotEquals_1;
            Board _board_1 = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board_1 != null;
            if (_tripleNotEquals_1) {
                pack = config.getBoard().getPackage();
            }
        }
        _xblockexpression = pack;
        return _xblockexpression;
    }

    public Package getPack(PinSettings ps) {
        Package _xblockexpression = null;
        Package pack = null;
        IncludeBoard _includedBoard = ps.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = GpioCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        _xblockexpression = pack = _package;
        return _xblockexpression;
    }

    public static EList<Module> getAllModules(PinSettings settings) {
        boolean _tripleEquals;
        BasicEList _xifexpression = null;
        Board _board = GpioCfgHelper.getBoard(settings);
        boolean bl = _tripleEquals = _board == null;
        if (_tripleEquals) {
            _xifexpression = settings.getModules();
        } else {
            BasicEList _xblockexpression = null;
            BasicEList mods = new BasicEList();
            mods.addAll(settings.getModules());
            EList<Module> boardModules = GpioCfgHelper.getBoard(settings.getIncludedBoard()).getModules();
            mods.addAll(boardModules);
            _xifexpression = _xblockexpression = mods;
        }
        return _xifexpression;
    }

    public String getFamilyDescription(PinSettings ps) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        PinConfiguration config = (PinConfiguration)_eContainer;
        Family family = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            EObject cont = GpioCfgHelper.getBoard(includedBoard).getPackage().eContainer();
            family = (Family)cont;
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                EObject cont_1 = config.getBoard().getPackage().eContainer();
                family = (Family)cont_1;
            }
        }
        String _xifexpression = null;
        _xifexpression = family != null && family.getDesc() != null ? family.getDesc() : "";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public com.st.stellar.pinmap.gpioCfg.Include getIncludes(PinSetting ps) {
        com.st.stellar.pinmap.gpioCfg.Include _xblockexpression = null;
        EObject _eContainer = ps.eContainer();
        Module module = (Module)_eContainer;
        com.st.stellar.pinmap.gpioCfg.Include includes = null;
        EObject _eContainer_1 = module.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            Board board;
            EObject _eContainer_2 = module.eContainer();
            IncludeBoard includedBoard = ((PinSettings)_eContainer_2).getIncludedBoard();
            if (includedBoard != null && (board = GpioCfgHelper.getBoard(includedBoard)) != null) {
                includes = board.getIncludes();
            }
        } else {
            EObject _eContainer_3 = module.eContainer();
            if (_eContainer_3 instanceof Board) {
                EObject _eContainer_4 = module.eContainer();
                includes = ((Board)_eContainer_4).getIncludes();
            }
        }
        _xblockexpression = includes;
        return _xblockexpression;
    }

    public com.st.stellar.pinmap.gpioCfg.Include getIncludes(PinConfiguration config) {
        boolean _tripleNotEquals;
        com.st.stellar.pinmap.gpioCfg.Include _xblockexpression = null;
        com.st.stellar.pinmap.gpioCfg.Include includes = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            Board board;
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            if (includedBoard != null && (board = GpioCfgHelper.getBoard(includedBoard)) != null) {
                includes = board.getIncludes();
            }
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                includes = config.getBoard().getIncludes();
            }
        }
        _xblockexpression = includes;
        return _xblockexpression;
    }

    public static Board getBoard(PinSettings ps) {
        boolean _tripleEquals;
        Board _xblockexpression = null;
        Board res = null;
        IncludeBoard _includedBoard = ps.getIncludedBoard();
        boolean bl = _tripleEquals = _includedBoard == null;
        if (_tripleEquals) {
            return res;
        }
        String inc = ps.getIncludedBoard().getImportURI();
        if (inc != null) {
            res = GpioCfgHelper.getBoard(ps.eResource(), inc);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Board getBoard(PinSetting pin) {
        EObject _eContainer = pin.eContainer();
        Module mod = (Module)_eContainer;
        EObject _eContainer_1 = mod.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            EObject _eContainer_2 = mod.eContainer();
            PinSettings ps = (PinSettings)_eContainer_2;
            return GpioCfgHelper.getBoard(ps.getIncludedBoard());
        }
        EObject _eContainer_3 = mod.eContainer();
        if (_eContainer_3 instanceof Board) {
            EObject _eContainer_4 = mod.eContainer();
            return (Board)_eContainer_4;
        }
        return null;
    }

    public static Board getBoard(IncludeBoard includeBoard) {
        String inc;
        Board _xblockexpression = null;
        Board res = null;
        String _importURI = null;
        if (includeBoard != null) {
            _importURI = includeBoard.getImportURI();
        }
        if ((inc = _importURI) != null) {
            res = GpioCfgHelper.getBoard(includeBoard.eResource(), inc);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Resource getResource(Resource context, String uriStr) {
        Resource _xblockexpression = null;
        Resource res = null;
        if (uriStr != null && context != null) {
            try {
                boolean _greaterThan;
                Resource r = EcoreUtil2.getResource((Resource)context, (String)uriStr);
                if (r != null) {
                    r.load(null);
                }
                if (r == null) {
                    return null;
                }
                int _size = r.getContents().size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    res = r;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    System.err.println(e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static Board getBoard(Resource context, String uriStr) {
        Board _xblockexpression = null;
        Board res = null;
        Resource r = GpioCfgHelper.getResource(context, uriStr);
        if (r != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            boolean _isInstance;
            boolean _greaterThan;
            int _size = r.getContents().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (_isInstance = PinConfiguration.class.isInstance(r.getContents().get(0)))) {
                EObject _get = (EObject)r.getContents().get(0);
                PinConfiguration pinCfg = (PinConfiguration)_get;
                res = pinCfg.getBoard();
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(PinSetting registerConfig) {
        List<RegisterType> _xblockexpression = null;
        EObject _eContainer = registerConfig.eContainer();
        Module module = (Module)_eContainer;
        _xblockexpression = this.getRegisters(module);
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(PinConfiguration conf) {
        boolean _tripleNotEquals;
        ArrayList _xblockexpression = null;
        List registers = CollectionLiterals.newArrayList();
        com.st.stellar.pinmap.gpioCfg.Include inc = this.getIncludes(conf);
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            EObject _get;
            PinmapModel root;
            Include pinmapinc;
            boolean _isNullOrEmpty;
            boolean _not;
            Resource resource = null;
            if (resource == null) {
                Resource r;
                resource = conf.eResource();
                resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
                _resourceCache.put(inc.getImportURI(), resource);
            }
            boolean bl2 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)resource.getContents()));
            if (_not && (pinmapinc = (Include)(root = (PinmapModel)(_get = (EObject)resource.getContents().get(0))).getIncludes().get(0)) != null) {
                boolean _isNullOrEmpty_1;
                boolean _not_1;
                resource = null;
                if (resource == null) {
                    Resource r_1;
                    resource = conf.eResource();
                    resource = r_1 = EcoreUtil2.getResource((Resource)resource, (String)pinmapinc.getImportURI());
                    _resourceCache.put(pinmapinc.getImportURI(), resource);
                }
                boolean bl3 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)resource.getContents()));
                if (_not_1) {
                    EObject _get_1 = (EObject)resource.getContents().get(0);
                    DocumentRoot iomux = (DocumentRoot)_get_1;
                    ComponentType comp = iomux.getComponent();
                    EList _memoryMap = comp.getMemoryMaps().getMemoryMap();
                    for (MemoryMapType mm : _memoryMap) {
                        EList _addressBlock = mm.getAddressBlock();
                        for (AddressBlockType ab : _addressBlock) {
                            Functions.Function1 _function = it -> {
                                boolean _contains = it.getName().contains("_Reserved_");
                                return !_contains;
                            };
                            registers = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ab.getRegister(), (Functions.Function1)_function));
                        }
                    }
                }
            }
        }
        _xblockexpression = registers;
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(Module module) {
        List<RegisterType> _xblockexpression = null;
        EObject _eContainer = module.eContainer().eContainer();
        PinConfiguration conf = (PinConfiguration)_eContainer;
        _xblockexpression = this.getRegisters(conf);
        return _xblockexpression;
    }

    public void createFieldInstances(PinSetting config) {
        if (config == null) {
            return;
        }
        ConfigurablePin pin = GpioCfgHelper.getFirstConfigurablePin(config);
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        boolean _find = matcher.find();
        if (_find) {
            String bank = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2));
            List<RegisterType> registersList = this.getRegisters(config);
            Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
            Iterable registers = IterableExtensions.filter(registersList, (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.isSupported((RegisterType)it);
            Iterable _filter = IterableExtensions.filter((Iterable)registers, (Functions.Function1)_function_1);
            for (RegisterType reg : _filter) {
                Functions.Function1 _function_2 = it -> {
                    AccessType _access = it.getAccess();
                    return !Objects.equals(_access, AccessType.READ_ONLY);
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
                for (FieldType field : _filter_1) {
                    boolean _equals = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index));
                    if (!_equals) continue;
                    Functions.Function1 _function_3 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(field.getName());
                    FieldInstance alreadyThere = (FieldInstance)IterableExtensions.findFirst(config.getIoFields().getReg(), (Functions.Function1)_function_3);
                    if (alreadyThere != null) continue;
                    Object value = "";
                    if (field.getName() != null && field.getName().startsWith("AFR")) {
                        FunctionRef functionRef = GpioCfgHelper.getFunctionRef(config);
                        value = functionRef.getAlt();
                        if (value != null) {
                            value = functionRef.getAlt();
                            boolean _equals_1 = "Direct_Analog".equals(value);
                            if (_equals_1) {
                                value = "0x0";
                            }
                        } else {
                            value = "0x0";
                        }
                    } else {
                        boolean _lessThan;
                        value = this.defaultValue(reg, field);
                        long _longValue = GpioCfgHelper.longValue((String)value);
                        boolean bl = _lessThan = _longValue < 1L;
                        if (_lessThan) {
                            value = "'" + (String)value + "'";
                        }
                    }
                    FieldInstance fieldInst = GpioCfgFactory.eINSTANCE.createFieldInstance();
                    fieldInst.setAttr(field);
                    fieldInst.setValue((String)value);
                    config.getIoFields().getReg().add((Object)fieldInst);
                }
            }
        }
    }

    public String getFieldInstances(Module module, ConfigurablePin pin, String functionName, List<FieldType> alreadyThere) {
        String _xblockexpression = null;
        Object res = "";
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        boolean _find = matcher.find();
        if (_find) {
            String bank = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2));
            List<RegisterType> registersList = this.getRegisters(module);
            Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
            Iterable registers = IterableExtensions.filter(registersList, (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.isSupported((RegisterType)it);
            Iterable _filter = IterableExtensions.filter((Iterable)registers, (Functions.Function1)_function_1);
            for (RegisterType reg : _filter) {
                Functions.Function1 _function_2 = it -> {
                    AccessType _access = it.getAccess();
                    return !Objects.equals(_access, AccessType.READ_ONLY);
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
                for (FieldType field : _filter_1) {
                    boolean _greaterThan;
                    boolean _equals;
                    boolean _contains = alreadyThere.contains(field);
                    boolean _not = !_contains;
                    if (!_not || !(_equals = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index)))) continue;
                    Object value = "";
                    if (field.getName() != null && field.getName().startsWith("AFR")) {
                        FunctionRef functionRef = null;
                        EList _functions = pin.getRef().getFunctions();
                        for (FunctionRef f : _functions) {
                            boolean _equals_2;
                            boolean _equals_1 = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
                            if (!_equals_1 || !(_equals_2 = f.getName().getName().equals(functionName))) continue;
                            functionRef = f;
                        }
                        value = functionRef.getAlt();
                        if (value != null) {
                            value = functionRef.getAlt();
                            boolean _equals_3 = "Direct_Analog".equals(value);
                            if (_equals_3) {
                                value = "0x0";
                            }
                        } else {
                            value = "0x0";
                        }
                    } else {
                        boolean _lessThan;
                        value = this.defaultValue(reg, field);
                        long _longValue = GpioCfgHelper.longValue((String)value);
                        boolean bl = _lessThan = _longValue < 1L;
                        if (_lessThan) {
                            value = "'" + (String)value + "'";
                        }
                    }
                    int _length = ((String)res).length();
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        String _res = res;
                        res = _res + ",\n\t\t";
                    }
                    String _res_1 = res;
                    String _name = field.getName();
                    String _plus = _name + " = ";
                    String _plus_1 = _plus + (String)value;
                    res = _res_1 + _plus_1;
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getDefaultFieldInstances(Module module, ConfigurablePin pin, String functionName, List<FieldInstance> alreadyThere) {
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> regValues = new HashMap<String, String>();
        if (pin == null) return regValues;
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        String res = "";
        boolean _find = matcher.find();
        if (!_find) return regValues;
        String bank = matcher.group(1);
        int index = Integer.parseInt(matcher.group(2));
        EObject _eContainer = module.eContainer().eContainer();
        PinConfiguration conf = (PinConfiguration)_eContainer;
        List<RegisterType> registersList = this.getRegisters(conf);
        Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
        Iterable registers = IterableExtensions.filter(registersList, (Functions.Function1)_function);
        int alternate = 0;
        FunctionRef functionRef = null;
        EList _functions = pin.getRef().getFunctions();
        for (FunctionRef f : _functions) {
            boolean _equals_1;
            boolean _equals = module.getName().getName().equals(f.getName().getPeripheralRef().getName());
            if (!_equals || !(_equals_1 = f.getName().getName().equals(functionName))) continue;
            functionRef = f;
        }
        Direction direction = functionRef.getDirection();
        EList<EnumeratedValueType> moderValues = this.getRegisterValues(registers, index, "MODER");
        EList<EnumeratedValueType> trValues = this.getRegisterValues(registers, index, "TR");
        int moder = 2;
        int tr = 0;
        String alternateStr = functionRef.getAlt();
        if (alternateStr == null) {
            if (direction != null) {
                switch (direction) {
                    case INPUT: {
                        moder = 0;
                        tr = 1;
                        break;
                    }
                    case INPUT_OUTPUT: {
                        moder = 1;
                        tr = 1;
                        break;
                    }
                    case OUTPUT: {
                        moder = 1;
                        tr = 0;
                        break;
                    }
                    default: {
                        moder = 1;
                        tr = 0;
                        break;
                    }
                }
            } else {
                moder = 1;
                tr = 0;
            }
            alternate = 0;
        } else {
            boolean _equals_2 = "Direct_Analog".equals(alternateStr);
            if (_equals_2) {
                alternate = 0;
                moder = 3;
                tr = 0;
            } else {
                moder = 2;
                if (direction != null) {
                    switch (direction) {
                        case INPUT_OUTPUT: 
                        case INPUT: {
                            tr = 1;
                            break;
                        }
                        default: {
                            tr = 0;
                            break;
                        }
                    }
                } else {
                    tr = 0;
                }
                alternate = Integer.parseInt(alternateStr);
            }
        }
        Functions.Function1 _function_1 = it -> this.isSupported((RegisterType)it);
        Iterable supportedRegisters = IterableExtensions.filter((Iterable)registers, (Functions.Function1)_function_1);
        Iterator iterator = supportedRegisters.iterator();
        block11: while (true) {
            if (!iterator.hasNext()) {
                String moderValue;
                String afrValue;
                String afrKey;
                block33: {
                    res = "";
                    Functions.Function1 _function_4 = it -> it.startsWith("AFR");
                    afrKey = (String)IterableExtensions.findFirst(regValues.keySet(), (Functions.Function1)_function_4);
                    afrValue = regValues.get(afrKey);
                    Functions.Function1 _function_5 = it -> it.startsWith("MODER");
                    moderValue = regValues.get(IterableExtensions.filter(regValues.keySet(), (Functions.Function1)_function_5));
                    if (moderValue == null) {
                        Functions.Function1 _function_6 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().startsWith("MODER");
                        FieldInstance currentValue = (FieldInstance)IterableExtensions.findFirst(alreadyThere, (Functions.Function1)_function_6);
                        if (currentValue != null && currentValue.getValue() != null) {
                            String nameStr = currentValue.getValue().replaceAll("'", "").replaceAll("\"", "");
                            try {
                                Integer.parseInt(nameStr);
                                moderValue = nameStr;
                            }
                            catch (Throwable _t) {
                                boolean _startsWith_3;
                                if (!(_t instanceof NumberFormatException)) {
                                    throw Exceptions.sneakyThrow((Throwable)_t);
                                }
                                Functions.Function1 _function_7 = it -> it.getName().equals(nameStr);
                                EnumeratedValueType enumValue = (EnumeratedValueType)IterableExtensions.findFirst(moderValues, (Functions.Function1)_function_7);
                                if (enumValue != null && (_startsWith_3 = (moderValue = enumValue.getValue()).startsWith("0x"))) {
                                    long hexValue = Long.parseLong(moderValue.substring(2), 16);
                                    moderValue = Long.valueOf(hexValue).toString();
                                }
                                break block33;
                            }
                        }
                        moderValue = Integer.valueOf(moder).toString();
                    }
                }
                if (afrValue == null) return regValues;
                if (moderValue == null) return regValues;
                int _parseInt = Integer.parseInt(moderValue);
                boolean _notEquals = _parseInt != 2;
                if (!_notEquals) return regValues;
                regValues.put(afrKey, "0");
                return regValues;
            }
            RegisterType reg = (RegisterType)iterator.next();
            Functions.Function1 _function_2 = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
            Iterator iterator2 = _filter.iterator();
            while (true) {
                boolean _equals_3;
                if (!iterator2.hasNext()) continue block11;
                FieldType field = (FieldType)iterator2.next();
                Functions.Function1 _function_3 = it -> it.getAttr();
                boolean _contains = ListExtensions.map(alreadyThere, (Functions.Function1)_function_3).contains(field);
                boolean _not = !_contains;
                if (!_not || !(_equals_3 = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index)))) continue;
                Object value = "";
                boolean _startsWith = field.getName().startsWith("MODER");
                if (_startsWith) {
                    value = ((EnumeratedValueType)moderValues.get(moder)).getName();
                    value = "'" + (String)value + "'";
                } else {
                    boolean _startsWith_1 = field.getName().startsWith("AFR");
                    if (_startsWith_1) {
                        value = Integer.valueOf(alternate).toString();
                    } else {
                        boolean _startsWith_2 = field.getName().startsWith("TR");
                        if (_startsWith_2) {
                            value = ((EnumeratedValueType)trValues.get(tr)).getName();
                            value = "'" + (String)value + "'";
                        } else {
                            boolean _lessThan;
                            value = this.defaultValue(reg, field);
                            long _longValue = GpioCfgHelper.longValue((String)value);
                            boolean bl = _lessThan = _longValue < 1L;
                            if (_lessThan) {
                                value = "'" + (String)value + "'";
                            }
                        }
                    }
                }
                regValues.put(field.getName(), (String)value);
            }
            break;
        }
    }

    public List<Pair<FieldType, String>> getDefaultFieldInstanceList(PinConfiguration conf, ConfigurablePin pin, FunctionRef functionRef, List<FieldType> alreadyThere) {
        ArrayList _xblockexpression = null;
        ArrayList res = CollectionLiterals.newArrayList();
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        boolean _find = matcher.find();
        if (_find) {
            String bank = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2));
            List<RegisterType> registersList = this.getRegisters(conf);
            Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
            Iterable registers = IterableExtensions.filter(registersList, (Functions.Function1)_function);
            int alternate = 0;
            Direction direction = functionRef.getDirection();
            EList<EnumeratedValueType> moderValues = this.getRegisterValues(registers, index, "MODER");
            EList<EnumeratedValueType> trValues = this.getRegisterValues(registers, index, "TR");
            int moder = 2;
            int tr = 0;
            String alternateStr = functionRef.getAlt();
            if (alternateStr == null) {
                if (direction != null) {
                    switch (direction) {
                        case INPUT: {
                            moder = 0;
                            tr = 1;
                            break;
                        }
                        case INPUT_OUTPUT: {
                            moder = 1;
                            tr = 1;
                            break;
                        }
                        case OUTPUT: {
                            moder = 1;
                            tr = 0;
                            break;
                        }
                        default: {
                            moder = 1;
                            tr = 0;
                            break;
                        }
                    }
                } else {
                    moder = 1;
                    tr = 0;
                }
                alternate = 0;
            } else {
                boolean _equals = "Direct_Analog".equals(alternateStr);
                if (_equals) {
                    alternate = 0;
                    moder = 3;
                    tr = 0;
                } else {
                    moder = 2;
                    if (direction != null) {
                        switch (direction) {
                            case INPUT_OUTPUT: 
                            case INPUT: {
                                tr = 1;
                                break;
                            }
                            default: {
                                tr = 0;
                                break;
                            }
                        }
                    } else {
                        tr = 0;
                    }
                    alternate = Integer.parseInt(alternateStr);
                }
            }
            Functions.Function1 _function_1 = it -> this.isSupported((RegisterType)it);
            Iterable supportedRegisters = IterableExtensions.filter((Iterable)registers, (Functions.Function1)_function_1);
            for (RegisterType reg : supportedRegisters) {
                Functions.Function1 _function_2 = it -> {
                    AccessType _access = it.getAccess();
                    return !Objects.equals(_access, AccessType.READ_ONLY);
                };
                Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_2);
                for (FieldType field : _filter) {
                    boolean _equals_1;
                    boolean _contains = alreadyThere.contains(field);
                    boolean _not = !_contains;
                    if (!_not || !(_equals_1 = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index)))) continue;
                    Object value = "";
                    boolean _startsWith = field.getName().startsWith("MODER");
                    if (_startsWith) {
                        value = ((EnumeratedValueType)moderValues.get(moder)).getName();
                        value = "'" + (String)value + "'";
                    } else {
                        boolean _startsWith_1 = field.getName().startsWith("AFR");
                        if (_startsWith_1) {
                            value = Integer.valueOf(alternate).toString();
                        } else {
                            boolean _startsWith_2 = field.getName().startsWith("TR");
                            if (_startsWith_2) {
                                value = ((EnumeratedValueType)trValues.get(tr)).getName();
                                value = "'" + (String)value + "'";
                            } else {
                                boolean _lessThan;
                                value = this.defaultValue(reg, field);
                                long _longValue = GpioCfgHelper.longValue((String)value);
                                boolean bl = _lessThan = _longValue < 1L;
                                if (_lessThan) {
                                    value = "'" + (String)value + "'";
                                }
                            }
                        }
                    }
                    Pair<FieldType, Object> pair = new Pair<FieldType, Object>(field, value);
                    res.add(pair);
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public EList<EnumeratedValueType> getRegisterValues(Iterable<RegisterType> registers, int index, String registerName) {
        BasicEList res = new BasicEList();
        Functions.Function1 _function = it -> this.isSupported((RegisterType)it);
        Iterable supportedRegisters = IterableExtensions.filter(registers, (Functions.Function1)_function);
        for (RegisterType reg : supportedRegisters) {
            Functions.Function1 _function_1 = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function_1);
            for (FieldType field : _filter) {
                boolean _startsWith;
                boolean _equals = field.getName().replaceAll("[A-Z]", "").equals(Integer.toString(index));
                if (!_equals || !(_startsWith = field.getName().startsWith(registerName))) continue;
                res = field.getEnumeratedValues().getEnumeratedValue();
                return res;
            }
        }
        return res;
    }

    public List<com.st.stellar.pinmap.gpio.gpioDsl.Function> getFunctions(PinSettings config, Peripheral periph) {
        Package pack;
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        IncludeBoard _includedBoard = config.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = GpioCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        if ((pack = _package) != null) {
            EObject _eContainer = pack.eContainer();
            Family family = (Family)_eContainer;
            EList functions = family.getFunctions();
            Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getName().equals(periph.getName());
            Iterables.addAll((Collection)list, (Iterable)IterableExtensions.filter((Iterable)functions, (Functions.Function1)_function));
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public Family getFamily(PinConfiguration config) {
        boolean _tripleNotEquals;
        Family _xblockexpression = null;
        Family family = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            IncludeBoard includedBoard = config.getPinSetting().getIncludedBoard();
            EObject cont = GpioCfgHelper.getBoard(includedBoard).getPackage().eContainer();
            family = (Family)cont;
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                EObject cont_1 = config.getBoard().getPackage().eContainer();
                family = (Family)cont_1;
            }
        }
        _xblockexpression = family;
        return _xblockexpression;
    }

    public static List<Pin> getPinsForFunction(PinSettings settings, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        IncludeBoard _includedBoard = settings.getIncludedBoard();
        Board _board = null;
        if (_includedBoard != null) {
            _board = GpioCfgHelper.getBoard(_includedBoard);
        }
        Package _package = null;
        if (_board != null) {
            _package = _board.getPackage();
        }
        Package pckg = _package;
        ArrayList<Pin> pins = new ArrayList<Pin>();
        EObject _eContainer = pckg.eContainer();
        Family family = (Family)_eContainer;
        EList configurations = family.getConfigurations();
        for (Configuration configuration : configurations) {
            EList _functions = configuration.getFunctions();
            for (FunctionRef fct : _functions) {
                Pin pin;
                boolean _equals = fct.getName().getName().equals(function.getName());
                if (!_equals || (pin = GpioCfgHelper.getPinForConfiguration(pckg, configuration)) == null || pins.contains(pin)) continue;
                pins.add(pin);
            }
        }
        return pins;
    }

    public static Pin getPinForConfiguration(Package pckg, Configuration configuration) {
        EList _pins = pckg.getPins();
        for (Pin pin : _pins) {
            Functions.Function1 _function = it -> it.getRef().getName().equals(configuration.getName());
            Iterable configurablePins = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)configurablePins);
            boolean _not = !_isEmpty;
            if (!_not) continue;
            return pin;
        }
        return null;
    }

    public List<com.st.stellar.pinmap.gpio.gpioDsl.Function> getFunctionForPeripheral(PinConfiguration config, Peripheral peripheral) {
        List<Object> _xblockexpression = null;
        List<Object> functions = new ArrayList<com.st.stellar.pinmap.gpio.gpioDsl.Function>();
        Family family = this.getFamily(config);
        if (family == null) {
            return functions;
        }
        Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().equals((Object)peripheral);
        _xblockexpression = functions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)family.getFunctions(), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public boolean isEnabledPeripheral(PinSettings settings, Peripheral peripheral) {
        boolean _xblockexpression = false;
        ArrayList peripherals = new ArrayList();
        Functions.Function1 _function = m -> m.getPins();
        Functions.Function1 _function_1 = p -> p.getConfig();
        Functions.Function1 _function_2 = p -> p.getAlt();
        Consumer<com.st.stellar.pinmap.gpio.gpioDsl.Function> _function_3 = f -> peripherals.add(f.getPeripheralRef().getName());
        IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(GpioCfgHelper.getAllModules(settings), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
        _xblockexpression = peripherals.contains(peripheral.getName());
        return _xblockexpression;
    }

    public List<PinSetting> getConfiguredPins(PinSettings settings) {
        Functions.Function1 _function = m -> m.getPins();
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap(GpioCfgHelper.getAllModules(settings), (Functions.Function1)_function));
    }

    public List<PinSetting> getConfiguredPins(PinSettings settings, com.st.stellar.pinmap.gpio.gpioDsl.Function function) {
        List<PinSetting> _xblockexpression = null;
        Functions.Function1 _function = m -> m.getPins();
        List configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(GpioCfgHelper.getAllModules(settings), (Functions.Function1)_function));
        Predicate<PinSetting> _function_1 = it -> it.getConfig().getAlt() != null && it.getConfig().getAlt().equals((Object)function);
        Stream<PinSetting> a = configuredPins.stream().filter(_function_1);
        _xblockexpression = a.toList();
        return _xblockexpression;
    }

    public String getPadName(Pin pin) {
        String _xblockexpression = null;
        Object padName = "";
        Predicate<PinConfig> _function = it -> ConfigurablePin.class.isInstance(it);
        Function<PinConfig, ConfigurablePin> _function_1 = it -> (ConfigurablePin)ConfigurablePin.class.cast(it);
        List configs = pin.getPinConfigurations().stream().filter(_function).map(_function_1).collect(Collectors.toList());
        for (ConfigurablePin config : configs) {
            Configuration pad = config.getRef();
            String _padName = padName;
            String _label = pad.getLabel();
            padName = _padName + _label;
        }
        _xblockexpression = padName;
        return _xblockexpression;
    }

    public Pin findPin(PinConfiguration config, String lookup) {
        Functions.Function1 _function = ps -> ps.getPin();
        Functions.Function1 _function_1 = it -> it.getName().equals(lookup);
        return (Pin)IterableExtensions.findFirst((Iterable)ListExtensions.map(GpioCfgHelper.getAllPinSettings(config), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public boolean isGPIO(com.st.stellar.pinmap.gpio.gpioDsl.Function fct) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        String _name = fct.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return false;
        }
        _xblockexpression = fct.getName().startsWith("GPIO") || fct.getName().startsWith("FCCU");
        return _xblockexpression;
    }

    public ArrayList<com.st.stellar.pinmap.gpio.gpioDsl.Function> getPackageFunctions(Package pack) {
        ArrayList _xblockexpression = null;
        ArrayList functionList = CollectionLiterals.newArrayList();
        if (pack != null) {
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                Iterable configurablePins = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : configurablePins) {
                    Configuration ref = pinConfig.getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef f : _functions) {
                        functionList.add(f.getName());
                    }
                }
            }
        }
        _xblockexpression = functionList;
        return _xblockexpression;
    }

    public List<com.st.stellar.pinmap.gpio.gpioDsl.Function> getFunctions(Configuration config, Peripheral periph) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        EList functions = config.getFunctions();
        Functions.Function1 _function = it -> it.getName().getPeripheralRef() != null && it.getName().getPeripheralRef().getName().equals(periph.getName());
        Functions.Function1 _function_1 = it -> it.getName();
        Iterables.addAll((Collection)list, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)functions, (Functions.Function1)_function), (Functions.Function1)_function_1));
        _xblockexpression = list;
        return _xblockexpression;
    }

    public String toUpper(PinSetting ps) {
        return ps.getName().toUpperCase(Locale.US);
    }

    public String getIODefinitions(PinSetting ps) {
        boolean _greaterThan;
        boolean _tripleEquals;
        String _xblockexpression = null;
        Object ioDef = "";
        ArrayList instances = CollectionLiterals.newArrayList();
        IOFields _ioFields = ps.getIoFields();
        boolean bl = _tripleEquals = _ioFields == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/* No IO definition for ");
            String _upper = this.toUpper(ps);
            _builder.append(_upper);
            _builder.append(" */");
            return _builder.toString();
        }
        EList<FieldInstance> regInstances = ps.getIoFields().getReg();
        for (FieldInstance inst : regInstances) {
            FieldType _attr = inst.getAttr();
            FieldType field = _attr;
            EObject _eContainer = field.eContainer();
            RegisterType reg = (RegisterType)_eContainer;
            boolean _isSupported = this.isSupported(reg);
            if (!_isSupported) continue;
            instances.add(inst);
        }
        int _size = instances.size();
        boolean bl2 = _greaterThan = _size > 0;
        if (_greaterThan) {
            int i = 1;
            for (FieldInstance inst_1 : instances) {
                boolean _equals;
                int _size_1 = instances.size();
                boolean bl3 = _equals = i == _size_1;
                if (_equals) {
                    String _ioDef = ioDef;
                    String _iO = this.toIO(inst_1);
                    ioDef = _ioDef + _iO;
                } else {
                    String _ioDef_1 = ioDef;
                    String _iO_1 = this.toIO(inst_1);
                    String _plus = _iO_1 + ", ";
                    ioDef = _ioDef_1 + _plus;
                }
                ++i;
            }
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/* No register instances for ");
            String _upper_1 = this.toUpper(ps);
            _builder_1.append(_upper_1);
            _builder_1.append(" */");
            ioDef = _builder_1.toString();
        }
        _xblockexpression = ioDef;
        return _xblockexpression;
    }

    public List<Pair<Configuration, com.st.stellar.pinmap.gpio.gpioDsl.Function>> getConfiguredPADs(PinConfiguration config) {
        ArrayList _xblockexpression = null;
        ArrayList res = CollectionLiterals.newArrayList();
        List<PinSetting> pinSettings = GpioCfgHelper.getAllPinSettings(config);
        for (PinSetting ps : pinSettings) {
            Configuration _ref = GpioCfgHelper.getFirstConfigurablePin(ps).getRef();
            com.st.stellar.pinmap.gpio.gpioDsl.Function _alt = ps.getConfig().getAlt();
            Pair<Configuration, com.st.stellar.pinmap.gpio.gpioDsl.Function> pair = new Pair<Configuration, com.st.stellar.pinmap.gpio.gpioDsl.Function>(_ref, _alt);
            res.add(pair);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }
}

