/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Include;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.GpioCfgPackage;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflow;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class GpiocfgScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private static final Logger log = Logger.getLogger(GpiocfgScopeProvider.class);

    public List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        ArrayList result = Lists.newArrayList();
        String _name = IWorkflow.class.getPackage().getName();
        String _plus = _name + ".*";
        result.add(this.createImportedNamespaceResolver(_plus, ignoreCase));
        return result;
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new JoiningImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    protected boolean isRelativeImport() {
        return false;
    }

    public IScope getScope(EObject context, EReference reference) {
        IScope _xblockexpression = null;
        if (context instanceof Board && Objects.equals(reference, GpioCfgPackage.Literals.BOARD__PACKAGE)) {
            Board ps = (Board)context;
            List importedNameSpaces = this.getImportedNamespaceResolvers(ps, true);
            return this.getScopeForPackage(ps, reference, importedNameSpaces);
        }
        if (context instanceof Module && Objects.equals(reference, GpioCfgPackage.Literals.MODULE__NAME)) {
            Module mod = (Module)context;
            EObject _eContainer = mod.eContainer();
            if (_eContainer instanceof PinSettings) {
                EObject _eContainer_1 = mod.eContainer();
                PinSettings ps_1 = (PinSettings)_eContainer_1;
                List importedNameSpaces_1 = this.getImportedNamespaceResolvers(ps_1, true);
                return this.getScopeForModules(ps_1, reference, (List<ImportNormalizer>)importedNameSpaces_1);
            }
            EObject _eContainer_2 = mod.eContainer();
            if (_eContainer_2 instanceof Board) {
                EObject _eContainer_3 = mod.eContainer();
                Board ps_2 = (Board)_eContainer_3;
                List importedNameSpaces_2 = this.getImportedNamespaceResolvers(ps_2, true);
                return this.getScopeForModules(ps_2, reference, (List<ImportNormalizer>)importedNameSpaces_2);
            }
        } else {
            boolean _equals;
            if (context instanceof PinSetting && Objects.equals(reference, GpioCfgPackage.Literals.PIN_SETTING__PIN)) {
                PinSetting setting = (PinSetting)context;
                EObject _eContainer_4 = setting.eContainer();
                Module module = (Module)_eContainer_4;
                EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)context);
                PinConfiguration root = (PinConfiguration)_rootContainer;
                List importedNameSpaces_3 = this.getImportedNamespaceResolvers(root, true);
                return this.getScopeForPin(this._gpioCfgHelper.getPack(module), reference, importedNameSpaces_3, module, setting);
            }
            if (context instanceof PinProperties && Objects.equals(reference, GpioCfgPackage.Literals.PIN_PROPERTIES__ALT)) {
                EObject _rootContainer_1 = EcoreUtil2.getRootContainer((EObject)context);
                PinConfiguration root_1 = (PinConfiguration)_rootContainer_1;
                PinProperties fct = (PinProperties)context;
                EObject _eContainer_5 = fct.eContainer().eContainer();
                Module module_1 = (Module)_eContainer_5;
                List importedNameSpaces_4 = this.getImportedNamespaceResolvers(root_1, true);
                return this.getScopeForAlt(root_1, reference, (List<ImportNormalizer>)importedNameSpaces_4, module_1, fct);
            }
            if (context instanceof FieldInstance && (_equals = Objects.equals(reference, GpioCfgPackage.Literals.FIELD_INSTANCE__ATTR))) {
                EObject _rootContainer_2 = EcoreUtil2.getRootContainer((EObject)context);
                PinConfiguration root_2 = (PinConfiguration)_rootContainer_2;
                List importedNameSpaces_5 = this.getImportedNamespaceResolvers(root_2, true);
                EObject pinSetting = ((FieldInstance)context).eContainer();
                return this.getScopeForAttr(pinSetting, reference, (List<ImportNormalizer>)importedNameSpaces_5);
            }
        }
        _xblockexpression = super.getScope(context, reference);
        return _xblockexpression;
    }

    public IScope getScopeForModules(PinSettings pinSettings, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        Resource resource;
        Resource r;
        boolean _tripleEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        IncludeBoard _includedBoard = pinSettings.getIncludedBoard();
        boolean bl = _tripleEquals = _includedBoard == null;
        if (_tripleEquals) {
            return scope;
        }
        Board board = GpioCfgHelper.getBoard(pinSettings.getIncludedBoard());
        if (board == null) {
            return scope;
        }
        com.st.stellar.pinmap.gpioCfg.Include includes = board.getIncludes();
        if (includes != null && includes.getImportURI() != null && (r = GpioCfgHelper.getResource(resource = pinSettings.eResource(), includes.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForPeripheral((PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForModules(Board pinSettings, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        Resource resource;
        Resource r;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        com.st.stellar.pinmap.gpioCfg.Include includes = pinSettings.getIncludes();
        if (includes != null && includes.getImportURI() != null && (r = GpioCfgHelper.getResource(resource = pinSettings.eResource(), includes.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForPeripheral((PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForPeripheral(PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EList _families = pinmapModel.getFamilies();
        for (Family fam : _families) {
            scope = Scopes.scopeFor((Iterable)fam.getPeripherals(), (IScope)scope);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForMCU(PinSettings pinSettings, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        Resource resource;
        Resource r;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        com.st.stellar.pinmap.gpioCfg.Include includes = GpioCfgHelper.getBoard(pinSettings.getIncludedBoard()).getIncludes();
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        if (inc != null && inc.getImportURI() != null && (r = GpioCfgHelper.getResource(resource = pinSettings.eResource(), inc.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForMCU((PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForMCU(PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EList _families = pinmapModel.getFamilies();
        for (Family fam : _families) {
            scope = super.getScope((EObject)fam, reference);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForPackage(Board pinSettings, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        Resource resource;
        Resource r;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        com.st.stellar.pinmap.gpioCfg.Include includes = pinSettings.getIncludes();
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        if (inc != null && inc.getImportURI() != null && (r = EcoreUtil2.getResource((Resource)(resource = pinSettings.eResource()), (String)inc.getImportURI())) != null && !r.getContents().isEmpty()) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForMCU((PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForPin(Package pack, EReference reference, List<ImportNormalizer> importedNameSpaces, Module module, PinSetting ps) {
        SimpleScope _xblockexpression = null;
        if (pack == null) {
            return IScope.NULLSCOPE;
        }
        String fctName = GpioCfgHelper.getFunctionName(ps);
        ArrayList result = Lists.newArrayList();
        EList _pins = pack.getPins();
        for (Pin pin : _pins) {
            boolean found = false;
            EList _pinConfigurations = pin.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                if (!(cfg instanceof ConfigurablePin)) continue;
                ConfigurablePin cp = (ConfigurablePin)cfg;
                EList _functions = cp.getRef().getFunctions();
                for (FunctionRef fr : _functions) {
                    if (fctName == null || !fctName.equals(fr.getName().getName())) continue;
                    found = true;
                }
            }
            if (!found) continue;
            result.add(EObjectDescription.create((String)pin.getName(), (EObject)pin));
        }
        _xblockexpression = new SimpleScope(IScope.NULLSCOPE, (Iterable)result);
        return _xblockexpression;
    }

    public IScope getScopeForAttr(PinSetting pinproperties, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        boolean _tripleNotEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)pinproperties);
        PinConfiguration root = (PinConfiguration)_rootContainer;
        com.st.stellar.pinmap.gpioCfg.Include includes = this._gpioCfgHelper.getIncludes(root);
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            Resource resource = root.eResource();
            Resource r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForAttr(pinproperties, root, (PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAttr(EObject fieldType, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        Resource resource;
        Resource r;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EObject _eContainer = fieldType.eContainer();
        PinSetting pinproperties = (PinSetting)_eContainer;
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)pinproperties);
        PinConfiguration root = (PinConfiguration)_rootContainer;
        com.st.stellar.pinmap.gpioCfg.Include includes = this._gpioCfgHelper.getIncludes(root);
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        if (inc != null && inc.getImportURI() != null && (r = GpioCfgHelper.getResource(resource = root.eResource(), inc.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForFieldAttr(fieldType, root, (PinmapModel)_get, reference, importedNameSpaces);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    protected IScope _getScopeForFieldAttr(EObject fieldType, PinConfiguration pinSettings, PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope scope;
        IScope _xblockexpression = null;
        _xblockexpression = scope = IScope.NULLSCOPE;
        return _xblockexpression;
    }

    protected IScope _getScopeForFieldAttr(IOFields fieldType, PinConfiguration pinSettings, PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EList includes = pinmapModel.getIncludes();
        for (Include inc : includes) {
            EObject _eContainer;
            PinSetting ps;
            PinProperties pinproperties;
            Resource resource;
            Resource r;
            String _importURI = inc.getImportURI();
            boolean _tripleNotEquals = _importURI != null;
            if (!_tripleNotEquals || (r = GpioCfgHelper.getResource(resource = pinSettings.eResource(), inc.getImportURI())) == null || IterableExtensions.isNullOrEmpty((Iterable)r.getContents()) || (pinproperties = (ps = (PinSetting)(_eContainer = fieldType.eContainer())).getConfig()) == null) continue;
            List<RegisterType> registerList = this._gpioCfgHelper.getRef(pinproperties);
            for (RegisterType reg : registerList) {
                scope = Scopes.scopeFor((Iterable)reg.getField(), (IScope)scope);
            }
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAttr(PinSetting ps, PinConfiguration pinSettings, PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        try {
            EList includes = pinmapModel.getIncludes();
            for (Include inc : includes) {
                String _importURI = inc.getImportURI();
                boolean _tripleNotEquals = _importURI != null;
                if (!_tripleNotEquals) continue;
                Resource resource = pinSettings.eResource();
                Resource r = GpioCfgHelper.getResource(resource, inc.getImportURI());
                if (r != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
                    EObject _get = (EObject)r.getContents().get(0);
                    scope = this.getScopeForAttr((DocumentRoot)_get, ps, reference, importedNameSpaces);
                }
                PinProperties pinproperties = ps.getConfig();
                List<RegisterType> registerList = this._gpioCfgHelper.getRef(pinproperties);
                for (RegisterType reg : registerList) {
                    scope = Scopes.scopeFor((Iterable)reg.getField(), (IScope)scope);
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                log.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAttr(DocumentRoot registerModel, PinSetting ps, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        PinProperties pinproperties = ps.getConfig();
        try {
            List<RegisterType> registerList = this._gpioCfgHelper.getRef(pinproperties);
            for (RegisterType reg : registerList) {
                scope = Scopes.scopeFor((Iterable)reg.getField(), (IScope)scope);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                log.error((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAlt(PinConfiguration cfg, EReference reference, List<ImportNormalizer> importedNameSpaces, Module module, PinProperties fct) {
        boolean _tripleNotEquals;
        IScope _xifexpression = null;
        PinSettings _pinSetting = cfg.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            _xifexpression = this.getScopeForAlt(cfg.getPinSetting(), reference, importedNameSpaces, module, fct);
        } else {
            boolean _tripleNotEquals_1;
            IScope _xifexpression_1 = null;
            Board _board = cfg.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                _xifexpression_1 = this.getScopeForAlt(cfg.getBoard(), reference, importedNameSpaces, module, fct);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public IScope getScopeForAlt(PinSettings pinSettings, EReference reference, List<ImportNormalizer> importedNameSpaces, Module module, PinProperties fct) {
        Resource resource;
        Resource r;
        boolean _tripleEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        IncludeBoard _includedBoard = pinSettings.getIncludedBoard();
        boolean bl = _tripleEquals = _includedBoard == null;
        if (_tripleEquals) {
            return scope;
        }
        Board board = GpioCfgHelper.getBoard(pinSettings.getIncludedBoard());
        if (board == null) {
            return scope;
        }
        com.st.stellar.pinmap.gpioCfg.Include includes = board.getIncludes();
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        if (inc != null && inc.getImportURI() != null && (r = EcoreUtil2.getResource((Resource)(resource = pinSettings.eResource()), (String)inc.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForAlt((PinmapModel)_get, reference, importedNameSpaces, module, fct);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAlt(Board board, EReference reference, List<ImportNormalizer> importedNameSpaces, Module module, PinProperties fct) {
        Resource resource;
        Resource r;
        boolean _tripleNotEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        com.st.stellar.pinmap.gpioCfg.Include includes = board.getIncludes();
        com.st.stellar.pinmap.gpioCfg.Include inc = includes;
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals && (r = GpioCfgHelper.getResource(resource = board.eResource(), inc.getImportURI())) != null && !IterableExtensions.isNullOrEmpty((Iterable)r.getContents())) {
            EObject _get = (EObject)r.getContents().get(0);
            scope = this.getScopeForAlt((PinmapModel)_get, reference, importedNameSpaces, module, fct);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAlt(PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces, Module peripheral, PinProperties af) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        if (pinmapModel != null) {
            ArrayList result = Lists.newArrayList();
            EList _functions = ((Family)pinmapModel.getFamilies().get(0)).getFunctions();
            for (Function f : _functions) {
                if (f.getPeripheralRef() == null || !f.getPeripheralRef().getName().equals(peripheral.getName().getName())) continue;
                result.add(EObjectDescription.create((String)f.getName(), (EObject)f));
            }
            return new SimpleScope(IScope.NULLSCOPE, (Iterable)result);
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    @XbaseGenerated
    public IScope getScopeForFieldAttr(EObject fieldType, PinConfiguration pinSettings, PinmapModel pinmapModel, EReference reference, List<ImportNormalizer> importedNameSpaces) {
        if (fieldType instanceof IOFields) {
            return this._getScopeForFieldAttr((IOFields)fieldType, pinSettings, pinmapModel, reference, importedNameSpaces);
        }
        if (fieldType != null) {
            return this._getScopeForFieldAttr(fieldType, pinSettings, pinmapModel, reference, importedNameSpaces);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fieldType, pinSettings, pinmapModel, reference, importedNameSpaces).toString());
    }

    public static class JoiningImportNormalizer
    extends ImportNormalizer {
        public JoiningImportNormalizer(QualifiedName importedNamespace, boolean wildCard, boolean ignoreCase) {
            super(importedNamespace, wildCard, ignoreCase);
        }

        public QualifiedName resolve(QualifiedName relativeName) {
            if (relativeName.getSegmentCount() > 1 && !this.hasWildCard()) {
                QualifiedName importPrefix;
                boolean _equals;
                String pivot = relativeName.getFirstSegment();
                boolean _isIgnoreCase = this.isIgnoreCase();
                if (_isIgnoreCase) {
                    pivot = pivot.toLowerCase();
                }
                if (_equals = pivot.equals((importPrefix = this.getImportedNamespacePrefix()).getLastSegment())) {
                    return importPrefix.append(relativeName.skipFirst(1));
                }
            }
            return super.resolve(relativeName);
        }

        public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
            QualifiedName importPrefix;
            boolean _startsWith;
            boolean _not;
            boolean _hasWildCard = this.hasWildCard();
            boolean bl = _not = !_hasWildCard;
            if (_not && (_startsWith = fullyQualifiedName.startsWith(importPrefix = this.getImportedNamespacePrefix()))) {
                int _segmentCount = importPrefix.getSegmentCount();
                int _minus = _segmentCount - 1;
                return fullyQualifiedName.skipFirst(_minus);
            }
            return super.deresolve(fullyQualifiedName);
        }
    }
}

