/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.NotConnectedPin;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.GpioCfgPackage;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.Include;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.validation.AbstractGpiocfgValidator;
import com.st.stellar.pinmap.validation.GpioValidationMessageAcceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe2.language.scoping.QualifiedNameProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;

public class GpiocfgValidator
extends AbstractGpiocfgValidator {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    @Inject
    private QualifiedNameProvider qnprovider;
    protected static final String ISSUE_CODE_PREFIX = "com.st.stellar.pinmap.";
    public static final String INVALID_FIELD_INSTANCE_VALUE = "com.st.stellar.pinmap.invalidFieldInstanceValue";
    public static final String INVALID_FIELD_INSTANCE_ATTR = "com.st.stellar.pinmap.invalidFieldInstanceAttr";
    public static final String INVALID_OUTPUTFOLDER = "com.st.stellar.pinmap.invalidOutputFolder";
    private GpioValidationMessageAcceptor errorAcceptor = null;
    public static final String INVALID_REGISTER_CONFIG = "invalidRegisterConfig";
    public static final String MISSING_REG_INSTANCES = "com.st.stellar.pinmap.missingReg Instances";
    public static final String DUPLICATED_ELEMENT = "com.st.stellar.pinmap.duplicatedElement";
    public static final String UNIQUE_FUNCTION_USAGE = "com.st.stellar.pinmap.uniqueFunctionUsage";
    public static final String UNIQUE_PIN_USAGE = "com.st.stellar.pinmap.uniquePinUsage";
    public static final String DUPLICATED_PINCONFIG = "com.st.stellar.pinmap.duplicatedPinConfig";
    public static final String WRONG_FUNCTION = "com.st.stellar.pinmap.wrongFunction";
    public static final String NOTCONNECTED_PIN = "com.st.stellar.pinmap.notConnectedPin";
    public static final String SPECIAL_PIN = "com.st.stellar.pinmap.specialPin";
    public static final String SYSTEMFUNCTION_PIN = "com.st.stellar.pinmap.systermFunctionPin";
    public static final String WRONG_DIRECTION = "com.st.stellar.pinmap.wrongDirection";
    public static final String BAD_URI = "com.st.stellar.pinmap.badURI";

    public GpioValidationMessageAcceptor getAcceptor() {
        GpioValidationMessageAcceptor _xifexpression = null;
        if (this.errorAcceptor == null) {
            GpioValidationMessageAcceptor _gpioValidationMessageAcceptor;
            GpiocfgValidator _cast = (GpiocfgValidator)((Object)GpiocfgValidator.class.cast((Object)this));
            _xifexpression = this.errorAcceptor = (_gpioValidationMessageAcceptor = new GpioValidationMessageAcceptor(_cast));
        } else {
            _xifexpression = this.errorAcceptor;
        }
        return _xifexpression;
    }

    public static Pair<Integer, String> checkValue(FieldInstance regInstance, IOFields fieldType, String valueStr) {
        FieldType field = regInstance.getAttr();
        if (field.getEnumeratedValues() == null || field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            PinProperties _config;
            EObject _eContainer = regInstance.eContainer();
            IOFields ioFields = (IOFields)_eContainer;
            EObject _eContainer_1 = ioFields.eContainer();
            PinSetting ps = (PinSetting)_eContainer_1;
            PinProperties pp = _config = ps.getConfig();
            Function regConfig = pp.getAlt();
            if (field.getName() != null && field.getName().startsWith("AFR")) {
                boolean _greaterThan;
                boolean _equals;
                Functions.Function1 _function = it -> it.getAttr().getName().startsWith("MODER");
                FieldInstance moder = (FieldInstance)IterableExtensions.findFirst(fieldType.getReg(), (Functions.Function1)_function);
                boolean resetAFRValue = moder != null && moder.getValue() != null && !moder.getValue().contains("Alternate");
                Functions.Function1 _function_1 = it -> it.getName().getName().equals(pp.getAlt().getName());
                Iterable functionRefs = IterableExtensions.filter(GpioCfgHelper.getFunctionRefs(ps), (Functions.Function1)_function_1);
                int _size = IterableExtensions.size((Iterable)functionRefs);
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    FunctionRef functionRef = ((FunctionRef[])Conversions.unwrapArray((Object)functionRefs, FunctionRef.class))[0];
                    String value = functionRef.getAlt();
                    if (value != null) {
                        if ("Direct_Analog".equals(value) || resetAFRValue) {
                            value = "0x0";
                        }
                    } else {
                        value = "0";
                    }
                    long longVal = GpioCfgHelper.longValue(value);
                    String _name = field.getName();
                    String _name_1 = regConfig.getName();
                    Object[] objects = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name, _name_1, value})).toArray();
                    String message = NLS.bind((String)"The only possible value of ''{0}'' field for function: ''{1}'' is ''{2}''", (Object[])objects);
                    long inputValLong = GpioCfgHelper.longValue(valueStr);
                    int _xifexpression = 0;
                    boolean _equals_1 = Long.valueOf(inputValLong).equals(longVal);
                    _xifexpression = _equals_1 ? 0 : 2;
                    return new Pair((Object)_xifexpression, (Object)message);
                }
                ArrayList values = CollectionLiterals.newArrayList();
                Functions.Function1 _function_2 = it -> {
                    boolean _equals_2 = "Direct_Analog".equals(it.getAlt());
                    return !_equals_2;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)functionRefs, (Functions.Function1)_function_2);
                for (FunctionRef functionRef_1 : _filter) {
                    String value_1 = functionRef_1.getAlt();
                    long longVal_1 = GpioCfgHelper.longValue(value_1);
                    values.add(longVal_1);
                }
                Functions.Function1 _function_3 = it -> {
                    Long _xifexpression_1 = null;
                    _xifexpression_1 = resetAFRValue ? Long.valueOf(0L) : it;
                    return _xifexpression_1;
                };
                List longList = ListExtensions.map((List)values, (Functions.Function1)_function_3);
                HashSet uniqueValues = new HashSet(longList);
                String listStr = IterableExtensions.join(uniqueValues, (CharSequence)",");
                int _size_1 = uniqueValues.size();
                boolean bl2 = _greaterThan = _size_1 > 0;
                if (_greaterThan) {
                    String _name_2 = field.getName();
                    String _name_3 = regConfig.getName();
                    Object[] objects_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name_2, _name_3, listStr})).toArray();
                    String message_1 = NLS.bind((String)"The only possible value of ''{0}'' field for function: ''{1}'' is ''{2}''", (Object[])objects_1);
                    long inputValLong_1 = GpioCfgHelper.longValue(valueStr);
                    int _xifexpression_1 = 0;
                    boolean _contains = uniqueValues.contains(inputValLong_1);
                    _xifexpression_1 = _contains ? 0 : 2;
                    int status = _xifexpression_1;
                    return new Pair((Object)status, (Object)message_1);
                }
                String _name_4 = field.getName();
                String _name_5 = regConfig.getName();
                Object[] objects_2 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name_4, _name_5, listStr})).toArray();
                String message_2 = NLS.bind((String)"The only possible values of ''{0}'' field for function: ''{1}'' are ''{2}''", (Object[])objects_2);
                long inputValLong_2 = GpioCfgHelper.longValue(valueStr);
                int _xifexpression_2 = 0;
                boolean _contains_1 = uniqueValues.contains(inputValLong_2);
                _xifexpression_2 = _contains_1 ? 0 : 2;
                int status_1 = _xifexpression_2;
                return new Pair((Object)status_1, (Object)message_2);
            }
            return new Pair((Object)0, (Object)"");
        }
        EnumeratedValueType enumValue = GpiocfgValidator.findEnumeratedValue(field, valueStr);
        if (enumValue == null) {
            String message_3 = NLS.bind((String)"Wrong value ''{0}'' for bit field ''{1}''", (Object)valueStr, (Object)field.getName());
            int error = 4;
            return new Pair((Object)4, (Object)message_3);
        }
        if (field.getName() != null && field.getName().startsWith("MODER")) {
            PinProperties _config_1;
            EObject _eContainer_2 = regInstance.eContainer();
            IOFields ioFields_1 = (IOFields)_eContainer_2;
            EObject _eContainer_3 = ioFields_1.eContainer();
            PinSetting ps_1 = (PinSetting)_eContainer_3;
            PinProperties pp_1 = _config_1 = ps_1.getConfig();
            Function regConfig_1 = pp_1.getAlt();
            FunctionRef functionRef_2 = GpioCfgHelper.getFunctionRef(ps_1);
            String value_1 = functionRef_2.getAlt();
            if (value_1 != null && "Direct_Analog".equals(value_1) && !enumValue.getName().equals("Analog")) {
                String _name_6 = field.getName();
                String _name_7 = regConfig_1.getName();
                Object[] objects_3 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name_6, _name_7, "Analog"})).toArray();
                String message_4 = NLS.bind((String)"The only possible value of ''{0}'' field for function: ''{1}'' is ''{2}''", (Object[])objects_3);
                int error_1 = 4;
                return new Pair((Object)4, (Object)message_4);
            }
        }
        return new Pair((Object)0, (Object)"");
    }

    public static EnumeratedValueType findEnumeratedValue(FieldType field, String valueStr) {
        EnumeratedValueType _xblockexpression = null;
        EList values = field.getEnumeratedValues().getEnumeratedValue();
        EnumeratedValueType enumValue = null;
        long valueLong = GpioCfgHelper.longValue(valueStr);
        if (valueLong < 0L) {
            String nameStr = valueStr.replaceAll("'", "").replaceAll("\"", "");
            Functions.Function1 _function = it -> it.getName().equals(nameStr);
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function);
        } else {
            Functions.Function1 _function_1 = it -> {
                boolean _xblockexpression_1 = false;
                long enumLong = GpioCfgHelper.longValue(it.getValue());
                _xblockexpression_1 = Long.valueOf(enumLong).equals(valueLong);
                return _xblockexpression_1;
            };
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function_1);
        }
        _xblockexpression = enumValue;
        return _xblockexpression;
    }

    @Check
    public void checkFieldInstanceValue(FieldInstance instance) {
        EObject parent = instance.eContainer();
        this.checkFieldInstanceValues(parent, instance);
    }

    protected void _checkFieldInstanceValues(IOFields fieldType, FieldInstance instance) {
        GpiocfgValidator.checkFieldInstanceValues(fieldType, instance, this.getAcceptor());
    }

    public static void checkFieldInstanceValues(IOFields fieldType, FieldInstance instance, GpioValidationMessageAcceptor acceptor) {
        FieldType bf = instance.getAttr();
        String value = instance.getValue();
        if (bf == null || value == null) {
            return;
        }
        boolean nameIsValid = GpiocfgValidator.checkInstanceName(instance);
        if (nameIsValid) {
            Pair<Integer, String> res = GpiocfgValidator.checkValue(instance, fieldType, value);
            if (res == null) {
                return;
            }
            Integer _key = (Integer)res.getKey();
            int valid = _key;
            if (valid != 0) {
                String _value;
                String message = _value = (String)res.getValue();
                List<String> values = GpiocfgValidator.possibleValues(instance, fieldType);
                if (valid == 2) {
                    acceptor.collectWarning(message, (EObject)instance, (EStructuralFeature)GpioCfgPackage.Literals.FIELD_INSTANCE__VALUE, -1, INVALID_FIELD_INSTANCE_VALUE, (String[])Iterables.toArray(values, String.class));
                } else {
                    acceptor.collectError(message, (EObject)instance, (EStructuralFeature)GpioCfgPackage.Literals.FIELD_INSTANCE__VALUE, -1, INVALID_FIELD_INSTANCE_VALUE, (String[])Iterables.toArray(values, String.class));
                }
            }
        } else {
            EObject _eContainer = fieldType.eContainer();
            PinProperties config = ((PinSetting)_eContainer).getConfig();
            if (config != null) {
                EObject _eContainer_1 = fieldType.eContainer();
                String message_1 = NLS.bind((String)"Register ''{0}'' is not accessible for function ''{1}''", (Object)instance.getAttr().getName(), (Object)((PinSetting)_eContainer_1).getConfig().getAlt().getName());
                acceptor.collectError(message_1, (EObject)instance, (EStructuralFeature)GpioCfgPackage.Literals.FIELD_INSTANCE__ATTR, -1, INVALID_FIELD_INSTANCE_ATTR, null);
            }
        }
    }

    public static boolean checkInstanceName(FieldInstance instance) {
        boolean _xblockexpression = false;
        EObject _eContainer = instance.eContainer().eContainer();
        PinSetting config = (PinSetting)_eContainer;
        ConfigurablePin pin = GpioCfgHelper.getFirstConfigurablePin(config);
        if (pin == null) {
            return false;
        }
        String id = pin.getRef().getName();
        Pattern pattern = Pattern.compile("P[0-9]*_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        int pinBank = -1;
        boolean valid = false;
        boolean _find = matcher.find();
        if (_find) {
            String attrName;
            pinBank = Integer.parseInt(matcher.group(1));
            pattern = Pattern.compile("[^0-9]*([0-9]*)");
            matcher = pattern.matcher(attrName = instance.getAttr().getName());
            boolean _find_1 = matcher.find();
            if (_find_1) {
                int attrBank = Integer.parseInt(matcher.group(1));
                valid = attrBank == pinBank;
            }
        }
        _xblockexpression = valid;
        return _xblockexpression;
    }

    protected void _checkFieldInstanceValues(EObject fieldType, FieldInstance instance) {
        InputOutput.println((Object)("checkFieldInstanceValues:" + String.valueOf(fieldType)));
    }

    public static List<String> possibleValues(FieldInstance regInstance, IOFields fieldType) {
        ArrayList<String> _xblockexpression = null;
        FieldType field = regInstance.getAttr();
        ArrayList<String> list = new ArrayList<String>();
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            ArrayList _arrayList;
            boolean _equals;
            EObject _eContainer;
            PinSetting ps;
            FunctionRef functionRef;
            String value;
            boolean _startsWith = field.getName().startsWith("MODER");
            if (_startsWith && (value = (functionRef = GpioCfgHelper.getFunctionRef(ps = (PinSetting)(_eContainer = fieldType.eContainer()))).getAlt()) != null && (_equals = "Direct_Analog".equals(value))) {
                value = "Analog";
                list.add(value);
                return list;
            }
            ArrayList _elvis = null;
            Functions.Function1 _function = it -> it.getName();
            ArrayList _map = ListExtensions.map((List)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            _elvis = _map != null ? _map : (_arrayList = new ArrayList());
            return _elvis;
        }
        if (field.getName() != null && field.getName().startsWith("AFR")) {
            boolean _equals_1;
            PinProperties _config;
            Functions.Function1 _function_1 = it -> it.getAttr().getName().startsWith("MODER");
            FieldInstance moder = (FieldInstance)IterableExtensions.findFirst(fieldType.getReg(), (Functions.Function1)_function_1);
            boolean resetAFRValue = moder != null && !moder.getValue().contains("Alternate");
            EObject _eContainer_1 = fieldType.eContainer();
            PinSetting ps_1 = (PinSetting)_eContainer_1;
            PinProperties pp = _config = ps_1.getConfig();
            Functions.Function1 _function_2 = it -> it.getName().getName().equals(pp.getAlt().getName());
            Iterable functionRefs = IterableExtensions.filter(GpioCfgHelper.getFunctionRefs(ps_1), (Functions.Function1)_function_2);
            int _size = IterableExtensions.size((Iterable)functionRefs);
            boolean bl = _equals_1 = _size == 1;
            if (_equals_1) {
                FunctionRef functionRef_1 = ((FunctionRef[])Conversions.unwrapArray((Object)functionRefs, FunctionRef.class))[0];
                String value_1 = functionRef_1.getAlt();
                if (value_1 != null) {
                    if ("Direct_Analog".equals(value_1) || resetAFRValue) {
                        value_1 = "0x0";
                    }
                    list.add(value_1);
                } else {
                    list.add("0x0");
                }
            } else {
                Functions.Function1 _function_3 = it -> {
                    boolean _equals_2 = "Direct_Analog".equals(it.getAlt());
                    return !_equals_2;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)functionRefs, (Functions.Function1)_function_3);
                for (FunctionRef functionRef_2 : _filter) {
                    boolean _contains;
                    boolean _not;
                    String value_2 = functionRef_2.getAlt();
                    if (resetAFRValue) {
                        value_2 = "0";
                    }
                    if (!(_not = !(_contains = list.contains(value_2)))) continue;
                    list.add(value_2);
                }
            }
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static List<String> possibleFunctionLocations(PinSetting ps) {
        EObject _eContainer_3;
        ArrayList _xblockexpression = null;
        Function function = ps.getConfig().getAlt();
        EObject _eContainer = ps.eContainer();
        Module module = (Module)_eContainer;
        ArrayList list = CollectionLiterals.newArrayList();
        EObject _eContainer_1 = module.eContainer();
        if (_eContainer_1 instanceof PinSettings) {
            EObject _eContainer_2 = module.eContainer();
            List<Pin> _functionPins = GpioCfgHelper.getFunctionPins((PinSettings)_eContainer_2, function);
            for (Pin pin : _functionPins) {
                boolean _equals = ps.getPin().getName().equals(pin.getName());
                boolean _not = !_equals;
                if (!_not) continue;
                list.add(pin.getName());
            }
        }
        if ((_eContainer_3 = module.eContainer()) instanceof Board) {
            EObject _eContainer_4 = module.eContainer();
            List<Pin> _functionPins_1 = GpioCfgHelper.getFunctionPins((Board)_eContainer_4, function);
            for (Pin pin_1 : _functionPins_1) {
                boolean _equals_1 = ps.getPin().getName().equals(pin_1.getName());
                boolean _not_1 = !_equals_1;
                if (!_not_1) continue;
                list.add(pin_1.getName());
            }
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public static boolean directionsAreCompatible(PinSetting ps, Direction fctDirection, com.st.stellar.pinmap.gpioCfg.Direction pinDirection, Function fct) {
        boolean _equals_1;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        boolean res = false;
        Function _alt = ps.getConfig().getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals && (!fct.getName().startsWith("GPI") || fct.getName().startsWith("GPIO"))) {
            return false;
        }
        boolean inout = false;
        Function _alt_1 = ps.getConfig().getAlt();
        boolean bl2 = _tripleEquals_1 = _alt_1 == null;
        if (_tripleEquals_1) {
            // empty if block
        }
        boolean _or = false;
        boolean _equals = ps.getConfig().getAlt().getPeripheralRef().getName().equals("GPIO");
        _or = _equals ? true : (_equals_1 = ps.getConfig().getAlt().getPeripheralRef().getName().equals("FCCU"));
        if (pinDirection != null) {
            switch (pinDirection) {
                case INPUT: {
                    res = Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case OUTPUT: {
                    res = Objects.equals(fctDirection, Direction.OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case INPUT_OUTPUT: {
                    res = Objects.equals(fctDirection, Direction.INPUT_OUTPUT) || inout;
                    break;
                }
                default: {
                    res = false;
                    break;
                }
            }
        } else {
            res = false;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static boolean directionsAreCompatible(PinSetting ps, Direction fctDirection, com.st.stellar.pinmap.gpioCfg.Direction pinDirection) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        boolean res = false;
        boolean inout = false;
        Function _alt = ps.getConfig().getAlt();
        boolean bl = _tripleEquals = _alt == null;
        if (_tripleEquals) {
            inout = false;
        } else {
            boolean _equals_1;
            boolean _or = false;
            boolean _equals = ps.getConfig().getAlt().getPeripheralRef().getName().equals("GPIO");
            _or = _equals ? true : (_equals_1 = ps.getConfig().getAlt().getPeripheralRef().getName().equals("FCCU"));
        }
        if (pinDirection != null) {
            switch (pinDirection) {
                case INPUT: {
                    res = Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case OUTPUT: {
                    res = Objects.equals(fctDirection, Direction.OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case INPUT_OUTPUT: {
                    res = Objects.equals(fctDirection, Direction.INPUT_OUTPUT) || inout;
                    break;
                }
                default: {
                    res = false;
                    break;
                }
            }
        } else {
            res = false;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static boolean directionsAreCompatible(Direction fctDirection, com.st.stellar.pinmap.gpioCfg.Direction pinDirection) {
        boolean _xblockexpression = false;
        boolean res = false;
        if (pinDirection != null) {
            switch (pinDirection) {
                case INPUT: {
                    res = Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case OUTPUT: {
                    res = Objects.equals(fctDirection, Direction.OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                    break;
                }
                case INPUT_OUTPUT: {
                    boolean _equals;
                    res = _equals = Objects.equals(fctDirection, Direction.INPUT_OUTPUT);
                    break;
                }
                default: {
                    res = false;
                    break;
                }
            }
        } else {
            res = false;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static boolean directionsAreCompatible(Function fct, Direction fctDirection, com.st.stellar.pinmap.gpioCfg.Direction pinDirection) {
        boolean _xblockexpression = false;
        boolean res = false;
        if (fct.getName().startsWith("GPI") && !fct.getName().contains("GPIO")) {
            res = (Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT)) && Objects.equals((Object)pinDirection, (Object)com.st.stellar.pinmap.gpioCfg.Direction.INPUT);
        } else {
            boolean _isGPIO = GpioCfgHelper.instance.isGPIO(fct);
            if (_isGPIO) {
                if (pinDirection != null) {
                    switch (pinDirection) {
                        case INPUT: {
                            res = Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                            break;
                        }
                        case OUTPUT: {
                            res = Objects.equals(fctDirection, Direction.OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                            break;
                        }
                        case INPUT_OUTPUT: {
                            res = Objects.equals(fctDirection, Direction.INPUT_OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                            break;
                        }
                        default: {
                            res = false;
                            break;
                        }
                    }
                } else {
                    res = false;
                }
            } else if (pinDirection != null) {
                switch (pinDirection) {
                    case INPUT: {
                        res = Objects.equals(fctDirection, Direction.INPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                        break;
                    }
                    case OUTPUT: {
                        res = Objects.equals(fctDirection, Direction.OUTPUT) || Objects.equals(fctDirection, Direction.INPUT_OR_OUTPUT);
                        break;
                    }
                    case INPUT_OUTPUT: {
                        boolean _equals;
                        res = _equals = Objects.equals(fctDirection, Direction.INPUT_OUTPUT);
                        break;
                    }
                    default: {
                        res = false;
                        break;
                    }
                }
            } else {
                res = false;
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Check
    public void checkMissingRegInstances(PinSetting ps) {
        GpiocfgValidator.checkMissingRegInstances(ps, this.getAcceptor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkMissingRegInstances(PinSetting ps, GpioValidationMessageAcceptor acceptor) {
        if (ps != null && ps.getIoFields() != null) {
            Functions.Function1 _function = it -> {
                FieldType _attr = it.getAttr();
                return _attr != null;
            };
            Iterable iofields = IterableExtensions.filter(ps.getIoFields().getReg(), (Functions.Function1)_function);
            EObject _eContainer = ps.eContainer();
            Module module = (Module)_eContainer;
            if (module == null) return;
            ConfigurablePin pin = GpioCfgHelper.getFirstConfigurablePin(ps);
            if (ps.getConfig() == null) return;
            if (ps.getConfig().getAlt() == null) return;
            Map<String, String> registers = GpioCfgHelper.instance.getDefaultFieldInstances(module, pin, ps.getConfig().getAlt().getName(), IterableExtensions.toList((Iterable)iofields));
            int _size = registers.size();
            if (_size <= 0) return;
            boolean bl = true;
            boolean _greaterThan = bl;
            if (!_greaterThan) return;
            String missingRegisters = IterableExtensions.join(registers.keySet(), (CharSequence)", ");
            try {
                acceptor.collectWarning("Missing register instances values: '" + missingRegisters + "'", (EObject)ps, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_IoFields(), -1, MISSING_REG_INSTANCES, new String[0]);
                return;
            }
            catch (Throwable _t) {
                if (!(_t instanceof IllegalArgumentException)) throw Exceptions.sneakyThrow((Throwable)_t);
                return;
            }
        }
        try {
            acceptor.collectWarning("Missing IO definition", (EObject)ps, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_IoFields(), -1, MISSING_REG_INSTANCES, new String[0]);
            return;
        }
        catch (Throwable _t) {
            if (!(_t instanceof IllegalArgumentException)) throw Exceptions.sneakyThrow((Throwable)_t);
            return;
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(PinConfiguration cfg) {
        GpiocfgValidator.checkNoDuplicatedPinNames(cfg, this.getAcceptor());
    }

    public static void checkNoDuplicatedPinNames(PinConfiguration cfg, GpioValidationMessageAcceptor acceptor) {
        PinSettings _pinSetting;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        HashMultimap multiMap = HashMultimap.create();
        Board _board = cfg.getBoard();
        boolean bl = _tripleNotEquals = _board != null;
        if (_tripleNotEquals) {
            List<PinSetting> _pins = GpioCfgHelper.getPins(cfg.getBoard());
            for (PinSetting e : _pins) {
                multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_pinSetting = cfg.getPinSetting()) != null;
        if (_tripleNotEquals_1) {
            List<PinSetting> _allPinSettings = GpioCfgHelper.getAllPinSettings(cfg);
            for (PinSetting pinSetting : _allPinSettings) {
                String _name = pinSetting.getName();
                boolean _tripleNotEquals_2 = _name != null;
                if (!_tripleNotEquals_2) continue;
                multiMap.put((Object)pinSetting.getName().toLowerCase(Locale.ENGLISH), (Object)pinSetting);
            }
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                try {
                    String _name_1 = d.getName();
                    String _plus = "Duplicated pin identifier: " + _name_1;
                    acceptor.collectError(_plus, (EObject)d, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Name(), -1, DUPLICATED_ELEMENT, new String[0]);
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalArgumentException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(PinSettings ps) {
        GpiocfgValidator.checkNoDuplicatedPinNames(ps, this.getAcceptor());
    }

    public static void checkNoDuplicatedPinNames(PinSettings ps, GpioValidationMessageAcceptor acceptor) {
        HashMultimap multiMap = HashMultimap.create();
        List<PinSetting> _pins = GpioCfgHelper.getPins(ps);
        for (PinSetting e : _pins) {
            String _name = e.getName();
            boolean _tripleNotEquals = _name != null;
            if (!_tripleNotEquals) continue;
            multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                try {
                    String _name_1 = d.getName();
                    String _plus = "Duplicated pin identifier: " + _name_1;
                    acceptor.collectError(_plus, (EObject)d, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Name(), -1, DUPLICATED_ELEMENT, new String[0]);
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalArgumentException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(Board board) {
        this.checkNoDuplicatedPinNames(board, this.getAcceptor());
    }

    public void checkNoDuplicatedPinNames(Board board, GpioValidationMessageAcceptor acceptor) {
        HashMultimap multiMap = HashMultimap.create();
        List<PinSetting> _pins = GpioCfgHelper.getPins(board);
        for (PinSetting e : _pins) {
            String _name = e.getName();
            boolean _tripleNotEquals = _name != null;
            if (!_tripleNotEquals) continue;
            multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                try {
                    String _name_1 = d.getName();
                    String _plus = "Duplicated pin identifier: " + _name_1;
                    acceptor.collectError(_plus, (EObject)d, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Name(), -1, DUPLICATED_ELEMENT, new String[0]);
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalArgumentException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    @Check
    public void checkUniqueFunctionUsage(PinSettings settings) {
        GpiocfgValidator.checkUniqueFunctionUsage(settings, this.getAcceptor());
    }

    public static void checkUniqueFunctionUsage(PinSettings settings, GpioValidationMessageAcceptor acceptor) {
        HashMultimap multiMap = HashMultimap.create();
        URI currentURI = settings.eResource().getURI();
        List<PinSetting> pins = GpioCfgHelper.getAllPinSettings(settings);
        for (PinSetting e : pins) {
            if (e.getConfig() == null || e.getConfig().getAlt() == null || e.getConfig().getAlt().getName() == null) continue;
            multiMap.put((Object)e.getConfig().getAlt().getName(), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                URI uri = d.eResource().getURI();
                if (uri != currentURI && !acceptor.acceptsExternalResource()) continue;
                acceptor.collectError(NLS.bind((String)"Function cannot be used twice on different pins: ''{0}''", (Object)d.getConfig().getAlt().getName()), (EObject)d.getConfig(), (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinProperties_Alt(), -1, UNIQUE_FUNCTION_USAGE, new String[0]);
            }
        }
    }

    @Check
    public void checkUniqueFunctionUsage(PinConfiguration config) {
        GpiocfgValidator.checkUniqueFunctionUsage(config, this.getAcceptor());
    }

    public static void checkUniqueFunctionUsage(PinConfiguration config, GpioValidationMessageAcceptor acceptor) {
        Board _board;
        boolean _tripleNotEquals_1;
        HashMultimap multiMap = HashMultimap.create();
        PinSettings settings = config.getPinSetting();
        if (settings != null) {
            boolean _tripleNotEquals;
            List<PinSetting> _pins = GpioCfgHelper.getPins(settings);
            for (PinSetting e : _pins) {
                if (e.getConfig() == null || e.getConfig().getAlt() == null || e.getConfig().getAlt().getName() == null) continue;
                multiMap.put((Object)e.getConfig().getAlt().getName(), (Object)e);
            }
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            boolean bl = _tripleNotEquals = _includedBoard != null;
            if (_tripleNotEquals) {
                Board board = GpioCfgHelper.getBoard(config.getPinSetting().getIncludedBoard());
                List<PinSetting> boardSettings = GpioCfgHelper.getPins(board);
                for (PinSetting e_1 : boardSettings) {
                    if (e_1.getConfig() == null || e_1.getConfig().getAlt() == null || e_1.getConfig().getAlt().getName() == null) continue;
                    multiMap.put((Object)e_1.getConfig().getAlt().getName(), (Object)e_1);
                }
            }
        }
        boolean bl = _tripleNotEquals_1 = (_board = config.getBoard()) != null;
        if (_tripleNotEquals_1) {
            List<PinSetting> boardSettings_1 = GpioCfgHelper.getPins(config.getBoard());
            for (PinSetting e_2 : boardSettings_1) {
                if (e_2.getConfig() == null || e_2.getConfig().getAlt() == null || e_2.getConfig().getAlt().getName() == null) continue;
                multiMap.put((Object)e_2.getConfig().getAlt().getName(), (Object)e_2);
            }
        }
        URI currentURI = config.eResource().getURI();
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Functions.Function1 _function;
            Iterable pins;
            int _size_3;
            boolean _greaterThan_2;
            boolean _greaterThan_1;
            Collection duplicates = (Collection)entry.getValue();
            Set resources = GpiocfgValidator.getResources(duplicates).asMap().entrySet();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            int _size_1 = resources.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                for (Map.Entry uri : resources) {
                    Collection pinSettings = (Collection)uri.getValue();
                    for (PinSetting d : pinSettings) {
                        if (((URI)uri.getKey()).equals(currentURI) && !acceptor.acceptsExternalResource()) continue;
                        Functions.Function1 _function2 = it -> {
                            boolean _equals = it.eResource().getURI().equals(uri.getKey());
                            return !_equals;
                        };
                        acceptor.collectError(NLS.bind((String)"Function ''{0}'' cannot be used twice on different pins. Already defined in ''{1}''", (Object)d.getConfig().getAlt().getName(), uri.getKey()), (EObject)IterableExtensions.findFirst((Iterable)duplicates, (Functions.Function1)_function2), (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Config(), -1, UNIQUE_FUNCTION_USAGE, new String[0]);
                    }
                }
                continue;
            }
            Set entries = resources;
            int _size_2 = entries.size();
            boolean _equals = _size_2 == 1;
            if (!_equals || !(_greaterThan_2 = (_size_3 = IterableExtensions.size((Iterable)(pins = IterableExtensions.filter((Iterable)duplicates, (Functions.Function1)(_function = it -> it.eResource().getURI().equals(((Map.Entry[])Conversions.unwrapArray((Object)entries, Map.Entry.class))[0].getKey())))))) > 1)) continue;
            for (PinSetting d : pins) {
                URI uri_1 = d.eResource().getURI();
                if (uri_1 != currentURI && !acceptor.acceptsExternalResource()) continue;
                acceptor.collectError(NLS.bind((String)"Function cannot be used twice on different pins: ''{0}''", (Object)d.getConfig().getAlt().getName()), (EObject)d.getConfig(), (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinProperties_Alt(), -1, UNIQUE_FUNCTION_USAGE, new String[0]);
            }
        }
    }

    @Check
    public void checkPinAlreadyUsed(PinConfiguration config) {
        GpiocfgValidator.checkPinAlreadyUsed(config, this.getAcceptor());
    }

    public static void checkPinAlreadyUsed(PinConfiguration config, GpioValidationMessageAcceptor acceptor) {
        Board _board;
        boolean _tripleNotEquals_3;
        HashMultimap multiMap = HashMultimap.create();
        PinSettings settings = config.getPinSetting();
        Functions.Function1 _function = it -> it.getPin().getName();
        List cfgPins = ListExtensions.map(GpioCfgHelper.getPins(settings), (Functions.Function1)_function);
        if (settings != null) {
            boolean _tripleNotEquals_1;
            List<PinSetting> _pins = GpioCfgHelper.getPins(settings);
            for (PinSetting e : _pins) {
                Pin _pin = e.getPin();
                boolean _tripleNotEquals = _pin != null;
                if (!_tripleNotEquals) continue;
                multiMap.put((Object)e.getPin(), (Object)e);
            }
            IncludeBoard _includedBoard = config.getPinSetting().getIncludedBoard();
            boolean bl = _tripleNotEquals_1 = _includedBoard != null;
            if (_tripleNotEquals_1) {
                Board board = GpioCfgHelper.getBoard(config.getPinSetting().getIncludedBoard());
                List<PinSetting> boardSettings = GpioCfgHelper.getPins(board);
                for (PinSetting e_1 : boardSettings) {
                    Pin _pin_1 = e_1.getPin();
                    boolean _tripleNotEquals_2 = _pin_1 != null;
                    if (!_tripleNotEquals_2) continue;
                    multiMap.put((Object)e_1.getPin(), (Object)e_1);
                }
            }
        }
        boolean bl = _tripleNotEquals_3 = (_board = config.getBoard()) != null;
        if (_tripleNotEquals_3) {
            List<PinSetting> boardSettings_1 = GpioCfgHelper.getPins(config.getBoard());
            for (PinSetting e_2 : boardSettings_1) {
                Pin _pin_2 = e_2.getPin();
                boolean _tripleNotEquals_4 = _pin_2 != null;
                if (!_tripleNotEquals_4) continue;
                multiMap.put((Object)e_2.getPin(), (Object)e_2);
            }
        }
        URI currentURI = config.eResource().getURI();
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan_1;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Multimap<URI, PinSetting> resources = GpiocfgValidator.getResources(duplicates);
            int _size_1 = resources.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                Set _entrySet_1 = resources.asMap().entrySet();
                for (Map.Entry uri : _entrySet_1) {
                    Collection pinSettings = (Collection)uri.getValue();
                    for (PinSetting d : pinSettings) {
                        List<String> values = GpiocfgValidator.possibleFunctionLocations(d);
                        if (uri.getKey() == currentURI || acceptor.acceptsExternalResource()) {
                            acceptor.collectWarning(NLS.bind((String)"Pin ''{0}'' cannot be configured twice. Already defined in ''{1}''", (Object)d.getPin().getName(), uri.getKey()), (EObject)d, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
                            continue;
                        }
                        boolean _contains = cfgPins.contains(d.getPin().getName());
                        if (!_contains) continue;
                        Functions.Function1 _function_1 = it -> {
                            boolean _equals = it.eResource().getURI().equals(uri.getKey());
                            return !_equals;
                        };
                        acceptor.collectError(NLS.bind((String)"Pin ''{0}'' cannot be configured twice. Already defined in ''{1}''", (Object)d.getPin().getName(), uri.getKey()), (EObject)IterableExtensions.findFirst((Iterable)duplicates, (Functions.Function1)_function_1), (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
                    }
                }
                continue;
            }
            for (PinSetting d : duplicates) {
                List<String> values = GpiocfgValidator.possibleFunctionLocations(d);
                Resource uri_1 = d.eResource();
                if (uri_1 != currentURI && !acceptor.acceptsExternalResource()) continue;
                acceptor.collectWarning(NLS.bind((String)"Pin ''{0}''cannot be configured twice.", (Object)d.getPin().getName()), (EObject)d.getConfig(), (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), -1, UNIQUE_PIN_USAGE, (String[])Iterables.toArray(values, String.class));
            }
        }
    }

    public static Multimap<URI, PinSetting> getResources(Collection<PinSetting> settings) {
        boolean _greaterThan;
        HashMultimap resources = HashMultimap.create();
        int _size = settings.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (PinSetting d : settings) {
                URI boardUri;
                boolean _equals;
                boolean _not;
                URI pinResourceUri = d.eResource().getURI();
                resources.put((Object)pinResourceUri, (Object)d);
                Board board = GpioCfgHelper.getBoard(d);
                if (board == null || !(_not = !(_equals = (boardUri = board.eResource().getURI()).equals(pinResourceUri)))) continue;
                resources.put((Object)pinResourceUri, (Object)d);
            }
        } else {
            boolean _greaterThan_1;
            int _size_1 = settings.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                PinSetting d_1 = ((PinSetting[])Conversions.unwrapArray(settings, PinSetting.class))[0];
                resources.put((Object)d_1.eResource().getURI(), (Object)d_1);
            }
        }
        return resources;
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        this.getChain().add(this.createDiagnostic(Severity.ERROR, message, object, feature, -1, code, issueData));
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature, String code, String ... issueData) {
        this.getChain().add(this.createDiagnostic(Severity.WARNING, message, object, feature, -1, code, issueData));
    }

    @Check
    public void checkPinConfig(PinConfiguration config) {
        GpiocfgValidator.checkPinConfig(config, this.getAcceptor());
    }

    public static void checkPinConfig(PinConfiguration config, GpioValidationMessageAcceptor acceptor) {
        boolean _tripleNotEquals;
        HashMultimap multiMap = HashMultimap.create();
        List<PinSetting> pinsList = null;
        PinSettings _pinSetting = config.getPinSetting();
        boolean bl = _tripleNotEquals = _pinSetting != null;
        if (_tripleNotEquals) {
            pinsList = GpioCfgHelper.getPins(config.getPinSetting());
        } else {
            boolean _tripleNotEquals_1;
            Board _board = config.getBoard();
            boolean bl2 = _tripleNotEquals_1 = _board != null;
            if (_tripleNotEquals_1) {
                pinsList = GpioCfgHelper.getPins(config.getBoard());
            }
        }
        for (PinSetting e : pinsList) {
            if (e.getPin() == null || e.getPin().getName() == null) continue;
            multiMap.put((Object)e.getPin().getName(), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                String _name = d.getPin().getName();
                String _plus = "Duplicated pin configuration: " + _name;
                acceptor.collectWarning(_plus, (EObject)d, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), -1, DUPLICATED_PINCONFIG, new String[0]);
            }
        }
    }

    @Check
    public void checkPinFunction(PinProperties config) {
    }

    @Check
    public void checkPinFunction(PinSetting setting) {
    }

    @Check
    public void checkPinConnected(PinSetting setting) {
        try {
            boolean _tripleNotEquals;
            Pin _pin = setting.getPin();
            boolean bl = _tripleNotEquals = _pin != null;
            if (_tripleNotEquals) {
                EList _pinConfigurations = setting.getPin().getPinConfigurations();
                for (PinConfig pinConfig : _pinConfigurations) {
                    if (!(pinConfig instanceof NotConnectedPin)) continue;
                    String message = NLS.bind((String)"Pin ''{0}'' is not connected", (Object)setting.getPin().getName());
                    this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), NOTCONNECTED_PIN, new String[0]);
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                InputOutput.println((Object)e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkPinSpecial(PinSetting setting) {
        boolean _tripleNotEquals;
        Pin _pin = setting.getPin();
        boolean bl = _tripleNotEquals = _pin != null;
        if (_tripleNotEquals) {
            EList _pinConfigurations = setting.getPin().getPinConfigurations();
            for (PinConfig pinConfig : _pinConfigurations) {
                if (setting.getPin() == null || setting.getPin().getPinConfigurations() == null || !(pinConfig instanceof SpecialPin)) continue;
                String message = NLS.bind((String)"Pin ''{0}'' is not configurable", (Object)setting.getPin().getName());
                this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), SPECIAL_PIN, new String[0]);
            }
        }
    }

    @Check
    public void checkPinSystemFunction(PinSetting setting) {
        boolean _tripleNotEquals;
        Pin _pin = setting.getPin();
        boolean bl = _tripleNotEquals = _pin != null;
        if (_tripleNotEquals) {
            EList _pinConfigurations = setting.getPin().getPinConfigurations();
            for (PinConfig pinConfig : _pinConfigurations) {
                if (!(pinConfig instanceof SystemFunctionPin)) continue;
                String message = NLS.bind((String)"Pin ''{0}'' is not configurable", (Object)setting.getPin().getName());
                this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSetting_Pin(), SYSTEMFUNCTION_PIN, new String[0]);
            }
        }
    }

    @Check
    public void checkPinDirection(PinProperties config) {
        EObject _eContainer = config.eContainer();
        PinSetting setting = (PinSetting)_eContainer;
        Function fct = setting.getConfig().getAlt();
        com.st.stellar.pinmap.gpioCfg.Direction direction = setting.getConfig().getDirection();
        if (fct != null) {
            boolean _tripleNotEquals;
            QualifiedName fctName = this.qnprovider.getFullyQualifiedName((EObject)fct);
            Pin _pin = setting.getPin();
            boolean bl = _tripleNotEquals = _pin != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function = it -> it instanceof ConfigurablePin;
                Iterable _filter = IterableExtensions.filter((Iterable)setting.getPin().getPinConfigurations(), (Functions.Function1)_function);
                for (PinConfig pinConfig : _filter) {
                    Functions.Function1 _function_2;
                    Configuration ref = ((ConfigurablePin)pinConfig).getRef();
                    Functions.Function1 _function_1 = it -> this.qnprovider.getFullyQualifiedName((EObject)it.getName()).equals((Object)fctName);
                    Iterable functionNames = IterableExtensions.filter((Iterable)ref.getFunctions(), (Functions.Function1)_function_1);
                    Iterable functions = IterableExtensions.filter((Iterable)functionNames, (Functions.Function1)(_function_2 = it -> GpiocfgValidator.directionsAreCompatible(it.getName(), it.getDirection(), setting.getConfig().getDirection())));
                    int _size = IterableExtensions.size((Iterable)functions);
                    boolean _lessThan = _size < 1;
                    if (!_lessThan) continue;
                    String message = NLS.bind((String)"Cannot set function ''{0}'' in ''{1}''", (Object)fct.getName(), (Object)direction.getName());
                    ArrayList<String> validDirections = GpioCfgHelper.getDirections(setting);
                    this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinProperties_Direction(), WRONG_DIRECTION, (String[])Iterables.toArray(validDirections, String.class));
                }
            }
        }
    }

    @Check
    public void checkOutputFolder(PinSettings settings) {
        String outputfolder = settings.getOutputFolder();
        if (outputfolder != null && outputfolder.contains("..")) {
            this.error("Relative path not allowed.", settings, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSettings_OutputFolder(), INVALID_OUTPUTFOLDER, new String[0]);
        }
    }

    @Check
    public void checkImports(PinSettings ps) {
        Board board = GpioCfgHelper.getBoard(ps.getIncludedBoard());
        if (board == null) {
            String message = NLS.bind((String)"Cannot import URI ''{0}''", (Object)ps.getIncludedBoard().getImportURI());
            this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
        }
    }

    @Check
    public void checkImports(Board board) {
        Include inc = board.getIncludes();
        if (inc != null && inc.getImportURI() != null) {
            EObject config = board.eContainer();
            Resource resource = config.eResource();
            Resource r = GpioCfgHelper.getResource(resource, inc.getImportURI());
            if (r != null && !r.getContents().isEmpty()) {
                EcoreUtil.resolveAll((Resource)r);
                EList _errors = r.getErrors();
                for (Resource.Diagnostic error : _errors) {
                    String _message = error.getMessage();
                    String _plus = "This URI contains the following error: " + _message;
                    this.error(_plus, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getBoard_Includes(), BAD_URI, null);
                }
            } else {
                String message = NLS.bind((String)"Cannot load URI ''{0}''", (Object)inc.getImportURI());
                this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
            }
        }
    }

    @Check
    public void checkPinSettings(PinSettings setting) {
        IncludeBoard inc = setting.getIncludedBoard();
        if (inc != null && inc.getImportURI() != null) {
            Resource resource = setting.eResource();
            Resource r = GpioCfgHelper.getResource(resource, inc.getImportURI());
            if (r != null && !r.getContents().isEmpty()) {
                EcoreUtil.resolveAll((Resource)r);
                EList _errors = r.getErrors();
                for (Resource.Diagnostic error : _errors) {
                    String _message = error.getMessage();
                    String _plus = "This URI contains the following error: " + _message;
                    this.error(_plus, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSettings_IncludedBoard(), BAD_URI, null);
                }
            } else {
                String message = NLS.bind((String)"Cannot load URI ''{0}''", (Object)inc.getImportURI());
                this.error(message, (EStructuralFeature)GpioCfgPackage.eINSTANCE.getPinSettings_Name(), BAD_URI, null);
            }
        }
    }

    @XbaseGenerated
    public void checkFieldInstanceValues(EObject fieldType, FieldInstance instance) {
        if (fieldType instanceof IOFields) {
            this._checkFieldInstanceValues((IOFields)fieldType, instance);
            return;
        }
        if (fieldType != null) {
            this._checkFieldInstanceValues(fieldType, instance);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fieldType, instance).toString());
    }
}

