/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.codeGenerator.runtime;

import com.google.inject.Inject;
import com.st.stellar.pinmap.generator.GeneratePinmapView;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GeneratePinSettings {
    private final GeneratePinmapView genPinmapView = new GeneratePinmapView();
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    private StringBuilder errors;
    private StringBuilder warnings;

    public CharSequence generate(PinSettings a) {
        return this.generateContent(a);
    }

    public CharSequence generateContent(PinSettings settings) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<PackageInstance refId=\"");
        String _refId = this.getRefId((EObject)settings);
        _builder.append(_refId);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("<Configurables>");
        _builder.newLine();
        List _allPinSettings = PinCfgHelper.getAllPinSettings((PinSettings)settings);
        for (PinSetting pin : _allPinSettings) {
            _builder.append("\t");
            Object _generateConfigurables = this.generateConfigurables(pin);
            _builder.append(_generateConfigurables, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("</Configurables>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</PackageInstance>");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        return _builder;
    }

    protected String _getRefId(PinSettings settings) {
        String _xblockexpression = null;
        Board incBoard = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard());
        EObject _eContainer = incBoard.getPackage().eContainer();
        String n = ((Family)_eContainer).getName();
        n = n.replaceAll("x", incBoard.getPackage().getName());
        int a = n.indexOf("_");
        _xblockexpression = n = n.substring(0, a);
        return _xblockexpression;
    }

    protected String _getRefId(PinSetting setting) {
        return this.getRefId((EObject)setting.getPad());
    }

    protected String _getRefId(ConfigurablePin pin) {
        Configuration _ref;
        String _xblockexpression = null;
        Configuration cfg = _ref = pin.getRef();
        _xblockexpression = cfg.getName();
        return _xblockexpression;
    }

    public Object generateConfigurables(PinSetting setting) {
        return null;
    }

    public GeneratePinSettings() {
        StringBuilder _stringBuilder_1;
        StringBuilder _stringBuilder;
        this.errors = _stringBuilder = new StringBuilder("errors:\n");
        this.warnings = _stringBuilder_1 = new StringBuilder("warnings:\n");
    }

    public StringBuilder error(String message) {
        return this.errors.append("error: " + message + "\n");
    }

    public StringBuilder warning(String message) {
        return this.warnings.append("warning: " + message + "\n");
    }

    public StringBuilder generateReport() {
        return this.errors.append((CharSequence)this.warnings);
    }

    public int getPortNb(String s) {
        int portNb;
        int _xblockexpression = 0;
        char subString = s.charAt(1);
        int port = Character.getNumericValue(subString);
        int begin = Character.getNumericValue('A');
        _xblockexpression = portNb = port - begin;
        return _xblockexpression;
    }

    public int getBit(String s) {
        int _xblockexpression = 0;
        String subString = s.substring(2, s.length());
        _xblockexpression = Integer.parseInt(subString);
        return _xblockexpression;
    }

    private static CharSequence script() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<script type=\"text/javascript\">");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("var svg = null;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("function init() {");
        _builder.newLine();
        _builder.append("\t\t  \t\t  \t");
        _builder.append("svg = document.getElementById('svg-doc');");
        _builder.newLine();
        _builder.append("//\t\t  \t\t    console.log(svg);");
        _builder.newLine();
        _builder.append("\t\t  \t\t  \t");
        _builder.newLine();
        _builder.append("\t\t  \t\t  \t");
        _builder.append("var size = getSVGSize();");
        _builder.newLine();
        _builder.append("\t\t  \t\t      ");
        _builder.append("console.log(size);");
        _builder.newLine();
        _builder.append("\t\t  \t\t  ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t  \t");
        _builder.append("function getSVGSize() {");
        _builder.newLine();
        _builder.append("\t\t  \t");
        _builder.append("var svgDoc = svg;//document.getElementById('wizard-svg');");
        _builder.newLine();
        _builder.append("\t\t  \t");
        _builder.append("if( svgDoc ) {");
        _builder.newLine();
        _builder.append("\t\t  \t\t");
        _builder.append("var width = svgDoc.getAttribute('width');");
        _builder.newLine();
        _builder.append("\t\t  \t\t");
        _builder.append("var height = svgDoc.getAttribute('height');");
        _builder.newLine();
        _builder.append("\t\t  \t\t");
        _builder.append("res = '<'+width+','+height+'>';");
        _builder.newLine();
        _builder.append("\t\t  \t\t");
        _builder.append("return res;");
        _builder.newLine();
        _builder.append("\t\t  \t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t  \t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t  \t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("function comboInit(thelist)");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("theinput = document.getElementById('theinput');  ");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("var idx = thelist.selectedIndex;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("var content = thelist.options[idx].innercode;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("if(theinput) {");
        _builder.newLine();
        _builder.append("\t\t      ");
        _builder.append("theinput.value = content;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("var wizIntDisplayOff = function(elem) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (elem) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = svg.getElementById(elem);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (elt) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elt.style.display = \"none\";");
        _builder.newLine();
        _builder.append("//\t\t\tconsole.log(elt+' off')");
        _builder.newLine();
        _builder.append("//\t\t} else {");
        _builder.newLine();
        _builder.append("//\t\t\talert(\"wizIntDisplayOff: please provide a valid element id (\"");
        _builder.newLine();
        _builder.append("//\t\t\t\t\t+ elem + \" does not exist)\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var wizIntDisplayOn = function(elem) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (elem) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = svg.getElementById(elem);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (elt) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elt.style.display = \"inline\";");
        _builder.newLine();
        _builder.append("//\t\t\tconsole.log(elt+' on')");
        _builder.newLine();
        _builder.append("//\t\t} else {");
        _builder.newLine();
        _builder.append("//\t\t\talert(\"wizIntDisplayOn: please provide a valid element id (\" + elem");
        _builder.newLine();
        _builder.append("//\t\t\t\t\t+ \" does not exist)\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("function combo(thelist, theinput)");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(window.old) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("console.log('from: '+window.old);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("wizIntDisplayOff('peripheral_layer_'+old)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("wizIntDisplayOff('main_layer')");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("theinput = document.getElementById(theinput);  ");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("var idx = thelist.selectedIndex;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("var content = thelist.options[idx].innercode;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("if(theinput) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("theinput.value = content;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("window.old = content;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("window.old = content;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("console.log('to: '+content);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("wizIntDisplayOn('main_layer')");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("wizIntDisplayOn('peripheral_layer_'+content)");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("</script>");
        _builder.newLine();
        return _builder;
    }

    public String generateView(PinSettings settings) {
        String fileContent;
        String _xblockexpression = null;
        Board incBoard = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard());
        Object pins = "";
        EList _allModules = PinCfgHelper.getAllModules((PinSettings)settings);
        for (Module mod : _allModules) {
            EList _pins = mod.getPins();
            Iterator iterator = _pins.iterator();
            while (iterator.hasNext()) {
                PinSetting pin = (PinSetting)iterator.next();
                Iterator _pins_1 = pins;
                String _generatePin = this.generatePin(pin, incBoard.getPackage());
                pins = (String)((Object)_pins_1) + _generatePin;
            }
        }
        ArrayList<String> peripherals = new ArrayList<String>();
        EList _pins_2 = incBoard.getPackage().getPins();
        for (Pin pin_1 : _pins_2) {
            EList _pinConfigurations = pin_1.getPinConfigurations();
            for (PinConfig cfg : _pinConfigurations) {
                if (!(cfg instanceof ConfigurablePin)) continue;
                ConfigurablePin cp = (ConfigurablePin)cfg;
                EList _functions = cp.getRef().getFunctions();
                for (FunctionRef fct : _functions) {
                    boolean _contains = peripherals.contains(fct.getName().getPeripheralRef().getLabel());
                    boolean _not = !_contains;
                    if (!_not) continue;
                    String _label = fct.getName().getPeripheralRef().getLabel();
                    peripherals.add(_label);
                }
            }
        }
        String pinmapView = this.genPinmapView.generatePackage(incBoard.getPackage(), (String)pins);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<label>Show pins for peripheral <select name=\"thelist\" onChange=\"combo(this, 'theinput')\" onMouseOut=\"comboInit(this, 'theinput')\" ></label>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<option></option>");
        _builder.newLine();
        List _sort = IterableExtensions.sort(peripherals);
        for (String p : _sort) {
            _builder.append("\t\t");
            _builder.append("<option>");
            _builder.append(p, "\t\t");
            _builder.append("</option>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("</select>");
        String peripheralCombo = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<!DOCTYPE code>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<code lang=\"en\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.newLine();
        _builder_1.append("\t\t  ");
        _builder_1.append("</head>");
        _builder_1.newLine();
        _builder_1.append("\t\t    ");
        _builder_1.append("<title>");
        String _name = settings.getName();
        _builder_1.append(_name, "\t\t    ");
        _builder_1.append("</title>");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t  ");
        _builder_1.append("</head>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.newLine();
        _builder_1.append("\t\t  ");
        _builder_1.append("<body onload=\"init();\">");
        _builder_1.newLine();
        _builder_1.append("\t\t  ");
        _builder_1.append("<div id=\"tooltip\" display=\"none\" style=\"position: absolute; display: none;\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t  ");
        _builder_1.append(peripheralCombo, "\t\t  ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t  ");
        _builder_1.append(pinmapView, "\t\t  ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t  ");
        CharSequence _script = GeneratePinSettings.script();
        _builder_1.append((Object)_script, "\t\t  ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t  ");
        _builder_1.append("</body>");
        _builder_1.newLine();
        _builder_1.append("\t\t  ");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</code>");
        _xblockexpression = fileContent = _builder_1.toString();
        return _xblockexpression;
    }

    public String generatePin(PinSetting pinSetting, Package p) {
        String _xblockexpression = null;
        Utils util = Utils.instance;
        Configuration pad = pinSetting.getPad();
        this._pinCfgHelper = PinCfgHelper.instance;
        int x = this.genPinmapView.getX(p, pad);
        int y = this.genPinmapView.getY(p, pad);
        String color = "black";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<foreignObject class=\"node\"><div>");
        Object tooltip = _builder.toString();
        String _oltip = tooltip;
        String _name = pinSetting.getName();
        String _plus = _name + "<br/>";
        Object _oltip_1 = tooltip = _oltip + _plus;
        Direction _direction = pinSetting.getConfig().getDirection();
        String _plus_1 = "Direction: " + String.valueOf(_direction);
        String _plus_2 = _plus_1 + "<br/>";
        tooltip = (String)_oltip_1 + _plus_2;
        this._pinCfgHelper = PinCfgHelper.instance;
        Object _oltip_2 = tooltip;
        String _functionName = this._pinCfgHelper.getFunctionName(pinSetting);
        String _plus_3 = "Function: " + _functionName;
        Object _oltip_3 = tooltip = (String)_oltip_2 + _plus_3;
        String _mscrIndex = this._pinCfgHelper.getMscrIndex(pinSetting);
        String _plus_4 = " (" + _mscrIndex;
        String _plus_5 = _plus_4 + "_";
        String _mscrSSS = this._pinCfgHelper.getMscrSSS(pinSetting);
        String _plus_6 = _plus_5 + _mscrSSS;
        String _plus_7 = _plus_6 + ")";
        String _plus_8 = _plus_7 + "<br/>";
        Object _oltip_4 = tooltip = (String)_oltip_3 + _plus_8;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</div></foreignObject>");
        tooltip = (String)_oltip_4 + String.valueOf(_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("<g transform=\"translate(");
        Objects.requireNonNull(this.genPinmapView);
        Objects.requireNonNull(this.genPinmapView);
        _builder_2.append((Object)(x * (40 + 3)));
        _builder_2.append(", ");
        Objects.requireNonNull(this.genPinmapView);
        Objects.requireNonNull(this.genPinmapView);
        _builder_2.append((Object)((y + 1) * (40 + 3)));
        _builder_2.append(")\" >");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("        ");
        _builder_2.append("<circle class=\"pin\" fill=\"#00FF00\" stroke=\"");
        _builder_2.append(color, "        ");
        _builder_2.append("\" stroke-width=\"0.5px\" r=\"");
        Objects.requireNonNull(this.genPinmapView);
        _builder_2.append((Object)(40 / 2), "        ");
        _builder_2.append("\"/>");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("   \t\t");
        _builder_2.append("<title>");
        _builder_2.append((String)tooltip, "   \t\t");
        _builder_2.append("</title>");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("        ");
        _builder_2.append("<text x=\"0\" y=\"");
        _builder_2.append((Object)(this.genPinmapView.fontSize / 2), "        ");
        _builder_2.append("\" style=\"font-variant:normal;font-weight:normal;font-size:");
        _builder_2.append((Object)this.genPinmapView.fontSize, "        ");
        _builder_2.append("px;font-family:Helvetica;-inkscape-font-specification:Helvetica;writing-mode:lr-tb;fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\" stroke=\"");
        _builder_2.append(color, "        ");
        _builder_2.append("\" text-anchor=\"middle\" alignment-baseline=\"middle\">");
        String _truncatedPad = util.getTruncatedPad(pad);
        _builder_2.append(_truncatedPad, "        ");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("        ");
        _builder_2.append("</text>");
        _builder_2.newLine();
        _builder_2.append("        ");
        _builder_2.append("<title>");
        _builder_2.append((String)tooltip, "        ");
        _builder_2.append("</title>");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("      ");
        _builder_2.append("</g>");
        _xblockexpression = _builder_2.toString();
        return _xblockexpression;
    }

    @XbaseGenerated
    public String getRefId(EObject pin) {
        if (pin instanceof ConfigurablePin) {
            return this._getRefId((ConfigurablePin)pin);
        }
        if (pin instanceof PinSetting) {
            return this._getRefId((PinSetting)pin);
        }
        if (pin instanceof PinSettings) {
            return this._getRefId((PinSettings)pin);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pin).toString());
    }
}

