/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.codeGenerator.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.LatchedState;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.framework.Bundle;

public class PinCfgCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    private static int pageWidth = 80;
    private static String PINMAPCFG_BUNDLE_ID = "com.st.stellar.pinmap.pincfg";

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        ResourceSet resourceSet = (ResourceSet)this.rsp.get();
        Resource r = resourceSet.getResource(resource.getURI(), true);
        boolean _isEmpty = r.getContents().isEmpty();
        if (_isEmpty) {
            return;
        }
        EObject head = (EObject)IterableExtensions.head((Iterable)r.getContents());
        PinConfiguration cfg = (PinConfiguration)head;
        PinSettings _pinSetting = cfg.getPinSetting();
        if (_pinSetting instanceof PinSettings) {
            boolean _tripleNotEquals;
            PinSettings pinSettings = cfg.getPinSetting();
            Object outputFolder = "";
            String _outputFolder = pinSettings.getOutputFolder();
            boolean bl = _tripleNotEquals = _outputFolder != null;
            if (_tripleNotEquals) {
                String _outputFolder_1 = pinSettings.getOutputFolder();
                String _plus = "../" + _outputFolder_1;
                String _plus_1 = _plus + "/";
                outputFolder = _plus_1;
            } else if (fsa instanceof JavaIoFileSystemAccess) {
                JavaIoFileSystemAccess fsa2 = (JavaIoFileSystemAccess)fsa;
                OutputConfiguration outputCfg = (OutputConfiguration)fsa2.getOutputConfigurations().get("PinCfgCode");
                String _outputDirectory = outputCfg.getOutputDirectory();
                String _plus_2 = _outputDirectory + "/";
                outputFolder = _plus_2;
                outputFolder = "../" + (String)outputFolder;
            } else {
                outputFolder = "./src-gen/";
                outputFolder = "../" + (String)outputFolder;
            }
            String bootheader = this.generatePinSettings(pinSettings);
            String _name = pinSettings.getName();
            String _plus_3 = (String)outputFolder + _name;
            String _plus_4 = _plus_3 + ".h";
            fsa.generateFile(_plus_4, "DEFAULT_OUTPUT", (CharSequence)bootheader);
        }
    }

    public static String getVersion() {
        String _xifexpression = null;
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            String _xblockexpression = null;
            Bundle ideBundle = Platform.getBundle((String)PINMAPCFG_BUNDLE_ID);
            _xifexpression = _xblockexpression = ideBundle.getVersion().toString();
        } else {
            _xifexpression = PinCfgHelper.PINCFG_VERSION;
        }
        return _xifexpression;
    }

    public static String getPluginName() {
        String _xifexpression = null;
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            String _xblockexpression = null;
            Bundle ideBundle = Platform.getBundle((String)PINMAPCFG_BUNDLE_ID);
            _xifexpression = _xblockexpression = ideBundle.getSymbolicName();
        } else {
            _xifexpression = PINMAPCFG_BUNDLE_ID;
        }
        return _xifexpression;
    }

    public String generatePinSettings(PinSettings pinSettings) {
        String _xblockexpression = null;
        EcoreUtil.resolveAll((Resource)pinSettings.eResource());
        ArrayList<PinSetting> writtenPins = new ArrayList<PinSetting>();
        EObject _eContainer = pinSettings.eContainer();
        EObject _eContainer_1 = this._pinCfgHelper.getFamily((PinConfiguration)_eContainer).eContainer();
        String boardName = ((PinmapModel)_eContainer_1).getName();
        int _lastIndexOf = boardName.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        boardName = boardName.substring(_plus);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2024-2026 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,");
        _builder.newLine();
        _builder.append("* USING ");
        String _pluginName = PinCfgCodeGenerator.getPluginName();
        _builder.append(_pluginName);
        _builder.append(", Version ");
        String _string = PinCfgCodeGenerator.getVersion().toString();
        _builder.append(_string);
        _builder.newLineIfNotEmpty();
        _builder.append("* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file    ");
        String _lowerCase = pinSettings.getName().toLowerCase(Locale.US);
        _builder.append(_lowerCase, " ");
        _builder.append(".h");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @brief   ");
        String _lowerCase_1 = pinSettings.getName().toLowerCase(Locale.US);
        _builder.append(_lowerCase_1, " ");
        _builder.append(" board header.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @defgroup PLATFORM PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @defgroup BOARD BOARD");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @ingroup PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup ");
        String _familyLabel = this._pinCfgHelper.getFamilyLabel(pinSettings);
        _builder.append(_familyLabel, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @ingroup BOARD");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifndef _");
        String _upperCase = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_1);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define ");
        String _upperCase_2 = PinCfgHelper.getBoard((PinSettings)pinSettings).getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_2);
        _builder.append(" 1");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <siul2.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Board defines.                                                            */");
        _builder.newLine();
        String _familyDescriptionComment = this.getFamilyDescriptionComment(pinSettings);
        _builder.append(_familyDescriptionComment);
        _builder.newLineIfNotEmpty();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define ");
        String _upperCase_3 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_3);
        _builder.append(" 1");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _allModules = PinCfgHelper.getAllModules((PinSettings)pinSettings);
        for (Module mod : _allModules) {
            boolean _tripleEquals;
            String _comment = mod.getComment();
            boolean bl = _tripleEquals = _comment == null;
            if (_tripleEquals) {
                _builder.append("/*--------------------- ");
                String _name = mod.getName().getName();
                _builder.append(_name);
                _builder.append(" pins definitions ---------------------*/");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("/*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* ");
                String _comment_1 = mod.getComment();
                _builder.append(_comment_1, " ");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
            }
            EList _pins = mod.getPins();
            for (Object pin : _pins) {
                Functions.Function1 _function = arg_0 -> PinCfgCodeGenerator.lambda$generatePinSettings$0((PinSetting)pin, arg_0);
                int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(writtenPins, (Functions.Function1)_function));
                boolean _equals = _size == 0;
                if (!_equals) continue;
                boolean addRes = writtenPins.add((PinSetting)pin);
                _builder.newLineIfNotEmpty();
                boolean _startsWith = pin.getConfig().getAlt().getLabel().startsWith("EIRQ");
                if (_startsWith) {
                    _builder.append("#define ");
                    String _upper = this.toUpper((PinSetting)pin);
                    _builder.append(_upper);
                    _builder.append("_NUMBER          SIUL2_");
                    String _label = pin.getConfig().getAlt().getLabel();
                    _builder.append(_label);
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("/* ");
                String _padName = this.getPadName((PinSetting)pin);
                _builder.append(_padName);
                _builder.append(" - MSCR_IO");
                String _mscrIndex = this._pinCfgHelper.getMscrIndex((PinSetting)pin);
                _builder.append(_mscrIndex);
                _builder.append(" */");
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _upper_1 = this.toUpper((PinSetting)pin);
                _builder.append(_upper_1);
                _builder.append(" siul2_iopack(");
                String _portName = this.getPortName((PinSetting)pin);
                _builder.append(_portName);
                _builder.append(", ");
                String _pinPad = this.getPinPad((PinSetting)pin);
                _builder.append(_pinPad);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                String _iODefinitions = this.getIODefinitions((PinSetting)pin);
                _builder.append(_iODefinitions);
                _builder.newLineIfNotEmpty();
                boolean _isIsSetLatchedState = pin.isIsSetLatchedState();
                if (_isIsSetLatchedState) {
                    _builder.append("#define ");
                    String _upper_2 = this.toUpper((PinSetting)pin);
                    _builder.append(_upper_2);
                    _builder.append("_LATCHED_STATE\t\t");
                    String _xifexpression = null;
                    LatchedState _latchedState = pin.getLatchedState();
                    boolean _equals_1 = Objects.equals(_latchedState, LatchedState.HIGH);
                    _xifexpression = _equals_1 ? "SIUL2_IO_HIGH" : "SIUL2_IO_LOW";
                    _builder.append(_xifexpression);
                    _builder.newLineIfNotEmpty();
                }
                String _muxDefinition = this.getMuxDefinition((PinSetting)pin);
                _builder.append(_muxDefinition);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.newLine();
            }
        }
        String fieldStr1 = _builder.toString();
        ArrayList _arrayList = new ArrayList();
        writtenPins = _arrayList;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/*===========================================================================*/");
        _builder_1.newLine();
        _builder_1.append("/* External declarations.                                                    */");
        _builder_1.newLine();
        _builder_1.append("/*===========================================================================*/");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("#ifdef __cplusplus");
        _builder_1.newLine();
        _builder_1.append("extern \"C\" {");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("#define ");
        String _name_1 = pinSettings.getName();
        _builder_1.append(_name_1);
        _builder_1.append("_init() \\");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("    ");
        _builder_1.append("do {                                                                      \\");
        _builder_1.newLine();
        EList _allModules_1 = PinCfgHelper.getAllModules((PinSettings)pinSettings);
        for (Module mod_1 : _allModules_1) {
            _builder_1.append("\t");
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("/* ");
            String _name_2 = mod_1.getName().getName();
            _builder_2.append(_name_2);
            _builder_2.append(" */");
            String comment = _builder_2.toString();
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("    ");
            _builder_1.append(comment, "\t    ");
            int _max = Math.max(comment.length(), 1);
            int _minus = pageWidth - _max;
            int _minus_1 = _minus - 10;
            String _repeat = " ".repeat(_minus_1);
            _builder_1.append(_repeat, "\t    ");
            _builder_1.append("\\");
            _builder_1.newLineIfNotEmpty();
            EList _pins_1 = mod_1.getPins();
            for (PinSetting pin_1 : _pins_1) {
                Functions.Function1 _function_1 = it -> it.getName().equals(pin_1.getName());
                int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter(writtenPins, (Functions.Function1)_function_1));
                boolean _equals_2 = _size_1 == 0;
                if (!_equals_2) continue;
                _builder_1.append("\t");
                boolean addRes_1 = writtenPins.add(pin_1);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("    ");
                _builder_3.append("siul2_set_iomode(");
                String _upper_3 = this.toUpper(pin_1);
                _builder_3.append(_upper_3, "    ");
                _builder_3.append(", ");
                String _upper_4 = this.toUpper(pin_1);
                _builder_3.append(_upper_4, "    ");
                _builder_3.append("_CFG);");
                String ioMode = _builder_3.toString();
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                int _length = ioMode.length();
                int _minus_2 = pageWidth - _length;
                int ioSpaces = _minus_2 - 6;
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append(ioMode, "\t");
                String _repeat_1 = " ".repeat(Math.max(ioSpaces, 1));
                _builder_1.append(_repeat_1, "\t");
                _builder_1.append("\\");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("    ");
                _builder_4.append("siul2_set_muxmode(");
                String _upper_5 = this.toUpper(pin_1);
                _builder_4.append(_upper_5, "    ");
                _builder_4.append("_IOMUX, ");
                String _upper_6 = this.toUpper(pin_1);
                _builder_4.append(_upper_6, "    ");
                _builder_4.append("_IOMUX_CFG);");
                String muxMode = _builder_4.toString();
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                int _length_1 = muxMode.length();
                int _minus_3 = pageWidth - _length_1;
                int muxSpaces = _minus_3 - 6;
                _builder_1.newLineIfNotEmpty();
                if (this._pinCfgHelper.hasMUX(pin_1) && this._pinCfgHelper.getFunctionRefMux(pin_1) != null) {
                    _builder_1.append("\t");
                    _builder_1.append(muxMode, "\t");
                    String _repeat_2 = " ".repeat(Math.max(muxSpaces, 1));
                    _builder_1.append(_repeat_2, "\t");
                    _builder_1.append("\\");
                    _builder_1.newLineIfNotEmpty();
                }
                _builder_1.append("\t");
                String _xifexpression_1 = null;
                boolean _isIsSetLatchedState_1 = pin_1.isIsSetLatchedState();
                if (_isIsSetLatchedState_1) {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("    ");
                    _builder_5.append("siul2_iowrite(");
                    String _upper_7 = this.toUpper(pin_1);
                    _builder_5.append(_upper_7, "    ");
                    _builder_5.append(", ");
                    String _upper_8 = this.toUpper(pin_1);
                    _builder_5.append(_upper_8, "    ");
                    _builder_5.append("_LATCHED_STATE);");
                    _xifexpression_1 = _builder_5.toString();
                } else {
                    _xifexpression_1 = "";
                }
                String latchedState = _xifexpression_1;
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                int _length_2 = latchedState.length();
                int _minus_4 = pageWidth - _length_2;
                int latchedSpaces = _minus_4 - 6;
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append(latchedState, "\t");
                String _repeat_3 = " ".repeat(Math.max(latchedSpaces, 1));
                _builder_1.append(_repeat_3, "\t");
                _builder_1.append("\\");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                String _repeat_4 = " ".repeat(pageWidth - 6);
                _builder_1.append(_repeat_4, "\t");
                _builder_1.append("\\");
                _builder_1.newLineIfNotEmpty();
            }
        }
        _builder_1.append("\t");
        _builder_1.append("} while (0)");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.newLine();
        _builder_1.append("#ifdef __cplusplus");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("#endif /* _");
        String _upperCase_4 = pinSettings.getName().toUpperCase(Locale.US);
        _builder_1.append(_upperCase_4);
        _builder_1.append("_H_ */");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        _builder_1.append("/** @} */");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.newLine();
        String fieldStr2 = _builder_1.toString();
        _xblockexpression = fieldStr1 + fieldStr2;
        return _xblockexpression;
    }

    public String toUpper(PinSetting ps) {
        return ps.getName().toUpperCase(Locale.US);
    }

    public String getFamilyDescriptionComment(PinSettings ps) {
        boolean _greaterThan;
        String _xblockexpression = null;
        StringBuffer sb = new StringBuffer();
        String desc = this._pinCfgHelper.getFamilyDescription(ps);
        int _length = desc.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            String[] _split;
            sb.append("/*                                                                           */\n");
            for (String line : _split = desc.split("\n")) {
                boolean _greaterThan_1;
                String l = line.trim().replaceAll("\n", "");
                String _xifexpression = null;
                int _length_1 = l.length();
                boolean bl2 = _greaterThan_1 = _length_1 > 73;
                if (_greaterThan_1) {
                    _xifexpression = "";
                } else {
                    int _length_2 = l.length();
                    int _minus = 73 - _length_2;
                    _xifexpression = " ".repeat(_minus);
                }
                String _plus = "/* " + l + _xifexpression;
                String _plus_1 = _plus + " */\n";
                sb.append(_plus_1);
            }
            sb.append("/*                                                                           */\n");
        }
        _xblockexpression = sb.toString();
        return _xblockexpression;
    }

    public String getIODefinitions(PinSetting ps) {
        String _xblockexpression = null;
        String ioDef = "";
        int _length = this.toUpper(ps).length();
        int _minus = pageWidth - _length;
        int _length_1 = "_CFG".length();
        int _minus_1 = _minus - _length_1;
        int _length_2 = "#define ".length();
        int _minus_2 = _minus_1 - _length_2;
        int spaces = _minus_2 - 2;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("#define ");
        String _upper = this.toUpper(ps);
        _builder.append(_upper);
        _builder.append("_CFG");
        String _repeat = " ".repeat(spaces);
        _builder.append(_repeat);
        _builder.append("\\");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* ");
        String _iOHex = this._pinCfgHelper.toIOHex(ps.getConfig());
        _builder.append(_iOHex, "\t");
        _builder.append(" : ");
        String _IOValues = this._pinCfgHelper.IOValues(ps.getConfig());
        _builder.append(_IOValues, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = ioDef = _builder.toString();
        return _xblockexpression;
    }

    public boolean isMUX(PinSetting ps) {
        boolean _xblockexpression = false;
        FunctionRef funcRef = this._pinCfgHelper.getFunctionRef(ps);
        if (funcRef != null && funcRef.getAlt() != null && funcRef.getAlt().getRef() != null && funcRef.getAlt().getInput() == null && funcRef.getAlt().getInputOutput() == null && funcRef.getAlt().getOutput() == null) {
            int _sss = funcRef.getAlt().getSss();
            return _sss > 511;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public String getMuxDefinition(PinSetting ps) {
        String _xblockexpression = null;
        String muxDef = "";
        boolean _isMUX = this.isMUX(ps);
        if (_isMUX) {
            FunctionRef funcRef = this._pinCfgHelper.getFunctionRef(ps);
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            _builder.append("#define ");
            String _upper = this.toUpper(ps);
            _builder.append(_upper);
            _builder.append("_IOMUX              ");
            int _index = funcRef.getAlt().getIndex();
            _builder.append((Object)_index);
            _builder.append("u");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            String _upper_1 = this.toUpper(ps);
            _builder.append(_upper_1);
            _builder.append("_IOMUX_CFG          ");
            long _parseLong = Long.parseLong(this._pinCfgHelper.toMUXHex(ps.getConfig()).substring(2), 16);
            _builder.append((Object)_parseLong);
            _builder.append("u");
            _builder.newLineIfNotEmpty();
            muxDef = _builder.toString();
        } else {
            boolean _hasMUX = this._pinCfgHelper.hasMUX(ps);
            if (_hasMUX) {
                FunctionRef funcRefMux = this._pinCfgHelper.getFunctionRefMux(ps);
                if (funcRefMux != null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.newLine();
                    _builder_1.append("#define ");
                    String _upper_2 = this.toUpper(ps);
                    _builder_1.append(_upper_2);
                    _builder_1.append("_IOMUX             ");
                    int _index_1 = funcRefMux.getAlt().getIndex();
                    _builder_1.append((Object)_index_1);
                    _builder_1.append("u");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("#define ");
                    String _upper_3 = this.toUpper(ps);
                    _builder_1.append(_upper_3);
                    _builder_1.append("_IOMUX_CFG         ");
                    long _parseLong_1 = Long.parseLong(this._pinCfgHelper.toMUXHex(ps.getConfig(), funcRefMux).substring(2), 16);
                    _builder_1.append((Object)_parseLong_1);
                    _builder_1.append("u");
                    _builder_1.newLineIfNotEmpty();
                    muxDef = _builder_1.toString();
                }
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                muxDef = _builder_2.toString();
            }
        }
        _xblockexpression = muxDef;
        return _xblockexpression;
    }

    public String getPadName(PinSetting setting) {
        Configuration pad = setting.getPad();
        Pattern pattern = Pattern.compile("P([^\\d]+)(\\d+)");
        Matcher matcher = pattern.matcher(pad.getName());
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(1);
            String _plus = "P" + _group;
            String _plus_1 = _plus + "[";
            String _group_1 = matcher.group(2);
            String _plus_2 = _plus_1 + _group_1;
            return _plus_2 + "]";
        }
        return pad.getName();
    }

    public String getPinPad(PinSetting setting) {
        Configuration pad = setting.getPad();
        Pattern pattern = Pattern.compile("P([^\\d]+)(\\d+)");
        Matcher matcher = pattern.matcher(pad.getName());
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(2);
            return "SIUL2_PAD_" + _group;
        }
        return pad.getName();
    }

    public String getPortName(PinSetting setting) {
        Configuration pad = setting.getPad();
        Pattern pattern = Pattern.compile("P([^\\d]+)(\\d+)");
        Matcher matcher = pattern.matcher(pad.getName());
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(1);
            return "SIUL2_PORT_" + _group;
        }
        return pad.getName();
    }

    private static /* synthetic */ Boolean lambda$generatePinSettings$0(PinSetting pin, PinSetting it) {
        return it.getName().equals(pin.getName());
    }
}

