package com.st.stellar.pinmap.pincfg.codeGenerator.runtime

import com.google.inject.Inject
import com.st.stellar.pinmap.generator.GeneratePinmapView
import com.st.stellar.pinmap.helpers.PinCfgHelper
import com.st.stellar.pinmap.helpers.Utils
import com.st.stellar.pinmap.pinCfg.PinSetting
import com.st.stellar.pinmap.pinCfg.PinSettings
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin
import com.st.stellar.pinmap.pinmapDsl.Configuration
import com.st.stellar.pinmap.pinmapDsl.Family
import com.st.stellar.pinmap.pinmapDsl.Package
import java.util.ArrayList

//import org.apache.poi.hssf.usermodel.HSSFWorkbook
//import org.apache.poi.ss.usermodel.IndexedColors
class GeneratePinSettings {

	// @Inject extension Converter
	val genPinmapView = new GeneratePinmapView

	@Inject extension PinCfgHelper;

	def generate(PinSettings a) {
		a.generateContent
	}

	def generateContent(PinSettings settings) '''
		<?xml version="1.0" encoding="UTF-8"?>
		<PackageInstance refId="«getRefId(settings)»">
		<Configurables>
			«FOR pin : PinCfgHelper.getAllPinSettings(settings)»
				«pin.generateConfigurables»
			«ENDFOR»
			</Configurables>
			</PackageInstance>
			
	'''

	def dispatch String getRefId(PinSettings settings) {
		val incBoard = PinCfgHelper.getBoard(settings.includedBoard) 
		var n = (incBoard.package.eContainer as Family).name
		n = n.replaceAll('x', incBoard.package.name)
		var a = n.indexOf('_')
		n = n.substring(0, a)
		n
	}

	def dispatch String getRefId(PinSetting setting) {
		setting.getPad().getRefId
	}

	def dispatch String getRefId(ConfigurablePin pin) {
		var cfg = pin.ref as Configuration
		cfg.name

	}

	def generateConfigurables(PinSetting setting) {
//		var fname = ""
//		if (setting.config.alt === null) {
//			val fct = setting.config.defaultInput as FunctionRef
//			fname = fct.name.name
//		} else {
//			val fct = setting.config.alt.eContainer as FunctionRef
//			fname = fct.name.name
//		}
//
//		var apc = "false"
//		var smc = "true"
//		var ibe = "true"
//		var wpue = "false"
//		var wpde = "false"
//		var filpresc = "0"
//		var filbypass = "0"
//		var inv = "false"
//		var odc = "2"
//		var oerc = "0"
//		var ils = "0"
//		var hys = "false"
//		var stream = ""
//		if (setting.config.alt !== null) {
//			val config = setting.config as PinProperties
////			var sss = config.reg.findFirst[it|it.attr.attribute.name.equals("SSS")]
////			if (sss !== null) {
////				sss.value = Integer.toString(config.alt.sss)
////			} else {
////				val bitfield = config.alt.ref.bitfields.findFirst[name.equals("SSS")]
////				sss = PinCfgFactory.eINSTANCE.createFieldInstance
////				sss.attr = bitfield
////				sss.value = Integer.toString(config.alt.sss)
////				config.reg.add(sss)
////			}
//			val hexValue = PinCfgHelper.toHex(config)
//			if (hexValue !== null) {
//				// PinCfgHelper.decode(config.alt.ref, hexValue)
//				val register = config.alt.ref
//				_converter = Converter.instance
//				apc = register.decode('APC', hexValue)
//				smc = register.decode('SMC', hexValue)
//				ibe = register.decode('IBE', hexValue)
//				wpue = register.decode('WPUE', hexValue)
//				wpde = register.decode('WPDE', hexValue)
//				filpresc = register.decode('FILPRESC', hexValue)
//				filbypass = register.decode('FILBYPASS', hexValue)
//				inv = register.decode('INV', hexValue)
//				odc = register.decode('ODC', hexValue)
//				oerc = register.decode('OERC', hexValue)
//				ils = register.decode('ILS', hexValue)
//				hys = register.decode('HYS', hexValue)
//			}
//
//			stream = '''
//				<Configurable refId="«setting.getRefId»" alias="«setting.name.toUpperCase»" active="NONE" advanced="false">
//					<Properties>
//					        <PropertyRef refId="P_3" value="0" />
//					        <PropertyRef refId="P_6" value="«apc»" />
//					        <PropertyRef refId="P_5" value="«smc»" />
//					        <PropertyRef refId="P_8" value="«ibe»" />
//					        <PropertyRef refId="P_20" value="«wpue»" />
//					        <PropertyRef refId="P_22" value="«filpresc»" />
//					        <PropertyRef refId="P_21" value="«inv»" />
//					        <PropertyRef refId="P_17" value="«odc»" />
//					        <PropertyRef refId="P_100" value="true" />
//					        <PropertyRef refId="P_16" value="«oerc»" />
//					        <PropertyRef refId="P_19" value="«wpde»" />
//					        <PropertyRef refId="P_18" value="«ils»" />
//					        <PropertyRef refId="P_23" value="«filbypass»" />
//					        <PropertyRef refId="P_14" value="«hys»" />
//					      </Properties>
//					<FunctionRef id="«fname»" direction="«setting.config.direction»" alt="«setting.config.alt.ref.name+"_"+setting.config.alt.index+"_"+setting.config.alt.sss»" />
//				</Configurable>
//			'''
//		} else {
//			stream = '''
//				<Configurable refId="«setting.getRefId»" alias="«setting.name.toUpperCase»" active="NONE" advanced="false">
//					<Properties>
//					</Properties>
//					<FunctionRef id="«fname»" direction="«setting.config.direction»" alt="IAF" />
//				</Configurable>
//			'''
//		}
//		stream
	}

	new() {
		errors = new StringBuilder("errors:\n")
		warnings = new StringBuilder("warnings:\n")
	}

	var StringBuilder errors

	def error(String message) {
		errors.append("error: " + message + "\n")
	}

	var StringBuilder warnings

	def warning(String message) {
		warnings.append("warning: " + message + "\n")
	}

	def generateReport() {
		return errors.append(warnings)
	}



	def int getPortNb(String s) {
		val subString = s.charAt(1)
		var int port = Character.getNumericValue(subString)
		val begin = Character.getNumericValue('A')
		val int portNb = port - begin
		// println(portNb)
		portNb
	}

	def int getBit(String s) {
		val subString = s.substring(2, s.length)
		Integer.parseInt(subString)
	}


	static private def script() '''
<script type="text/javascript">
		  var svg = null;
				function init() {
		  		  	svg = document.getElementById('svg-doc');
//		  		    console.log(svg);
		  		  	
		  		  	var size = getSVGSize();
		  		      console.log(size);
		  		  }
		  	function getSVGSize() {
		  	var svgDoc = svg;//document.getElementById('wizard-svg');
		  	if( svgDoc ) {
		  		var width = svgDoc.getAttribute('width');
		  		var height = svgDoc.getAttribute('height');
		  		res = '<'+width+','+height+'>';
		  		return res;
		  	} else {
		  		return null;
		  	}
		  }

		  function comboInit(thelist)
		  {
		    theinput = document.getElementById('theinput');  
		    var idx = thelist.selectedIndex;
		    var content = thelist.options[idx].innercode;
		    if(theinput) {
		      theinput.value = content;
		    }
		  }
		  var wizIntDisplayOff = function(elem) {
	if (elem) {
		var elt = svg.getElementById(elem);
		if (elt) {
			elt.style.display = "none";
//			console.log(elt+' off')
//		} else {
//			alert("wizIntDisplayOff: please provide a valid element id ("
//					+ elem + " does not exist)");
		}
	}
}

var wizIntDisplayOn = function(elem) {
	if (elem) {
		var elt = svg.getElementById(elem);
		if (elt) {
			elt.style.display = "inline";
//			console.log(elt+' on')
//		} else {
//			alert("wizIntDisplayOn: please provide a valid element id (" + elem
//					+ " does not exist)");
		}
	}
}
		  function combo(thelist, theinput)
		  {
			if(window.old) {
				console.log('from: '+window.old);
				wizIntDisplayOff('peripheral_layer_'+old)
				wizIntDisplayOff('main_layer')
			}
		    theinput = document.getElementById(theinput);  
		    var idx = thelist.selectedIndex;
		    var content = thelist.options[idx].innercode;
		    if(theinput) {
				theinput.value = content;
				window.old = content;
			}
			window.old = content;
			console.log('to: '+content);
			wizIntDisplayOn('main_layer')
			wizIntDisplayOn('peripheral_layer_'+content)
		  }
</script>
	'''

	def generateView(PinSettings settings) {
		val incBoard = PinCfgHelper.getBoard(settings.includedBoard) 
		var pins = ""
		for (mod : PinCfgHelper.getAllModules(settings)) {
			for (pin : mod.pins) {
				pins += pin.generatePin(incBoard.package)
			}
		}
		var peripherals = new ArrayList<String>
		for (pin : incBoard.package.pins) {
			for (cfg : pin.pinConfigurations) {
				if (cfg instanceof ConfigurablePin) {
					val cp = (cfg as ConfigurablePin)
					for (fct : cp.ref.functions) {
						if (!peripherals.contains(fct.name.peripheralRef.label)) {
							peripherals += fct.name.peripheralRef.label
						}
					}
//				} else if (cfg instanceof SystemFunctionPin) {
//					val cp = (cfg as SystemFunctionPin)
//					if (!peripherals.contains(cp.ref.peripheralRef.name)) {
//						peripherals += cp.ref.peripheralRef.name
//					}
				}
			}
		}

		val pinmapView = genPinmapView.generatePackage(incBoard.package, pins)

		val peripheralCombo = '''<label>Show pins for peripheral <select name="thelist" onChange="combo(this, 'theinput')" onMouseOut="comboInit(this, 'theinput')" ></label>
		<option></option>
		«FOR p : peripherals.sort»
			<option>«p»</option>
		«ENDFOR»
		</select>'''

		val fileContent = '''<!DOCTYPE code>
		<code lang="en">
		
		  </head>
		    <title>«settings.name»</title>
		  </head>
		
		  <body onload="init();">
		  <div id="tooltip" display="none" style="position: absolute; display: none;"></div>
		  «peripheralCombo»
		  «pinmapView»
		  «script»
		  </body>
		  
		</code>'''
		fileContent
	}

	def String generatePin(PinSetting pinSetting, Package p) {
		val util = Utils.instance
		val pad = pinSetting.getPad()
		
		_pinCfgHelper = PinCfgHelper.instance;
		val x = genPinmapView.getX(p,pad)
		val y = genPinmapView.getY(p,pad)
		var color = "black"
		var tooltip = '''<foreignObject class="node"><div>'''
		tooltip += pinSetting.name + "<br/>"
		tooltip += "Direction: " + pinSetting.config.direction + "<br/>"
		_pinCfgHelper = PinCfgHelper.instance

		tooltip += "Function: " + pinSetting.functionName
		tooltip += " (" + pinSetting.mscrIndex + "_" + pinSetting.mscrSSS + ")" + "<br/>"
		tooltip += '''</div></foreignObject>'''
		'''<g transform="translate(«x*(genPinmapView.pinWidth+genPinmapView.pinMarginWidth)», «(y+1)*(genPinmapView.pinHeight+genPinmapView.pinMarginHeight)»)" >
        <circle class="pin" fill="#00FF00" stroke="«color»" stroke-width="0.5px" r="«genPinmapView.pinWidth/2»"/>
   		<title>«tooltip»</title>
        <text x="0" y="«genPinmapView.fontSize/2»" style="font-variant:normal;font-weight:normal;font-size:«genPinmapView.fontSize»px;font-family:Helvetica;-inkscape-font-specification:Helvetica;writing-mode:lr-tb;fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none" stroke="«color»" text-anchor="middle" alignment-baseline="middle">«util.getTruncatedPad(pad)»
        </text>
        <title>«tooltip»</title>
      </g>'''
	}
}
