/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.glsp;

import com.st.stellar.pinmap.glsp.PinAbstractPropertySection;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PinPropertySection
extends PinAbstractPropertySection {
    private static final String TITLE = "Pin Specific Information";
    private static final String DESCRIPTION = "Shows the selected pin specific information";
    private Composite container;

    public PinPropertySection() {
        this.title = TITLE;
        this.description = DESCRIPTION;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage atabbedPropertySheetPage) {
        this.container = new Composite(parent, 0);
        this.container.setBackground(this.container.getDisplay().getSystemColor(1));
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            GLSPDiagramEditor diagramEditor = (GLSPDiagramEditor)part;
            if (diagramEditor != null && diagramEditor.getDiagram().getInjector() != null) {
                EMFModelState state = (EMFModelState)diagramEditor.getDiagram().getInjector().getInstance(EMFModelState.class);
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
                List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
                Optional<PinSetting> first = selectedPinConfigs.stream().filter(PinSetting.class::isInstance).map(PinSetting.class::cast).findFirst();
                if (first.isEmpty()) {
                    return;
                }
                for (Control control : this.container.getChildren()) {
                    control.dispose();
                }
                try {
                    ECPSWTViewRenderer.INSTANCE.render(this.container, (EObject)first.get());
                }
                catch (ECPRendererException e) {
                    e.printStackTrace();
                }
                this.container.layout();
            }
        }
    }
}

