/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

public class PinCfgGLSPDiagramActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction refreshViewerAction = new Action("&Refresh"){

        public boolean isEnabled() {
            return PinCfgGLSPDiagramActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (PinCfgGLSPDiagramActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)PinCfgGLSPDiagramActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> configActions;
    protected IMenuManager configMenuManager;

    public PinCfgGLSPDiagramActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("pincfg-settings"));
        toolBarManager.add((IContributionItem)new Separator("pincfg-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
        if (part instanceof GLSPDiagramEditor) {
            IActionBars actionBars = part.getEditorSite().getActionBars();
            ((GLSPDiagramEditor)part).getDiagram().getGlobalActions().forEach((arg_0, arg_1) -> ((IActionBars)actionBars).setGlobalActionHandler(arg_0, arg_1));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        if (this.configMenuManager != null) {
            this.depopulateManager((IContributionManager)this.configMenuManager, this.configActions);
        }
        if ((selection = event.getSelection()) instanceof IStructuredSelection) {
            // empty if block
        }
        this.configActions = this.generateConfigActions(selection);
        if (this.configMenuManager != null) {
            this.populateManager((IContributionManager)this.configMenuManager, this.configActions, null);
            this.configMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateConfigActions(ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            List ioActions;
            List outActions;
            List inActions = actions.stream().filter(a -> a.getText().contains("'I'")).collect(Collectors.toList());
            if (inActions.size() > 0) {
                manager.insertBefore("inputs", (IAction)new Action(this, "Inputs"){

                    public boolean isEnabled() {
                        return false;
                    }
                });
                for (Object action : inActions) {
                    manager.insertBefore("inputs", (IAction)action);
                }
            }
            if ((outActions = actions.stream().filter(a -> a.getText().contains("'O'")).collect(Collectors.toList())).size() > 0) {
                manager.insertBefore("outputs", (IAction)new Action(this, "Outputs"){

                    public boolean isEnabled() {
                        return false;
                    }
                });
                manager.add((IContributionItem)new Separator("outputs"));
                for (IAction action : outActions) {
                    manager.insertBefore("outputs", action);
                }
            }
            if ((ioActions = actions.stream().filter(a -> a.getText().contains("'IO'")).collect(Collectors.toList())).size() > 0) {
                manager.insertBefore("inputoutputs", (IAction)new Action(this, "InputOutputs"){

                    public boolean isEnabled() {
                        return false;
                    }
                });
                manager.add((IContributionItem)new Separator("inputoutputs"));
                for (IAction action : ioActions) {
                    manager.insertBefore("inputoutputs", action);
                }
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            for (int i = 0; i < items.length; ++i) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (!(contributionItem instanceof ActionContributionItem) || !actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) continue;
                manager.remove(contributionItem);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

