/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.editor;

import com.google.inject.Injector;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinCfg.provider.PinCfgItemProviderAdapterFactory;
import com.st.stellar.pinmap.pincfg.glsp.editor.Activator;
import com.st.stellar.pinmap.pincfg.glsp.editor.MyGLSPDiagramComposite;
import com.st.stellar.pinmap.pincfg.glsp.editor.PinCfgBrowserFocusControlInstaller;
import com.st.stellar.pinmap.pincfg.glsp.editor.RenameDialog;
import com.st.stellar.pinmap.pincfg.glsp.editor.ResetSelection;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlinePinMapView;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.pincfg.glsp.editor.ui.BrowserContextMenuInstaller;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pincfg.glsp.server.operations.AssignPinFunctionOperation;
import com.st.stellar.pinmap.pincfg.glsp.server.operations.PopupStateChangeOperation;
import com.st.stellar.pinmap.pincfg.glsp.server.operations.RenamePinOperation;
import com.st.stellar.pinmap.pincfg.ui.editor.PinCfgEditor;
import com.st.stellar.pinmap.pincfg.ui.handler.MigrateConfiguration;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import com.st.stellar.pinmap.pinmapDsl.provider.PinmapDslItemProviderAdapterFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.ide.editor.ui.BrowserKeyBindingForwarderInstaller;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.CenterAction;
import org.eclipse.glsp.server.actions.FitToScreenAction;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.spiritconsorsium.xml.spiritmodel.Spirit.provider.SpiritItemProviderAdapterFactory;

public class PinCfgGLSPDiagramEditor
extends GLSPDiagramEditor
implements IEditingDomainProvider {
    static Logger LOGGER = LogManager.getLogger(PinCfgGLSPDiagramEditor.class);
    static String CONFIG_EDITOR_ID = "com.st.stellar.pinmap.PinCfg.config";
    static String BOARD_EDITOR_ID = "com.st.stellar.pinmap.PinCfg.board";
    protected IContentOutlinePage contentOutlinePage;
    protected TreeViewer contentOutlineViewer;
    protected Viewer currentViewer;
    protected MenuItem menuItemNotUsed = null;
    protected MenuItem menuRenamePin = null;
    protected MenuItem menuItemShowInXtext = null;
    protected MenuItem menuItemNotConfigurable = null;
    protected MenuItem menuItemAlreadyConfigured = null;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " opened"));
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == PinCfgGLSPDiagramEditor.this.contentOutlinePage) {
                    PinCfgGLSPDiagramEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PinCfgGLSPDiagramEditor.this);
                    PinCfgGLSPDiagramEditor.this.setCurrentViewer((Viewer)PinCfgGLSPDiagramEditor.this.contentOutlineViewer);
                }
            } else if (p == PinCfgGLSPDiagramEditor.this) {
                PinCfgGLSPDiagramEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " brought to top"));
        }

        public void partClosed(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " closed"));
        }

        public void partDeactivated(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " deactivated"));
        }

        public void partOpened(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " opened"));
        }
    };
    protected ISelectionChangedListener selectionChangedListener;
    private ISelectionListener updateSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
            if (PinCfgEditor.class.isInstance(part) && TextSelection.class.isInstance(selection) && PinCfgGLSPDiagramEditor.this.getInjector() != null) {
                final PinCfgEditor editor = (PinCfgEditor)PinCfgEditor.class.cast(part);
                EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                PinCfgModelState PinCfgState = (PinCfgModelState)state;
                PinConfiguration config = PinCfgState.getPinConfiguration();
                if (config.eResource() != null) {
                    String editorResourceStr = editor.getResource().getRawLocationURI().toString().replaceAll("^file:.*:", "");
                    String configResourceStr = config.eResource().getURI().toString().replaceAll("^file:.*:", "");
                    if (editor.getSite().getId().equals(CONFIG_EDITOR_ID) && configResourceStr.equals(editorResourceStr)) {
                        editor.getDocument().tryReadOnly((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                            public XtextResource exec(XtextResource state) throws Exception {
                                TextSelection ts = (TextSelection)selection;
                                PinSetting config = editor.getPinSettingNearby(state, ts.getOffset());
                                if (config != null) {
                                    PinCfgGLSPDiagramEditor.this.highlightSelectedPin(config);
                                }
                                return state;
                            }
                        });
                    }
                }
            }
        }
    };
    protected Object contextMenu;
    private MenuManager menuManager = null;
    private Menu menu;
    private OutlinePinMapView outline;
    ISelection mycurrentSelection = StructuredSelection.EMPTY;
    private PinCfgHelper _pinCfgHelper;
    static Integer DIRECT_ANALOG = 999;
    protected static final String KEY_PIN_MENU_DIRECTION = "pin.menu.direction";
    protected static final String KEY_PIN_MENU_FUNCTION = "pin.menu.function";
    public static String REGEX_SYMBOL_NAME = "[a-zA-Z0-9_]+";
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        protected boolean dispatching;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = PinCfgGLSPDiagramEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            PinCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            PinCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        this.dispatchUpdateProblemIndication();
                        break;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void dispatchUpdateProblemIndication() {
            if (PinCfgGLSPDiagramEditor.this.updateProblemIndication && !this.dispatching) {
                this.dispatching = true;
                PinCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dispatching = false;
                        PinCfgGLSPDiagramEditor.this.updateProblemIndication();
                    }
                });
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            PinCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.remove(target);
            this.dispatchUpdateProblemIndication();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = PinCfgGLSPDiagramEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!PinCfgGLSPDiagramEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    PinCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            PinCfgGLSPDiagramEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!PinCfgGLSPDiagramEditor.this.isDirty()) {
                                PinCfgGLSPDiagramEditor.this.getSite().getPage().closeEditor((IEditorPart)PinCfgGLSPDiagramEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    PinCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            PinCfgGLSPDiagramEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (PinCfgGLSPDiagramEditor.this.getSite().getPage().getActiveEditor() == PinCfgGLSPDiagramEditor.this) {
                                PinCfgGLSPDiagramEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                LOGGER.error((Object)exception);
            }
        }
    };
    private UIJob debouncingJob = null;
    static GModelElement lastSelectedPad = null;

    public PinCfgGLSPDiagramEditor() {
        LOGGER.setLevel(Level.INFO);
        LogManager.getLogger(GLSPDiagramEditor.class).setLevel(Level.INFO);
        this.initializeEditingDomain();
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (PinCfgGLSPDiagramEditor.this.currentViewer != null) {
                        PinCfgGLSPDiagramEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PinCfgItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PinmapDslItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SpiritItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                new UIJob("setSelection"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PinCfgGLSPDiagramEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            PinCfgGLSPDiagramEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.outline = new OutlinePinMapView(this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileinput = (FileEditorInput)input;
            URI.createPlatformResourceURI((String)fileinput.getFile().getFullPath().toString(), (boolean)true);
        }
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", true);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext("com.st.stellar.pinmap.pincfg.glsp.editor.context");
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.updateSelectionListener);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        new UIJob("migrate"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (PinCfgGLSPDiagramEditor.this.getInjector() != null) {
                    EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                    PinCfgModelState pincfgState = (PinCfgModelState)state;
                    PinConfiguration pincfg = pincfgState.getPinConfiguration();
                    if (pincfg == null) {
                        return Status.CANCEL_STATUS;
                    }
                    PinSettings ps = pincfg.getPinSetting();
                    if (ps != null) {
                        if (ps.getIncludedBoard() != null && ps.getIncludedBoard().isIsSetVersion()) {
                            return Status.OK_STATUS;
                        }
                        MigrateConfiguration.migrateProject((PinConfiguration)pincfg, (String)"Pinmap configuration need to be migrated to latest version. Do you agree?");
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        }.schedule(5000L);
    }

    private Map<Integer, String> IMAGES() {
        HashMap<Integer, String> options = new HashMap<Integer, String>();
        options.put(0, "image.input");
        options.put(1, "image.output");
        options.put(2, "image.inout");
        options.put(DIRECT_ANALOG, "image.input");
        return options;
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        this.mycurrentSelection = selection;
    }

    protected void fireSelection(Object selectedObject2) {
        if (selectedObject2 != null) {
            StructuredSelection ss = new StructuredSelection(selectedObject2);
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)ss));
            this.setSelection((ISelection)ss);
        }
    }

    public void dispose() {
        if (this.outline != null) {
            this.outline.dispose();
            this.outline = null;
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.updateSelectionListener);
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
            this.contentOutlinePage = null;
        }
        super.dispose();
    }

    protected void installBrowserFunctions() {
        new BrowserKeyBindingForwarderInstaller((IServiceLocator)this.getSite()).install(this.getBrowser());
        new PinCfgBrowserFocusControlInstaller((IEditorPart)this).install(this.getBrowser());
        new BrowserContextMenuInstaller().install(this.getBrowser());
    }

    protected boolean menuExist() {
        return this.menu != null && !this.menu.isDisposed();
    }

    protected void createBrowserMenu() {
        LOGGER.setLevel(Level.DEBUG);
        this.menuManager = new MenuManager();
        this.getSite().registerContextMenu(this.menuManager, this.getSite().getSelectionProvider());
        this.menu = new Menu((Control)this.getBrowser());
        this.getBrowser().setMenu(this.menu);
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Object first;
                ISelection sel = PinCfgGLSPDiagramEditor.this.getSite().getSelectionProvider().getSelection();
                if (IStructuredSelection.class.isInstance(sel) && GNode.class.isInstance(first = ((IStructuredSelection)IStructuredSelection.class.cast(sel)).getFirstElement())) {
                    if (PinCfgGLSPDiagramEditor.this.menu.isDisposed()) {
                        return;
                    }
                    for (MenuItem item : PinCfgGLSPDiagramEditor.this.menu.getItems()) {
                        item.dispose();
                    }
                    PinCfgGLSPDiagramEditor.this.createMenuItems(PinCfgGLSPDiagramEditor.this.menu);
                    PinCfgGLSPDiagramEditor.this.dispatch((Action)new PopupStateChangeOperation(true));
                    return;
                }
                for (MenuItem item : PinCfgGLSPDiagramEditor.this.menu.getItems()) {
                    item.dispose();
                }
            }

            public void menuHidden(MenuEvent e) {
                PinCfgGLSPDiagramEditor.this.dispatch((Action)new PopupStateChangeOperation(false));
            }
        });
    }

    protected void createMenuItems(Menu menu) {
        ISelection selection = this.getSelection();
        Optional<PinSetting> ps = this.getSelectedPinSetting(selection);
        if (ps.isPresent()) {
            Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)ps.get());
            this.createMenuItems(menu, ps.get(), pin);
        } else {
            Pin pin = this.getSelectedPin(selection);
            if (pin != null) {
                this.createMenuItems(menu, null, pin);
            }
        }
    }

    public static String directionAsString(com.st.stellar.pinmap.pinmapDsl.Direction direction) {
        String text = null;
        switch (direction) {
            case GROUND: {
                text = "Ground";
                break;
            }
            case INPUT: {
                text = "Input";
                break;
            }
            case INPUT_ALTERNATE: {
                text = "Input alternate";
                break;
            }
            case INPUT_OR_OUTPUT: {
                text = "Input or Output";
                break;
            }
            case INPUT_OUTPUT: {
                text = "InputOutput";
                break;
            }
            case OUTPUT: {
                text = "Output";
                break;
            }
            case OUTPUT_ALTERNATE: {
                text = "Output alternate";
                break;
            }
            case POWER: {
                text = "Power";
                break;
            }
        }
        return text;
    }

    public static String directionAsString(Direction direction) {
        String text = null;
        switch (direction) {
            case DEFAULT_INPUT: {
                text = "DefaultInput";
            }
            case INPUT: {
                text = "Input";
            }
            case INPUT_OUTPUT: {
                text = "InputOutput";
            }
            case OUTPUT: {
                text = "Output";
            }
        }
        return text;
    }

    public boolean isBoardPin(PinSetting pin) {
        if (pin == null) {
            return false;
        }
        return pin.eContainer().eContainer() instanceof Board;
    }

    protected void createMenuItems(Menu menu, PinSetting ps, Pin pin) {
        ArrayList<MenuItem> configActions = new ArrayList<MenuItem>();
        if (this.isBoardPin(ps)) {
            this.buildAlreadyConfiguredMenu(menu, pin);
            Board board = (Board)ps.eContainer().eContainer();
            if (!board.eResource().getURI().isPlatform()) {
                this.buildShowInXtextEditorMenu(menu, BOARD_EDITOR_ID);
                this.buildRenamePinMenu(menu);
            }
        } else {
            for (PinConfig reference : pin.getPinConfigurations()) {
                MenuItem menuItem;
                String pad;
                if (reference instanceof SpecialPin) {
                    pad = pin.getName();
                    menuItem = new MenuItem(menu, 64);
                    menuItem.setText("PAD: " + pad);
                    menuItem.setEnabled(false);
                    new MenuItem(menu, 2);
                    this.buildNotConfigurabeMenu(menu);
                    continue;
                }
                if (reference instanceof SystemFunctionPin) {
                    pad = pin.getName();
                    menuItem = new MenuItem(menu, 64);
                    menuItem.setText("PAD: " + pad);
                    menuItem.setEnabled(false);
                    new MenuItem(menu, 2);
                    this.buildNotConfigurabeMenu(menu);
                    continue;
                }
                if (!(reference instanceof ConfigurablePin)) continue;
                ConfigurablePin config = (ConfigurablePin)reference;
                Configuration pad2 = config.getRef();
                HashMap<com.st.stellar.pinmap.pinmapDsl.Direction, Menu> parentItems = new HashMap<com.st.stellar.pinmap.pinmapDsl.Direction, Menu>();
                HashMap<com.st.stellar.pinmap.pinmapDsl.Direction, String> labels = new HashMap<com.st.stellar.pinmap.pinmapDsl.Direction, String>();
                MenuItem menuItem2 = new MenuItem(menu, 64);
                menuItem2.setText("PAD: " + pad2.getName());
                menuItem2.setEnabled(false);
                new MenuItem(menu, 2);
                int nbNonIntrinsics = 0;
                EList refs = config.getRef().getFunctions();
                for (FunctionRef ref : refs) {
                    com.st.stellar.pinmap.pinmapDsl.Direction direction = ref.getDirection();
                    if (ref.getAlt() != null) {
                        if (ref.getAlt() != null || direction == com.st.stellar.pinmap.pinmapDsl.Direction.INPUT) {
                            // empty if block
                        }
                        ++nbNonIntrinsics;
                        this.addIfMissing(direction, labels);
                        if (direction != com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OR_OUTPUT) continue;
                        this.addIfMissing(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT, labels);
                        this.addIfMissing(com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT, labels);
                        continue;
                    }
                    this.addIfMissing(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT, labels);
                }
                if (nbNonIntrinsics > 0) {
                    Set keys = labels.keySet();
                    for (com.st.stellar.pinmap.pinmapDsl.Direction direction : keys) {
                        String directionStr = (String)labels.get(direction);
                        this.buildParentMenu(menu, parentItems, direction, directionStr);
                    }
                    for (FunctionRef ref : config.getRef().getFunctions()) {
                        Menu parent = null;
                        com.st.stellar.pinmap.pinmapDsl.Direction direction = ref.getDirection();
                        if (ref.getAlt() != null) {
                            if (ref.getAlt() == null && direction == com.st.stellar.pinmap.pinmapDsl.Direction.INPUT) {
                                parent = (Menu)parentItems.get(DIRECT_ANALOG);
                                if (parent == null) continue;
                                MenuItem a = this.buildItem(configActions, ps, pin, ref, parent, direction);
                                a.setSelection(true);
                                continue;
                            }
                            parent = (Menu)parentItems.get(direction);
                            if (parent != null) {
                                this.buildItem(configActions, ps, pin, ref, parent, direction);
                            }
                            if (direction != com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OR_OUTPUT) continue;
                            parent = (Menu)parentItems.get(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                            if (!this.isInputOnly(ref, (List<FunctionRef>)refs)) {
                                this.buildItem(configActions, ps, pin, ref, parent, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                            }
                            parent = (Menu)parentItems.get(com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT);
                            this.buildItem(configActions, ps, pin, ref, parent, com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT);
                            continue;
                        }
                        parent = (Menu)parentItems.get(com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                        if (parent == null) continue;
                        this.buildItem(configActions, ps, pin, ref, parent, com.st.stellar.pinmap.pinmapDsl.Direction.INPUT);
                    }
                    this.buildNotUsedMenu(menu);
                    if (ps != null) {
                        this.buildShowInXtextEditorMenu(menu, CONFIG_EDITOR_ID);
                        this.buildRenamePinMenu(menu);
                    }
                } else {
                    this.buildNotConfigurabeMenu(menu);
                }
                this.menuItemNotUsed.setSelection(ps == null);
            }
        }
    }

    private void buildAlreadyConfiguredMenu(Menu menu, Pin pin) {
        String pad = pin.getName();
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("PAD: " + pad);
        menuItem.setEnabled(false);
        new MenuItem(menu, 2);
        this.menuItemAlreadyConfigured = new MenuItem(menu, 32);
        this.menuItemAlreadyConfigured.setText("Already configured");
    }

    private void addIfMissing(com.st.stellar.pinmap.pinmapDsl.Direction direction, Map<com.st.stellar.pinmap.pinmapDsl.Direction, String> labels) {
        String directionStr = PinCfgGLSPDiagramEditor.directionAsString(direction);
        if (!labels.containsKey(direction)) {
            labels.put(direction, directionStr);
        }
    }

    private void buildNotConfigurabeMenu(Menu menu) {
        this.menuItemNotConfigurable = new MenuItem(menu, 32);
        this.menuItemNotConfigurable.setText("Not configurable");
    }

    protected void buildNotUsedMenu(Menu menu) {
        this.menuItemNotUsed = new MenuItem(menu, 2);
        this.menuItemNotUsed = new MenuItem(menu, 32);
        this.menuItemNotUsed.setText("Not used");
        this.menuItemNotUsed.setImage(Activator.getDefault().getImage("image.notUsed"));
        this.menuItemNotUsed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Configuration pad;
                EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                PinCfgModelState pincfgState = (PinCfgModelState)state;
                PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
                ISelection selection = PinCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = PinCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty() && (pad = PinCfgGLSPDiagramEditor.this.getSelectedPad(selection)) != null) {
                    PinCfgGLSPDiagramEditor.this.dispatch((Action)new AssignPinFunctionOperation(pinConfiguration, pad, null, null, null)).thenRun(() -> PinCfgGLSPDiagramEditor.this.setSelection((ISelection)StructuredSelection.EMPTY));
                }
            }
        });
    }

    protected void buildRenamePinMenu(final Menu menu) {
        this.menuRenamePin = new MenuItem(menu, 2);
        this.menuRenamePin = new MenuItem(menu, 8);
        this.menuRenamePin.setText("Rename pin");
        this.menuRenamePin.setImage(Activator.getDefault().getImage("image.renamePin"));
        this.menuRenamePin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                Pin pin;
                EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                PinCfgModelState pincfgState = (PinCfgModelState)state;
                PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
                ISelection selection = PinCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = PinCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty() && (pin = PinCfgGLSPDiagramEditor.this.getSelectedPin(selection)) != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    Composite editorArea = (Composite)page.getWorkbenchWindow().getShell().getChildren()[0];
                    Point center = PinCfgGLSPDiagramEditor.getCenterCoordinates(editorArea);
                    RenameDialog dialog = new RenameDialog(menu.getShell(), ps.get().getName());
                    dialog.create();
                    dialog.setTitle("Rename pin");
                    Rectangle bounds = dialog.getShell().getBounds();
                    dialog.getShell().setBounds(center.x, center.y, bounds.width, bounds.height);
                    if (dialog.open() == 0) {
                        PinCfgGLSPDiagramEditor.this.dispatch((Action)new RenamePinOperation(pinConfiguration, ps.get(), dialog.getNewName()));
                    }
                }
            }
        });
        this.menuRenamePin.setSelection(false);
    }

    private static Point getCenterCoordinates(Composite composite) {
        Point size = composite.getSize();
        Point location = composite.toDisplay(0, 0);
        int centerX = location.x + size.x / 2;
        int centerY = location.y + size.y / 2;
        return new Point(centerX, centerY);
    }

    protected void buildShowInXtextEditorMenu(Menu menu, final String editorId) {
        this.menuItemShowInXtext = new MenuItem(menu, 2);
        this.menuItemShowInXtext = new MenuItem(menu, 32);
        this.menuItemShowInXtext.setText("Show in Xtext editor");
        this.menuItemShowInXtext.setImage(Activator.getDefault().getImage("image.locate"));
        this.menuItemShowInXtext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = PinCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = PinCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty()) {
                    PinCfgGLSPDiagramEditor.this.showInXtextEditor(ps.get(), editorId);
                }
            }
        });
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        return lastSegment;
    }

    private IProject getProject(EObject eObject) {
        URI uri;
        Resource resource = eObject.eResource();
        if (resource != null && (uri = resource.getURI()).isFile()) {
            File file = new File(uri.toFileString());
            IFile iResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
            if (iResource != null) {
                return iResource.getProject();
            }
            for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                if (!file.getAbsolutePath().startsWith(project.getLocation().toFile().getAbsolutePath())) continue;
                return project;
            }
        }
        return null;
    }

    public void showInXtextEditor(final PinSetting pinSetting, final String editorId) {
        boolean doit = true;
        boolean isDirty = this.isDirty();
        long delay = 1L;
        if (isDirty) {
            String title = "Need to save";
            String[] options = new String[]{"Yes", "No"};
            String message = "Before showing this pin inside the textual editor we need to save the latest modifications... Do you aggree?";
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, message, 3, options, 0);
            int result = dialog.open();
            if (result != 0) {
                doit = false;
            }
        }
        if (doit) {
            if (isDirty) {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                this.doSave((IProgressMonitor)progressMonitor);
                delay = 2000L;
            }
            UIJob showPinJob = new UIJob("Show selected pin"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    block11: {
                        try {
                            TextSelection textSel;
                            PinCfgEditor xtextEditor;
                            IEditorPart editor;
                            ISelectionService selectionService;
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IFile file = ((IFileEditorInput)PinCfgGLSPDiagramEditor.this.getEditorInput()).getFile();
                            if (BOARD_EDITOR_ID.equals(editorId)) {
                                Board board = (Board)pinSetting.eContainer().eContainer();
                                if (board.eResource().getURI().isPlatform()) {
                                    LOGGER.error((Object)("Cannot show file: " + board.eResource().getURI().toString()));
                                } else {
                                    IProject project = PinCfgGLSPDiagramEditor.this.getProject((EObject)pinSetting);
                                    IPath base = project.getLocation();
                                    String filePath = String.valueOf(base) + File.separator + PinCfgGLSPDiagramEditor.this.fileName(board.eResource().getURI());
                                    File f = new File(filePath);
                                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                    file = root.getFileForLocation((IPath)new Path(f.getAbsolutePath()));
                                }
                            }
                            if ((selectionService = (ISelectionService)(editor = page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3)).getSite().getService(ISelectionService.class)) == null) break block11;
                            ICompositeNode node = NodeModelUtils.getNode((EObject)pinSetting);
                            if (node != null) {
                                int offset = node.getOffset();
                                xtextEditor = (PinCfgEditor)editor;
                                textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset, 0);
                                LOGGER.info((Object)("ok: " + String.valueOf(textSel)));
                                editor.getSite().getSelectionProvider().setSelection((ISelection)textSel);
                                break block11;
                            }
                            LOGGER.error((Object)("Cannot find node for :" + pinSetting.getPad().getName()));
                            node = NodeModelUtils.getNode((EObject)pinSetting.getPad());
                            if (node != null) {
                                IFile docFile;
                                int offset = node.getOffset();
                                xtextEditor = (PinCfgEditor)editor;
                                textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset, 0);
                                if (textSel.getStartLine() >= 0 || (docFile = (IFile)xtextEditor.getDocument().getAdapter(IFile.class)) == null) break block11;
                                try {
                                    String line;
                                    InputStream inputStream = file.getContents();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                                    int lineNumber = 1;
                                    offset = 1;
                                    int charPosition = -1;
                                    while ((line = reader.readLine()) != null && (charPosition = line.indexOf("-> " + pinSetting.getPad().getName())) == -1) {
                                        offset += line.length() + 2;
                                        ++lineNumber;
                                    }
                                    reader.close();
                                    inputStream.close();
                                    if (charPosition != -1) {
                                        LOGGER.info((Object)(pinSetting.getPad().getName() + " found at line " + lineNumber + ", position " + charPosition));
                                        textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset += charPosition, 0);
                                        LOGGER.info((Object)textSel);
                                        editor.getSite().getSelectionProvider().setSelection((ISelection)textSel);
                                        break block11;
                                    }
                                    LOGGER.error((Object)"String not found");
                                }
                                catch (IOException | CoreException e) {
                                    e.printStackTrace();
                                }
                                break block11;
                            }
                            LOGGER.error((Object)("Cannot find node for :" + pinSetting.getPad().getName()));
                        }
                        catch (PartInitException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            showPinJob.schedule(delay);
        }
    }

    private boolean isInputOnly(FunctionRef ref, List<FunctionRef> refs) {
        for (FunctionRef function : refs) {
            if (function.getDirection() != com.st.stellar.pinmap.pinmapDsl.Direction.INPUT || !function.getName().equals((Object)ref.getName())) continue;
            return true;
        }
        return false;
    }

    private MenuItem buildItem(ArrayList<MenuItem> items, PinSetting ps, final Pin pin, final FunctionRef ref, Menu parent, final com.st.stellar.pinmap.pinmapDsl.Direction direction) {
        PinProperties config;
        Function function = ref.getName();
        String name = function.getName();
        String description = function.getDesc().trim();
        MenuItem menuItem = new MenuItem(parent, 16);
        items.add(menuItem);
        final String pinName = "PIN_" + function.getName();
        String text = "";
        if (description.isEmpty()) {
            text = NLS.bind((String)"{0}", (Object)name);
        } else {
            Object[] bindings = new String[]{name, description};
            text = NLS.bind((String)"{0} ({1})", (Object[])bindings);
        }
        menuItem.setText(text);
        menuItem.setEnabled(true);
        menuItem.setData(KEY_PIN_MENU_FUNCTION, (Object)ref);
        menuItem.setData(KEY_PIN_MENU_DIRECTION, (Object)direction);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pin alreadyConfiguredPin;
                boolean selection = ((MenuItem)e.getSource()).getSelection();
                if (!selection) {
                    return;
                }
                EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                PinCfgModelState pincfgState = (PinCfgModelState)state;
                PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
                Optional<PinSetting> alreadyDefinedPinSetting = PinCfgHelper.getAllPinSettings((PinConfiguration)pinConfiguration).stream().filter(it -> it.getConfig().getAlt().getName().equals(ref.getName().getName())).findFirst();
                boolean doit = true;
                if (alreadyDefinedPinSetting.isPresent() && !pin.equals((Object)(alreadyConfiguredPin = PinCfgHelper.getPinForConfiguration((PinSetting)alreadyDefinedPinSetting.get())))) {
                    String title = "Function is already defined";
                    String[] options = new String[]{"Confirm", "Cancel"};
                    String message = NLS.bind((String)"The function is already defined...\n\nIt will be removed from PAD ''{0}'' (pin ''{1}'')\n\nDo you confirm ?", (Object)alreadyDefinedPinSetting.get().getPad().getName(), (Object)alreadyConfiguredPin);
                    MessageDialog dialog = new MessageDialog(PinCfgGLSPDiagramEditor.this.getSite().getShell(), title, null, message, 3, options, 0);
                    int result = dialog.open();
                    if (result != 0) {
                        doit = false;
                    }
                }
                if (doit) {
                    Optional<ConfigurablePin> pad = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).findFirst();
                    if (pad.isPresent()) {
                        PinCfgGLSPDiagramEditor.this.dispatch((Action)new AssignPinFunctionOperation(pinConfiguration, pad.get().getRef(), ref, direction, pinName)).thenRun(() -> PinCfgGLSPDiagramEditor.this.setSelection((ISelection)StructuredSelection.EMPTY));
                    }
                }
            }
        });
        if (ps != null && ps.getConfig() != null && (config = ps.getConfig()).getAlt().equals((Object)function)) {
            menuItem.setSelection(true);
        }
        return menuItem;
    }

    private void buildParentMenu(Menu menu, Map<com.st.stellar.pinmap.pinmapDsl.Direction, Menu> parentItems, com.st.stellar.pinmap.pinmapDsl.Direction direction, String directionStr) {
        System.out.println(direction.getLiteral());
        if (!parentItems.containsKey(direction)) {
            Menu cascadeMenu = new Menu(menu.getParent(), 4);
            MenuItem menuItem = new MenuItem(menu, 64);
            menuItem.setText(directionStr);
            menuItem.setImage(Activator.getDefault().getImage(this.IMAGES().get(direction.getValue())));
            menuItem.setMenu(cascadeMenu);
            parentItems.put(direction, cascadeMenu);
        }
    }

    private Pin getSelectedPin(ISelection sel) {
        this._pinCfgHelper = PinCfgHelper.instance;
        PinCfgModelState state = (PinCfgModelState)this.getInjector().getInstance(EMFModelState.class);
        StructuredSelection structuredSelection = (StructuredSelection)sel;
        Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
        List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        Optional<PinSetting> pinSetting = selectedPinConfigs.stream().filter(PinSetting.class::isInstance).map(PinSetting.class::cast).findFirst();
        if (pinSetting.isEmpty()) {
            Optional<Configuration> pad = selectedPinConfigs.stream().filter(Configuration.class::isInstance).map(Configuration.class::cast).findFirst();
            if (pad.isEmpty()) {
                return null;
            }
            PinConfiguration pinConfiguration = state.getPinConfiguration();
            Package pack = this._pinCfgHelper.getPack(pinConfiguration);
            Pin p = this._pinCfgHelper.getPinForConfiguration(pack, pad.get());
            return p;
        }
        return PinCfgHelper.getPinForConfiguration((PinSetting)pinSetting.get());
    }

    private Configuration getSelectedPad(ISelection sel) {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        StructuredSelection structuredSelection = (StructuredSelection)sel;
        Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
        List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        Optional<PinSetting> pinSetting = selectedPinConfigs.stream().filter(PinSetting.class::isInstance).map(PinSetting.class::cast).findFirst();
        if (pinSetting.isEmpty()) {
            Optional<Configuration> pad = selectedPinConfigs.stream().filter(Configuration.class::isInstance).map(Configuration.class::cast).findFirst();
            if (pad.isEmpty()) {
                return null;
            }
            return pad.get();
        }
        return pinSetting.get().getPad();
    }

    private Optional<PinSetting> getSelectedPinSetting(ISelection sel) {
        Optional pin;
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        StructuredSelection structuredSelection = (StructuredSelection)sel;
        Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
        List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        Stream<Configuration> a = selectedPinConfigs.stream().filter(Configuration.class::isInstance).map(Configuration.class::cast);
        List selectedPins = a.collect(Collectors.toList());
        PinCfgModelState modelState = (PinCfgModelState)state;
        PinConfiguration pinConfiguration = modelState.getPinConfiguration();
        EList modules = PinCfgHelper.getAllModules((PinSettings)pinConfiguration.getPinSetting());
        ArrayList configuredPins = new ArrayList();
        if (modules.size() > 0) {
            for (Module module : modules) {
                configuredPins.addAll(module.getPins());
            }
        }
        if ((pin = selectedPins.stream().findFirst()).isPresent()) {
            return configuredPins.stream().filter(it -> it.getPad().equals(pin.get())).findFirst();
        }
        return Optional.empty();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.outline;
        }
        if (key.equals(IGotoMarker.class)) {
            return key.cast((Object)this);
        }
        return super.getAdapter(key);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        PinCfgGLSPDiagramEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "com.st.stellar.pinmap.glsp.editor", 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "com.st.stellar.pinmap.glsp.editor", 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "com.st.stellar.pinmap.glsp.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                try {
                    this.markerHelper.updateMarkers((Diagnostic)diagnostic);
                }
                catch (CoreException exception) {
                    LOGGER.error((Object)exception);
                }
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(resourceSet.getLoadOptions());
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Conflict", (String)"There are unsaved changes that conflict with changes made outside the editor.  Do you wish to discard this editor's changes?");
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void updateMicro(Object sel, boolean padSelection) {
        if (this.debouncingJob != null) {
            this.debouncingJob.cancel();
        }
        this.debouncingJob = new DebouncingJob(sel, padSelection);
        this.debouncingJob.schedule(100L);
    }

    public void updateMicro(Object sel, boolean padSelection, boolean resetHighlightStates, List<String> centerOn) {
        block15: {
            Set toDeselect;
            PinCfgModelState pinCfgState;
            block19: {
                block18: {
                    block17: {
                        EMFModelState state;
                        block16: {
                            if (resetHighlightStates) {
                                this.resetHighlightedStates();
                            }
                            state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
                            pinCfgState = (PinCfgModelState)state;
                            if (!(sel instanceof StructuredSelection)) break block16;
                            StructuredSelection ss = (StructuredSelection)sel;
                            for (Object a : ss.toList()) {
                                this.updateMicro(a, padSelection, false, centerOn);
                            }
                            break block15;
                        }
                        if (sel instanceof ResetSelection) break block15;
                        toDeselect = state.getIndex().allIds();
                        if (!(sel instanceof OutlinePin)) break block17;
                        OutlinePin outlinepin = (OutlinePin)sel;
                        Configuration pad = outlinepin.getPad();
                        String id = pinCfgState.getIndex().indexEObject((EObject)pad);
                        String padName = pad.getName();
                        List allPins = PinCfgHelper.getAllPinSettings((PinConfiguration)this.getPinConfiguration());
                        Package p = PinCfgHelper.instance.getPack(this.getPinConfiguration());
                        for (Pin pin : p.getPins()) {
                            Optional<Configuration> pad2 = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).map(ConfigurablePin::getRef).filter(it -> it.getName().equals(padName)).findFirst();
                            if (!pad2.isPresent()) continue;
                            id = pinCfgState.getIndex().indexEObject((EObject)pad2.get());
                            Optional elt2 = pinCfgState.getIndex().get(id);
                            if (elt2.isPresent()) {
                                centerOn.add(id);
                                if (padSelection) {
                                    this.selectedPad((GModelElement)elt2.get());
                                } else {
                                    this.highlightPad((GModelElement)elt2.get());
                                }
                            } else {
                                id = pinCfgState.getIndex().indexEObject((EObject)pad);
                                Optional eltLabel = pinCfgState.getIndex().get(id + "_pin_label");
                                if (eltLabel.isPresent()) {
                                    centerOn.add(id);
                                    if (padSelection) {
                                        this.selectedPad(((GModelElement)eltLabel.get()).getParent());
                                    } else {
                                        this.highlightPad(((GModelElement)eltLabel.get()).getParent());
                                    }
                                } else {
                                    LOGGER.error((Object)("UpdateMicro: Pin with name " + pad.getName() + " not found"));
                                }
                            }
                            break block15;
                        }
                        break block15;
                    }
                    if (!(sel instanceof OutlineFunction)) break block18;
                    OutlineFunction of = (OutlineFunction)sel;
                    Function function = of.getFunction();
                    for (String id : toDeselect) {
                        Optional node;
                        Configuration pad;
                        List functions;
                        Optional elt = pinCfgState.getIndex().getEObject(id);
                        if (!elt.isPresent() || !Configuration.class.isInstance(elt.get()) || !(functions = (pad = (Configuration)elt.get()).getFunctions().stream().map(it -> it.getName()).collect(Collectors.toList())).contains(function) || !(node = pinCfgState.getIndex().get(id)).isPresent()) continue;
                        centerOn.add(id);
                        this.highlightPad((GModelElement)node.get());
                    }
                    break block15;
                }
                if (!(sel instanceof OutlinePeripheral)) break block19;
                OutlinePeripheral op = (OutlinePeripheral)sel;
                Peripheral periph = op.getPeripheral();
                for (String id : toDeselect) {
                    Optional node;
                    Configuration pad;
                    List pinPeriphs;
                    Optional elt = pinCfgState.getIndex().getEObject(id);
                    if (!elt.isPresent() || !Configuration.class.isInstance(elt.get()) || !(pinPeriphs = (pad = (Configuration)elt.get()).getFunctions().stream().map(it -> it.getName().getPeripheralRef()).collect(Collectors.toList())).contains(periph) || !(node = pinCfgState.getIndex().get(id)).isPresent()) continue;
                    centerOn.add(id);
                    this.highlightPad((GModelElement)node.get());
                }
                break block15;
            }
            if (!(sel instanceof OutlinePeripheralFamily)) break block15;
            OutlinePeripheralFamily fam = (OutlinePeripheralFamily)sel;
            List<OutlinePeripheral> peripherals = fam.getPeripheralList();
            for (OutlinePeripheral periph : peripherals) {
                for (String id : toDeselect) {
                    Optional node;
                    Configuration pad;
                    List pinPeriphs;
                    Optional elt = pinCfgState.getIndex().getEObject(id);
                    if (!elt.isPresent() || !Configuration.class.isInstance(elt.get()) || !(pinPeriphs = (pad = (Configuration)elt.get()).getFunctions().stream().map(it -> it.getName().getPeripheralRef()).collect(Collectors.toList())).contains(periph.getPeripheral()) || !(node = pinCfgState.getIndex().get(id)).isPresent()) continue;
                    centerOn.add(id);
                    this.highlightPad((GModelElement)node.get());
                }
            }
        }
    }

    private void resetHighlightedStates() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        Set toDeselect = state.getIndex().allIds();
        toDeselect.stream().map(it -> state.getIndex().get(it)).flatMap(Optional::stream).filter(GNode.class::isInstance).map(GNode.class::cast).forEach(it -> {
            it.getCssClasses().remove((Object)"highlighted");
            it.getCssClasses().remove((Object)"selectedPAD");
        });
    }

    public ISelection getSelection() {
        return this.getDiagram().getSelection();
    }

    protected List<GModelElement> toGModelElementsLabel(List<String> ids, GModelState modelState) {
        List gElements = ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        return gElements.stream().map(it -> (GModelElement)it.eContainer()).collect(Collectors.toList());
    }

    private void addUnique(List<GModelElement> fromList, List<GModelElement> toList) {
        for (GModelElement newSelectedElement : fromList) {
            if (toList.contains(newSelectedElement)) continue;
            toList.add(newSelectedElement);
        }
    }

    public Object getCurrentFamily() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        PinCfgModelState PinCfgState = (PinCfgModelState)state;
        PinConfiguration pinCfg = PinCfgState.getPinConfiguration();
        pinCfg.getBoard();
        return null;
    }

    public PinConfiguration getPinConfiguration() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        PinCfgModelState PinCfgState = (PinCfgModelState)state;
        PinConfiguration pinConfiguration = PinCfgState.getPinConfiguration();
        return pinConfiguration;
    }

    protected void highlightSelectedPin(PinSetting ps) {
        this.resetHighlightedStates();
        if (ps.getPad() == null) {
            return;
        }
        PinCfgHelper helper = PinCfgHelper.instance;
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        PinCfgModelState PinCfgState = (PinCfgModelState)state;
        PinConfiguration config = PinCfgState.getPinConfiguration();
        Configuration pad = helper.findPin(config, ps.getPad().getName());
        if (pad == null) {
            return;
        }
        String id = state.getIndex().indexEObject((EObject)ps.getPad());
        Optional elt = state.getIndex().get(id);
        if (elt.isPresent()) {
            this.selectedPad((GModelElement)elt.get());
            ArrayList<String> centerOn = new ArrayList<String>();
            centerOn.add(state.getIndex().indexEObject((EObject)pad));
            this.getModelStateOnceInitialized().thenAccept(modelState -> this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> this.dispatch((Action)new FitToScreenAction("fit", centerOn, 10.0, 1.0, true)))));
        } else {
            LOGGER.info((Object)("Cannot find graphical element for pad '" + ps.getPad().getName() + "'"));
            Stream<Configuration> pins = PinCfgHelper.getAllPinSettings((PinConfiguration)config).stream().map(it -> it.getPad()).filter(i -> i.getName().equals(pad.getName()));
            Optional<Configuration> first = pins.findFirst();
            if (first.isPresent()) {
                Configuration p = first.get();
                Optional pinElement = PinCfgState.getModelElement((EObject)p);
                if (pinElement.isPresent()) {
                    LOGGER.info((Object)("found: " + String.valueOf(pinElement)));
                    this.selectedPad((GModelElement)pinElement.get());
                    ArrayList<String> centerOn = new ArrayList<String>();
                    centerOn.add(state.getIndex().indexEObject((EObject)pad));
                    this.getModelStateOnceInitialized().thenAccept(modelState -> this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> this.dispatch((Action)new FitToScreenAction("fit", centerOn, 10.0, 1.0, true)))));
                } else {
                    LOGGER.error((Object)("Cannot find: " + p.getName()));
                }
            }
        }
    }

    private void selectedPad(GModelElement elt) {
        if (lastSelectedPad != null) {
            lastSelectedPad.getCssClasses().remove((Object)"selectedPAD");
        }
        elt.getCssClasses().add((Object)"selectedPAD");
        lastSelectedPad = elt;
    }

    private void highlightPad(GModelElement elt) {
        elt.getCssClasses().add((Object)"highlighted");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (Object listener : this.getListeners()) {
            ISelectionChangedListener selectionChangedListeners = (ISelectionChangedListener)listener;
            UIUtil.asyncExec(() -> selectionChangedListeners.selectionChanged(event));
        }
    }

    public List<OutlinePeripheralFamily> getCategories(PinConfiguration cfg) {
        Set<OutlinePeripheralFamily> peripheralsList = OutlinePeripheralFamily.getPackagePeripheralFamilies(cfg);
        return Collections.unmodifiableList(peripheralsList.stream().toList());
    }

    public List<OutlinePin> getPins(Function function) {
        List<OutlinePeripheralFamily> categories = this.getCategories(this.getPinConfiguration());
        for (OutlinePeripheralFamily cat : categories) {
            List<OutlinePeripheral> peripherals = cat.getPeripheralList();
            for (OutlinePeripheral periph : peripherals) {
                List<OutlineFunction> functions = periph.getFunctionsList();
                for (OutlineFunction f : functions) {
                    if (!function.getName().equals(f.getName())) continue;
                    return f.getPinsList();
                }
            }
        }
        return new ArrayList<OutlinePin>();
    }

    protected GLSPDiagramComposite createGLSPDiagramComposite() {
        return new MyGLSPDiagramComposite(this.getEditorId(), this);
    }

    private CompletableFuture<GModelState> getModelStateOnceInitialized() {
        MyGLSPDiagramComposite diagram = (MyGLSPDiagramComposite)this.getDiagram();
        return diagram.getModelStateOnceInitialized();
    }

    private Stream<GModelElement> toGModelElementStream(StructuredSelection selection) {
        return selection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
    }

    private List<GModelElement> toGModelElements(Collection<String> ids, GModelState modelState) {
        return ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public CompletableFuture<Void> dispatch(Action action) {
        MyGLSPDiagramComposite diagram = (MyGLSPDiagramComposite)this.getDiagram();
        return diagram.dispatch(action);
    }

    public Injector getInjector() {
        return this.getDiagram().getInjector();
    }

    Browser getBrowser() {
        return this.getDiagram().getBrowser();
    }

    class DebouncingJob
    extends UIJob {
        private Object sel;
        private boolean padSelection;

        DebouncingJob(Object sel, boolean padSelection) {
            super("debouncing");
            this.sel = sel;
            this.padSelection = padSelection;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList<String> centerOn = new ArrayList<String>();
            PinCfgGLSPDiagramEditor.this.updateMicro(this.sel, this.padSelection, true, centerOn);
            EMFModelState state = (EMFModelState)PinCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
            if (centerOn.isEmpty()) {
                PinCfgGLSPDiagramEditor.this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot()));
            } else {
                PinCfgGLSPDiagramEditor.this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> PinCfgGLSPDiagramEditor.this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> PinCfgGLSPDiagramEditor.this.dispatch((Action)new FitToScreenAction("fit", centerOn, 10.0, 1.0, true))));
            }
            return Status.OK_STATUS;
        }
    }
}

