/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.editor.outline;

import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pincfg.glsp.editor.PinCfgGLSPDiagramEditor;
import com.st.stellar.pinmap.pincfg.glsp.editor.ResetSelection;
import com.st.stellar.pinmap.pincfg.glsp.editor.listeners.IdentifiableSelectionChangedListener;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.LinkWithEditorAction;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlineFunctionsContentProvider;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlineFunctionsDecorator;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlineFunctionsLabelProvider;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlineFunctionsSorter;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlinePADsFilter;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.OutlineStringFilter;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.ViewDecoratingStyledCellLabelProvider;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.GroupFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class OutlinePinMapView
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    public static final String ID = "org.eclipse.ui.views.ContentOutline";
    private PinCfgGLSPDiagramEditor editor;
    private IdentifiableSelectionChangedListener listener;
    private TreeViewer viewer;
    private boolean enableFire = true;
    private PinCfgHelper _pinCfgHelper;
    private Text filterText;
    private OutlinePADsFilter padsFilter;
    private OutlineStringFilter stringFilter;
    private Composite container;
    private boolean resetSelection = false;
    private ISelectionListener updateSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (OutlinePinMapView.this.viewer == null) {
                OutlinePinMapView.this.viewer = OutlinePinMapView.this.getTreeViewer();
            }
            if (part instanceof GLSPDiagramEditor) {
                if (((GLSPDiagramEditor)part).getDiagram().getInjector() == null) {
                    return;
                }
                GLSPDiagramEditor diagramEditor = (GLSPDiagramEditor)part;
                EMFModelState state = (EMFModelState)diagramEditor.getDiagram().getInjector().getInstance(EMFModelState.class);
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
                List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
                Optional<PinSetting> sel2 = selectedPinConfigs.stream().filter(PinSetting.class::isInstance).map(PinSetting.class::cast).findFirst();
                if (sel2.isPresent()) {
                    if (OutlinePinMapView.this.viewer.getControl() != null && !OutlinePinMapView.this.viewer.getControl().isDisposed()) {
                        OutlinePinMapView.this.refresh(state, (ISelection)new StructuredSelection((Object)sel2.get()));
                    }
                } else {
                    Optional<Configuration> sel = selectedPinConfigs.stream().filter(Configuration.class::isInstance).map(Configuration.class::cast).findFirst();
                    try {
                        if (sel.isPresent()) {
                            OutlinePinMapView.this.refresh(state, (ISelection)new StructuredSelection((Object)sel.get()));
                        } else {
                            OutlinePinMapView.this.refresh(state, (ISelection)StructuredSelection.EMPTY);
                        }
                    }
                    catch (IllegalStateException ise) {
                        System.err.println(ise.getMessage());
                    }
                    catch (ClassCastException ise) {
                        System.err.println(ise.getMessage());
                    }
                    catch (Exception ise) {
                        System.err.println(ise.getMessage());
                    }
                }
            }
        }
    };
    private LinkWithEditorAction linkWithEditorAction;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private TreeViewer treeViewer;
    private boolean linkWithEditor = true;

    public OutlinePinMapView(PinCfgGLSPDiagramEditor editor) {
        this.editor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.updateSelectionListener);
    }

    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.updateSelectionListener);
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        this.container = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).layoutData((Object)new GridData(1808))).create((Widget)parent);
        this.stringFilter = new OutlineStringFilter();
        this.padsFilter = new OutlinePADsFilter();
        Group frame = (Group)((GroupFactory)((GroupFactory)WidgetFactory.group((int)0).layout((Layout)new GridLayout(2, false))).layoutData((Object)new GridData(768))).create((Widget)this.container);
        frame.setText("Filter by");
        final Button radioPAD = (Button)WidgetFactory.button((int)16).create((Widget)frame);
        radioPAD.setText("PAD");
        radioPAD.setSelection(true);
        final Button radioString = (Button)WidgetFactory.button((int)16).create((Widget)frame);
        radioString.setText("Peripheral/function");
        radioString.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (radioString.getSelection()) {
                    OutlinePinMapView.this.filterText.setMessage("Enter peripheral or function name");
                    OutlinePinMapView.this.filterText.setToolTipText("Enter peripheral or function name");
                    OutlinePinMapView.this.treeViewer.resetFilters();
                    OutlinePinMapView.this.treeViewer.addFilter((ViewerFilter)OutlinePinMapView.this.stringFilter);
                    OutlinePinMapView.this.treeViewer.refresh();
                }
            }
        });
        radioPAD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (radioPAD.getSelection()) {
                    OutlinePinMapView.this.filterText.setMessage("Enter PAD name (eg. i0 or pi0 for PI[0]");
                    OutlinePinMapView.this.filterText.setToolTipText("Enter PAD name (eg. i0 or pi0 for PI[0]");
                    OutlinePinMapView.this.treeViewer.resetFilters();
                    OutlinePinMapView.this.treeViewer.addFilter((ViewerFilter)OutlinePinMapView.this.padsFilter);
                    OutlinePinMapView.this.treeViewer.refresh();
                }
            }
        });
        this.filterText = new Text(this.container, 2176);
        this.filterText.setMessage("Enter PAD name (eg. i0 or pi0 for PI[0]");
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutlinePinMapView.this.stringFilter.setFilterString(OutlinePinMapView.this.filterText.getText());
                OutlinePinMapView.this.padsFilter.setFilterString(OutlinePinMapView.this.filterText.getText());
                if (radioPAD.getSelection()) {
                    OutlinePinMapView.this.getTreeViewer().refresh();
                    if (OutlinePinMapView.this.padsFilter.getFilteredItemsCount() > 0) {
                        OutlinePinMapView.this.getTreeViewer().refresh();
                        OutlinePinMapView.this.getTreeViewer().expandAll();
                        List<TreeItem> items = this.getAllPADS(OutlinePinMapView.this.getTreeViewer());
                        if (items.size() > 0) {
                            OutlinePinMapView.this.setSelection((ISelection)new StructuredSelection(items.stream().map(it -> it.getData()).toList()));
                        } else {
                            OutlinePinMapView.this.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                } else {
                    OutlinePinMapView.this.getTreeViewer().refresh();
                    if (OutlinePinMapView.this.stringFilter.getFilteredItemsCount() > 0) {
                        OutlinePinMapView.this.getTreeViewer().expandToLevel(3);
                        List<TreeItem> items = this.getAllFunctions(OutlinePinMapView.this.stringFilter, OutlinePinMapView.this.getTreeViewer());
                        if (items.size() > 0) {
                            OutlinePinMapView.this.setSelection((ISelection)new StructuredSelection(items.stream().map(it -> it.getData()).toList()));
                        } else {
                            OutlinePinMapView.this.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                }
            }

            private List<TreeItem> getAllPADS(TreeViewer viewer) {
                TreeItem[] items;
                ArrayList<TreeItem> leaves = new ArrayList<TreeItem>();
                for (TreeItem item : items = viewer.getTree().getItems()) {
                    this.getAllPADS(item, leaves);
                }
                return leaves;
            }

            private void getAllPADS(TreeItem item, List<TreeItem> leaves) {
                if (item.getItemCount() == 0) {
                    leaves.add(item);
                } else {
                    for (TreeItem childItem : item.getItems()) {
                        this.getAllPADS(childItem, leaves);
                    }
                }
            }

            private List<TreeItem> getAllFunctions(OutlineStringFilter stringFilter, TreeViewer viewer) {
                TreeItem[] items;
                ArrayList<TreeItem> functions = new ArrayList<TreeItem>();
                for (TreeItem item : items = viewer.getTree().getItems()) {
                    this.getAllFunctions(item, functions);
                }
                return functions.stream().filter(it -> OutlineFunction.class.isInstance(it.getData())).toList();
            }

            private void getAllFunctions(TreeItem item, List<TreeItem> functions) {
                if (item.getItemCount() == 0) {
                    functions.add(item);
                } else {
                    for (TreeItem childItem : item.getItems()) {
                        this.getAllFunctions(childItem, functions);
                    }
                }
            }
        });
        this.filterText.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                OutlinePinMapView.this.resetSelection = true;
                OutlinePinMapView.this.setSelection((ISelection)StructuredSelection.EMPTY);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.treeViewer = new TreeViewer(this.container, this.getTreeStyle());
        this.treeViewer.setComparer(new IElementComparer(this){

            public int hashCode(Object element) {
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (OutlinePin.class.isInstance(a) && OutlinePin.class.isInstance(b)) {
                    String aName = ((OutlinePin)OutlinePin.class.cast(a)).getName();
                    String bName = ((OutlinePin)OutlinePin.class.cast(b)).getName();
                    return aName.equals(bName);
                }
                if (OutlinePeripheral.class.isInstance(a) && OutlinePeripheral.class.isInstance(b)) {
                    String aName = ((OutlinePeripheral)OutlinePeripheral.class.cast(a)).getName();
                    String bName = ((OutlinePeripheral)OutlinePeripheral.class.cast(b)).getName();
                    return aName.equals(bName);
                }
                if (OutlinePeripheralFamily.class.isInstance(a) && OutlinePeripheralFamily.class.isInstance(b)) {
                    String aName = ((OutlinePeripheralFamily)OutlinePeripheralFamily.class.cast(a)).getName();
                    String bName = ((OutlinePeripheralFamily)OutlinePeripheralFamily.class.cast(b)).getName();
                    return aName.equals(bName);
                }
                if (OutlineFunction.class.isInstance(a) && OutlineFunction.class.isInstance(b)) {
                    String aName = ((OutlineFunction)OutlineFunction.class.cast(a)).getName();
                    String bName = ((OutlineFunction)OutlineFunction.class.cast(b)).getName();
                    return aName.equals(bName);
                }
                return a.equals(b);
            }
        });
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().getControl().setLayoutData((Object)new GridData(1808));
        this.viewer = this.getTreeViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new OutlineFunctionsContentProvider(this.editor));
        OutlineFunctionsDecorator outlineDecorator = new OutlineFunctionsDecorator(this.viewer, this.editor, this.padsFilter, this.stringFilter);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewDecoratingStyledCellLabelProvider(new OutlineFunctionsLabelProvider(outlineDecorator), outlineDecorator, null));
        this.viewer.setComparator((ViewerComparator)new OutlineFunctionsSorter());
        this.treeViewer.resetFilters();
        this.treeViewer.addFilter((ViewerFilter)this.padsFilter);
        this.treeViewer.refresh();
        this.linkWithEditorAction = new LinkWithEditorAction(this);
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.linkWithEditorAction);
        this.getSite().getActionBars().updateActionBars();
    }

    private Package getCurrentPackage(EMFModelState state) {
        this._pinCfgHelper = PinCfgHelper.instance;
        if (PinCfgModelState.class.isInstance(state)) {
            PinCfgModelState pincfgState = (PinCfgModelState)PinCfgModelState.class.cast(state);
            PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
            Package p = this._pinCfgHelper.getPack(pinConfiguration.getPinSetting());
            return p;
        }
        return null;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void refresh(EMFModelState state, ISelection selection) {
        this.viewer = this.getTreeViewer();
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        Package pack = this.getCurrentPackage(state);
        if (pack != null && this.viewer != null && !this.viewer.getTree().isDisposed()) {
            if (this.viewer.getInput() != pack) {
                this.viewer.setInput((Object)pack);
            }
            this.enableFire = false;
            if (selection != null && !selection.isEmpty()) {
                if (this.editor.getDiagram().getInjector() == null) {
                    return;
                }
                if (!this.isLinkWithEditor()) {
                    return;
                }
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                ArrayList<Object> selections = new ArrayList<Object>();
                ArrayList<Object> expanded = new ArrayList<Object>();
                if (structuredSelection.getFirstElement() instanceof PinSetting) {
                    ArrayList<PinSetting> pinList = new ArrayList<PinSetting>();
                    pinList.add((PinSetting)structuredSelection.getFirstElement());
                    PinSetting ps = (PinSetting)structuredSelection.getFirstElement();
                    Peripheral peripheral = ps.getConfig().getAlt().getPeripheralRef();
                    if (peripheral != null) {
                        expanded.add(peripheral);
                        expanded.add(ps.getConfig().getAlt().getName());
                        selections.add(ps.getConfig().getAlt().getName());
                    }
                    if (selections.size() > 0) {
                        for (Object e : this.viewer.getExpandedElements()) {
                            expanded.add(e);
                        }
                        this.viewer.setExpandedElements(expanded.toArray());
                        this.viewer.setSelection((ISelection)new StructuredSelection(selections), true);
                    }
                } else if (structuredSelection.getFirstElement() instanceof Configuration) {
                    Configuration pad = (Configuration)structuredSelection.getFirstElement();
                    if (PinCfgModelState.class.isInstance(state)) {
                        PinCfgModelState pincfgState = (PinCfgModelState)PinCfgModelState.class.cast(state);
                        PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
                        List pinSettings = PinCfgHelper.getAllPinSettings((PinConfiguration)pinConfiguration);
                        for (PinSetting ps : pinSettings) {
                            if (!ps.getPad().getName().equals(pad.getName())) continue;
                            Function fct = ps.getConfig().getAlt();
                            Optional<OutlinePin> op = this.editor.getPins(fct).stream().filter(it -> it.getName().equals(pad.getName())).findFirst();
                            if (!op.isPresent()) break;
                            selections.add(op.get());
                            expanded.add(op.get());
                            break;
                        }
                    }
                    if (selections.size() > 0) {
                        for (Object e : this.viewer.getExpandedElements()) {
                            expanded.add(e);
                        }
                        this.viewer.setExpandedElements(expanded.toArray());
                        this.viewer.setSelection((ISelection)new StructuredSelection(selections), true);
                    }
                } else if (structuredSelection.getFirstElement() instanceof OutlinePin) {
                    OutlinePin pin = (OutlinePin)structuredSelection.getFirstElement();
                    for (Object e : this.viewer.getExpandedElements()) {
                        expanded.add(e);
                        selections.add(e);
                    }
                    expanded.add(pin);
                    this.viewer.setExpandedElements(expanded.toArray());
                    selections.add(pin);
                    this.viewer.setSelection((ISelection)new StructuredSelection(selections), true);
                }
            } else {
                this.viewer.refresh();
            }
            this.enableFire = true;
        }
    }

    public PinCfgGLSPDiagramEditor getEditor() {
        return this.editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.listener == null) {
            this.listener = new IdentifiableSelectionChangedListener(this.getSite().getPage().getActivePart());
            this.addSelectionChangedListener(this.listener);
        }
        if (!StructuredSelection.class.isInstance(event.getSelection())) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)StructuredSelection.class.cast(event.getSelection());
        if (this.enableFire) {
            this.fireSelectionChanged(event.getSelection());
        }
        if (this.resetSelection) {
            this.editor.updateMicro(new ResetSelection(), true);
            this.resetSelection = false;
            return;
        }
        if (TreeViewer.class.isInstance(event.getSource())) {
            this.editor.updateMicro(ss, true);
        } else {
            this.editor.updateMicro(ss, false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected int getTreeStyle() {
        return 770;
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (final ISelectionChangedListener l : this.selectionChangedListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(this){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public Control getControl() {
        return this.container;
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection, true);
        }
    }

    public void setLinkWithEditor(boolean link) {
        this.linkWithEditor = link;
    }

    public boolean isLinkWithEditor() {
        return this.linkWithEditor;
    }
}

