/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.editor.outline;

import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class OutlineStringFilter
extends ViewerFilter {
    String patternString = "";
    int filteredItemsCount = 0;

    public void setFilterString(String pattern) {
        this.patternString = pattern;
        this.filteredItemsCount = 0;
    }

    public int getFilteredItemsCount() {
        return this.filteredItemsCount;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.patternString == null || this.patternString.isEmpty()) {
            return true;
        }
        if (element instanceof OutlineFunction) {
            OutlinePin pin;
            OutlineFunction function = (OutlineFunction)element;
            List<OutlinePin> pins = function.getPinsList();
            boolean valid = this.wildcardMatch(function.getName());
            for (int j = 0; j < pins.size() && !valid; valid |= this.wildcardMatch(pin.getPad().getName()), ++j) {
                pin = pins.get(j);
            }
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePeripheral) {
            OutlinePeripheral peripheral = (OutlinePeripheral)element;
            boolean valid = this.wildcardMatch(peripheral.getName());
            List<OutlineFunction> functions = peripheral.getFunctionsList();
            for (OutlineFunction f : functions) {
                valid |= this.wildcardMatch(f.getName());
            }
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePeripheralFamily) {
            OutlinePeripheralFamily fam = (OutlinePeripheralFamily)element;
            boolean valid = this.wildcardMatch(fam.getName());
            List<OutlinePeripheral> peripherals = fam.getPeripheralList();
            for (OutlinePeripheral p : peripherals) {
                valid |= this.wildcardMatch(p.getName());
                List<OutlineFunction> functions = p.getFunctionsList();
                for (OutlineFunction f : functions) {
                    valid |= this.wildcardMatch(f.getName());
                }
            }
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePin) {
            OutlinePin op = (OutlinePin)element;
            Configuration pin = op.getPad();
            boolean valid = this.wildcardMatch(pin.getName());
            valid |= this.wildcardMatch(op.getParent().getName());
            valid |= this.wildcardMatch(op.getParent().getParent().getName());
            if (valid |= this.wildcardMatch(op.getParent().getParent().getParent().getName())) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        return true;
    }

    private boolean wildcardMatch(String text) {
        Object pattern = this.patternString;
        if (!((String)pattern).startsWith("*")) {
            pattern = "^*" + (String)pattern;
        }
        if (!((String)pattern).endsWith("*")) {
            pattern = (String)pattern + "*";
        }
        if (!((String)pattern).endsWith("$")) {
            pattern = (String)pattern + "$";
        }
        String lowerText = text.toLowerCase(Locale.ENGLISH);
        String lowerPattern = ((String)pattern).toLowerCase(Locale.ENGLISH);
        String regex = lowerPattern.replace("?", ".?").replace("*", ".*?");
        return lowerText.matches(regex);
    }
}

