/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.editor.outline.data;

import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.pincfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OutlinePeripheral {
    private Peripheral peripheral;
    private Set<OutlineFunction> functions;
    private OutlinePeripheralFamily fam;

    public OutlinePeripheral(OutlinePeripheralFamily fam, Peripheral periph) {
        this.peripheral = periph;
        this.fam = fam;
        this.functions = null;
    }

    public String getName() {
        return this.peripheral.getName();
    }

    public OutlinePeripheralFamily getParent() {
        return this.fam;
    }

    public Peripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean addFunction(OutlineFunction fct) {
        return this.functions.add(fct);
    }

    public List<OutlineFunction> getFunctionsList() {
        if (this.functions == null) {
            this.functions = new HashSet<OutlineFunction>();
            PinConfiguration pinConfiguration = this.getParent().getPinConfiguration();
            HashSet<Function> functionsList = new HashSet<Function>();
            for (Pin pin : this.getParent().getPackage().getPins()) {
                List configurablePins = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).collect(Collectors.toList());
                for (ConfigurablePin cfg : configurablePins) {
                    for (FunctionRef fctref : cfg.getRef().getFunctions()) {
                        functionsList.add(fctref.getName());
                    }
                }
            }
            functionsList.stream().filter(f -> f.getPeripheralRef() != null && f.getPeripheralRef().getName().equals(this.peripheral.getName())).forEach(f -> this.addFunction(new OutlineFunction(this, (Function)f)));
        }
        return Collections.unmodifiableList(this.functions.stream().toList());
    }

    public void dispose() {
        if (this.functions != null) {
            for (OutlineFunction f : this.functions) {
                f.dispose();
            }
            this.functions.clear();
            this.functions = null;
        }
    }
}

