/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server;

import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Direction;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GHtmlRoot;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPreRenderedElement;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.popup.PopupModelFactory;
import org.eclipse.glsp.server.features.popup.RequestPopupModelAction;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class PinCfgPopupModelFactory
implements PopupModelFactory {
    @Inject
    protected PinCfgModelState modelState;
    private static final String NL = "<br/>";

    public EObject getEObject(GModelElement element) {
        Optional selectedPinConfigs = this.modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> EObject.class.isInstance(it);
        java.util.function.Function<EObject, EObject> _function_1 = it -> (EObject)EObject.class.cast(it);
        Optional<EObject> ps = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        return ps.orElse(null);
    }

    public Pin lookupPin(GModelElement element) {
        Pin _xblockexpression = null;
        Optional selectedPinConfigs = this.modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> Configuration.class.isInstance(it);
        java.util.function.Function<EObject, Configuration> _function_1 = it -> (Configuration)Configuration.class.cast(it);
        Optional<Configuration> ps = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        Package pack = PinCfgHelper.instance.getPack(this.modelState.getPinConfiguration());
        Pin _xifexpression = null;
        boolean _isPresent = ps.isPresent();
        _xifexpression = _isPresent ? PinCfgHelper.instance.getPinForConfiguration(pack, ps.get()) : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public PinSetting lookupPinSetting(GModelElement element) {
        Optional selectedPinConfigs = this.modelState.getIndex().getEObject(element.getId());
        Predicate<EObject> _function = it -> Configuration.class.isInstance(it);
        java.util.function.Function<EObject, Configuration> _function_1 = it -> (Configuration)Configuration.class.cast(it);
        Optional<Configuration> selectedPin = selectedPinConfigs.stream().filter(_function).map(_function_1).findFirst();
        boolean _isPresent = selectedPin.isPresent();
        if (_isPresent) {
            PinConfiguration config = this.modelState.getPinConfiguration();
            List pins = PinCfgHelper.getAllPinSettings((PinConfiguration)config);
            Functions.Function1 _function_2 = it -> it.getPad().getName().equals(((Configuration)selectedPin.get()).getName());
            PinSetting ps = (PinSetting)IterableExtensions.findFirst((Iterable)pins, (Functions.Function1)_function_2);
            return ps;
        }
        return null;
    }

    protected String _generateBody(PinSetting ps) {
        if (ps == null) {
            return null;
        }
        return String.format("PinSetting: %s", ps.getName());
    }

    public String generateBody(Pin pin, PinSetting ps) {
        HashMap pinMap;
        HashMap tooltipMap;
        Function fct;
        String _xblockexpression = null;
        if (pin == null) {
            return null;
        }
        String psPeriph = "";
        String psFct = "";
        if (ps != null && (fct = ps.getConfig().getAlt()) != null) {
            psFct = fct.getName();
            psPeriph = fct.getPeripheralRef().getName();
        }
        if ((tooltipMap = (HashMap)(pinMap = new HashMap()).get(pin)) == null) {
            HashMap _hashMap = new HashMap();
            pinMap.put(pin, _hashMap);
            tooltipMap = (HashMap)pinMap.get(pin);
        }
        Object tooltips = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            Object tooltip = "";
            String periph = "";
            if (cfg instanceof SystemFunctionPin) {
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                periph = "System";
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip = tooltip;
                String _label = sfp.getRef().getLabel();
                String _plus = _label + " (";
                String _name = sfp.getDirection().getName();
                String _plus_1 = _plus + _name;
                String _plus_2 = _plus_1 + ")";
                String _plus_3 = _plus_2 + NL;
                tooltip = _oltip + _plus_3;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof SpecialPin) {
                SpecialPin sp = (SpecialPin)cfg;
                periph = "Special";
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip_1 = tooltip;
                String _label_1 = sp.getRef().getLabel();
                String _plus_4 = _label_1 + " (";
                String _name_1 = sp.getDirection().getName();
                String _plus_5 = _plus_4 + _name_1;
                String _plus_6 = _plus_5 + ")";
                Object _oltip_2 = tooltip = _oltip_1 + _plus_6;
                tooltip = (String)_oltip_2 + NL;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof ConfigurablePin) {
                boolean _lessThan;
                ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
                int _length = ((String)tooltips).length();
                boolean bl = _lessThan = _length < 1;
                if (_lessThan) {
                    String _name_2 = pin.getName();
                    String _plus_7 = "<b>" + _name_2;
                    String _plus_8 = (String)_plus_7 + ": ";
                    String _label_2 = sfp_1.getRef().getLabel();
                    String _plus_9 = _plus_8 + _label_2;
                    String _plus_10 = _plus_9 + "</b><br/><pre>";
                    tooltips = _plus_10;
                }
                EList _functions = sfp_1.getRef().getFunctions();
                for (FunctionRef c : _functions) {
                    String fctName;
                    boolean _equals;
                    periph = c.getName().getPeripheralRef().getName();
                    Object t = (String)tooltipMap.get(periph);
                    if (t == null) {
                        tooltipMap.put(periph, "");
                        t = (String)tooltipMap.get(periph);
                    }
                    if (_equals = (fctName = c.getName().getName()).equals(psFct)) {
                        String _t = t;
                        Direction _direction = c.getDirection();
                        String _plus_11 = "&#160;&#160;&#160;(" + String.valueOf(_direction);
                        String _plus_12 = _plus_11 + ") <b>";
                        String _plus_13 = _plus_12 + fctName;
                        String _plus_14 = _plus_13 + "</b><br/>";
                        t = _t + _plus_14;
                    } else {
                        String _t_1 = t;
                        Direction _direction_1 = c.getDirection();
                        String _plus_15 = "&#160;&#160;&#160;(" + String.valueOf(_direction_1);
                        String _plus_16 = _plus_15 + ") ";
                        String _plus_17 = _plus_16 + fctName;
                        String _plus_18 = _plus_17 + NL;
                        t = _t_1 + _plus_18;
                    }
                    tooltipMap.put(periph, t);
                }
                Object _oltip_3 = tooltip;
                String _get = (String)tooltipMap.get(periph);
                tooltip = (String)_oltip_3 + _get;
                Object _oltips = tooltips;
                tooltips = (String)_oltips + "</pre>";
                continue;
            }
            String _oltip_4 = tooltip;
            String _string = cfg.toString();
            String _plus_11 = "&#160;&#160;&#160;" + _string;
            String _plus_12 = _plus_11 + NL;
            tooltip = _oltip_4 + _plus_12;
        }
        Set _keySet = tooltipMap.keySet();
        for (String key : _keySet) {
            boolean _equals = key.equals(psPeriph);
            if (_equals) {
                String _oltips = tooltips;
                tooltips = _oltips + "<b>" + key + "</b><br/>";
            } else {
                String _oltips_1 = tooltips;
                tooltips = _oltips_1 + "<em>" + key + "</em><br/>";
            }
            Object _oltips_2 = tooltips;
            String _get = (String)tooltipMap.get(key);
            tooltips = (String)_oltips_2 + _get;
        }
        _xblockexpression = tooltips;
        return _xblockexpression;
    }

    protected String _generateBody(EObject ps) {
        return null;
    }

    protected String _generateTitle(PinSetting ps) {
        String _xblockexpression = null;
        if (ps == null) {
            return null;
        }
        _xblockexpression = String.format("Pad: %s<br/>Pin: %s<br/>Direction: %s", ps.getPad().getName(), ps.getPad().getName(), ps.getConfig().getDirection());
        return _xblockexpression;
    }

    protected String _generateTitle(EObject task) {
        return null;
    }

    public Optional<GHtmlRoot> createPopupModel(GModelElement element, RequestPopupModelAction action) {
        if (element != null) {
            boolean _not;
            boolean _popupState = this.modelState.getPopupState();
            boolean bl = _not = !_popupState;
            if (_not) {
                PinSetting pinSetting = this.lookupPinSetting(element);
                if (pinSetting != null) {
                    GHtmlRoot root = GraphFactory.eINSTANCE.createGHtmlRoot();
                    GBounds bounds = action.getBounds();
                    root.setCanvasBounds(GraphUtil.bounds((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight()));
                    root.setType("html");
                    root.setId("sprotty-popup");
                    String title = "";
                    GPreRenderedElement p1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                    p1.setType("pre-rendered");
                    p1.setId("popup-title");
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("<div class=\"sprotty-popup-title\">");
                    _builder.append("");
                    _builder.append("</div>");
                    p1.setCode(_builder.toString());
                    root.getChildren().add((Object)p1);
                    Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)pinSetting);
                    String body = this.generateBody(pin, pinSetting);
                    if (body != null) {
                        GPreRenderedElement p2 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                        p2.setType("pre-rendered");
                        p2.setId("popup-body");
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("<div class=\"sprotty-popup-body\">");
                        _builder_1.append(body);
                        _builder_1.append("</div>");
                        p2.setCode(_builder_1.toString());
                        root.getChildren().add((Object)p2);
                    }
                    return Optional.of(root);
                }
                Pin ps = this.lookupPin(element);
                if (ps != null) {
                    GHtmlRoot root_1 = GraphFactory.eINSTANCE.createGHtmlRoot();
                    GBounds bounds_1 = action.getBounds();
                    root_1.setCanvasBounds(GraphUtil.bounds((double)bounds_1.getX(), (double)bounds_1.getY(), (double)bounds_1.getWidth(), (double)bounds_1.getHeight()));
                    root_1.setType("html");
                    root_1.setId("sprotty-popup");
                    String title_1 = "";
                    GPreRenderedElement p1_1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                    p1_1.setType("pre-rendered");
                    p1_1.setId("popup-title");
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("<div class=\"sprotty-popup-title\">");
                    _builder_2.append("");
                    _builder_2.append("</div>");
                    p1_1.setCode(_builder_2.toString());
                    root_1.getChildren().add((Object)p1_1);
                    String body_1 = this.generateBody(ps, null);
                    if (body_1 != null) {
                        GPreRenderedElement p2_1 = GraphFactory.eINSTANCE.createGPreRenderedElement();
                        p2_1.setType("pre-rendered");
                        p2_1.setId("popup-body");
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("<div class=\"sprotty-popup-body\">");
                        _builder_3.append(body_1);
                        _builder_3.append("</div>");
                        p2_1.setCode(_builder_3.toString());
                        root_1.getChildren().add((Object)p2_1);
                    }
                    return Optional.of(root_1);
                }
            }
        }
        return Optional.empty();
    }

    @XbaseGenerated
    public String generateBody(EObject ps) {
        if (ps instanceof PinSetting) {
            return this._generateBody((PinSetting)ps);
        }
        if (ps != null) {
            return this._generateBody(ps);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ps).toString());
    }

    @XbaseGenerated
    public String generateTitle(EObject ps) {
        if (ps instanceof PinSetting) {
            return this._generateTitle((PinSetting)ps);
        }
        if (ps != null) {
            return this._generateTitle(ps);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ps).toString());
    }
}

