/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.handlers;

import com.st.stellar.pinmap.helpers.Pair;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinCfgFactory;
import com.st.stellar.pinmap.pinCfg.PinCfgPackage;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.operations.AssignPinFunctionOperation;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.server.emf.EMFOperationHandler;

public class AssignFunctionOperationHandler
extends EMFOperationHandler<AssignPinFunctionOperation> {
    public Optional<Command> createCommand(AssignPinFunctionOperation operation) {
        return this.assignFunctionToPin(operation.getPinConfiguration(), operation.getDirection(), operation.getPad(), operation.getFunction(), operation.getPinName());
    }

    private Optional<Command> assignFunctionToPin(PinConfiguration pinConfiguration, com.st.stellar.pinmap.pinmapDsl.Direction direction, Configuration pad, FunctionRef function, String pinName) {
        EditingDomain editingDomain = this.modelState.getEditingDomain();
        StrictCompoundCommand strictCompoundCommand = new StrictCompoundCommand();
        EList modules = pinConfiguration.getPinSetting().getModules();
        if (function == null) {
            block10: for (Module mod : modules) {
                EList pins = mod.getPins();
                for (PinSetting ps : pins) {
                    if (!ps.getPad().getName().equals(pad.getName())) continue;
                    Command commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)PinCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                    strictCompoundCommand.append(commandRemovePin);
                    if (pins.size() >= 2) continue block10;
                    Command commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod.eContainer(), (Object)PinCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)mod);
                    strictCompoundCommand.append(commandRemoveModule);
                    continue block10;
                }
            }
        } else {
            Module previousModule = null;
            block12: for (Module mod : modules) {
                if (previousModule != null) break;
                for (PinSetting ps : mod.getPins()) {
                    if (!ps.getPad().getName().equals(pad.getName())) continue;
                    previousModule = mod;
                    continue block12;
                }
            }
            String text = "assign pad " + pad.getName() + "' to function '" + String.valueOf(function.getName()) + "' as '" + pinName + "' (direction = '" + direction.getLiteral() + "')";
            System.out.println(text);
            Peripheral periph = function.getName().getPeripheralRef();
            Optional<Module> module = pinConfiguration.getPinSetting().getModules().stream().filter(it -> it.getName().getName().equals(periph.getName())).findFirst();
            Optional<PinSetting> alreadyDefinedPinSetting = PinCfgHelper.getAllPinSettings((PinConfiguration)pinConfiguration).stream().filter(it -> it.getConfig().getAlt().getName().equals(function.getName().getName())).findFirst();
            Module mod = null;
            if (module.isPresent()) {
                mod = module.get();
                if (alreadyDefinedPinSetting.isPresent()) {
                    Command removePreviousPinSetting = RemoveCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)PinCfgPackage.eINSTANCE.getModule_Pins(), (Object)alreadyDefinedPinSetting.get());
                    strictCompoundCommand.append(removePreviousPinSetting);
                }
                if (previousModule != null && mod != previousModule) {
                    pins = previousModule.getPins();
                    for (PinSetting ps : pins) {
                        if (!ps.getPad().getName().equals(pad.getName())) continue;
                        commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule, (Object)PinCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                        strictCompoundCommand.append(commandRemovePin);
                        break;
                    }
                    if (previousModule.getPins().size() < 2) {
                        Iterator commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule.eContainer(), (Object)PinCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)previousModule);
                        strictCompoundCommand.append((Command)commandRemoveModule);
                    }
                }
            } else {
                if (previousModule != null) {
                    pins = previousModule.getPins();
                    for (PinSetting ps : pins) {
                        if (!ps.getPad().getName().equals(pad.getName())) continue;
                        commandRemovePin = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule, (Object)PinCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                        strictCompoundCommand.append(commandRemovePin);
                    }
                }
                if (previousModule != null && previousModule.getPins().size() < 2) {
                    Command commandRemoveModule = RemoveCommand.create((EditingDomain)editingDomain, (Object)previousModule.eContainer(), (Object)PinCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)previousModule);
                    strictCompoundCommand.append(commandRemoveModule);
                }
                mod = PinCfgFactory.eINSTANCE.createModule();
                PinSettings settings = pinConfiguration.getPinSetting();
                Command command = AddCommand.create((EditingDomain)editingDomain, (Object)settings, (Object)PinCfgPackage.eINSTANCE.getPinSettings_Modules(), (Object)mod);
                strictCompoundCommand.append(command);
                Command commandSetModuleName = SetCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)PinCfgPackage.eINSTANCE.getModule_Name(), (Object)periph);
                strictCompoundCommand.append(commandSetModuleName);
            }
            PinProperties config = null;
            boolean newConfig = false;
            Optional<PinSetting> pp = mod.getPins().stream().filter(it -> it.getPad().equals((Object)pad) || it.getName().equals(pinName)).findFirst();
            PinSetting ps = null;
            if (pp.isEmpty()) {
                config = PinCfgFactory.eINSTANCE.createPinProperties();
                newConfig = true;
                ps = PinCfgFactory.eINSTANCE.createPinSetting();
            } else if (alreadyDefinedPinSetting.isPresent()) {
                config = PinCfgFactory.eINSTANCE.createPinProperties();
                newConfig = true;
                ps = PinCfgFactory.eINSTANCE.createPinSetting();
            } else {
                ps = pp.get();
                config = ps.getConfig();
            }
            Command commandSetPSName = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)PinCfgPackage.eINSTANCE.getPinSetting_Name(), (Object)pinName);
            strictCompoundCommand.append(commandSetPSName);
            Command commandSetPSPin = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)PinCfgPackage.eINSTANCE.getPinSetting_Pad(), (Object)pad);
            strictCompoundCommand.append(commandSetPSPin);
            Command commandSetAlt = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Alt(), (Object)function.getName());
            strictCompoundCommand.append(commandSetAlt);
            switch (direction) {
                case INPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)Direction.INPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case INPUT_OR_OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)Direction.INPUT_OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case INPUT_ALTERNATE: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)Direction.INPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case GROUND: {
                    break;
                }
                case INPUT_OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)Direction.INPUT_OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case OUTPUT: {
                    Command commandSetDirection = SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)PinCfgPackage.eINSTANCE.getPinProperties_Direction(), (Object)Direction.OUTPUT);
                    strictCompoundCommand.append(commandSetDirection);
                    break;
                }
                case OUTPUT_ALTERNATE: {
                    break;
                }
                case POWER: {
                    break;
                }
            }
            IOFields iofields = PinCfgFactory.eINSTANCE.createIOFields();
            Command commandSetIOFields = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)PinCfgPackage.eINSTANCE.getPinSetting_IoFields(), (Object)iofields);
            strictCompoundCommand.append(commandSetIOFields);
            PinCfgHelper hlp = PinCfgHelper.instance;
            ArrayList fieldsList = new ArrayList();
            List registers = hlp.getDefaultFieldInstanceList(pinConfiguration, pad, function, fieldsList);
            for (Pair pair : registers) {
                FieldInstance reg = PinCfgFactory.eINSTANCE.createFieldInstance();
                Command commandSetAttr = SetCommand.create((EditingDomain)editingDomain, (Object)reg, (Object)PinCfgPackage.eINSTANCE.getFieldInstance_Attr(), (Object)pair.getKey());
                strictCompoundCommand.append(commandSetAttr);
                Command commandSetValue = SetCommand.create((EditingDomain)editingDomain, (Object)reg, (Object)PinCfgPackage.eINSTANCE.getFieldInstance_Value(), (Object)pair.getValue());
                strictCompoundCommand.append(commandSetValue);
                Command commandAddRegister1 = AddCommand.create((EditingDomain)editingDomain, (Object)iofields, (Object)PinCfgPackage.eINSTANCE.getIOFields_Reg(), (Object)reg);
                strictCompoundCommand.append(commandAddRegister1);
            }
            if (newConfig) {
                Command commandSetConfig = SetCommand.create((EditingDomain)editingDomain, (Object)ps, (Object)PinCfgPackage.eINSTANCE.getPinSetting_Config(), (Object)config);
                strictCompoundCommand.append(commandSetConfig);
                Command commandSetPins = AddCommand.create((EditingDomain)editingDomain, (Object)mod, (Object)PinCfgPackage.eINSTANCE.getModule_Pins(), (Object)ps);
                strictCompoundCommand.append(commandSetPins);
            }
        }
        if (strictCompoundCommand.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(strictCompoundCommand);
    }
}

