/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.st.stellar.pinmap.generator.GeneratePinmapView;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Direction;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import com.st.stellar.pinmap.validation.PinCfgValidationMessageAcceptor;
import com.st.stellar.pinmap.validation.PinCfgValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class GeneratePinSettings {
    @Inject
    @Extension
    private Utils _utils;
    private final GeneratePinmapView genPinmapView = new GeneratePinmapView();
    public final int pinWidthLQFP = 24;
    public final int pinHeightLQFP = 12;
    public final int pinMarginWidthLQFP = 7;
    public final int pinMarginHeightLQFP = 3;
    public final int fontSizeLQFP = this.pinWidthLQFP / 2;
    public final int generalOffsetXLQFP = -25;
    public final int generalOffsetYLQFP = -15;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    protected StringBuilder errors;
    protected StringBuilder warnings;
    protected static final LinkedHashMap<Direction, String> directionNames = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[]{Pair.of((Object)Direction.INPUT, (Object)"in"), Pair.of((Object)Direction.OUTPUT, (Object)"out"), Pair.of((Object)Direction.INPUT_OUTPUT, (Object)"inout"), Pair.of((Object)Direction.INPUT_OR_OUTPUT, (Object)"inout"), Pair.of((Object)Direction.GROUND, (Object)"ground"), Pair.of((Object)Direction.POWER, (Object)"power"), Pair.of((Object)Direction.INPUT_ALTERNATE, (Object)""), Pair.of((Object)Direction.OUTPUT_ALTERNATE, (Object)"")});

    public GeneratePinSettings() {
        StringBuilder _stringBuilder_1;
        StringBuilder _stringBuilder;
        this.errors = _stringBuilder = new StringBuilder("errors:\n");
        this.warnings = _stringBuilder_1 = new StringBuilder("warnings:\n");
    }

    public StringBuilder error(String message) {
        return this.errors.append("error: " + message + "\n");
    }

    public StringBuilder warning(String message) {
        return this.warnings.append("warning: " + message + "\n");
    }

    public StringBuilder generateReport() {
        return this.errors.append((CharSequence)this.warnings);
    }

    public boolean generatePins(GModelElement newRoot, PinCfgModelState modelState, PinConfiguration pinConfiguration) {
        return false;
    }

    public boolean isBoardPin(PinSetting pin) {
        this._pinCfgHelper = PinCfgHelper.instance;
        EObject _eContainer = pin.eContainer().eContainer();
        return _eContainer instanceof Board;
    }

    public boolean addConfiguredPin(Package pack, GModelElement newRoot, PinCfgModelState modelState, PinSetting pin, PinSettingsErrorManager errorsMap) {
        return false;
    }

    public GModelElement generatePackage(GModelElement newRoot, PinCfgModelState modelState, Package p, List<PinSetting> configuredPins, String additional) {
        return null;
    }

    public String getTooltip(Pin pin) {
        String _xblockexpression = null;
        Object tooltip = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            if (cfg instanceof SystemFunctionPin) {
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                String _oltip = tooltip;
                String _label = sfp.getRef().getLabel();
                String _plus = _label + " (";
                String _name = sfp.getDirection().getName();
                String _plus_1 = _plus + _name;
                String _plus_2 = _plus_1 + ")";
                Object _oltip_1 = tooltip = _oltip + _plus_2;
                tooltip = (String)_oltip_1 + "<br/>";
                continue;
            }
            if (cfg instanceof SpecialPin) {
                SpecialPin sp = (SpecialPin)cfg;
                String _oltip_2 = tooltip;
                String _label_1 = sp.getRef().getLabel();
                String _plus_3 = _label_1 + " (";
                String _name_1 = sp.getDirection().getName();
                String _plus_4 = _plus_3 + _name_1;
                String _plus_5 = _plus_4 + ")";
                Object _oltip_3 = tooltip = _oltip_2 + _plus_5;
                tooltip = (String)_oltip_3 + "<br/>";
                continue;
            }
            if (cfg instanceof ConfigurablePin) {
                ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
                String _oltip_4 = tooltip;
                String _name_2 = pin.getName();
                String _plus_6 = "<b>" + _name_2;
                String _plus_7 = _plus_6 + ": ";
                String _label_2 = sfp_1.getRef().getLabel();
                String _plus_8 = _plus_7 + _label_2;
                String _plus_9 = _plus_8 + "</b><br/><pre>";
                tooltip = _oltip_4 + _plus_9;
                EList _functions = sfp_1.getRef().getFunctions();
                for (FunctionRef c : _functions) {
                    Object _oltip_5 = tooltip;
                    String _name_3 = c.getName().getName();
                    String _plus_10 = "   " + _name_3;
                    String _plus_11 = _plus_10 + "<br/>";
                    tooltip = (String)_oltip_5 + _plus_11;
                }
                Object _oltip_6 = tooltip;
                tooltip = (String)_oltip_6 + "</pre>";
                continue;
            }
            String _oltip_7 = tooltip;
            String _string = cfg.toString();
            String _plus_12 = "   " + _string;
            String _plus_13 = _plus_12 + "<br/>";
            tooltip = _oltip_7 + _plus_13;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("onmousemove=\"showTooltip(evt, '");
        _builder.append((String)tooltip, " ");
        _builder.append("');\" onmouseout=\"hideTooltip();\"");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public boolean relatedToPinSetting(Diagnostic diag, PinSetting ps) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        if (ps == null) {
            return false;
        }
        PinProperties _config = ps.getConfig();
        boolean bl = _tripleEquals = _config == null;
        if (_tripleEquals) {
            return false;
        }
        IOFields _ioFields = ps.getIoFields();
        boolean bl2 = _tripleEquals_1 = _ioFields == null;
        if (_tripleEquals_1) {
            return false;
        }
        boolean res = false;
        ArrayList objList = CollectionLiterals.newArrayList();
        objList.add(ps);
        objList.add(ps.getConfig());
        objList.add(ps.getIoFields());
        EList _reg = ps.getIoFields().getReg();
        for (FieldInstance reg : _reg) {
            objList.add(reg);
        }
        boolean _contains = objList.contains(diag.getData().get(0));
        if (_contains) {
            res = true;
        }
        return res;
    }

    public PinSettingsErrorManager generateErrors(GModelElement newRoot, PinCfgModelState modelState, List<PinSetting> configuredPins) {
        PinConfiguration pinConfiguration = modelState.pinConfiguration;
        PinSettingsErrorManager errorManager = new PinSettingsErrorManager();
        PinCfgValidator.checkNoDuplicatedPinNames((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        PinCfgValidator.checkUniqueFunctionUsage((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        PinCfgValidator.checkPinAlreadyUsed((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        for (PinSetting ps : configuredPins) {
            int _size;
            boolean _greaterThan;
            ArrayList diags = new ArrayList();
            PinCfgValidator.checkMissingRegInstances((PinSetting)ps, (PinCfgValidationMessageAcceptor)errorManager);
            boolean _isBoardPin = this.isBoardPin(ps);
            if (_isBoardPin) {
                Diagnostic errorCfg = Diagnostician.INSTANCE.validate((EObject)pinConfiguration);
                List errorsCfg = errorCfg.getChildren();
                Functions.Function1 _function = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsCfg, (Functions.Function1)_function));
                for (Diagnostic e : errorsCfg) {
                    Functions.Function1 _function_1 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e.getChildren(), (Functions.Function1)_function_1));
                }
            } else {
                Diagnostic errorPs = Diagnostician.INSTANCE.validate((EObject)ps);
                List errorsPs = errorPs.getChildren();
                Functions.Function1 _function_2 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsPs, (Functions.Function1)_function_2));
                for (Diagnostic e_1 : errorsPs) {
                    Functions.Function1 _function_3 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e_1.getChildren(), (Functions.Function1)_function_3));
                }
            }
            if (!(_greaterThan = (_size = diags.size()) > 0)) continue;
            Functions.Function1 _function_4 = d -> {
                int _severity = d.getSeverity();
                return _severity == 4;
            };
            Functions.Function1 _function_5 = it -> it.getMessage();
            Consumer<String> _function_6 = it -> errorManager.errors.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_4), (Functions.Function1)_function_5).forEach(_function_6);
            Functions.Function1 _function_7 = d -> {
                int _severity = d.getSeverity();
                return _severity == 2;
            };
            Functions.Function1 _function_8 = it -> it.getMessage();
            Consumer<String> _function_9 = it -> errorManager.warnings.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_7), (Functions.Function1)_function_8).forEach(_function_9);
            Functions.Function1 _function_10 = d -> {
                int _severity = d.getSeverity();
                return _severity == 1;
            };
            Functions.Function1 _function_11 = it -> it.getMessage();
            Consumer<String> _function_12 = it -> errorManager.infos.put((Object)ps, it);
            IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_10), (Functions.Function1)_function_11).forEach(_function_12);
        }
        return errorManager;
    }

    public static class PinSettingsErrorManager
    extends PinCfgValidationMessageAcceptor {
        public final Multimap<EObject, String> errors = HashMultimap.create();
        public final Multimap<EObject, String> infos = HashMultimap.create();
        public final Multimap<EObject, String> warnings = HashMultimap.create();

        public PinSettingsErrorManager() {
            super(null);
            this.acceptsExternalResource(true);
        }

        public void collectError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.errors.put((Object)object, (Object)message);
        }

        public void collectError(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.errors.put((Object)object, (Object)message);
        }

        public void collectInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.infos.put((Object)object, (Object)message);
        }

        public void collectInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.infos.put((Object)object, (Object)message);
        }

        public void collectWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
            this.warnings.put((Object)object, (Object)message);
        }

        public void collectWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
            this.warnings.put((Object)object, (Object)message);
        }
    }
}

