/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.model;

import com.google.inject.Inject;
import com.st.stellar.pinmap.generator.GeneratePinmapView;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.GeneratePinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinNodeBuilder;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PreferenceManager;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.NotConnectedPin;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;
import org.eclipse.glsp.graph.builder.impl.GLayoutOptions;
import org.eclipse.glsp.graph.builder.impl.GNodeBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GeneratePinSettingsBGA
extends GeneratePinSettings {
    @Inject
    @Extension
    private Utils _utils;
    private final GeneratePinmapView genPinmapView = new GeneratePinmapView();
    public final int pinWidthBGA = 40;
    public final int pinHeightBGA = 40;
    public final int pinMarginWidthBGA = 3;
    public final int pinMarginHeightBGA = 3;
    public final int fontSizeBGA;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    private final String rowLetters = "A,B,C,D,E,F,G,H,J,K,L,M,N,P,R,T,U,V,W,Y,AA,AB,AC,AD,AE,AF,AG,AH,AJ,AK";
    private final List<String> rowLettersListOrdered;
    private final List<String> rowLettersList;
    public List<String> rowEnabledLetters;
    private int deltaY;

    public GeneratePinSettingsBGA() {
        Objects.requireNonNull(this);
        this.fontSizeBGA = 40 / 3;
        this.rowLetters = "A,B,C,D,E,F,G,H,J,K,L,M,N,P,R,T,U,V,W,Y,AA,AB,AC,AD,AE,AF,AG,AH,AJ,AK";
        this.rowLettersListOrdered = Arrays.asList(this.rowLetters.split(","));
        this.rowLettersList = ListExtensions.reverseView(this.rowLettersListOrdered);
        this.rowEnabledLetters = new ArrayList<String>();
    }

    @Override
    public boolean generatePins(GModelElement newRoot, PinCfgModelState modelState, PinConfiguration pinConfiguration) {
        boolean _greaterThan;
        this._pinCfgHelper = PinCfgHelper.instance;
        this._utils = Utils.instance;
        EList modules = PinCfgHelper.getAllModules((PinSettings)pinConfiguration.getPinSetting());
        Package pack = this._pinCfgHelper.getPack(pinConfiguration);
        int _size = modules.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getPins();
            List configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)modules, (Functions.Function1)_function));
            GModelElement packageNode = this.generatePackage(newRoot, modelState, pack, configuredPins, "");
            GeneratePinSettings.PinSettingsErrorManager errorsMap = this.generateErrors(packageNode, modelState, configuredPins);
            boolean status = true;
            for (PinSetting pin : configuredPins) {
                status = status && this.addConfiguredPin(pack, packageNode, modelState, pin, errorsMap);
            }
            return status;
        }
        GModelElement _generatePackage = this.generatePackage(newRoot, modelState, this._pinCfgHelper.getPack(pinConfiguration.getPinSetting()), CollectionLiterals.newArrayList(), "");
        return _generatePackage != null;
    }

    @Override
    public boolean addConfiguredPin(Package pack, GModelElement newRoot, PinCfgModelState modelState, PinSetting ps, GeneratePinSettings.PinSettingsErrorManager errorsMap) {
        try {
            Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)ps);
            int _x = this.genPinmapView.getX(pin);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int _multiply = _x * (40 + 3);
            Objects.requireNonNull(this);
            int x = _multiply - 40 / 2;
            int _y = this.genPinmapView.getY(pin);
            int _minus = _y - this.deltaY;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int _multiply_1 = _minus * (40 + 3);
            Objects.requireNonNull(this);
            int y = _multiply_1 + 3 * 40 / 4;
            String id = modelState.getIndex().indexEObject((EObject)ps.getPad());
            Configuration config = ps.getPad();
            ArrayList cssClasses = CollectionLiterals.newArrayList();
            ArrayList nodeClasses = CollectionLiterals.newArrayList();
            boolean _isBoardPin = this.isBoardPin(ps);
            if (_isBoardPin) {
                cssClasses.add("board");
            } else {
                cssClasses.add("cPin");
            }
            PinNodeBuilder pinNode = null;
            String padName = this._utils.getCfgName((EObject)config, 4);
            Collection errors = errorsMap.errors.get((Object)ps);
            Collection warnings = errorsMap.warnings.get((Object)ps);
            Collection infos = errorsMap.infos.get((Object)ps);
            Functions.Function1 _function = it -> it.getId().equals(id);
            GModelElement graphObject = (GModelElement)IterableExtensions.findFirst((Iterable)newRoot.getChildren(), (Functions.Function1)_function);
            if (graphObject == null) {
                if (errors.size() > 0 || warnings.size() > 0 || infos.size() > 0) {
                    boolean _greaterThan;
                    PinNodeBuilder _pinNodeBuilder;
                    pinNode = _pinNodeBuilder = new PinNodeBuilder("pin-error");
                    pinNode.addArgument("name", ps.getPad().getName());
                    int _size = errors.size();
                    boolean bl = _greaterThan = _size > 0;
                    if (_greaterThan) {
                        pinNode.addArgument("error", IterableExtensions.join((Iterable)errors, (CharSequence)","));
                        nodeClasses.add("error");
                        cssClasses.add("error");
                    } else {
                        boolean _greaterThan_1;
                        int _size_1 = warnings.size();
                        boolean bl2 = _greaterThan_1 = _size_1 > 0;
                        if (_greaterThan_1) {
                            pinNode.addArgument("warning", IterableExtensions.join((Iterable)warnings, (CharSequence)","));
                            nodeClasses.add("warning");
                            cssClasses.add("warning");
                        } else {
                            boolean _greaterThan_2;
                            int _size_2 = infos.size();
                            boolean bl3 = _greaterThan_2 = _size_2 > 0;
                            if (_greaterThan_2) {
                                pinNode.addArgument("info", IterableExtensions.join((Iterable)infos, (CharSequence)","));
                                nodeClasses.add("info");
                                cssClasses.add("info");
                            }
                        }
                    }
                    GLabelBuilder _id = (GLabelBuilder)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").addCssClass("configured-text")).text(padName)).id(id + "_pin_label");
                    int _length = padName.length();
                    int _minus_1 = 4 - _length;
                    int _multiply_2 = _minus_1 * 2;
                    int _plus = _multiply_2 + 6;
                    EList eList = newRoot.getChildren();
                    PinNodeBuilder pinNodeBuilder = (PinNodeBuilder)((PinNodeBuilder)pinNode.id(id)).addCssClasses(cssClasses);
                    double d = _plus;
                    Objects.requireNonNull(this);
                    int n = 40 / 4;
                    Objects.requireNonNull(this);
                    PinNodeBuilder pinNodeBuilder2 = (PinNodeBuilder)pinNodeBuilder.add(((GLabelBuilder)_id.position(d, (double)(n + 3))).build());
                    Objects.requireNonNull(this);
                    Objects.requireNonNull(this);
                    eList.add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNodeBuilder2.size(40.0, 40.0)).position(x, y)).build());
                } else {
                    pinNode = (PinNodeBuilder)new PinNodeBuilder("pin").id(id);
                    pinNode.addArgument("name", ps.getPad().getName());
                    GLabelBuilder _id_1 = (GLabelBuilder)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("pin-name").addCssClass("configured-text")).text(padName)).id(id + "_pin_label");
                    int _length_1 = padName.length();
                    int _minus_2 = 4 - _length_1;
                    int _multiply_3 = _minus_2 * 2;
                    int _plus_1 = _multiply_3 + 6;
                    EList eList = newRoot.getChildren();
                    PinNodeBuilder pinNodeBuilder = (PinNodeBuilder)pinNode.addCssClasses(cssClasses);
                    double d = _plus_1;
                    Objects.requireNonNull(this);
                    int n = 40 / 4;
                    Objects.requireNonNull(this);
                    PinNodeBuilder pinNodeBuilder3 = (PinNodeBuilder)pinNodeBuilder.add(((GLabelBuilder)_id_1.position(d, (double)(n + 3))).build());
                    Objects.requireNonNull(this);
                    Objects.requireNonNull(this);
                    eList.add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNodeBuilder3.size(40.0, 40.0)).position(x, y)).build());
                }
            } else {
                InputOutput.println((Object)"coucou");
            }
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void generateLegend(GModelElement newRoot, PinCfgModelState modelState, double width) {
        this._pinCfgHelper = PinCfgHelper.instance;
        PinNodeBuilder node = (PinNodeBuilder)((PinNodeBuilder)new PinNodeBuilder("legend").position(width - 150.0, -60.0)).id("legend");
        node.addArgument("width", width);
        String state = this.getCurrentLegendState(modelState);
        node.addArgument("state", state);
        newRoot.getChildren().add((Object)node.build());
    }

    public String getCurrentLegendState(PinCfgModelState modelState) {
        String _xblockexpression = null;
        String key = modelState.getPinConfiguration().eResource().getURI().path();
        _xblockexpression = PreferenceManager.getPreference(key, "false");
        return _xblockexpression;
    }

    @Override
    public GModelElement generatePackage(GModelElement newRoot, PinCfgModelState modelState, Package p, List<PinSetting> configuredPins, String additional) {
        GNode _xtrycatchfinallyexpression = null;
        try {
            int i;
            int _minus;
            GNode _xblockexpression = null;
            GNode res = null;
            String id = modelState.getIndex().indexEObject((EObject)p);
            int nbColumns = 0;
            EList _pins = p.getPins();
            for (Pin pin : _pins) {
                String pName = pin.getName();
                String letter = pName.replaceAll("[0-9]", "");
                int _indexOf = this.rowLettersListOrdered.indexOf(letter);
                int _plus = _indexOf + 1;
                nbColumns = Math.max(nbColumns, _plus);
            }
            ++nbColumns;
            for (int i2 = 1; i2 < nbColumns; ++i2) {
                String letter = this.rowLettersListOrdered.get(i2 - 1);
                this.rowEnabledLetters.add(letter);
            }
            int _length = ((Object[])Conversions.unwrapArray(this.rowLettersList, Object.class)).length;
            int _length_1 = ((Object[])Conversions.unwrapArray(this.rowEnabledLetters, Object.class)).length;
            this.deltaY = _minus = _length - _length_1;
            int nbRows = nbColumns;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int width = (40 + 3) * nbColumns;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int height = (40 + 3) * nbRows;
            ArrayList cssClasses = CollectionLiterals.newArrayList();
            cssClasses.add("gpiocfg-package");
            GLabelBuilder _gLabelBuilder = new GLabelBuilder("package-name");
            EObject _eContainer = p.eContainer();
            String _label = ((Family)_eContainer).getLabel();
            String _name = p.getName();
            String _plus = _label + _name;
            GLabelBuilder gLabelBuilder = (GLabelBuilder)((GLabelBuilder)((GLabelBuilder)_gLabelBuilder.text(_plus)).id("packageId")).addCssClasses((List)cssClasses);
            double d = width / 2;
            Objects.requireNonNull(this);
            GLabelBuilder packageName = (GLabelBuilder)gLabelBuilder.position(d, (double)(-2 * 40));
            newRoot.getChildren().add((Object)packageName.build());
            GNodeBuilder packageNodeBuilder = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("package").id(id)).addCssClass("pincfg-package")).size((double)width, (double)height)).position(0.0, 0.0);
            GNode packageNode = (GNode)packageNodeBuilder.build();
            this.generateLegend(newRoot, modelState, width);
            res = packageNode;
            newRoot.getChildren().add((Object)res);
            EList _pins_1 = p.getPins();
            for (Pin pin_1 : _pins_1) {
                PinConfig _get = (PinConfig)pin_1.getPinConfigurations().get(0);
                PinConfig config = _get;
                if (config instanceof NotConnectedPin) continue;
                this.generatePin((GModelElement)res, modelState, configuredPins, pin_1);
            }
            for (i = 1; i < nbColumns; ++i) {
                EList eList = newRoot.getChildren();
                GNodeBuilder gNodeBuilder = (GNodeBuilder)((GNodeBuilder)new GNodeBuilder("axis-index").add(((GLabelBuilder)new GLabelBuilder("label").text(String.valueOf(i))).build())).addCssClass("axis-index-north");
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                eList.add((Object)((GNodeBuilder)gNodeBuilder.position((double)(i * (40 + 3) - 5), -12.0)).build());
                EList eList2 = newRoot.getChildren();
                GNodeBuilder gNodeBuilder2 = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("axis-index").addCssClass("axis-index-south")).add(((GLabelBuilder)new GLabelBuilder("label").text(String.valueOf(i))).build())).layout("vbox", Map.of("paddingRight", 5));
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                double d2 = i * (40 + 3) - 5;
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                eList2.add((Object)((GNodeBuilder)gNodeBuilder2.position(d2, (double)((40 + 3) * (nbRows + 1) - 40 + 8))).build());
            }
            for (i = this.rowEnabledLetters.size(); i > 0; --i) {
                String indexName = this.rowLettersList.get(i + this.deltaY - 1);
                GLabelBuilder _text = (GLabelBuilder)new GLabelBuilder("label").text(indexName);
                int _length_2 = indexName.length();
                int _multiply = _length_2 * 5;
                int _minus_1 = 30 - _multiply;
                EList eList = newRoot.getChildren();
                GNodeBuilder gNodeBuilder = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("axis-index").addCssClass("axis-index-west")).add(((GLabelBuilder)_text.position((double)_minus_1, 0.0)).build())).layout("hbox")).layoutOptions((Map)new GLayoutOptions().vAlign("center"));
                Objects.requireNonNull(this);
                int n = -40;
                Objects.requireNonNull(this);
                double d3 = n + 3;
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                eList.add((Object)((GNodeBuilder)gNodeBuilder.position(d3, (double)(i * (40 + 3)))).build());
                EList eList3 = newRoot.getChildren();
                GNodeBuilder gNodeBuilder3 = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("axis-index").addCssClass("axis-index-east")).add(((GLabelBuilder)new GLabelBuilder("label").text(indexName)).build())).layout("hbox", Map.of("hAlign", 0));
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                double d4 = (40 + 3) * (nbRows + 1) - 40 + 3;
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                eList3.add((Object)((GNodeBuilder)gNodeBuilder3.position(d4, (double)(i * (40 + 3)))).build());
            }
            _xtrycatchfinallyexpression = _xblockexpression = res;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public int getX(Pin pin) {
        int _xblockexpression = 0;
        String id = pin.getName();
        String number = id.replaceAll("[a-zA-Z]", "");
        _xblockexpression = Integer.parseInt(number);
        return _xblockexpression;
    }

    public int getY(Pin pin) {
        int _xblockexpression = 0;
        String id = pin.getName();
        String letter = id.replaceAll("[0-9]", "");
        int _indexOf = this.rowLettersList.indexOf(letter);
        _xblockexpression = _indexOf - this.deltaY;
        return _xblockexpression;
    }

    public boolean generatePin(GModelElement newRoot, PinCfgModelState modelState, List<PinSetting> configuredPins, Pin pin) {
        PinConfig _get;
        boolean _xblockexpression = false;
        String type = null;
        PinSetting foundPin = null;
        PinConfig config = _get = (PinConfig)pin.getPinConfigurations().get(0);
        String idd = modelState.getIndex().indexEObject((EObject)pin);
        String name = pin.getName();
        boolean _isInstance = SpecialPin.class.isInstance(config);
        if (_isInstance) {
            type = "special-pin";
        } else {
            boolean _isInstance_1 = SystemFunctionPin.class.isInstance(config);
            if (_isInstance_1) {
                type = "systemfunction-pin";
            } else {
                boolean _isInstance_2 = ConfigurablePin.class.isInstance(config);
                if (_isInstance_2) {
                    ConfigurablePin cfg = (ConfigurablePin)ConfigurablePin.class.cast(config);
                    idd = modelState.getIndex().indexEObject((EObject)cfg.getRef());
                    name = cfg.getRef().getName();
                    Functions.Function1 _function = it -> it.getPad().getName().equals(cfg.getRef().getName());
                    foundPin = (PinSetting)IterableExtensions.findFirst(configuredPins, (Functions.Function1)_function);
                    if (foundPin == null) {
                        type = "configurable-pin";
                    }
                }
            }
        }
        boolean _xifexpression = false;
        if (type != null) {
            boolean _xblockexpression_1 = false;
            String padName = this._utils.getCfgName((EObject)config, 4);
            int _x = this.genPinmapView.getX(pin);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int _multiply = _x * (40 + 3);
            Objects.requireNonNull(this);
            int x = _multiply - 40 / 2;
            int _y = this.genPinmapView.getY(pin);
            int _minus = _y - this.deltaY;
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            int _multiply_1 = _minus * (40 + 3);
            Objects.requireNonNull(this);
            int y = _multiply_1 + 3 * 40 / 4;
            GNodeBuilder pinNode = new GNodeBuilder("pin");
            pinNode.addArgument("name", (Object)name);
            GLabelBuilder _text = (GLabelBuilder)new GLabelBuilder("label").text(padName);
            int _length = padName.length();
            int _minus_1 = 4 - _length;
            int _multiply_2 = _minus_1 * 2;
            int _plus = _multiply_2 + 6;
            EList eList = newRoot.getChildren();
            GNodeBuilder gNodeBuilder = (GNodeBuilder)((GNodeBuilder)pinNode.id(idd)).addCssClass(type);
            double d = _plus;
            Objects.requireNonNull(this);
            int n = 40 / 4;
            Objects.requireNonNull(this);
            GNodeBuilder gNodeBuilder2 = (GNodeBuilder)gNodeBuilder.add(((GLabelBuilder)((GLabelBuilder)_text.position(d, (double)(n + 3))).id(idd + "_pin_label")).build());
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            _xifexpression = _xblockexpression_1 = eList.add((Object)((GNodeBuilder)((GNodeBuilder)gNodeBuilder2.size(40.0, 40.0)).position((double)x, (double)y)).build());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

