/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.model;

import com.google.inject.Inject;
import com.st.stellar.pinmap.generator.GeneratePinmapViewLQFP;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.GeneratePinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinNodeBuilder;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.LQFPPackage;
import com.st.stellar.pinmap.pinmapDsl.NotConnectedPin;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;
import org.eclipse.glsp.graph.builder.impl.GNodeBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GeneratePinSettingsLQFP
extends GeneratePinSettings {
    @Inject
    @Extension
    private Utils _utils;
    private final GeneratePinmapViewLQFP genPinmapView = new GeneratePinmapViewLQFP();
    public final int pinWidthLQFP = 24;
    public final int pinHeightLQFP = 12;
    public final int pinMarginWidthLQFP = 7;
    public final int pinMarginHeightLQFP = 3;
    public final int fontSizeLQFP = this.pinWidthLQFP / 2;
    public final int generalOffsetXLQFP = -25;
    public final int generalOffsetYLQFP = -15;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;

    @Override
    public boolean generatePins(GModelElement newRoot, PinCfgModelState modelState, PinConfiguration pinConfiguration) {
        Package pack;
        GModelElement _generatePackage;
        boolean _greaterThan;
        this._pinCfgHelper = PinCfgHelper.instance;
        EList modules = PinCfgHelper.getAllModules((PinSettings)pinConfiguration.getPinSetting());
        List configuredPins = CollectionLiterals.newArrayList();
        int _size = modules.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getPins();
            configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)modules, (Functions.Function1)_function));
        }
        return (_generatePackage = this.generatePackage(newRoot, modelState, pack = this._pinCfgHelper.getPack(pinConfiguration.getPinSetting()), configuredPins, "")) != null;
    }

    @Override
    public GModelElement generatePackage(GModelElement newRoot, PinCfgModelState modelState, Package p, List<PinSetting> configuredPins, String additional) {
        GNode _xtrycatchfinallyexpression = null;
        try {
            GNode packageNode;
            int nbColumns;
            GNode _xblockexpression = null;
            GNode res = null;
            String id = modelState.getIndex().indexEObject((EObject)p);
            int _size = p.getPins().size();
            int nbRows = nbColumns = _size / 4;
            int pinSize = Math.min(this.pinWidthLQFP, this.pinHeightLQFP);
            int width = (pinSize + 2 * this.pinMarginHeightLQFP) * nbRows + this.pinMarginHeightLQFP;
            int height = (pinSize + 2 * this.pinMarginHeightLQFP) * nbRows + this.pinMarginHeightLQFP;
            ArrayList cssClasses = CollectionLiterals.newArrayList();
            cssClasses.add("gpiocfg-package");
            GModelElement legendNode = this.generateLegend(newRoot, modelState, width);
            GLabelBuilder _gLabelBuilder = new GLabelBuilder("LQFP_package-name");
            EObject _eContainer = p.eContainer();
            String _name = ((Family)_eContainer).getName();
            String _name_1 = p.getName();
            String _plus = _name + _name_1;
            GNodeBuilder packageNodeBuilder = (GNodeBuilder)((GNodeBuilder)((GNodeBuilder)((GNodeBuilder)new GNodeBuilder("LQFP_package").size((double)width, (double)width)).add(legendNode)).add(((GLabelBuilder)((GLabelBuilder)((GLabelBuilder)((GLabelBuilder)_gLabelBuilder.text(_plus)).id("packageId")).addCssClasses((List)cssClasses)).position((double)(width / 2), (double)(height / 2))).build())).id(id);
            res = packageNode = (GNode)packageNodeBuilder.build();
            newRoot.getChildren().add((Object)packageNode);
            GeneratePinSettings.PinSettingsErrorManager errorsMap = this.generateErrors(newRoot, modelState, configuredPins);
            EList _pins = p.getPins();
            for (Pin pin : _pins) {
                PinConfig _get = (PinConfig)pin.getPinConfigurations().get(0);
                PinConfig config = _get;
                if (config instanceof NotConnectedPin) continue;
                this.generatePin(newRoot, modelState, configuredPins, pin, errorsMap);
            }
            this.generateLegend(newRoot, modelState, width);
            _xtrycatchfinallyexpression = _xblockexpression = res;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public GModelElement generateLegend(GModelElement parent, PinCfgModelState modelState, int width) {
        GNode _xblockexpression = null;
        this._pinCfgHelper = PinCfgHelper.instance;
        PinNodeBuilder node = (PinNodeBuilder)new PinNodeBuilder("LQFP_legend").position(width + this.pinWidthLQFP / 2, -50.0);
        node.addArgument("width", width);
        GNode res = (GNode)node.build();
        parent.getChildren().add((Object)res);
        _xblockexpression = res;
        return _xblockexpression;
    }

    public boolean generatePin(GModelElement newRoot, PinCfgModelState modelState, List<PinSetting> configuredPins, Pin pin, GeneratePinSettings.PinSettingsErrorManager errorsMap) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> {
            boolean _xblockexpression_1 = false;
            Pin p = PinCfgHelper.getPinForConfiguration((PinSetting)it);
            _xblockexpression_1 = p.getName() != null && p.getName().equals(pin.getName());
            return _xblockexpression_1;
        };
        PinSetting ps = (PinSetting)IterableExtensions.findFirst(configuredPins, (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (ps == null) {
            _xifexpression = this.generateNotConfiguredPin(newRoot, modelState, pin, errorsMap);
        } else {
            boolean _xblockexpression_1 = false;
            EObject _eContainer = pin.eContainer();
            Package pack = (Package)_eContainer;
            _xifexpression = _xblockexpression_1 = this.generateConfiguredPin(pack, newRoot, modelState, ps, errorsMap);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean generateNotConfiguredPin(GModelElement newRoot, PinCfgModelState modelState, Pin pin, GeneratePinSettings.PinSettingsErrorManager errorsMap) {
        PinConfig _get;
        boolean _xblockexpression = false;
        ArrayList cssClasses = CollectionLiterals.newArrayList();
        ArrayList nodeClasses = CollectionLiterals.newArrayList();
        cssClasses.add("pinNone");
        nodeClasses.add("pinNone");
        PinConfig config = _get = (PinConfig)pin.getPinConfigurations().get(0);
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        Matcher matcher = pattern.matcher(pin.getName());
        boolean _xifexpression = false;
        boolean _find = matcher.find();
        if (_find) {
            boolean _xblockexpression_1 = false;
            EObject _eContainer = pin.eContainer();
            LQFPPackage p = (LQFPPackage)_eContainer;
            int _size = p.getPins().size();
            int size = _size / 4;
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String side = "";
            if (index <= size) {
                side = "west";
            } else if (index <= size * 2 && index > size) {
                side = "south";
            } else if (index <= size * 3 && index > size * 2) {
                side = "east";
            } else if (index > size * 3) {
                side = "north";
            }
            PinNodeBuilder pinNode = null;
            GLabelBuilder gName = null;
            GLabelBuilder gLabel = null;
            GLabelBuilder gDirection = null;
            gLabel = null;
            boolean _isInstance = SpecialPin.class.isInstance(config);
            if (_isInstance) {
                String id = modelState.getIndex().indexEObject((EObject)pin);
                pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin").id(id);
                pinNode.addArgument("side", side);
                pinNode.addArgument("name", pin.getName());
                SpecialPin sp = (SpecialPin)SpecialPin.class.cast(config);
                String _get_1 = GeneratePinSettings.directionNames.get(sp.getDirection());
                String _plus = _get_1 + "_";
                String directionName = _plus + side;
                nodeClasses.add("nonConfigurablePin");
                gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-name").text(sp.getRef().getName())).id(id + "_pin_name");
                gName.addArgument("side", (Object)side);
                gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-id").text(this.getPinNameLQFP(pin))).id(id + "_pin_label");
                gLabel.addArgument("side", (Object)side);
                gDirection = (GLabelBuilder)new GLabelBuilder("LQFP_pin-direction").id(id + "_pin_direction");
                gDirection.addArgument("direction", (Object)directionName);
            } else {
                boolean _isInstance_1 = SystemFunctionPin.class.isInstance(config);
                if (_isInstance_1) {
                    String id_1 = modelState.getIndex().indexEObject((EObject)pin);
                    pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin").id(id_1);
                    pinNode.addArgument("side", side);
                    pinNode.addArgument("name", pin.getName());
                    SystemFunctionPin sp_1 = (SystemFunctionPin)SystemFunctionPin.class.cast(config);
                    String _get_2 = GeneratePinSettings.directionNames.get(sp_1.getDirection());
                    String _plus_1 = _get_2 + "_";
                    String directionName_1 = _plus_1 + side;
                    nodeClasses.add("nonConfigurablePin");
                    gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-name").text(sp_1.getRef().getName())).id(id_1 + "_pin_name");
                    gName.addArgument("side", (Object)side);
                    gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-id").text(this.getPinNameLQFP(pin))).id(id_1 + "_pin_label");
                    gLabel.addArgument("side", (Object)side);
                    gDirection = (GLabelBuilder)new GLabelBuilder("LQFP_pin-direction").id(id_1 + "_pin_direction");
                    gDirection.addArgument("direction", (Object)directionName_1);
                } else {
                    boolean _isInstance_2 = NotConnectedPin.class.isInstance(config);
                    if (_isInstance_2) {
                        String id_2 = modelState.getIndex().indexEObject((EObject)pin);
                        pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin").id(id_2);
                        pinNode.addArgument("side", side);
                        pinNode.addArgument("name", pin.getName());
                        gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-name").text("not connected")).id(id_2 + "_pin_name");
                        gName.addArgument("side", (Object)side);
                    } else {
                        boolean _isInstance_3 = ConfigurablePin.class.isInstance(config);
                        if (_isInstance_3) {
                            ConfigurablePin cp = (ConfigurablePin)ConfigurablePin.class.cast(config);
                            String id_3 = modelState.getIndex().indexEObject((EObject)cp.getRef());
                            pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin").id(id_3);
                            pinNode.addArgument("side", side);
                            pinNode.addArgument("name", cp.getRef().getName());
                            gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-id").text(this.getPinNameLQFP(pin))).id(id_3 + "_pin_label");
                            gLabel.addArgument("side", (Object)side);
                        }
                    }
                }
            }
            int imageOffsetX = 0;
            int imageOffsetY = 0;
            if (index <= size) {
                x = 0;
                y = index;
                int _x = x;
                int _x_1 = x = _x * (this.pinWidthLQFP + 2 * this.pinMarginWidthLQFP);
                x = _x_1 + -3;
                int _y = y;
                y = _y * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                imageOffsetY = 1;
                imageOffsetX = -this.pinWidthLQFP / 2;
                side = "west";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 2 && index > size) {
                int _y_1 = y = (size + 1) * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP) + this.pinMarginHeightLQFP;
                y = _y_1 + 1;
                int _x_2 = x = index - size;
                int _x_3 = x = _x_2 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                x = _x_3 + this.pinHeightLQFP;
                imageOffsetX = 0;
                int _imageOffsetY = imageOffsetY;
                imageOffsetY = _imageOffsetY + (this.pinWidthLQFP + 2);
                side = "south";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinHeightLQFP + this.pinMarginHeightLQFP), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index <= size * 3 && index > size * 2) {
                x = size + 2;
                y = size * 3 - index + 1;
                int _x_4 = x;
                int _x_5 = x = _x_4 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                x = _x_5 - 4;
                int _y_2 = y;
                y = _y_2 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                imageOffsetX = this.pinWidthLQFP + 2;
                imageOffsetY = 1;
                side = "east";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinWidthLQFP + this.pinMarginWidthLQFP), 0.0)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            } else if (index > size * 3) {
                x = size * 4 - index + 1;
                y = 1;
                int _x_6 = x;
                int _x_7 = x = _x_6 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                x = _x_7 + this.pinHeightLQFP;
                int _y_3 = y;
                int _y_4 = y = _y_3 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                int _y_5 = y = _y_4 - 2 * (this.pinHeightLQFP + this.pinMarginHeightLQFP);
                y = _y_5 - 1;
                imageOffsetX = 0;
                imageOffsetY = -this.pinHeightLQFP - 2;
                side = "north";
                if (gLabel != null) {
                    pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                }
                if (gName != null) {
                    pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                }
                if (gDirection != null) {
                    pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                }
            }
            nodeClasses.add(side);
            int _x_8 = x;
            x = _x_8 + this.generalOffsetXLQFP;
            int _y_6 = y;
            y = _y_6 + this.generalOffsetYLQFP;
            _xifexpression = _xblockexpression_1 = newRoot.getChildren().add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNode.addCssClasses(nodeClasses)).position(x, y)).build());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean generateConfiguredPin(Package pack, GModelElement newRoot, PinCfgModelState modelState, PinSetting ps, GeneratePinSettings.PinSettingsErrorManager errorsMap) {
        boolean _xblockexpression = false;
        Pin pin = Utils.getPinForConfiguration((Package)pack, (Configuration)ps.getPad());
        ArrayList cssClasses = CollectionLiterals.newArrayList();
        ArrayList nodeClasses = CollectionLiterals.newArrayList();
        boolean _isBoardPin = this.isBoardPin(ps);
        if (_isBoardPin) {
            cssClasses.add("board");
            nodeClasses.add("board");
        } else {
            cssClasses.add("cPin");
            nodeClasses.add("cPin");
        }
        int x = 0;
        int y = 0;
        Pattern pattern = Pattern.compile("^.*_([0-9]+)$");
        String id = modelState.getIndex().indexEObject((EObject)ps.getPad());
        Functions.Function1 _function = it -> it.getId().equals(id);
        GModelElement graphObject = (GModelElement)IterableExtensions.findFirst((Iterable)newRoot.getChildren(), (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (graphObject == null) {
            boolean _xblockexpression_1 = false;
            Matcher matcher = pattern.matcher(pin.getName());
            boolean _xifexpression_1 = false;
            boolean _find = matcher.find();
            if (_find) {
                boolean _xblockexpression_2 = false;
                EObject _eContainer = pin.eContainer();
                LQFPPackage p = (LQFPPackage)_eContainer;
                int _size = p.getPins().size();
                int size = _size / 4;
                String number = matcher.group(1);
                int index = Integer.parseInt(number);
                String side = "";
                if (index <= size) {
                    side = "west";
                } else if (index <= size * 2 && index > size) {
                    side = "south";
                } else if (index <= size * 3 && index > size * 2) {
                    side = "east";
                } else if (index > size * 3) {
                    side = "north";
                }
                PinNodeBuilder pinNode = null;
                GLabelBuilder gName = null;
                GLabelBuilder gLabel = null;
                GLabelBuilder gDirection = null;
                String _literal = ps.getConfig().getDirection().getLiteral();
                String _plus = _literal + "_";
                String directionName = _plus + side;
                gName = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-name").text(ps.getName())).id(id + "_pin_name");
                gName.addArgument("side", (Object)side);
                gLabel = (GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_pin-id").text(this.getPinNameLQFP(pin))).id(id + "_pin_label");
                gLabel.addArgument("side", (Object)side);
                gDirection = (GLabelBuilder)new GLabelBuilder("LQFP_pin-direction").id(id + "_pin_direction");
                gDirection.addArgument("direction", (Object)directionName);
                Collection errors = errorsMap.errors.get((Object)pin);
                Collection warnings = errorsMap.warnings.get((Object)pin);
                Collection infos = errorsMap.infos.get((Object)pin);
                if (errors.size() > 0 || warnings.size() > 0 || infos.size() > 0) {
                    boolean _greaterThan;
                    pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin-error").id(id);
                    pinNode.addArgument("name", ps.getPad().getName());
                    int _size_1 = errors.size();
                    boolean bl = _greaterThan = _size_1 > 0;
                    if (_greaterThan) {
                        pinNode.addArgument("error", IterableExtensions.join((Iterable)errors, (CharSequence)","));
                        nodeClasses.add("error");
                        cssClasses.add("error");
                    } else {
                        boolean _greaterThan_1;
                        int _size_2 = warnings.size();
                        boolean bl2 = _greaterThan_1 = _size_2 > 0;
                        if (_greaterThan_1) {
                            pinNode.addArgument("warning", IterableExtensions.join((Iterable)warnings, (CharSequence)","));
                            nodeClasses.add("warning");
                            cssClasses.add("warning");
                        } else {
                            boolean _greaterThan_2;
                            int _size_3 = infos.size();
                            boolean bl3 = _greaterThan_2 = _size_3 > 0;
                            if (_greaterThan_2) {
                                pinNode.addArgument("info", IterableExtensions.join((Iterable)infos, (CharSequence)","));
                                nodeClasses.add("info");
                                cssClasses.add("info");
                            }
                        }
                    }
                    pinNode.addArgument("side", side);
                } else {
                    pinNode = (PinNodeBuilder)new PinNodeBuilder("LQFP_pin").id(id);
                    pinNode.addArgument("side", side);
                    pinNode.addArgument("name", ps.getPad().getName());
                }
                int imageOffsetX = 0;
                int imageOffsetY = 0;
                if (index <= size) {
                    x = 0;
                    y = index;
                    int _x = x;
                    int _x_1 = x = _x * (this.pinWidthLQFP + 2 * this.pinMarginWidthLQFP);
                    x = _x_1 + -3;
                    int _y = y;
                    y = _y * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    imageOffsetY = 1;
                    imageOffsetX = -this.pinWidthLQFP / 2;
                    side = "west";
                    if (gLabel != null) {
                        pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                    }
                    if (gName != null) {
                        pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                    }
                    if (gDirection != null) {
                        pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                    }
                } else if (index <= size * 2 && index > size) {
                    int _y_1 = y = (size + 1) * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP) + this.pinMarginHeightLQFP;
                    y = _y_1 + 1;
                    int _x_2 = x = index - size;
                    int _x_3 = x = _x_2 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    x = _x_3 + this.pinHeightLQFP;
                    imageOffsetX = 0;
                    int _imageOffsetY = imageOffsetY;
                    imageOffsetY = _imageOffsetY + (this.pinWidthLQFP + 2);
                    side = "south";
                    if (gLabel != null) {
                        pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                    }
                    if (gName != null) {
                        pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinHeightLQFP + this.pinMarginHeightLQFP), 0.0)).build());
                    }
                    if (gDirection != null) {
                        pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                    }
                } else if (index <= size * 3 && index > size * 2) {
                    x = size + 2;
                    y = size * 3 - index + 1;
                    int _x_4 = x;
                    int _x_5 = x = _x_4 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    x = _x_5 - 4;
                    int _y_2 = y;
                    y = _y_2 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    imageOffsetX = this.pinWidthLQFP + 2;
                    imageOffsetY = 1;
                    side = "east";
                    if (gLabel != null) {
                        pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                    }
                    if (gName != null) {
                        pinNode.add(((GLabelBuilder)((GLabelBuilder)gName.addCssClasses((List)cssClasses)).position((double)(this.pinWidthLQFP + this.pinMarginWidthLQFP), 0.0)).build());
                    }
                    if (gDirection != null) {
                        pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                    }
                } else if (index > size * 3) {
                    x = size * 4 - index + 1;
                    y = 1;
                    int _x_6 = x;
                    int _x_7 = x = _x_6 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    x = _x_7 + this.pinHeightLQFP;
                    int _y_3 = y;
                    int _y_4 = y = _y_3 * (this.pinHeightLQFP + 2 * this.pinMarginHeightLQFP);
                    int _y_5 = y = _y_4 - 2 * (this.pinHeightLQFP + this.pinMarginHeightLQFP);
                    y = _y_5 - 1;
                    imageOffsetX = 0;
                    imageOffsetY = -this.pinHeightLQFP - 2;
                    side = "north";
                    if (gLabel != null) {
                        pinNode.add(((GLabelBuilder)gLabel.addCssClasses((List)cssClasses)).build());
                    }
                    if (gName != null) {
                        pinNode.add(((GLabelBuilder)gName.addCssClasses((List)cssClasses)).build());
                    }
                    if (gDirection != null) {
                        pinNode.add(((GLabelBuilder)gDirection.position((double)imageOffsetX, (double)imageOffsetY)).build());
                    }
                }
                nodeClasses.add(side);
                int _x_8 = x;
                x = _x_8 + this.generalOffsetXLQFP;
                int _y_6 = y;
                y = _y_6 + this.generalOffsetYLQFP;
                _xifexpression_1 = _xblockexpression_2 = newRoot.getChildren().add((Object)((PinNodeBuilder)((PinNodeBuilder)pinNode.addCssClasses(nodeClasses)).position(x, y)).build());
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getPinNameLQFP(Pin pin) {
        String id;
        Pattern pattern = Pattern.compile("^(.*)_([0-9]+)$");
        Matcher matcher = pattern.matcher(id = pin.getName());
        boolean _find = matcher.find();
        if (_find) {
            String number = matcher.group(2);
            return number;
        }
        return "";
    }
}

