/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.model;

import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.GeneratePinSettings;
import com.st.stellar.pinmap.pincfg.glsp.server.model.GeneratePinSettingsBGA;
import com.st.stellar.pinmap.pincfg.glsp.server.model.GeneratePinSettingsLQFP;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import com.st.stellar.pinmap.pinmapDsl.BGAPackage;
import com.st.stellar.pinmap.pinmapDsl.LQFPPackage;
import com.st.stellar.pinmap.pinmapDsl.Package;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;
import org.eclipse.glsp.server.emf.EMFGModelFactory;
import org.eclipse.glsp.server.emf.EMFIdGenerator;

public class PinCfgGModelFactory
extends EMFGModelFactory {
    @Inject
    protected PinCfgModelState modelState;
    @Inject
    protected EMFIdGenerator idGenerator;

    protected void fillRootElement(GModelRoot newRoot) {
        block6: {
            if (this.modelState.getPinConfiguration() == null) {
                return;
            }
            PinConfiguration pincfg = this.modelState.getPinConfiguration();
            PinSettings ps = pincfg.getPinSetting();
            if (ps.getIncludedBoard() != null && ps.getIncludedBoard().isIsSetVersion()) {
                try {
                    if (this.generatePins(newRoot, pincfg)) {
                        this.modelState.updateRoot(newRoot);
                        break block6;
                    }
                    newRoot.getChildren().clear();
                    this.generateError(newRoot, "Cannot open pinmap diagram editor...");
                    this.modelState.updateRoot(newRoot);
                }
                catch (Exception e) {
                    newRoot.getChildren().clear();
                    this.generateError(newRoot, e.getMessage());
                    this.modelState.updateRoot(newRoot);
                }
            } else {
                this.generateError(newRoot, "Cannot open pinmap diagram editor...");
                this.modelState.updateRoot(newRoot);
            }
        }
    }

    private void generateError(GModelRoot newRoot, String ... message) {
        Object res = null;
        int y = 50;
        for (String string : message) {
            GLabel packageNode = (GLabel)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("LQFP_package-name").text(string)).position(0.0, (double)y)).build();
            newRoot.getChildren().add((Object)packageNode);
            y += 30;
        }
    }

    private boolean generatePins(GModelRoot newRoot, PinConfiguration pinConfiguration) {
        GeneratePinSettings gen;
        boolean status = true;
        PinCfgHelper _pinCfgHelper = PinCfgHelper.instance;
        Package p = _pinCfgHelper.getPack(pinConfiguration);
        if (LQFPPackage.class.isInstance(p)) {
            gen = new GeneratePinSettingsLQFP();
            boolean bl = status = status && ((GeneratePinSettingsLQFP)gen).generatePins((GModelElement)newRoot, this.modelState, pinConfiguration);
        }
        if (BGAPackage.class.isInstance(p)) {
            gen = new GeneratePinSettingsBGA();
            status = status && ((GeneratePinSettingsBGA)gen).generatePins((GModelElement)newRoot, this.modelState, pinConfiguration);
        }
        return status;
    }
}

