/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.glsp.server.model;

import com.google.inject.Inject;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.emf.EMFSourceModelStorage;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public class PinCfgSourceModelStorage
extends EMFSourceModelStorage {
    private static Logger LOGGER = LogManager.getLogger((String)EMFSourceModelStorage.class.getSimpleName());
    @Inject
    private PinCfgModelState modelState;

    public void loadSourceModel(RequestModelAction action) {
        URI resourceURI = this.getUri(action);
        this.modelState.setProperty("sourceUri", resourceURI);
        this.loadXtextResource(action, resourceURI);
        this.loadPinConfiguration(resourceURI);
    }

    public void reloadSourceModel() {
        Optional sourceUri = ClientOptionsUtil.getSourceUri((Map)this.modelState.getClientOptions());
        if (sourceUri.isPresent()) {
            URI uri = URI.createURI((String)((String)sourceUri.get()));
            this.loadPinConfiguration(uri);
        }
    }

    protected URI getUri(RequestModelAction action) {
        String sourceURI = (String)ClientOptionsUtil.getSourceUri((Map)action.getOptions()).orElseThrow(() -> new GLSPServerException("No source URI given to load model!"));
        return URI.createFileURI((String)sourceURI);
    }

    protected void loadXtextResource(RequestModelAction action, URI resourceURI) {
        EditingDomain editingDomain = this.getOrCreateEditingDomain();
        this.doLoadSourceModel(editingDomain.getResourceSet(), resourceURI, action);
    }

    protected void loadPinConfiguration(URI resourceURI) {
        ResourceSet resourceSet = this.modelState.getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            resource.unload();
        }
        Resource xtextResource = this.modelState.getResourceSet().getResource(resourceURI, true);
        xtextResource = this.modelState.getResourceSet().getResource(resourceURI, true);
        EObject rootEObject = (EObject)xtextResource.getContents().get(0);
        if (rootEObject instanceof PinConfiguration) {
            this.modelState.setPinConfiguration((PinConfiguration)rootEObject);
        }
    }

    protected ResourceSet setupResourceSet(ResourceSet resourceSet) {
        return resourceSet;
    }

    public void saveSourceModel(SaveModelAction action) {
        CopyOnWriteArrayList resources = new CopyOnWriteArrayList(this.modelState.getResourceSet().getResources());
        for (Resource resource : resources) {
            if (resource.getURI() == null) continue;
            System.out.println("Saving resource: " + resource.getURI().toString());
            if (resource.getURI().toString().contains("com.st.stellar.model.lib") || resource.getURI().toString().startsWith("platform:")) continue;
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Could not save resource: " + String.valueOf(resource.getURI())), (Throwable)e);
                throw new GLSPServerException("Could not save model to file: " + String.valueOf(resource.getURI()), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not save resource: " + String.valueOf(resource.getURI())), (Throwable)e);
                throw new GLSPServerException("Could not save model to file: " + String.valueOf(resource.getURI()), (Throwable)e);
            }
        }
    }
}

