package com.st.stellar.pinmap.pincfg.glsp.server

import com.google.inject.Inject
import com.st.stellar.pinmap.helpers.PinCfgHelper
import com.st.stellar.pinmap.pinCfg.PinSetting
import com.st.stellar.pinmap.pincfg.glsp.server.model.PinCfgModelState
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin
import com.st.stellar.pinmap.pinmapDsl.Pin
import com.st.stellar.pinmap.pinmapDsl.SpecialPin
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin
import java.util.HashMap
import java.util.Optional
import org.eclipse.emf.ecore.EObject
import org.eclipse.glsp.graph.GHtmlRoot
import org.eclipse.glsp.graph.GModelElement
import org.eclipse.glsp.graph.GraphFactory
import org.eclipse.glsp.server.features.popup.PopupModelFactory
import org.eclipse.glsp.server.features.popup.RequestPopupModelAction

import static org.eclipse.glsp.graph.util.GraphUtil.bounds
import com.st.stellar.pinmap.pinmapDsl.Configuration

class PinCfgPopupModelFactory implements PopupModelFactory {

	@Inject
	protected PinCfgModelState modelState;

	def EObject getEObject(GModelElement element) {
		val selectedPinConfigs = modelState.index.getEObject(element.id)

//		val ps = selectedPinConfigs.stream().filter(it|PinSetting.isInstance(it)).map(it|PinSetting.cast(it))
//				.findFirst();
		val ps = selectedPinConfigs.stream().filter(it|EObject.isInstance(it)).map(it|EObject.cast(it)).findFirst();
		return ps.orElse(null);
	}

	def Pin lookupPin(GModelElement element) {
		val selectedPinConfigs = modelState.index.getEObject(element.id)
		val ps = selectedPinConfigs.stream().filter(it|Configuration.isInstance(it)).map(it|Configuration.cast(it)).
			findFirst();

		val pack = PinCfgHelper.instance.getPack(modelState.pinConfiguration)
		if (ps.isPresent) {
			PinCfgHelper.instance.getPinForConfiguration(pack, ps.get());
		} else {
			null
		}
	}

	def PinSetting lookupPinSetting(GModelElement element) {
		val selectedPinConfigs = modelState.index.getEObject(element.id)
		val selectedPin = selectedPinConfigs.stream().filter(it|Configuration.isInstance(it)).map(
			it |
				Configuration.cast(it)
		).findFirst();
		if (selectedPin.isPresent) {
			val config = modelState.pinConfiguration
			val pins = PinCfgHelper.getAllPinSettings(config)
			val ps = pins.findFirst[it|it.pad.name.equals(selectedPin.get.name)]
			return ps;
		}
		return null
	}

	dispatch def String generateBody(PinSetting ps) {
		if (ps === null) {
			return null
		}
		return String.format("PinSetting: %s", ps.name);
	}

	def String generateBody(Pin pin, PinSetting ps) {
		if (pin === null) {
			return null
		}

		var psPeriph = ""
		var psFct = ""
		if (ps !== null) {
			val fct = ps.config.alt
			if (fct !== null) {
				psFct = fct.name
				psPeriph = fct.peripheralRef.name
			}
		}

		val pinMap = new HashMap<Pin, HashMap<String, String>>

		var tooltipMap = pinMap.get(pin)
		if (tooltipMap === null) {
			pinMap.put(pin, new HashMap<String, String>)
			tooltipMap = pinMap.get(pin)
		}

		var tooltips = ""
		for (cfg : pin.pinConfigurations) {
			var tooltip = ""
			var periph = ""
			if (cfg instanceof SystemFunctionPin) {
				val sfp = cfg as SystemFunctionPin
				periph = "System"

				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sfp.ref.label + " (" + sfp.direction.getName + ")" + "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof SpecialPin) {
				val sp = cfg as SpecialPin
				periph = "Special"
				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sp.ref.label + " (" + sp.direction.getName + ")"
				tooltip += "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof ConfigurablePin) {
				val sfp = cfg as ConfigurablePin
				if (tooltips.length < 1) {
					tooltips = "<b>" + pin.name + ": " + sfp.ref.label + "</b><br/><pre>"
				}
				for (c : sfp.ref.functions) {
					periph = c.name.peripheralRef.name
					var t = tooltipMap.get(periph)
					if (t === null) {
						tooltipMap.put(periph, "")
						t = tooltipMap.get(periph)
					}
					val fctName = c.name.name
					if (fctName.equals(psFct)) {
						t += "&#160;&#160;&#160;(" + c.direction + ") <b>" + fctName + "</b><br/>"
					} else {
						t += "&#160;&#160;&#160;(" + c.direction + ") " + fctName + NL
					}

					tooltipMap.put(periph, t)
				}
				tooltip += tooltipMap.get(periph)
				tooltips += "</pre>"

			} else {
				tooltip += "&#160;&#160;&#160;" + cfg.toString + "<br/>"
			}

		}

		for (key : tooltipMap.keySet) {
			if (key.equals(psPeriph)) {
				tooltips += "<b>" + key + "</b><br/>"
			} else {
				tooltips += "<em>" + key + "</em><br/>"
			}
			tooltips += tooltipMap.get(key) // + "<br/>"
		}
		tooltips
	}

	dispatch def String generateBody(EObject ps) {
		return null
	}

	dispatch def String generateTitle(PinSetting ps) {
		if (ps === null) {
			return null
		}
		String.format("Pad: %s" + NL + "Pin: %s" + NL + "Direction: %s", ps.pad.name, ps.pad.name, ps.config.direction);
	}

	dispatch def String generateTitle(EObject task) {
		return null
	}

	static final String NL = "<br/>";

	override Optional<GHtmlRoot> createPopupModel(GModelElement element, RequestPopupModelAction action) {
		if (element !== null) {
			if (!modelState.popupState) {

				val pinSetting = lookupPinSetting(element);
				if (pinSetting !== null) {
					val root = GraphFactory.eINSTANCE.createGHtmlRoot
					val bounds = action.bounds
					root.setCanvasBounds(bounds(bounds.x, bounds.y, bounds.width, bounds.height))
					root.type = "html"
					root.id = "sprotty-popup"
					val title = ""
					val p1 = GraphFactory.eINSTANCE.createGPreRenderedElement
					p1.type = "pre-rendered"
					p1.id = "popup-title"
					p1.code = '''<div class="sprotty-popup-title">«title»</div>'''
					root.children.add(p1)

					val pin = PinCfgHelper.getPinForConfiguration(pinSetting)
					val body = generateBody(pin, pinSetting)
					if (body !== null) {
						val p2 = GraphFactory.eINSTANCE.createGPreRenderedElement
						p2.type = "pre-rendered"
						p2.id = "popup-body"
						p2.code = '''<div class="sprotty-popup-body">«body»</div>'''
						root.children.add(p2)
					}
					return Optional.of(root)
				} else {
					val ps = lookupPin(element);
					if (ps !== null) {
						val root = GraphFactory.eINSTANCE.createGHtmlRoot
						val bounds = action.bounds
						root.setCanvasBounds(bounds(bounds.x, bounds.y, bounds.width, bounds.height))
						root.type = "html"
						root.id = "sprotty-popup"
						val title = ""
						val p1 = GraphFactory.eINSTANCE.createGPreRenderedElement
						p1.type = "pre-rendered"
						p1.id = "popup-title"
						p1.code = '''<div class="sprotty-popup-title">«title»</div>'''
						root.children.add(p1)

						val body = generateBody(ps, null)
						if (body !== null) {
							val p2 = GraphFactory.eINSTANCE.createGPreRenderedElement
							p2.type = "pre-rendered"
							p2.id = "popup-body"
							p2.code = '''<div class="sprotty-popup-body">«body»</div>'''
							root.children.add(p2)
						}
						return Optional.of(root)
					}
				}
			}
		}
		return Optional.empty
	}
}
