/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.htmlGenerator.runtime;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.pinmap.generator.GeneratePinmapViewLQFP;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.helpers.Utils;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.Direction;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.htmlGenerator.runtime.GeneratePinSettings;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.FunctionRef;
import com.st.stellar.pinmap.pinmapDsl.Peripheral;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.SpecialPin;
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GeneratePinSettingsLQFP
implements GeneratePinSettings {
    @Inject
    @Extension
    private Utils _utils;
    private final GeneratePinmapViewLQFP genPinmapView = new GeneratePinmapViewLQFP();
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    private StringBuilder errors;
    private StringBuilder warnings;
    public final int pinWidth = 24;
    public final int pinHeight = 12;
    public final int pinMarginWidth = 3;
    public final int pinMarginHeight = 3;
    public final int fontSize = this.pinWidth / 2;
    public final int generalOffsetX = 200;
    public final int generalOffsetY = 200;

    protected String _getRefId(PinSettings settings) {
        String _xblockexpression = null;
        EObject _eContainer = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().eContainer();
        String n = ((Family)_eContainer).getName();
        n = n.replaceAll("x", PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getName());
        int a = n.indexOf("_");
        _xblockexpression = n = n.substring(0, a);
        return _xblockexpression;
    }

    protected String _getRefId(PinSetting setting) {
        return this.getRefId((EObject)setting.getPad());
    }

    protected String _getRefId(ConfigurablePin pin) {
        Configuration _ref;
        String _xblockexpression = null;
        Configuration cfg = _ref = pin.getRef();
        _xblockexpression = cfg.getName();
        return _xblockexpression;
    }

    public GeneratePinSettingsLQFP() {
        StringBuilder _stringBuilder_1;
        StringBuilder _stringBuilder;
        this.errors = _stringBuilder = new StringBuilder("errors:\n");
        this.warnings = _stringBuilder_1 = new StringBuilder("warnings:\n");
    }

    public StringBuilder error(String message) {
        return this.errors.append("error: " + message + "\n");
    }

    public StringBuilder warning(String message) {
        return this.warnings.append("warning: " + message + "\n");
    }

    public StringBuilder generateReport() {
        return this.errors.append((CharSequence)this.warnings);
    }

    public int getPortNb(String s) {
        int portNb;
        int _xblockexpression = 0;
        char subString = s.charAt(1);
        int port = Character.getNumericValue(subString);
        int begin = Character.getNumericValue('A');
        _xblockexpression = portNb = port - begin;
        return _xblockexpression;
    }

    public int getBit(String s) {
        int _xblockexpression = 0;
        String subString = s.substring(2, s.length());
        _xblockexpression = Integer.parseInt(subString);
        return _xblockexpression;
    }

    private static CharSequence script(String instancesOfPeripherals, String functionsOfPeripherals, String tooltipsArray) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<script type=\"text/javascript\">");
        _builder.newLine();
        _builder.append("var svg = null;");
        _builder.newLine();
        _builder.append("var oldpads = [];");
        _builder.newLine();
        _builder.append("var oldcolors = [];");
        _builder.newLine();
        _builder.append("var oldstroke = [];");
        _builder.newLine();
        _builder.append("var oldstrokeWidth = [];");
        _builder.newLine();
        _builder.append("var oldFillOpacity = [];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function init() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("svg = document.getElementById('svg-doc');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var size = getSVGSize();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//console.log(size);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Add mouse out events on elements matching cPin and configuredPin classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var elements = document.getElementsByClassName(\"cPin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (var i = 0; i < elements.length; i++) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("const elt = elements[i];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elt.addEventListener('mouseout', function(event) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("htt();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elt.addEventListener('mouseenter', function(event) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("const value = elt.value;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( value ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("onmouseenter=\"stt(evt,value);\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elements = document.getElementsByClassName(\"configuredPin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (var i = 0; i < elements.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elements[i].addEventListener('mouseout', function(event) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("htt();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elements = document.getElementsByClassName(\"sPin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (var i = 0; i < elements.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elements[i].addEventListener('mouseout', function(event) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("htt();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elements = document.getElementsByClassName(\"fPin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (var i = 0; i < elements.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elements[i].addEventListener('mouseout', function(event) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("htt();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}\t\t    ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("elements = document.getElementsByClassName(\"nonConfigurablePin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (var i = 0; i < elements.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elements[i].addEventListener('mouseout', function(event) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("htt();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function getSVGSize() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var svgDoc = svg;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if( svgDoc ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var width = svgDoc.getAttribute('width');");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var height = svgDoc.getAttribute('height');");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("res = '<'+width+','+height+'>';");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return res;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var hideLayer = function(elem) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (elem) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = svg.getElementById(elem);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (elt) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elt.style.display = \"none\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var showLayer = function(elem) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (elem) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = svg.getElementById(elem);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (elt) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elt.style.display = \"inline\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var selectedPeriph = \"\";");
        _builder.newLine();
        _builder.append("var selectedInstance = \"\";");
        _builder.newLine();
        _builder.append("var selectedFunction = \"\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function comboPeriph() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedPeriph) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("console.log('from: '+selectedPeriph);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedPeriph)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedInstance) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedInstance)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedFunction) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedFunction)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var combo = document.getElementById(\"comboPeriph\")");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var idx = combo.selectedIndex;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var content = combo.options[idx].innerHTML;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("selectedPeriph = content;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if( selectedPeriph === \"None\") {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("document.getElementById(\"instance\").innerHTML = \"<option value=\\\"\\\" selected>None</option>\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = \"<option value=\\\"\\\" selected>None</option>\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("console.log('to: '+content);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("showLayer('animation_layer_'+content)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("changecat(combo.value);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function comboPeriphInstance() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var thelist = document.getElementById('instance');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedPeriph) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedPeriph)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedInstance) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("console.log('from: '+selectedInstance);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedInstance)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedFunction) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedFunction)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var idx = thelist.selectedIndex;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var content = thelist.options[idx].innerHTML;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("selectedInstance = content;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("console.log('to: '+content);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("showLayer('animation_layer_'+content)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("changeinstance(thelist.value);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("function comboFunction() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var thelist = document.getElementById('function');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedPeriph) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedPeriph)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedInstance) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedInstance)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(selectedFunction) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("console.log('from: '+selectedFunction);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("hideLayer('animation_layer_'+selectedFunction)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var idx = thelist.selectedIndex;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var content = thelist.options[idx].innerHTML;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("console.log('comboFunction:'+content)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("selectedFunction = content;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("console.log('to: '+content);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(content === \"All\") {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("comboPeriphInstance(selectedInstance);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("showLayer('animation_layer_'+content)");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function replaceCharByInt(correspondance, p0, p1, p2, decalage, chaine) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Regular expression is: (^.*)(PAD_P?)(\\d*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//                          p0   p1    p2");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return [\"PAD_P\", p2].join('');");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function replaceCharByInt2(correspondance, p1, p2, p3, decalage, chaine) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Regular expression is: (PAD_P?)(\\d*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//                           p1    p2");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return [\"configured_P\", p2].join('');");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function findElements(name) {");
        _builder.newLine();
        _builder.append("  \t");
        _builder.append("//console.log(name);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var elArray = [];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var tmp = document.getElementsByClassName(\"pin\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var padName = name.replace(/(^.*)(PAD_P?)(\\d*)/, replaceCharByInt);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var regex = new RegExp(padName);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for ( var i = 0; i < tmp.length; i++ ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if ( regex.test(tmp[i].id) ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elArray.push(tmp[i]);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("padName = name.replace(/(PAD_P?)(\\d*)/, replaceCharByInt2);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var regex = new RegExp(padName);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for ( var i = 0; i < tmp.length; i++ ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if ( regex.test(tmp[i].id) ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elArray.push(tmp[i]);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//console.log(elArray);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return elArray;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function reset() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var input = document.getElementById(\"padToSelect\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("input.value = \"\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("selectPad();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function selectPad() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var input = document.getElementById(\"padToSelect\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var pad = input.value.toUpperCase();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pad = pad.replace(\"[\", \"\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pad = pad.replace(\"]\", \"\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pad = pad.replace(\".*\", \"\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pad = pad.replace(\"*\", \"\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pad = pad.concat(\"$\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for ( var i = 0; i < oldpads.length; i++ ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = oldpads[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.fill = oldcolors[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.stroke = oldstroke[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.strokeWidth = oldstrokeWidth[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.fillOpacity = oldfillOpacity[i];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldpads = [];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldcolors = [];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldstroke = [];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldstrokeWidth = [];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldfillOpacity = [];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var padName = \"^PAD_\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("padName = padName.concat(pad);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var pads = findElements(padName);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldpads = pads;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for ( var i = 0; i < pads.length; i++ ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var elt = pads[i];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//console.log(elt);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldcolors[i] = elt.style.fill;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldstroke[i] = elt.style.stroke;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldstrokeWidth[i] = elt.style.strokeWidth;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldfillOpacity[i] = elt.style.fillOpacity;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.fill = '#ffd200';");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.fillOpacity = '1';");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.strokeWidth = '2px';");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("elt.style.stroke = 'black';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append(instancesOfPeripherals);
        _builder.newLineIfNotEmpty();
        _builder.append(functionsOfPeripherals);
        _builder.newLineIfNotEmpty();
        _builder.append(tooltipsArray);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("function changecat(value) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (value.length == 0 || instanceOfPeripherals[value].length == 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("document.getElementById(\"instance\").innerHTML = \"<option selected>None</option>\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = \"<option selected>None</option>\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( instanceOfPeripherals[value].length == 1) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var categoryId = instanceOfPeripherals[value][0];");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var catOptions = \"<option value=\\\"All\\\" selected>\" + categoryId + \"</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"instance\").innerHTML = catOptions;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = \"<option value=\\\"\\\">All</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("changeinstance(categoryId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var catOptions = \"<option selected>All</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for (categoryId in instanceOfPeripherals[value]) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("catOptions += \"<option>\" + instanceOfPeripherals[value][categoryId] + \"</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"instance\").innerHTML = catOptions;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = \"<option value=\\\"\\\" selected>All</option>\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function changeinstance(value) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (value.length == 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = \"<option selected>All</option>\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var index=document.getElementById(\"instance\").options.selectedIndex");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var periph=document.getElementById(\"instance\").options[index].text");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( value === \"All\") {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//console.log(\"selected periph:\"+selectedPeriph);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("comboPeriph();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else if( functionsOfPeripherals[value].length == 1) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var categoryId = functionsOfPeripherals[value][0];");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var catOptions = \"<option selected>\" + categoryId + \"</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = catOptions;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("var catOptions = \"<option selected>All</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for (categoryId in functionsOfPeripherals[periph]) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("catOptions += \"<option>\" + functionsOfPeripherals[periph][categoryId] + \"</option>\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("document.getElementById(\"function\").innerHTML = catOptions;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var oldTooltipText = \"\";");
        _builder.newLine();
        _builder.append("function stt(evt, pin) { // show tooltip");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("let tooltip = document.getElementById(\"tooltip\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var text = tooltipsArray[pin];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if( text ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = text;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldTooltipText = text;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = oldTooltipText;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.display = \"block\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.left = evt.pageX + 10 + 'px';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.top = evt.pageY + 10 + 'px';");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("function sttConfigured(evt, text) { // show tooltip");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("let tooltip = document.getElementById(\"tooltip\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if( text ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = text;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldTooltipText = text;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = oldTooltipText;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.display = \"block\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.left = evt.pageX + 10 + 'px';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.top = evt.pageY + 10 + 'px';");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("function htt() { // Hide tooltip");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var tooltip = document.getElementById(\"tooltip\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.display = \"none\";");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("function toggleLegend() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var legend = document.getElementById('legend');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("var button = document.querySelector('.legend-title');");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (legend.style.display === 'none' || legend.style.display === '') {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("legend.style.display = 'flex';");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("button.textContent = 'Hide color legend';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("legend.style.display = 'none';");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("button.textContent = 'Show color legend';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("function showtt(text) { // show tooltip");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("let tooltip = document.getElementById(\"tooltip\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if( text ) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = text;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldTooltipText = text;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tooltip.innerHTML = oldTooltipText;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.display = \"block\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.left = event.pageX + 10 + 'px';");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tooltip.style.top = event.pageY + 10 + 'px';");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("</script>");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String generateView(PinSettings settings, Map<EObject, Map<Integer, List<String>>> errorsMap) {
        String fileContent;
        String _xblockexpression = null;
        this._pinCfgHelper = PinCfgHelper.instance;
        Object pins = "";
        EList _allModules = PinCfgHelper.getAllModules((PinSettings)settings);
        for (Module mod : _allModules) {
            EList _pins = mod.getPins();
            for (Object pin : _pins) {
                String _pins_1 = pins;
                String _generatePin = this.generatePin((PinSetting)pin, errorsMap);
                pins = _pins_1 + _generatePin;
            }
        }
        HashMap<String, HashSet<String>> peripheralMap = new HashMap<String, HashSet<String>>();
        HashMap functionsMap = new HashMap();
        HashSet<String> peripheralNameSet = null;
        EList _pins_2 = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getPins();
        for (Pin pin_1 : _pins_2) {
            Iterable _filter = Iterables.filter((Iterable)pin_1.getPinConfigurations(), ConfigurablePin.class);
            for (ConfigurablePin cfg : _filter) {
                EList _functions = cfg.getRef().getFunctions();
                for (FunctionRef fctref : _functions) {
                    String perDisplay = fctref.getName().getPeripheralRef().getLabel();
                    String periphName = fctref.getName().getPeripheralRef().getName();
                    HashSet<String> funcList = (HashSet<String>)functionsMap.get(periphName);
                    if (funcList == null) {
                        HashSet<String> _hashSet;
                        funcList = _hashSet = new HashSet<String>();
                        functionsMap.put(periphName, funcList);
                    }
                    List<Function> validFunctions = this.getFunctions(cfg.getRef(), fctref.getName().getPeripheralRef());
                    for (Function f : validFunctions) {
                        funcList.add(f.getName());
                    }
                    int _size = validFunctions.size();
                    boolean _greaterThan = _size > 0;
                    if (!_greaterThan) continue;
                    peripheralNameSet = (HashSet<String>)peripheralMap.get(perDisplay);
                    if (peripheralNameSet == null) {
                        HashSet<String> _hashSet_1 = new HashSet<String>();
                        peripheralNameSet = _hashSet_1;
                        peripheralMap.put(perDisplay, peripheralNameSet);
                    }
                    peripheralNameSet.add(periphName);
                }
            }
        }
        List peripherals = IterableExtensions.sort(peripheralMap.keySet());
        String pinmapView = this.genPinmapView.generatePackage(PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage(), (String)pins);
        String pack = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getName();
        EObject _eContainer = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().eContainer();
        Family family = (Family)_eContainer;
        String model = family.getName();
        int _lastIndexOf = model.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        model = model.substring(_plus);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<div class=\"tooltipLegend\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<button class=\"legend-title\" onclick=\"toggleLegend()\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Show legend</button>");
        _builder.newLine();
        _builder.append("</div>");
        _builder.newLine();
        String legend = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<div class=\"legend-container\">");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<div class=\"legend\" id=\"legend\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #e7017e;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Board predefined pins (modifiable only in <b><em>.gpio_board</em></b> file).')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Board predefined pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #49b170;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('User configured pins (modifiable in <b><em>.gpio</em></b> file).')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>User configured pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #3cb4e6;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Pins that match the show pins for peripheral combo boxes')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Filtered pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #ffd200;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Selected pin (result of Search PAD or when the mouse hovers a pin).')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Selected pin.</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div id=\"error-legend\" class=\"color-box\" style=\"background-color: #FF0000;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Pins with configuration errors.')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Error pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div id=\"warning-legend\"  class=\"color-box\" style=\"background-color: rgb(255, 153, 0);\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Pins with configuration warnings')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Warning pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #cccccc;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Not configurable pins')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Not configurable pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div class=\"legend-item\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<div class=\"color-box\" style=\"background-color: #ffffff;\"");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("onmouseenter=\"showtt('Pins not configured yet')\" onmouseout=\"htt()\"></div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<span>Unused pins</span>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("<div class=\"grid-container\">");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<div class=\"container\">");
        _builder_1.newLine();
        _builder_1.append("\t       ");
        _builder_1.append("<div class=\"left\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<label class=\"left\">Model: <em>");
        String _upperCase = model.toUpperCase(Locale.ENGLISH);
        _builder_1.append(_upperCase, "\t\t\t");
        _builder_1.append("</em>, Package: <em>");
        _builder_1.append(pack, "\t\t\t");
        _builder_1.append("</em>, Board: <em>");
        String _name = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getName();
        _builder_1.append(_name, "\t\t\t");
        _builder_1.append("</em></label>");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t\t     ");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t     ");
        _builder_1.append("<div class=\"right\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t            ");
        _builder_1.append(legend, "\t\t\t            ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t\t     ");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t ");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<div style=\"display:inline\" class=\"cell1\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<label>Show pins for peripheral <select id=\"comboPeriph\" onChange=\"comboPeriph()\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<option>None</option>");
        _builder_1.newLine();
        List _sort = IterableExtensions.sort((Iterable)peripherals);
        for (String p : _sort) {
            _builder_1.append("\t");
            _builder_1.append("<option>");
            _builder_1.append(p, "\t");
            _builder_1.append("</option>");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("\t");
        _builder_1.append("</select></label>");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<label>Instance");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<select name=\"instance\" id=\"instance\" onChange=\"comboPeriphInstance()\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<option>None</option>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</select>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</label>");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("<label>Function");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<select name=\"function\" id=\"function\" onChange=\"comboFunction()\">");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("<option>None</option>");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.append("</select>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</label>");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<div style=\"display:block\" class=\"cell2\">");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("<label id=\"searchPad\">Search PAD <input type=\"search\" id=\"padToSelect\" onsearch=\"reset()\" onkeyup=\"selectPad()\" placeholder=\"Enter PAD name...\"></label>");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("\t");
        _builder_1.append("</div>");
        _builder_1.newLine();
        _builder_1.append("</div>");
        String peripheralCombo = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("var instanceOfPeripherals = {");
        _builder_2.newLine();
        _builder_2.append("'None': [],");
        _builder_2.newLine();
        List _sort_1 = IterableExtensions.sort((Iterable)peripherals);
        for (String p_1 : _sort_1) {
            _builder_2.append("'");
            _builder_2.append(p_1);
            _builder_2.append("': [");
            Functions.Function1 _function = it -> "\"" + it + "\"";
            String _join = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)((Iterable)peripheralMap.get(p_1)), (Functions.Function1)_function)), (CharSequence)",");
            _builder_2.append(_join);
            _builder_2.append("],");
            _builder_2.newLineIfNotEmpty();
        }
        _builder_2.append("}");
        _builder_2.newLine();
        String instancesOfPeripherals = _builder_2.toString();
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("var functionsOfPeripherals = {");
        _builder_3.newLine();
        List _sort_2 = IterableExtensions.sort(functionsMap.keySet());
        for (String p_2 : _sort_2) {
            _builder_3.append("'");
            _builder_3.append(p_2);
            _builder_3.append("': [");
            Functions.Function1 _function_1 = it -> "\"" + it + "\"";
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)((Iterable)functionsMap.get(p_2)), (Functions.Function1)_function_1)), (CharSequence)",");
            _builder_3.append(_join_1);
            _builder_3.append("],");
            _builder_3.newLineIfNotEmpty();
        }
        _builder_3.append("}");
        _builder_3.newLine();
        String functionsOfPeripherals = _builder_3.toString();
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("var tooltipsArray = {");
        _builder_4.newLine();
        EList _pins_3 = PinCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getPins();
        for (Pin p_3 : _pins_3) {
            int _length = this.getTooltipNotConfigured(p_3).length();
            boolean _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            _builder_4.append("'");
            String _name_1 = p_3.getName();
            _builder_4.append(_name_1);
            _builder_4.append("': \"");
            String _tooltipNotConfigured = this.getTooltipNotConfigured(p_3);
            _builder_4.append(_tooltipNotConfigured);
            _builder_4.append("\",");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.append("}");
        _builder_4.newLine();
        String tooltipsArray = _builder_4.toString();
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("<!DOCTYPE HTML>");
        _builder_5.newLine();
        _builder_5.append("<html lang=\"en\">");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("<head>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<meta charset=\"UTF-8\">");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<title>");
        String _name_2 = settings.getName();
        _builder_5.append(_name_2, "\t");
        _builder_5.append("</title>");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("<style>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".st0 {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".st1 {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffffff;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("grid-container {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("display: grid;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("grid-template-columns: auto auto;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("grid-template-rows: auto;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("grid-gap: 10px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("padding: 10px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".grid-container > div {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("text-align: left;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("padding: 20px 0;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("#tooltip {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("background: #fff8dc;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("border: 1px solid #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("border-radius: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("padding: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("font-size: 0.8em;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".pinText {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("text-anchor: middle;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".pinText_start {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("font-size: 0.5em;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("text-anchor: start;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".pinText_end {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("font-size: 0.5em;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("text-anchor: end;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("text,");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("label {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("font-family: Verdana;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("font-size: 0.8em;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #49b170;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin > text:nth-child(2) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #49b170;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #49b170;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.error > rect {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: black;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("fill: #ff0000;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.error > text:nth-child(2) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.error > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.warning > rect {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: black;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("fill: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.warning > text:nth-child(2) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.warning > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin:hover rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffd200;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 2px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".pin {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nPin:hover rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffd200;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 2px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nPin text {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".pinNone {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffffff;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("width: 24px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("height: 12px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".layerPin {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #3cb4e6;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nonConfigurablePin {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nonConfigurablePin rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #cccccc;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nonConfigurablePin > text:nth-child(2) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nonConfigurablePin > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".nonConfigurablePin:hover rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffd200;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 2px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #e7017e;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board > text:nth-child(1) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #e7017e;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #e7017e;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 0.5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board:hover rect {");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill: #ffd200;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("fill-opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke: #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("stroke-width: 2px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.error > rect {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: black;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("fill: #ff0000;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.error > text:nth-child(1) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.error > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.warning > rect {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: black;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("fill: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.warning > text:nth-child(1) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.warning > text:nth-child(3) {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".cPin.error {");
        _builder_5.newLine();
        _builder_5.append("    ");
        _builder_5.append("stroke: black;");
        _builder_5.newLine();
        _builder_5.append("    ");
        _builder_5.append("fill: #ff0000;");
        _builder_5.newLine();
        _builder_5.append("    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".board.error {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("fill: #ff0000;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("@keyframes blink {");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("0% {");
        _builder_5.newLine();
        _builder_5.append("\t        ");
        _builder_5.append("opacity: 0.4;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("100% {");
        _builder_5.newLine();
        _builder_5.append("\t        ");
        _builder_5.append("opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t    ");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend-container {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("font-family: Arial, sans-serif;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("border-radius: 5px; /* Optional: Add rounded corners */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("background-color: #c8e0f9; /* Optional: Add background color */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("overflow: hidden; /* Ensure the button stays within the border */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-left: auto;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend-title {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("cursor: pointer;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("padding: 10px 20px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("/*background-color: #007BFF;*/");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("/*color: white;*/");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("border: none;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("border-radius: 5px 5px 0 0; /* Rounded corners for the top of the button */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("font-size: 16px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("width: 100%;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("text-align: left; /* Align text to the left */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("box-sizing: border-box; /* Ensure padding is included in the width */");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: none;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("padding: 10px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend-item {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: flex;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("align-items: center;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-bottom: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("#error-legend {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: flex;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("align-items: center;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-bottom: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("stroke: red;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("fill: #ff0000;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("#warning-legend {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: flex;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("align-items: center;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-bottom: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("stroke: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("fill: rgb(255, 153, 0);");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("animation: blink 500ms infinite;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".color-box {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("width: 20px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("height: 20px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-right: 10px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("border: 1px solid #03234b;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".container {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: flex;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("justify-content: space-between;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("align-items: center;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("padding: 10px;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".left {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: flex;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("gap: 10px; /* Space between the first two strings */");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".right {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-left: auto; /* Pushes the third string to the right */");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".tooltipLegend {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("position: relative;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("display: inline-block;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend-item:hover .tooltip {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("visibility: visible;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".legend-item:hover .tooltip {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("visibility: visible;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("opacity: 1;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(".tooltip {");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("visibility: hidden;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("width: 200px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("background-color: #000;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("color: #fff;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("text-align: center;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("border-radius: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("padding: 5px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("position: absolute;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("z-index: 1;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("bottom: 125%; /* Position the tooltip above the text */");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("left: 50%;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("margin-left: -100px;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("opacity: 0;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("transition: opacity 0.3s;");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("</style>");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("</head>");
        _builder_5.newLine();
        _builder_5.append("<header>");
        _builder_5.newLine();
        _builder_5.append(peripheralCombo);
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("</header>");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("<body onload=\"init();\">");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<div id=\"tooltip\" display=\"none\" style=\"position: absolute; display: none;\"></div>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append(pinmapView, "\t");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        CharSequence _script = GeneratePinSettingsLQFP.script(instancesOfPeripherals, functionsOfPeripherals, tooltipsArray);
        _builder_5.append((Object)_script, "\t");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("</body>");
        _builder_5.newLine();
        _builder_5.newLine();
        _builder_5.append("</html>");
        _xblockexpression = fileContent = _builder_5.toString();
        return _xblockexpression;
    }

    public String getTooltipNotConfigured(Pin pin) {
        String _xblockexpression = null;
        HashMap pinMap = new HashMap();
        HashMap tooltipMap = (HashMap)pinMap.get(pin);
        if (tooltipMap == null) {
            HashMap _hashMap = new HashMap();
            pinMap.put(pin, _hashMap);
            tooltipMap = (HashMap)pinMap.get(pin);
        }
        Object tooltips = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            Object tooltip = "";
            String periph = "";
            if (cfg instanceof SystemFunctionPin) {
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                String _xifexpression = null;
                Peripheral _peripheralRef = sfp.getRef().getPeripheralRef();
                boolean _tripleNotEquals = _peripheralRef != null;
                _xifexpression = _tripleNotEquals ? sfp.getRef().getPeripheralRef().getName() : "System function";
                periph = _xifexpression;
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                Object _oltip = tooltip;
                String _label = sfp.getRef().getLabel();
                String _plus = _label + " (";
                String _name = sfp.getDirection().getName();
                String _plus_1 = _plus + _name;
                String _plus_2 = _plus_1 + ")";
                String _plus_3 = _plus_2 + "<br/>";
                tooltip = (String)_oltip + _plus_3;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof SpecialPin) {
                SpecialPin sp = (SpecialPin)cfg;
                periph = sp.getDirection().getName();
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip_1 = tooltip;
                String _label_1 = sp.getRef().getLabel();
                Object _oltip_2 = tooltip = _oltip_1 + _label_1;
                tooltip = (String)_oltip_2 + "<br/>";
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof ConfigurablePin) {
                boolean _lessThan;
                ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
                int _length = ((String)tooltips).length();
                boolean bl = _lessThan = _length < 1;
                if (_lessThan) {
                    String _name_1 = pin.getName();
                    String _plus_4 = "<b>" + _name_1;
                    String _plus_5 = (String)_plus_4 + ": ";
                    String _label_2 = sfp_1.getRef().getLabel();
                    String _plus_6 = _plus_5 + _label_2;
                    String _plus_7 = _plus_6 + "</b><br/><pre>";
                    tooltips = _plus_7;
                }
                EList _functions = sfp_1.getRef().getFunctions();
                for (FunctionRef c : _functions) {
                    periph = c.getName().getPeripheralRef().getName();
                    Object t = (String)tooltipMap.get(periph);
                    if (t == null) {
                        tooltipMap.put(periph, "");
                        t = (String)tooltipMap.get(periph);
                    }
                    String _t = t;
                    String _name_2 = c.getName().getName();
                    String _plus_8 = "   " + _name_2;
                    String _plus_9 = _plus_8 + "<br/>";
                    t = _t + _plus_9;
                    tooltipMap.put(periph, t);
                }
                Object _oltip_3 = tooltip;
                String _get = (String)tooltipMap.get(periph);
                Object _oltip_4 = tooltip = (String)_oltip_3 + _get;
                tooltip = (String)_oltip_4 + "</pre>";
                continue;
            }
            String _oltip_5 = tooltip;
            String _string = cfg.toString();
            String _plus_8 = "   " + _string;
            String _plus_9 = _plus_8 + "<br/>";
            tooltip = _oltip_5 + _plus_9;
        }
        Set _keySet = tooltipMap.keySet();
        for (String key : _keySet) {
            String _oltips = tooltips;
            Object _oltips_1 = tooltips = _oltips + "<em>" + key + "</em><br/>";
            String _get = (String)tooltipMap.get(key);
            tooltips = (String)_oltips_1 + _get;
        }
        _xblockexpression = tooltips;
        return _xblockexpression;
    }

    public String getTooltipConfigured(PinSetting ps) {
        HashMap tooltipMap;
        Function fct;
        String _xblockexpression = null;
        HashMap pinMap = new HashMap();
        Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)ps);
        String psPeriph = "";
        String psFct = "";
        if (ps != null && (fct = ps.getConfig().getAlt()) != null) {
            psFct = fct.getName();
            psPeriph = fct.getPeripheralRef().getName();
        }
        if ((tooltipMap = (HashMap)pinMap.get(pin)) == null) {
            HashMap _hashMap = new HashMap();
            pinMap.put(pin, _hashMap);
            tooltipMap = (HashMap)pinMap.get(pin);
        }
        Object tooltips = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            Object tooltip = "";
            String periph = "";
            if (cfg instanceof SystemFunctionPin) {
                SystemFunctionPin sfp = (SystemFunctionPin)cfg;
                String _xifexpression = null;
                Peripheral _peripheralRef = sfp.getRef().getPeripheralRef();
                boolean _tripleNotEquals = _peripheralRef != null;
                _xifexpression = _tripleNotEquals ? sfp.getRef().getPeripheralRef().getName() : "System function";
                periph = _xifexpression;
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                Object _oltip = tooltip;
                String _label = sfp.getRef().getLabel();
                String _plus = _label + " (";
                String _name = sfp.getDirection().getName();
                String _plus_1 = _plus + _name;
                String _plus_2 = _plus_1 + ")";
                String _plus_3 = _plus_2 + "<br/>";
                tooltip = (String)_oltip + _plus_3;
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof SpecialPin) {
                SpecialPin sp = (SpecialPin)cfg;
                periph = sp.getDirection().getName();
                tooltip = (String)tooltipMap.get(periph);
                if (tooltip == null) {
                    tooltipMap.put(periph, "");
                    tooltip = (String)tooltipMap.get(periph);
                }
                String _oltip_1 = tooltip;
                String _label_1 = sp.getRef().getLabel();
                Object _oltip_2 = tooltip = _oltip_1 + (String)_label_1;
                tooltip = (String)_oltip_2 + "<br/>";
                tooltipMap.put(periph, tooltip);
                continue;
            }
            if (cfg instanceof ConfigurablePin) {
                ConfigurablePin sfp_1 = (ConfigurablePin)cfg;
                EList _functions = sfp_1.getRef().getFunctions();
                for (FunctionRef c : _functions) {
                    String fctName;
                    boolean _equals;
                    periph = c.getName().getPeripheralRef().getName();
                    Object t = (String)tooltipMap.get(periph);
                    if (t == null) {
                        tooltipMap.put(periph, "");
                        t = (String)tooltipMap.get(periph);
                    }
                    if (_equals = (fctName = c.getName().getName()).equals(psFct)) {
                        String _t = t;
                        String _name_1 = c.getName().getName();
                        String _plus_4 = "   <b>" + _name_1;
                        String _plus_5 = _plus_4 + "</b><br/>";
                        t = _t + _plus_5;
                    } else {
                        String _t_1 = t;
                        String _name_2 = c.getName().getName();
                        String _plus_6 = "   " + _name_2;
                        String _plus_7 = _plus_6 + "<br/>";
                        t = _t_1 + _plus_7;
                    }
                    tooltipMap.put(periph, t);
                }
                String _oltip_3 = tooltip;
                String _get = (String)tooltipMap.get(periph);
                Object _oltip_4 = tooltip = _oltip_3 + _get;
                tooltip = (String)_oltip_4 + "</pre>";
                continue;
            }
            String _oltip_5 = tooltip;
            String _string = cfg.toString();
            String _plus_4 = "   " + _string;
            String _plus_5 = _plus_4 + "<br/>";
            tooltip = _oltip_5 + _plus_5;
        }
        Set _keySet = tooltipMap.keySet();
        for (String key : _keySet) {
            boolean _equals = key.equals(psPeriph);
            if (_equals) {
                String _oltips = tooltips;
                tooltips = _oltips + "<b>" + key + "</b><br/>";
            } else {
                String _oltips_1 = tooltips;
                tooltips = _oltips_1 + "<em>" + key + "</em><br/>";
            }
            Object _oltips_2 = tooltips;
            String _get = (String)tooltipMap.get(key);
            tooltips = (String)_oltips_2 + _get;
        }
        _xblockexpression = tooltips;
        return _xblockexpression;
    }

    public String generatePin(PinSetting pinSetting, Map<EObject, Map<Integer, List<String>>> errorsMap) {
        String _xblockexpression = null;
        this._pinCfgHelper = PinCfgHelper.instance;
        Utils util = Utils.instance;
        Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)pinSetting);
        Object tooltip = "";
        String portLabel = "";
        EList _pinConfigurations = pin.getPinConfigurations();
        for (PinConfig cfg : _pinConfigurations) {
            if (!(cfg instanceof ConfigurablePin)) continue;
            portLabel = ((ConfigurablePin)cfg).getRef().getLabel();
        }
        String _oltip = tooltip;
        String _name = pin.getName();
        String _plus = "<b>" + _name;
        String _plus_1 = _plus + ": ";
        String _plus_2 = _plus_1 + portLabel;
        String _plus_3 = _plus_2 + " as ";
        String _name_1 = pinSetting.getName();
        String _plus_4 = _plus_3 + _name_1;
        String _plus_5 = _plus_4 + "</b><br/>";
        Object _oltip_1 = tooltip = _oltip + _plus_5;
        Direction _direction = pinSetting.getConfig().getDirection();
        String _plus_6 = "<pre>Direction: " + String.valueOf(_direction);
        String _plus_7 = _plus_6 + "<br/>";
        Object _oltip_2 = tooltip = (String)_oltip_1 + _plus_7;
        String _functionName = this._pinCfgHelper.getFunctionName(pinSetting);
        String _plus_8 = "Function: " + _functionName;
        String _plus_9 = _plus_8 + "<br/><br/>";
        Object _oltip_3 = tooltip = (String)_oltip_2 + _plus_9;
        String _tooltipConfigured = this.getTooltipConfigured(pinSetting);
        tooltip = (String)_oltip_3 + _tooltipConfigured;
        this._pinCfgHelper = PinCfgHelper.instance;
        Object _oltip_4 = tooltip;
        tooltip = (String)_oltip_4 + "</pre><br/>";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("onmouseenter=\"sttConfigured(evt,'");
        _builder.append((String)tooltip, " ");
        _builder.append("');\"");
        String tooltipElt = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(" ");
        _builder_1.append("onmouseenter=\"sttConfigured(evt);\"");
        String tooltipElt2 = _builder_1.toString();
        _xblockexpression = this.genPinmapView.createConfiguredPin(pin, "#00FF00", tooltipElt, tooltipElt2, pinSetting.getName(), GeneratePinSettingsLQFP.getDirection(pinSetting.getConfig().getDirection()), this.isBoardPin(pinSetting), errorsMap);
        return _xblockexpression;
    }

    public boolean isBoardPin(PinSetting pin) {
        this._pinCfgHelper = PinCfgHelper.instance;
        EObject _eContainer = pin.eContainer().eContainer();
        return _eContainer instanceof Board;
    }

    public static com.st.stellar.pinmap.pinmapDsl.Direction getDirection(Direction pinDirection) {
        com.st.stellar.pinmap.pinmapDsl.Direction _xblockexpression = null;
        com.st.stellar.pinmap.pinmapDsl.Direction res = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT;
        if (pinDirection != null) {
            switch (pinDirection) {
                case INPUT: {
                    res = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT;
                    break;
                }
                case OUTPUT: {
                    res = com.st.stellar.pinmap.pinmapDsl.Direction.OUTPUT;
                    break;
                }
                case INPUT_OUTPUT: {
                    res = com.st.stellar.pinmap.pinmapDsl.Direction.INPUT_OUTPUT;
                    break;
                }
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public List<Function> getFunctions(Configuration config, Peripheral periph) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        EList functions = config.getFunctions();
        Functions.Function1 _function = it -> it.getName().getPeripheralRef() != null && it.getName().getPeripheralRef().getName().equals(periph.getName());
        Functions.Function1 _function_1 = it -> it.getName();
        Iterables.addAll((Collection)list, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)functions, (Functions.Function1)_function), (Functions.Function1)_function_1));
        _xblockexpression = list;
        return _xblockexpression;
    }

    @XbaseGenerated
    public String getRefId(EObject pin) {
        if (pin instanceof ConfigurablePin) {
            return this._getRefId((ConfigurablePin)pin);
        }
        if (pin instanceof PinSetting) {
            return this._getRefId((PinSetting)pin);
        }
        if (pin instanceof PinSettings) {
            return this._getRefId((PinSettings)pin);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pin).toString());
    }
}

