/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.htmlGenerator.runtime;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.FieldInstance;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pincfg.htmlGenerator.runtime.GeneratePinSettings;
import com.st.stellar.pinmap.pincfg.htmlGenerator.runtime.GeneratePinSettingsBGA;
import com.st.stellar.pinmap.pincfg.htmlGenerator.runtime.GeneratePinSettingsLQFP;
import com.st.stellar.pinmap.pincfg.htmlGenerator.runtime.PinSettingsErrorManager;
import com.st.stellar.pinmap.pinmapDsl.BGAPackage;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.pinmapDsl.LQFPPackage;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.validation.PinCfgValidationMessageAcceptor;
import com.st.stellar.pinmap.validation.PinCfgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PinCfgHtmlGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        PinSettings _pinSetting;
        ResourceSet resourceSet = (ResourceSet)this.rsp.get();
        Resource r = resourceSet.getResource(resource.getURI(), true);
        boolean _isEmpty = r.getContents().isEmpty();
        if (_isEmpty) {
            return;
        }
        EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
        PinConfiguration configuration = (PinConfiguration)_head;
        boolean generateHtml = context.getCancelIndicator().getClass().getName().contains("GenerateHTMLDiagramCancelIndicator");
        if (generateHtml && (_pinSetting = configuration.getPinSetting()) instanceof PinSettings) {
            Package _package_1;
            PinSettings _pinSetting_1;
            PinSettings pinSettings = _pinSetting_1 = configuration.getPinSetting();
            String imageHtml = "";
            Board incBoard = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard());
            Package _package = incBoard.getPackage();
            if (_package instanceof LQFPPackage) {
                GeneratePinSettingsLQFP _generatePinSettingsLQFP = new GeneratePinSettingsLQFP();
                imageHtml = this.generateHTML(configuration, _generatePinSettingsLQFP);
            }
            if ((_package_1 = incBoard.getPackage()) instanceof BGAPackage) {
                GeneratePinSettingsBGA _generatePinSettingsBGA = new GeneratePinSettingsBGA();
                imageHtml = this.generateHTML(configuration, _generatePinSettingsBGA);
            }
            String filename = this._pinCfgHelper.getGenerationFileName(pinSettings, "html");
            fsa.generateFile(filename, (CharSequence)imageHtml);
            PinCfgHtmlGenerator.updateExplorer((EObject)configuration);
        }
    }

    public String generateHTML(PinConfiguration cfg, GeneratePinSettings gen) {
        boolean _greaterThan;
        boolean _tripleEquals;
        boolean _not;
        PinSettings _pinSetting = cfg.getPinSetting();
        boolean bl = _not = !(_pinSetting instanceof PinSettings);
        if (_not) {
            return null;
        }
        PinSettings _pinSetting_1 = cfg.getPinSetting();
        PinSettings pinSettings = _pinSetting_1;
        Package _package = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage();
        boolean bl2 = _tripleEquals = _package == null;
        if (_tripleEquals) {
            return null;
        }
        EObject _eContainer = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage().eContainer();
        String n = ((Family)_eContainer).getName();
        n = n.replaceAll("x", pinSettings.getName());
        EList modules = PinCfgHelper.getAllModules((PinSettings)cfg.getPinSetting());
        List configuredPins = CollectionLiterals.newArrayList();
        int _size = modules.size();
        boolean bl3 = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getPins();
            configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)modules, (Functions.Function1)_function));
        }
        Map<EObject, Map<Integer, List<String>>> errorsMap = this.generateErrors(cfg, configuredPins);
        String imageHtml = gen.generateView(pinSettings, errorsMap);
        return imageHtml;
    }

    public String generateHTMLLQFP(PinConfiguration cfg) {
        boolean _greaterThan;
        boolean _tripleEquals;
        boolean _not;
        PinSettings _pinSetting = cfg.getPinSetting();
        boolean bl = _not = !(_pinSetting instanceof PinSettings);
        if (_not) {
            return null;
        }
        PinSettings _pinSetting_1 = cfg.getPinSetting();
        PinSettings pinSettings = _pinSetting_1;
        Package _package = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage();
        boolean bl2 = _tripleEquals = _package == null;
        if (_tripleEquals) {
            return null;
        }
        EObject _eContainer = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage().eContainer();
        String n = ((Family)_eContainer).getName();
        n = n.replaceAll("x", pinSettings.getName());
        GeneratePinSettingsLQFP gen = new GeneratePinSettingsLQFP();
        EList modules = PinCfgHelper.getAllModules((PinSettings)cfg.getPinSetting());
        List configuredPins = CollectionLiterals.newArrayList();
        int _size = modules.size();
        boolean bl3 = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getPins();
            configuredPins = IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)modules, (Functions.Function1)_function));
        }
        Map<EObject, Map<Integer, List<String>>> errorsMap = this.generateErrors(cfg, configuredPins);
        String imageHtml = gen.generateView(pinSettings, errorsMap);
        return imageHtml;
    }

    public static IProject getProject(EObject model) {
        boolean _not;
        IProject project = null;
        URI uri = model.eResource().getURI();
        boolean _isFile = uri.isFile();
        boolean bl = _not = !_isFile;
        if (_not) {
            project = null;
        }
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public void checkNoDuplicatedPinNames(PinConfiguration cfg, Multimap<String, String> errors) {
        PinSettings _pinSetting;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        HashMultimap multiMap = HashMultimap.create();
        Board _board = cfg.getBoard();
        boolean bl = _tripleNotEquals = _board != null;
        if (_tripleNotEquals) {
            List _pinSettings = PinCfgHelper.getPinSettings((Board)cfg.getBoard());
            for (PinSetting e : _pinSettings) {
                multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
            }
        }
        boolean bl2 = _tripleNotEquals_1 = (_pinSetting = cfg.getPinSetting()) != null;
        if (_tripleNotEquals_1) {
            List _allPinSettings = PinCfgHelper.getAllPinSettings((PinConfiguration)cfg);
            for (PinSetting pinSetting : _allPinSettings) {
                multiMap.put((Object)pinSetting.getName().toLowerCase(Locale.ENGLISH), (Object)pinSetting);
            }
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (PinSetting d : duplicates) {
                String _name = d.getPad().getName();
                String _name_1 = d.getName();
                String _plus = "Duplicated pin identifier: " + _name_1;
                errors.put((Object)_name, (Object)_plus);
            }
        }
    }

    public boolean isBoardPin(PinSetting pin) {
        this._pinCfgHelper = PinCfgHelper.instance;
        EObject _eContainer = pin.eContainer().eContainer();
        return _eContainer instanceof Board;
    }

    public boolean relatedToPinSetting(Diagnostic diag, PinSetting ps) {
        if (ps == null || ps.getIoFields() == null) {
            return false;
        }
        boolean res = false;
        ArrayList objList = CollectionLiterals.newArrayList();
        objList.add(ps);
        objList.add(ps.getConfig());
        objList.add(ps.getIoFields());
        EList _reg = ps.getIoFields().getReg();
        for (FieldInstance reg : _reg) {
            objList.add(reg);
        }
        boolean _contains = objList.contains(diag.getData().get(0));
        if (_contains) {
            res = true;
        }
        return res;
    }

    public Map<EObject, Map<Integer, List<String>>> generateErrors(PinConfiguration pinConfiguration, List<PinSetting> configuredPins) {
        PinSettingsErrorManager errorManager = new PinSettingsErrorManager();
        PinCfgValidator.checkNoDuplicatedPinNames((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        PinCfgValidator.checkUniqueFunctionUsage((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        PinCfgValidator.checkPinAlreadyUsed((PinConfiguration)pinConfiguration, (PinCfgValidationMessageAcceptor)errorManager);
        HashMap errorsMap = CollectionLiterals.newHashMap();
        for (PinSetting ps : configuredPins) {
            Collection warnings;
            int _size_2;
            boolean _greaterThan_2;
            Collection errors;
            int _size_1;
            boolean _greaterThan_1;
            int _size;
            boolean _greaterThan;
            boolean _isBoardPin;
            List errorsList;
            List warningsList;
            List infosList;
            Map _get;
            ArrayList diags = new ArrayList();
            Pin pin = PinCfgHelper.getPinForConfiguration((PinSetting)ps);
            PinCfgValidator.checkMissingRegInstances((PinSetting)ps, (PinCfgValidationMessageAcceptor)errorManager);
            Map psMap = _get = (Map)errorsMap.get(pin);
            if (psMap == null) {
                psMap = CollectionLiterals.newHashMap();
                errorsMap.put(pin, psMap);
            }
            if ((infosList = (List)psMap.get(1)) == null) {
                infosList = CollectionLiterals.newArrayList();
                psMap.put(1, infosList);
            }
            if ((warningsList = (List)psMap.get(2)) == null) {
                warningsList = CollectionLiterals.newArrayList();
                psMap.put(2, warningsList);
            }
            if ((errorsList = (List)psMap.get(4)) == null) {
                errorsList = CollectionLiterals.newArrayList();
                psMap.put(4, errorsList);
            }
            if (_isBoardPin = this.isBoardPin(ps)) {
                Diagnostic errorCfg = Diagnostician.INSTANCE.validate((EObject)pinConfiguration);
                List errorsCfg = errorCfg.getChildren();
                Functions.Function1 _function = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsCfg, (Functions.Function1)_function));
                for (Diagnostic e : errorsCfg) {
                    Functions.Function1 _function_1 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e.getChildren(), (Functions.Function1)_function_1));
                }
                Diagnostic errorPs = Diagnostician.INSTANCE.validate((EObject)ps);
                List errorsPs = errorPs.getChildren();
                Functions.Function1 _function_2 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsPs, (Functions.Function1)_function_2));
                for (Diagnostic e_1 : errorsPs) {
                    Functions.Function1 _function_3 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e_1.getChildren(), (Functions.Function1)_function_3));
                }
            } else {
                Diagnostic errorPs_1 = Diagnostician.INSTANCE.validate((EObject)ps);
                List errorsPs_1 = errorPs_1.getChildren();
                Functions.Function1 _function_4 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)errorsPs_1, (Functions.Function1)_function_4));
                for (Diagnostic e_2 : errorsPs_1) {
                    Functions.Function1 _function_5 = it -> this.relatedToPinSetting((Diagnostic)it, ps);
                    Iterables.addAll(diags, (Iterable)IterableExtensions.filter((Iterable)e_2.getChildren(), (Functions.Function1)_function_5));
                }
            }
            boolean bl = _greaterThan = (_size = diags.size()) > 0;
            if (_greaterThan) {
                Functions.Function1 _function_6 = d -> {
                    int _severity = d.getSeverity();
                    return _severity == 4;
                };
                Functions.Function1 _function_7 = it -> it.getMessage();
                Consumer<String> _function_8 = msg -> errorManager.errors.put((Object)ps, msg);
                IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_6), (Functions.Function1)_function_7).forEach(_function_8);
                Functions.Function1 _function_9 = d -> {
                    int _severity = d.getSeverity();
                    return _severity == 2;
                };
                Functions.Function1 _function_10 = it -> it.getMessage();
                Consumer<String> _function_11 = msg -> errorManager.warnings.put((Object)ps, msg);
                IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_9), (Functions.Function1)_function_10).forEach(_function_11);
                Functions.Function1 _function_12 = d -> {
                    int _severity = d.getSeverity();
                    return _severity == 1;
                };
                Functions.Function1 _function_13 = it -> it.getMessage();
                Consumer<String> _function_14 = msg -> errorManager.infos.put((Object)ps, msg);
                IterableExtensions.map((Iterable)IterableExtensions.filter(diags, (Functions.Function1)_function_12), (Functions.Function1)_function_13).forEach(_function_14);
            }
            boolean bl2 = _greaterThan_1 = (_size_1 = (errors = errorManager.errors.get((Object)ps)).size()) > 0;
            if (_greaterThan_1) {
                Consumer<String> _function_15 = msg -> ((List)((Map)errorsMap.get(pin)).get(4)).add(msg);
                errors.forEach(_function_15);
            }
            if (!(_greaterThan_2 = (_size_2 = (warnings = errorManager.warnings.get((Object)ps)).size()) > 0)) continue;
            Consumer<String> _function_16 = msg -> ((List)((Map)errorsMap.get(pin)).get(2)).add(msg);
            warnings.forEach(_function_16);
        }
        return errorsMap;
    }

    public static void updateExplorer(EObject model) {
        IProject project = PinCfgHtmlGenerator.getProject(model);
        if (project != null) {
            try {
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public static String getFunctionName(PinSetting pinSetting) {
        return pinSetting.getConfig().getAlt().getName();
    }
}

