package com.st.stellar.pinmap.pincfg.htmlGenerator.runtime

import com.google.inject.Inject
import com.st.stellar.pinmap.generator.GeneratePinmapView
import com.st.stellar.pinmap.helpers.PinCfgHelper
import com.st.stellar.pinmap.helpers.Utils
import com.st.stellar.pinmap.pinCfg.Board
import com.st.stellar.pinmap.pinCfg.PinSetting
import com.st.stellar.pinmap.pinCfg.PinSettings
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin
import com.st.stellar.pinmap.pinmapDsl.Configuration
import com.st.stellar.pinmap.pinmapDsl.Family
import com.st.stellar.pinmap.pinmapDsl.Function
import com.st.stellar.pinmap.pinmapDsl.Peripheral
import com.st.stellar.pinmap.pinmapDsl.Pin
import com.st.stellar.pinmap.pinmapDsl.SpecialPin
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin
import java.util.ArrayList
import java.util.HashMap
import java.util.HashSet
import java.util.List
import java.util.Locale
import java.util.Map
import java.util.Set
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.EObject

class GeneratePinSettingsBGA implements GeneratePinSettings {

	@Inject extension Utils
	val genPinmapView = new GeneratePinmapView

	@Inject extension PinCfgHelper;

	def dispatch String getRefId(PinSettings settings) {
		var n = (PinCfgHelper.getBoard(settings.includedBoard).package.eContainer as Family).name
		n = n.replaceAll('x', PinCfgHelper.getBoard(settings.includedBoard).package.name)
		var a = n.indexOf('_')
		n = n.substring(0, a)
		n
	}

	def dispatch String getRefId(PinSetting setting) {
		setting.pad.getRefId
	}

	def dispatch String getRefId(ConfigurablePin pin) {
		var cfg = pin.ref as Configuration
		cfg.name

	}

	new() {
		errors = new StringBuilder("errors:\n")
		warnings = new StringBuilder("warnings:\n")
	}

	var StringBuilder errors

	def error(String message) {
		errors.append("error: " + message + "\n")
	}

	var StringBuilder warnings

	def warning(String message) {
		warnings.append("warning: " + message + "\n")
	}

	def generateReport() {
		return errors.append(warnings)
	}

	def int getPortNb(String s) {
		val subString = s.charAt(1)
		var int port = Character.getNumericValue(subString)
		val begin = Character.getNumericValue('A')
		val int portNb = port - begin
		portNb
	}

	def int getBit(String s) {
		val subString = s.substring(2, s.length)
		Integer.parseInt(subString)
	}

	public static val pinWidth = 40
	public static val pinHeight = 40
	public static val pinMarginWidth = 3
	public static val pinMarginHeight = 3
	public static val fontSize = pinWidth / 3

	static private def script(String instancesOfPeripherals, String functionsOfPeripherals, String tooltipsArray) '''
	<script type="text/javascript">
		var svg = null;
		var oldpads = [];
		var oldcolors = [];
		var oldstroke = [];
		var oldstrokeWidth = [];
		
		function init() {
		    svg = document.getElementById('svg-doc');
		
		    var size = getSVGSize();
		    //console.log(size);
		    
			// Add mouse out events on elements matching cPin and configuredPin classes
			var elements = document.getElementsByClassName("cPin");
			for (var i = 0; i < elements.length; i++) {
			const elt = elements[i];
				elt.addEventListener('mouseout', function(event) {
					htt();
				});
				elt.addEventListener('mouseenter', function(event) {
					const value = elt.value;
					if( value ) {
						onmouseenter="stt(evt,value);"
					}
				});
			}
			elements = document.getElementsByClassName("configuredPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}
			elements = document.getElementsByClassName("sPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}
			elements = document.getElementsByClassName("fPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}		    
		}
		
		function getSVGSize() {
		    var svgDoc = svg;
		    if (svgDoc) {
		        var width = svgDoc.getAttribute('width');
		        var height = svgDoc.getAttribute('height');
		        res = '<' + width + ',' + height + '>';
		        return res;
		    } else {
		        return null;
		    }
		}
		
		var hideLayer = function(elem) {
		    if (elem) {
		        var elt = svg.getElementById(elem);
		        if (elt) {
		            elt.style.display = "none";
		        }
		    }
		}
		
		var showLayer = function(elem) {
		    if (elem) {
		        var elt = svg.getElementById(elem);
		        if (elt) {
		            elt.style.display = "inline";
		        }
		    }
		}
		var selectedPeriph = "";
		var selectedInstance = "";
		var selectedFunction = "";
		
		function comboPeriph() {
		    hideLayer('main_layer')
		    if (selectedPeriph) {
		        console.log('from: ' + selectedPeriph);
		        hideLayer('animation_layer_' + selectedPeriph)
		    }
		    if (selectedInstance) {
		        hideLayer('animation_layer_' + selectedInstance)
		    }
		    if (selectedFunction) {
		        hideLayer('animation_layer_' + selectedFunction)
		    }
		    var combo = document.getElementById("comboPeriph")
		    var idx = combo.selectedIndex;
		    var content = combo.options[idx].innerHTML;
		    selectedPeriph = content;
		    if (selectedPeriph === "None") {
		        document.getElementById("instance").innerHTML = "<option value=\"\" selected>None</option>";
		        document.getElementById("function").innerHTML = "<option value=\"\" selected>None</option>";
		    }
		    console.log('to: ' + content);
		    showLayer('main_layer')
		    showLayer('animation_layer_' + content)
		    changecat(combo.value);
		}
		
		function comboPeriphInstance() {
		    var thelist = document.getElementById('instance');
		    hideLayer('main_layer')
		    if (selectedPeriph) {
		        hideLayer('animation_layer_' + selectedPeriph)
		    }
		    if (selectedInstance) {
		        console.log('from: ' + selectedInstance);
		        hideLayer('animation_layer_' + selectedInstance)
		    }
		    if (selectedFunction) {
		        hideLayer('animation_layer_' + selectedFunction)
		    }
		    var idx = thelist.selectedIndex;
		    var content = thelist.options[idx].innerHTML;
		    selectedInstance = content;
		    console.log('to: ' + content);
		    showLayer('main_layer')
		    showLayer('animation_layer_' + content)
		    changeinstance(thelist.value);
		}
		
		function comboFunction() {
		    var thelist = document.getElementById('function');
		    hideLayer('main_layer')
		    if (selectedPeriph) {
		        hideLayer('animation_layer_' + selectedPeriph)
		    }
		    if (selectedInstance) {
		        hideLayer('animation_layer_' + selectedInstance)
		    }
		    if (selectedFunction) {
		        console.log('from: ' + selectedFunction);
		        hideLayer('animation_layer_' + selectedFunction)
		    }
		    var idx = thelist.selectedIndex;
		    var content = thelist.options[idx].innerHTML;
		    console.log('comboFunction:' + content)
		    selectedFunction = content;
		    console.log('to: ' + content);
		    if (content === "All") {
		        comboPeriphInstance(selectedInstance);
		    }
		    showLayer('main_layer')
		    showLayer('animation_layer_' + content)
		}
		
		function replaceCharByInt(correspondance, p1, p2, p3, p4, decalage, chaine) {
		    // Regular expression is: (pad_P?)([^_]?)(_?)(\d*)
		    //                           p1     p2    p3   p4
		    // Convert p2 from Alphabetic character to integer (A -> 0, B -> 1...)
		    //let index = p2.toUpperCase().charCodeAt(0)-65;
		    p3 = "";
		    //if( index >= 0) {
		    //return ["pad_P", index, p3, p4].join('');
		    //} else {
		    return ["pad_P", p2, p3, p4].join('');
		    //}
		}
		
		function replaceCharByInt2(correspondance, p1, p2, p3, p4, decalage, chaine) {
		    // Regular expression is: (pad_P?)([^_]?)(_?)(\d*)
		    //                           p1     p2    p3   p4
		    // Convert p2 from Alphabetic character to integer (A -> 0, B -> 1...)
		    //let index = p2.toUpperCase().charCodeAt(0)-65;
		    p3 = "";
		    return ["configured_P", p2, p3, p4].join('');
		}
	
		function findElements(name) {
		   var elArray = [];
		   var elements1 = document.getElementsByClassName("cPin");
		   var elements2 = document.getElementsByClassName("configuredPin");
	
		    var padName = name.replace(/(pad_P?)([^\d]?)(_?)(\d*)/, replaceCharByInt);
		    var regex = new RegExp(padName);
		    var padName2 = name.replace(/(pad_P?)([^\d]?)(_?)(\d*)/, replaceCharByInt2);
		    var regex2 = new RegExp(padName2);
	
			var elements = [];
			for (var i = 0; i < elements1.length; i++) {
				elements.push(elements1[i]);
				  }
			for (var i = 0; i < elements2.length; i++) {
				elements.push(elements2[i]);
				  }
				  for (var i = 0; i < elements.length; i++) {
				      if (regex.test(elements[i].id) || regex2.test(elements[i].id)) {
				          elArray.push(elements[i]);
				      }
				  }
				  return elArray;
		}
		
		// Function to find and log elements with matching text pattern
		function findMatchingTextElements(targetString) {
			var elArray = [];
			var elements = document.getElementsByClassName(targetString);
			for (var i = 0; i < elements.length; i++) {
				var element = elements[i];
				elArray.push(element);
			}
			return elArray;
		}
		
		
		function selectPad() {
		    var input = document.getElementById("padToSelect");
		    var pad = input.value.toUpperCase();
		
		    pad = pad.replace("[", "");
		    pad = pad.replace("]", "");
		    pad = pad.replace(".*", "");
		    pad = pad.replace("*", "");
		    pad = pad.concat("$");
		    for (var i = 0; i < oldpads.length; i++) {
		        var elt = oldpads[i];
		        //if (elt.id.length > 10) { // Ugly patch as soon as elt.id.startsWith('configured_') function does not work properly on internal WEB browser
		            elt.style.fill = oldcolors[i];
		            elt.style.stroke = oldstroke[i];
		            elt.style.strokeWidth = oldstrokeWidth[i];
		        //} else {
		        //    elt.style.fill = 'white';
		        //    elt.style.stroke = 'black';
		        //    elt.style.strokeWidth = '0.5px';
		        //}
		    }
		    oldpads = [];
		    oldcolors = [];
		    oldstroke = [];
		    oldstrokeWidth = [];
		    var padName = "^pad_P";
		    padName = padName.concat(pad.toUpperCase());
		    padName = padName.replace("_PP", "_P");
		
		    var matchingPads = findElements(padName);
			var pads = [];
			for (var i = 0; i < matchingPads.length; i++) {
			   var elt = matchingPads[i];
			   pads.push(elt);
				const padId = elt.id.replace("pad_","");
				var matchingElts = findMatchingTextElements(padId);
					for (var j = 0; j < matchingElts.length; j++) {
						pads.push(matchingElts[j]);
				}
			}			
	
	   oldpads = pads;
			for (var i = 0; i < pads.length; i++) {
			   var elt = pads[i];
			   oldcolors[i] = elt.style.fill;
			   oldstroke[i] = elt.style.stroke;
			   oldstrokeWidth[i] = elt.style.strokeWidth;
			   elt.style.fill = '#ffd200';
			   elt.style.fillOpacity = '1';
			   elt.style.strokeWidth = '2px';
			   elt.style.stroke = 'black';
			}
		}
	
		«instancesOfPeripherals»
	
		«functionsOfPeripherals»
		
		«tooltipsArray»
	
		function changecat(value) {
		   console.log('changecat: ' + value);
		   if (value.length == 0 || instanceOfPeripherals[value].length == 0) {
		       document.getElementById("instance").innerHTML = "<option selected>None</option>";
		       document.getElementById("function").innerHTML = "<option selected>None</option>";
		   } else {
		       if (instanceOfPeripherals[value].length == 1) {
		           var categoryId = instanceOfPeripherals[value][0];
		           var catOptions = "<option value=\"All\" selected>" + categoryId + "</option>";
		           document.getElementById("instance").innerHTML = catOptions;
		           document.getElementById("function").innerHTML = "<option value=\"\">All</option>";
		           changeinstance(categoryId);
		       } else {
		           var catOptions = "<option selected>All</option>";
		           for (categoryId in instanceOfPeripherals[value]) {
		               catOptions += "<option>" + instanceOfPeripherals[value][categoryId] + "</option>";
		           }
		           document.getElementById("instance").innerHTML = catOptions;
		           document.getElementById("function").innerHTML = "<option value=\"\" selected>All</option>";
		       }
		   }
		}
		
		function changeinstance(value) {
		    if (value.length == 0) {
		        document.getElementById("function").innerHTML = "<option selected>All</option>";
		    } else {
		        var index = document.getElementById("instance").options.selectedIndex
		        var periph = document.getElementById("instance").options[index].text
		        //console.log(functionsOfPeripherals[periph])
		        if (value === "All") {
		            console.log("selected periph:" + selectedPeriph);
		            comboPeriph();
		        } else if (functionsOfPeripherals[value].length == 1) {
		            var categoryId = functionsOfPeripherals[value][0];
		            var catOptions = "<option selected>" + categoryId + "</option>";
		            document.getElementById("function").innerHTML = catOptions;
		        } else {
		            var catOptions = "<option selected>All</option>";
		            for (categoryId in functionsOfPeripherals[periph]) {
		                catOptions += "<option>" + functionsOfPeripherals[periph][categoryId] + "</option>";
		            }
		            document.getElementById("function").innerHTML = catOptions;
		        }
		    }
		}
		
		var oldTooltipText = "";
		function stt(evt, pin) { // show tooltip
			let tooltip = document.getElementById("tooltip");
			var text = tooltipsArray[pin];
			if( text ) {
				tooltip.innerHTML = text;
				oldTooltipText = text;
			} else {
				tooltip.innerHTML = oldTooltipText;
			}
			tooltip.style.display = "block";
			tooltip.style.left = evt.pageX + 10 + 'px';
			tooltip.style.top = evt.pageY + 10 + 'px';
		}
	
		function sttConfigured(evt, text) { // show tooltip
		let tooltip = document.getElementById("tooltip");
		if( text ) {
			tooltip.innerHTML = text;
			oldTooltipText = text;
		} else {
			tooltip.innerHTML = oldTooltipText;
		}
		tooltip.style.display = "block";
		tooltip.style.left = evt.pageX + 10 + 'px';
		tooltip.style.top = evt.pageY + 10 + 'px';
		}
	
		function htt() { // Hide tooltip
		   var tooltip = document.getElementById("tooltip");
		   tooltip.style.display = "none";
		}
		
		function toggleLegend() {
				var legend = document.getElementById('legend');
				var button = document.querySelector('.legend-title');
				if (legend.style.display === 'none' || legend.style.display === '') {
				    legend.style.display = 'flex';
				    button.textContent = 'Hide color legend';
				} else {
				    legend.style.display = 'none';
				    button.textContent = 'Show color legend';
				}
			}
		function showtt(text) { // show tooltip
			let tooltip = document.getElementById("tooltip");
			if( text ) {
				tooltip.innerHTML = text;
				oldTooltipText = text;
			} else {
				tooltip.innerHTML = oldTooltipText;
			}
			tooltip.style.display = "block";
			tooltip.style.left = event.pageX + 10 + 'px';
			tooltip.style.top = event.pageY + 10 + 'px';
		}
	</script>'''

	override generateView(PinSettings settings, Map<EObject, Map<Integer, List<String>>> errorsMap) {
		var writtenPins = new ArrayList<PinSetting>

		_pinCfgHelper = PinCfgHelper.instance
		var pins = ""
		for (mod : PinCfgHelper.getAllModules(settings)) {
			for (pin : mod.pins) {
				if (writtenPins.filter[it|it.config.alt.name.equals(pin.config.alt.name)].size == 0) {
					writtenPins.add(pin)
					pins += pin.generatePin(errorsMap)
				}
			}
		}

		// Map of peripherals : maps set of peripherals matching a peripheral display name
		var peripheralMap = new HashMap<String, Set<String>>

		// Map of functions : maps set of functions related to a peripheral
		var functionsMap = new HashMap<String, Set<String>>

		var Set<String> peripheralNameSet = null

		// In order to add model, package and board in the picture we need to get these info from the current pinSettings
		val incBoard = PinCfgHelper.getBoard(settings.includedBoard)
		val pack = incBoard.package
		var model = settings.pinmapModel.name
		model = model.substring(model.lastIndexOf(".") + 1);

		for (pin : pack.pins) {
			for (cfg : pin.pinConfigurations.filter(ConfigurablePin)) { // only considers Configurable pin
				for (fctref : cfg.ref.functions) {
					val perDisplay = fctref.name.peripheralRef.label

					val periphName = fctref.name.peripheralRef.name
					var Set<String> funcList = functionsMap.get(periphName)
					if (funcList === null) {
						funcList = new HashSet<String>
						functionsMap.put(periphName, funcList)
					}
					val validFunctions = cfg.ref.getFunctions(fctref.name.peripheralRef)
					for (f : validFunctions) {
						funcList.add(f.name)
					}

					if (validFunctions.size > 0) {
						// Get the list of peripherals associated to the peripheral (create it if needed)
						peripheralNameSet = peripheralMap.get(perDisplay)
						if (peripheralNameSet === null) {
							peripheralNameSet = new HashSet<String>
							peripheralMap.put(perDisplay, peripheralNameSet)
						}
						peripheralNameSet.add(periphName)
					}

				}
			}
		}
		var peripherals = peripheralMap.keySet.sort

		val pinmapView = genPinmapView.generatePackage(incBoard.package, pins)

		val legend = '''
			<div class="tooltipLegend">
				<button class="legend-title" onclick="toggleLegend()">
				Show legend</button>
			</div>
		'''

		val peripheralCombo = '''
		<div class="legend-container">
			<div class="legend" id="legend">
				<div class="legend-item">
					<div class="color-box" style="background-color: #e7017e;"
					onmouseenter="showtt('Board predefined pins (modifiable only in <b><em>.gpio_board</em></b> file).')" onmouseout="htt()"></div>
					<span>Board predefined pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #49b170;"
					onmouseenter="showtt('User configured pins (modifiable in <b><em>.gpio</em></b> file).')" onmouseout="htt()"></div>
					<span>User configured pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #3cb4e6;"
					onmouseenter="showtt('Pins that match the show pins for peripheral combo boxes')" onmouseout="htt()"></div>
					<span>Filtered pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #ffd200;"
					onmouseenter="showtt('Selected pin (result of Search PAD or when the mouse hovers a pin).')" onmouseout="htt()"></div>
					<span>Selected pin.</span>
				</div>
				<div class="legend-item">
					<div id="error-legend" class="color-box" style="background-color: #FF0000;"
					onmouseenter="showtt('Pins with configuration errors.')" onmouseout="htt()"></div>
					<span>Error pins</span>
				</div>
				<div class="legend-item">
					<div id="warning-legend"  class="color-box" style="background-color: rgb(255, 153, 0);"
					onmouseenter="showtt('Pins with configuration warnings')" onmouseout="htt()"></div>
					<span>Warning pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #cccccc;"
					onmouseenter="showtt('Not configurable pins')" onmouseout="htt()"></div>
					<span>Not configurable pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #ffffff;"
					onmouseenter="showtt('Pins not configured yet')" onmouseout="htt()"></div>
					<span>Unused pins</span>
				</div>
			</div>
		</div>
		<div class="grid-container">
		
			<div class="container">
			       <div class="left">
					<label class="left">Model: <em>«model.toUpperCase(Locale.ENGLISH)»</em>, Package: <em>«pack.name»</em>, Board: <em>«incBoard.name»</em></label>
					     </div>
					     <div class="right">
					            «legend»
					     </div>
					 </div>
		
			<div style="display:inline" class="cell1">
				<label>Show pins for peripheral <select id="comboPeriph" onChange="comboPeriph()">
					<option>None</option>
			«FOR p : peripherals.sort»
				<option>«p»</option>
			«ENDFOR»
			</select></label>
			
			<label>Instance
				<select name="instance" id="instance" onChange="comboPeriphInstance()">
					<option>None</option>
				</select>
			</label>
							
			<label>Function
				<select name="function" id="function" onChange="comboFunction()">
					<option>None</option>
					</select>
			</label>
					  	
			</div>
				<div style="display:block" class="cell2">
				<label id="searchPad">Search PAD <input type="text" id="padToSelect" onkeyup="selectPad()" placeholder="Enter PAD name..."></label>
			</div>
		</div>'''

		val instancesOfPeripherals = '''
			var instanceOfPeripherals = {
			'None': [],
			«FOR p : peripherals.sort»
				«p»: [«peripheralMap.get(p).map(it | '"'+it+'"').sort.join(",")»],
			«ENDFOR»
			}
		'''
		val functionsOfPeripherals = '''
			var functionsOfPeripherals = {
			«FOR p : functionsMap.keySet.sort»
				'«p»': [«functionsMap.get(p).map(it | '"'+it+'"').sort.join(",")»],
			«ENDFOR»
			}
		'''

		val tooltipsArray = '''
			var tooltipsArray = {
			«FOR p : incBoard.package.pins»
				«IF getTooltip2(p).length > 0»
					'«p.name»': "«getTooltip2(p)»",
				«ENDIF»
			«ENDFOR»
			}
		'''

		val fileContent = '''
		<!DOCTYPE HTML>
		<html lang="en">
		
			<head>
				<meta charset="UTF-8">
				<title>«settings.name»</title>
				<style>
				
				circle {
					stroke:black;
					stroke-width:0.5px;
				}
			
				grid-container {
					display: grid;
					grid-template-columns: auto auto;
					grid-template-rows: auto;
					grid-gap: 10px;
					padding: 10px;
				}
			
				.grid-container > div {
					text-align: left;
					padding: 20px 0;
				}
			
				#tooltip {
				background: #fff8dc;
				border: 1px solid #03234b;
				border-radius: 5px;
				padding: 5px;
				font-size: 0.8em;
				}
			
				.cPin {
					fill:white;
				}
						
				.cPin:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: black;
					stroke-width: 2px;
				}
				
				.cPin.error {
					stroke: black;
					fill: #ff0000;
					animation: blink 500ms infinite;
				}
				
				.cPin.warning {
					stroke: black;
					fill: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				
				.sPin {
					fill:rgb(180,180,180);
				}
			
				.sPin:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: black;
					stroke-width: 2px;
				}
			
				.fPin {
					fill:rgb(180,180,180);
					r:20;
				}
			
				.fPin:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: black;
					stroke-width: 2px;
					}
			
				.xaxistext {
					font-variant:normal;
					font-weight:normal;
					font-size:13px;
					font-family:Helvetica;
					writing-mode:lr-tb;
					fill:#231f20;
					fill-opacity:1;
					fill-rule:nonzero;
					text-anchor:middle;
				}
			
				.begin_y_axistext {
					font-variant:normal;
					font-weight:normal;
					font-size:13px;
					font-family:Helvetica;
					writing-mode:lr-tb;
					fill:#231f20;
					fill-opacity:1;
					fill-rule:nonzero;
					text-anchor:begin;
				}
			
				.end_y_axistext {
					font-variant:normal;
					font-weight:normal;
					font-size:13px;
					font-family:Helvetica;
					writing-mode:lr-tb;
					fill:#231f20;
					fill-opacity:1;
					fill-rule:nonzero;
					text-anchor:end;
				}
						
				.pPin {
					fill: #3cb4e6;
					stroke: #03234b;
					stroke-width: 0.5px;
					fill-opacity: 1;
				}
				
				.pPin:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: black;
					stroke-width: 2px;
				}
		
				.pinText {
			font-variant:normal;
			font-weight:normal;
			font-size:0.8em;
			font-family:Helvetica;
			writing-mode:lr-tb;
			fill:#231f20;
			fill-opacity:1;
			fill-rule:nonzero;
			text-anchor:middle;
				}
						
				.configuredPin {
					fill: #49b170;
					stroke: #03234b;
					stroke-width:0.5px;
				}
				.configuredPin:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: #03234b;
					stroke-width: 2px;
				}
						
				.configuredPin.error {
					stroke: black;
					fill: #ff0000;
					animation: blink 500ms infinite;
				}
				.configuredPin.error > circle {
					stroke: black;
					fill: #ff0000;
					animation: blink 500ms infinite;
				}
				.configuredPin.error > text:nth-child(2) {
					stroke: red;
					animation: blink 500ms infinite;
				}
				.configuredPin.error > text:nth-child(3) {
					stroke: red;
					animation: blink 500ms infinite;
				}
				.configuredPin.warning {
					stroke: black;
					fill: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				.configuredPin.warning > circle {
					stroke: black;
					fill: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				.configuredPin.warning > text:nth-child(2) {
					stroke: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				.configuredPin.warning > text:nth-child(3) {
					stroke: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
			
				.board {
					fill: #e7017e;
					stroke: #03234b;
					stroke-width:0.5px;
				}
				.board:hover {
					fill: #ffd200;
					fill-opacity: 1;
					stroke: #03234b;
					stroke-width: 2px;
				}
			
				.board.error {
					stroke: red;
					fill: #ff0000;
					animation: blink 500ms infinite;
				}
				.board.warning {
					stroke: rgb(255, 153, 0);
					fill: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				
				
				@keyframes blink {
				    0% {
				        opacity: 0.4;
				    }
				    100% {
				        opacity: 1;
					}
				}
				.legend-container {
					font-family: Arial, sans-serif;
					border-radius: 5px;
					background-color: #c8e0f9;
					overflow: hidden;
					margin-left: auto;
				}
				.legend-title {
					cursor: pointer;
					padding: 10px 20px;
					border: none;
					border-radius: 5px 5px 0 0;
					font-size: 16px;
					width: 100%;
					text-align: left;
					box-sizing: border-box;
				}
				.legend {
					display: none;
					padding: 10px;
				}
				.legend-item {
					display: flex;
					align-items: center;
					margin-bottom: 5px;
				}
				#error-legend {
					display: flex;
					align-items: center;
					margin-bottom: 5px;
					stroke: red;
					fill: #ff0000;
					animation: blink 500ms infinite;
				}
				#warning-legend {
					display: flex;
					align-items: center;
					margin-bottom: 5px;
					stroke: rgb(255, 153, 0);
					fill: rgb(255, 153, 0);
					animation: blink 500ms infinite;
				}
				.color-box {
					width: 20px;
					height: 20px;
					margin-right: 10px;
					border: 1px solid #03234b;
				}
					
				.container {
					display: flex;
					justify-content: space-between;
					align-items: center;
					padding: 10px;
				}
				.left {
					display: flex;
					gap: 10px; /* Space between the first two strings */
				}
				.right {
					margin-left: auto; /* Pushes the third string to the right */
				}
			
				.tooltipLegend {
					position: relative;
					display: inline-block;
				}
			
				.legend-item:hover .tooltip {
					visibility: visible;
					opacity: 1;
				}
				.legend-item:hover .tooltip {
					visibility: visible;
					opacity: 1;
				}
				.tooltip {
					visibility: hidden;
					width: 200px;
					background-color: #000;
					color: #fff;
					text-align: center;
					border-radius: 5px;
					padding: 5px;
					position: absolute;
					z-index: 1;
					bottom: 125%; /* Position the tooltip above the text */
					left: 50%;
					margin-left: -100px;
					opacity: 0;
					transition: opacity 0.3s;
				}
		
				</style>
			</head>
		
			<header>
			«peripheralCombo»
			</header>
		
			<body onload="init();">
			<div id="tooltip" display="none" style="position: absolute; display: none;"></div>
			«pinmapView»
			«script(instancesOfPeripherals, functionsOfPeripherals, tooltipsArray)»
			</body>
		
		</html>'''
		fileContent
	}

	def String getTooltip2(Pin pin) {
		val pinMap = new HashMap<Pin, HashMap<String, String>>

		var tooltipMap = pinMap.get(pin)
		if (tooltipMap === null) {
			pinMap.put(pin, new HashMap<String, String>)
			tooltipMap = pinMap.get(pin)
		}

		var tooltips = ""
		for (cfg : pin.pinConfigurations) {
			var tooltip = ""
			var periph = ""
			if (cfg instanceof SystemFunctionPin) {
				val sfp = cfg as SystemFunctionPin
				periph = cfg.ref.peripheralRef?.name

				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sfp.ref.label + " (" + sfp.direction.getName + ")" + "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof SpecialPin) {
				val sp = cfg as SpecialPin
				periph = "Special"
				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sp.ref.label + " (" + sp.direction.getName + ")"
				tooltip += "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof ConfigurablePin) {
				val sfp = cfg as ConfigurablePin
				if (tooltips.length < 1) {
					tooltips = "<b>" + pin.name + ": " + sfp.ref.label + "</b><br/><pre>"
				}
				for (c : sfp.ref.functions) {
					periph = c.name.peripheralRef.name
					var t = tooltipMap.get(periph)
					if (t === null) {
						tooltipMap.put(periph, "")
						t = tooltipMap.get(periph)
					}
					t += "   " + c.name.name + "<br/>"
					tooltipMap.put(periph, t)
				}
				tooltip += tooltipMap.get(periph)
				tooltip += "</pre>"

			} else {
				tooltip += "   " + cfg.toString + "<br/>"
			}

		}

		for (key : tooltipMap.keySet) {
			tooltips += "<em>" + key + "</em><br/>"
			tooltips += tooltipMap.get(key) // + "<br/>"
		}
		tooltips
	}

	def String generatePin(PinSetting pinSetting, Map<EObject, Map<Integer, List<String>>> errorsMap) {
		val util = Utils.instance
		// println(pin.name+": "+x+", "+y)
		val pin = PinCfgHelper.getPinForConfiguration(pinSetting)
		val x = genPinmapView.getX(pin)
		val y = genPinmapView.getY(pin)
		var tooltip = ""
		var portLabel = ""
		for (cfg : pin.pinConfigurations) {
			if (cfg instanceof ConfigurablePin) {
				portLabel = cfg.ref.label
			}
		}
		tooltip += "<b>" + pin.name + ": " + portLabel + " as " + pinSetting.name + "</b><br/>"
		tooltip += "<pre>   Direction: " + pinSetting.config.direction + "<br/>"
		_pinCfgHelper = PinCfgHelper.instance

		tooltip += "   Function: " + pinSetting.functionName
		tooltip += " (" + pinSetting.mscrIndex + "_" + pinSetting.mscrSSS + ")" + "<br/>"
		tooltip += "</pre><br/>"

		val tooltipElt = ''' onmouseenter="sttConfigured(evt,'«tooltip»');"'''
		val tooltipElt2 = ''' onmouseenter="sttConfigured(evt);"'''
		val pinId = 'configured_' + util.getFullPadName(pin)

		var cssClass = newArrayList
		if (pinSetting.isBoardPin) {
			cssClass.add("board")
			cssClass.add("configuredPin")
		} else {
			cssClass.add("configuredPin")
		}

		val msgMap = errorsMap.get(pin)
		if (msgMap !== null) {
			val errors = errorsMap.get(pin).get(Integer.valueOf(Diagnostic.ERROR))
			val warnings = errorsMap.get(pin).get(Integer.valueOf(Diagnostic.WARNING))
			// val infos = errorsMap.get(pinSetting).get(Integer.valueOf(Diagnostic.INFO))
			if (errors.size > 0) {
				cssClass.add("error");
				val errorMessage = errors.join(",").replace("'","")
				val tooltipErrors = ''' onmouseenter="sttConfigured(evt,'«errorMessage»');"'''
			
				return '''
				<g transform="translate(«x*(genPinmapView.pinWidth+genPinmapView.pinMarginWidth)», «(y+1)*(genPinmapView.pinHeight+genPinmapView.pinMarginHeight)»)">
					<circle class="«cssClass.join(" ")»" r="«genPinmapView.pinWidth/2»" id="«pinId»" «tooltipErrors»/>
					<text class="pinText" y="«genPinmapView.fontSize/2»" «tooltipErrors»>«util.getTruncatedPad(pin)»</text>
				</g>'''
			} else if (warnings.size > 0) {
				cssClass.add("warning");
				val warningMessage = warnings.join(",").replace("'","")
				val tooltipWarnings = ''' onmouseenter="sttConfigured(evt,'«warningMessage»');"'''
				return '''
				<g transform="translate(«x*(genPinmapView.pinWidth+genPinmapView.pinMarginWidth)», «(y+1)*(genPinmapView.pinHeight+genPinmapView.pinMarginHeight)»)">
					<circle class="«cssClass.join(" ")»" r="«genPinmapView.pinWidth/2»" id="«pinId»" «tooltipWarnings»/>
					<text class="pinText" y="«genPinmapView.fontSize/2»" «tooltipWarnings»>«util.getTruncatedPad(pin)»</text>
				</g>'''
			} else {
				'''
				<g transform="translate(«x*(genPinmapView.pinWidth+genPinmapView.pinMarginWidth)», «(y+1)*(genPinmapView.pinHeight+genPinmapView.pinMarginHeight)»)">
					<circle class="«cssClass.join(" ")»" r="«genPinmapView.pinWidth/2»" id="«pinId»" «tooltipElt»/>
					<text class="pinText" y="«genPinmapView.fontSize/2»" «tooltipElt2»>«util.getTruncatedPad(pin)»</text>
				</g>'''
			}
		} else {
			'''
			<g transform="translate(«x*(genPinmapView.pinWidth+genPinmapView.pinMarginWidth)», «(y+1)*(genPinmapView.pinHeight+genPinmapView.pinMarginHeight)»)">
				<circle class="«cssClass.join(" ")»" r="«genPinmapView.pinWidth/2»" id="«pinId»" «tooltipElt»/>
				<text class="pinText" y="«genPinmapView.fontSize/2»" «tooltipElt2»>«util.getTruncatedPad(pin)»</text>
			</g>'''
		}
	}

	def isBoardPin(PinSetting pin) {
		_pinCfgHelper = PinCfgHelper.instance
		if (pin.eContainer.eContainer instanceof Board) {
			return true
		} else {
			return false
		}
	}

	// LOW: (StellarERCR #1254100: SR6 functions proposed on C4 pinmap, but only present on C6
	def List<Function> getFunctions(Configuration config, Peripheral periph) {
		val list = newArrayList
		val functions = config.functions
		list.addAll(functions.filter [ it |
			it.name.peripheralRef !== null && it.name.peripheralRef.name.equals(periph.name)
		].map[name])
		list
	}
// )
}
