package com.st.stellar.pinmap.pincfg.htmlGenerator.runtime

import com.google.inject.Inject
import com.st.stellar.pinmap.generator.GeneratePinmapViewLQFP
import com.st.stellar.pinmap.helpers.PinCfgHelper
import com.st.stellar.pinmap.helpers.Utils
import com.st.stellar.pinmap.pinCfg.Board
import com.st.stellar.pinmap.pinCfg.PinSetting
import com.st.stellar.pinmap.pinCfg.PinSettings
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin
import com.st.stellar.pinmap.pinmapDsl.Configuration
import com.st.stellar.pinmap.pinmapDsl.Direction
import com.st.stellar.pinmap.pinmapDsl.Family
import com.st.stellar.pinmap.pinmapDsl.Function
import com.st.stellar.pinmap.pinmapDsl.Peripheral
import com.st.stellar.pinmap.pinmapDsl.Pin
import com.st.stellar.pinmap.pinmapDsl.SpecialPin
import com.st.stellar.pinmap.pinmapDsl.SystemFunctionPin
import java.util.HashMap
import java.util.HashSet
import java.util.List
import java.util.Locale
import java.util.Map
import java.util.Set
import org.eclipse.emf.ecore.EObject

class GeneratePinSettingsLQFP implements GeneratePinSettings {

	@Inject extension Utils
	val genPinmapView = new GeneratePinmapViewLQFP

	@Inject extension PinCfgHelper;

	def dispatch String getRefId(PinSettings settings) {
		var n = (PinCfgHelper.getBoard(settings.includedBoard).package.eContainer as Family).name
		n = n.replaceAll('x', PinCfgHelper.getBoard(settings.includedBoard).package.name)
		var a = n.indexOf('_')
		n = n.substring(0, a)
		n
	}

	def dispatch String getRefId(PinSetting setting) {
		setting.pad.getRefId
	}

	def dispatch String getRefId(ConfigurablePin pin) {
		var cfg = pin.ref as Configuration
		cfg.name

	}

	new() {
		errors = new StringBuilder("errors:\n")
		warnings = new StringBuilder("warnings:\n")
	}

	var StringBuilder errors

	def error(String message) {
		errors.append("error: " + message + "\n")
	}

	var StringBuilder warnings

	def warning(String message) {
		warnings.append("warning: " + message + "\n")
	}

	def generateReport() {
		return errors.append(warnings)
	}

	def int getPortNb(String s) {
		val subString = s.charAt(1)
		var int port = Character.getNumericValue(subString)
		val begin = Character.getNumericValue('A')
		val int portNb = port - begin
		// println(portNb)
		portNb
	}

	def int getBit(String s) {
		val subString = s.substring(2, s.length)
		Integer.parseInt(subString)
	}

	public val pinWidth = 24
	public val pinHeight = 12
	public val pinMarginWidth = 3
	public val pinMarginHeight = 3
	public val fontSize = pinWidth / 2
	public val generalOffsetX = 200
	public val generalOffsetY = 200

	static private def script(String instancesOfPeripherals, String functionsOfPeripherals, String tooltipsArray) '''
		<script type="text/javascript">
		var svg = null;
		var oldpads = [];
		var oldcolors = [];
		var oldstroke = [];
		var oldstrokeWidth = [];
		var oldFillOpacity = [];
		
		function init() {
			svg = document.getElementById('svg-doc');
			var size = getSVGSize();
			//console.log(size);
		
			// Add mouse out events on elements matching cPin and configuredPin classes
			var elements = document.getElementsByClassName("cPin");
			for (var i = 0; i < elements.length; i++) {
			const elt = elements[i];
			elt.addEventListener('mouseout', function(event) {
				htt();
			});
			elt.addEventListener('mouseenter', function(event) {
				const value = elt.value;
				if( value ) {
					onmouseenter="stt(evt,value);"
				}
			});
			}
			elements = document.getElementsByClassName("configuredPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}
			elements = document.getElementsByClassName("sPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}
			elements = document.getElementsByClassName("fPin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}		    
			elements = document.getElementsByClassName("nonConfigurablePin");
			for (var i = 0; i < elements.length; i++) {
				elements[i].addEventListener('mouseout', function(event) {
					htt();
				});
			}
		}
		
		function getSVGSize() {
			var svgDoc = svg;
			if( svgDoc ) {
				var width = svgDoc.getAttribute('width');
				var height = svgDoc.getAttribute('height');
				res = '<'+width+','+height+'>';
				return res;
			} else {
				return null;
			}
		}
		
		var hideLayer = function(elem) {
			if (elem) {
				var elt = svg.getElementById(elem);
				if (elt) {
					elt.style.display = "none";
				}
			}
		}
		
		var showLayer = function(elem) {
			if (elem) {
				var elt = svg.getElementById(elem);
				if (elt) {
					elt.style.display = "inline";
				}
			}
		}
		
		var selectedPeriph = "";
		var selectedInstance = "";
		var selectedFunction = "";
		
		function comboPeriph() {
			if(selectedPeriph) {
				console.log('from: '+selectedPeriph);
				hideLayer('animation_layer_'+selectedPeriph)
			}
			if(selectedInstance) {
				hideLayer('animation_layer_'+selectedInstance)
			}
			if(selectedFunction) {
				hideLayer('animation_layer_'+selectedFunction)
			}
			var combo = document.getElementById("comboPeriph")
			var idx = combo.selectedIndex;
			var content = combo.options[idx].innerHTML;
			selectedPeriph = content;
			if( selectedPeriph === "None") {
				document.getElementById("instance").innerHTML = "<option value=\"\" selected>None</option>";
				document.getElementById("function").innerHTML = "<option value=\"\" selected>None</option>";
			}
			console.log('to: '+content);
			showLayer('animation_layer_'+content)
			changecat(combo.value);
		}
		
		function comboPeriphInstance() {
			var thelist = document.getElementById('instance');
			if(selectedPeriph) {
				hideLayer('animation_layer_'+selectedPeriph)
			}
			if(selectedInstance) {
				console.log('from: '+selectedInstance);
				hideLayer('animation_layer_'+selectedInstance)
			}
			if(selectedFunction) {
				hideLayer('animation_layer_'+selectedFunction)
			}
			var idx = thelist.selectedIndex;
			var content = thelist.options[idx].innerHTML;
			selectedInstance = content;
			console.log('to: '+content);
			showLayer('animation_layer_'+content)
			changeinstance(thelist.value);
		}
		function comboFunction() {
			var thelist = document.getElementById('function');
			if(selectedPeriph) {
				hideLayer('animation_layer_'+selectedPeriph)
			}
			if(selectedInstance) {
				hideLayer('animation_layer_'+selectedInstance)
			}
			if(selectedFunction) {
				console.log('from: '+selectedFunction);
				hideLayer('animation_layer_'+selectedFunction)
			}
			var idx = thelist.selectedIndex;
			var content = thelist.options[idx].innerHTML;
			console.log('comboFunction:'+content)
			selectedFunction = content;
			console.log('to: '+content);
			if(content === "All") {
				comboPeriphInstance(selectedInstance);
			}
			showLayer('animation_layer_'+content)
		}
		
		function replaceCharByInt(correspondance, p0, p1, p2, decalage, chaine) {
			// Regular expression is: (^.*)(PAD_P?)(\d*)
			//                          p0   p1    p2
			return ["PAD_P", p2].join('');
		}
		
		function replaceCharByInt2(correspondance, p1, p2, p3, decalage, chaine) {
			// Regular expression is: (PAD_P?)(\d*)
			//                           p1    p2
			return ["configured_P", p2].join('');
		}
		
		function findElements(name) {
		  	//console.log(name);
			var elArray = [];
			var tmp = document.getElementsByClassName("pin");
			var padName = name.replace(/(^.*)(PAD_P?)(\d*)/, replaceCharByInt);
			var regex = new RegExp(padName);
			for ( var i = 0; i < tmp.length; i++ ) {
				if ( regex.test(tmp[i].id) ) {
					elArray.push(tmp[i]);
				}
			}
			padName = name.replace(/(PAD_P?)(\d*)/, replaceCharByInt2);
			var regex = new RegExp(padName);
			for ( var i = 0; i < tmp.length; i++ ) {
				if ( regex.test(tmp[i].id) ) {
					elArray.push(tmp[i]);
				}
			}
			//console.log(elArray);
			return elArray;
		}
		
		function reset() {
			var input = document.getElementById("padToSelect");
			input.value = "";
			selectPad();
		}
		
		function selectPad() {
			var input = document.getElementById("padToSelect");
			var pad = input.value.toUpperCase();
		
			pad = pad.replace("[", "");
			pad = pad.replace("]", "");
			pad = pad.replace(".*", "");
			pad = pad.replace("*", "");
			pad = pad.concat("$");
			for ( var i = 0; i < oldpads.length; i++ ) {
				var elt = oldpads[i];
				elt.style.fill = oldcolors[i];
				elt.style.stroke = oldstroke[i];
				elt.style.strokeWidth = oldstrokeWidth[i];
				elt.style.fillOpacity = oldfillOpacity[i];
			}
			oldpads = [];
			oldcolors = [];
			oldstroke = [];
			oldstrokeWidth = [];
			oldfillOpacity = [];
		
			var padName = "^PAD_";
			padName = padName.concat(pad);
			var pads = findElements(padName);
			oldpads = pads;
			for ( var i = 0; i < pads.length; i++ ) {
				var elt = pads[i];
				//console.log(elt);
				oldcolors[i] = elt.style.fill;
				oldstroke[i] = elt.style.stroke;
				oldstrokeWidth[i] = elt.style.strokeWidth;
				oldfillOpacity[i] = elt.style.fillOpacity;
				elt.style.fill = '#ffd200';
				elt.style.fillOpacity = '1';
				elt.style.strokeWidth = '2px';
				elt.style.stroke = 'black';
			}
		}
		«instancesOfPeripherals»
		«functionsOfPeripherals»
		«tooltipsArray»
		
		function changecat(value) {
			if (value.length == 0 || instanceOfPeripherals[value].length == 0) {
				document.getElementById("instance").innerHTML = "<option selected>None</option>";
				document.getElementById("function").innerHTML = "<option selected>None</option>";
			} else {	
				if( instanceOfPeripherals[value].length == 1) {
					var categoryId = instanceOfPeripherals[value][0];
					var catOptions = "<option value=\"All\" selected>" + categoryId + "</option>";
					document.getElementById("instance").innerHTML = catOptions;
					document.getElementById("function").innerHTML = "<option value=\"\">All</option>";
					changeinstance(categoryId);
				} else {
					var catOptions = "<option selected>All</option>";
					for (categoryId in instanceOfPeripherals[value]) {
						catOptions += "<option>" + instanceOfPeripherals[value][categoryId] + "</option>";
					}
					document.getElementById("instance").innerHTML = catOptions;
					document.getElementById("function").innerHTML = "<option value=\"\" selected>All</option>";
				}
			}
		}
		
		function changeinstance(value) {
			if (value.length == 0) {
				document.getElementById("function").innerHTML = "<option selected>All</option>";
			} else {
				var index=document.getElementById("instance").options.selectedIndex
				var periph=document.getElementById("instance").options[index].text
				if( value === "All") {
					//console.log("selected periph:"+selectedPeriph);
					comboPeriph();
				} else if( functionsOfPeripherals[value].length == 1) {
					var categoryId = functionsOfPeripherals[value][0];
					var catOptions = "<option selected>" + categoryId + "</option>";
					document.getElementById("function").innerHTML = catOptions;
				} else {
					var catOptions = "<option selected>All</option>";
					for (categoryId in functionsOfPeripherals[periph]) {
						catOptions += "<option>" + functionsOfPeripherals[periph][categoryId] + "</option>";
					}
					document.getElementById("function").innerHTML = catOptions;
				}
			}
		}
		
		var oldTooltipText = "";
		function stt(evt, pin) { // show tooltip
			let tooltip = document.getElementById("tooltip");
			var text = tooltipsArray[pin];
			if( text ) {
				tooltip.innerHTML = text;
				oldTooltipText = text;
			} else {
				tooltip.innerHTML = oldTooltipText;
			}
			tooltip.style.display = "block";
			tooltip.style.left = evt.pageX + 10 + 'px';
			tooltip.style.top = evt.pageY + 10 + 'px';
		}
		
		function sttConfigured(evt, text) { // show tooltip
			let tooltip = document.getElementById("tooltip");
			if( text ) {
				tooltip.innerHTML = text;
				oldTooltipText = text;
			} else {
				tooltip.innerHTML = oldTooltipText;
			}
			tooltip.style.display = "block";
			tooltip.style.left = evt.pageX + 10 + 'px';
			tooltip.style.top = evt.pageY + 10 + 'px';
		}
		function htt() { // Hide tooltip
			var tooltip = document.getElementById("tooltip");
			tooltip.style.display = "none";
		}
		function toggleLegend() {
			var legend = document.getElementById('legend');
			var button = document.querySelector('.legend-title');
			if (legend.style.display === 'none' || legend.style.display === '') {
			    legend.style.display = 'flex';
			    button.textContent = 'Hide color legend';
			} else {
			    legend.style.display = 'none';
			    button.textContent = 'Show color legend';
			}
		}
		function showtt(text) { // show tooltip
			let tooltip = document.getElementById("tooltip");
			if( text ) {
				tooltip.innerHTML = text;
				oldTooltipText = text;
			} else {
				tooltip.innerHTML = oldTooltipText;
			}
			tooltip.style.display = "block";
			tooltip.style.left = event.pageX + 10 + 'px';
			tooltip.style.top = event.pageY + 10 + 'px';
		}
		
		</script>
	'''

	override generateView(PinSettings settings, Map<EObject, Map<Integer, List<String>>> errorsMap) {

		_pinCfgHelper = PinCfgHelper.instance

		var pins = ""
		for (mod : PinCfgHelper.getAllModules(settings)) {
			for (pin : mod.pins) {
				pins += pin.generatePin(errorsMap)
			}
		}

		// Map of peripherals : maps set of peripherals matching a peripheral display name
		var peripheralMap = new HashMap<String, Set<String>>

		// Map of functions : maps set of functions related to a peripheral
		var functionsMap = new HashMap<String, Set<String>>

		var Set<String> peripheralNameSet = null

		for (pin : PinCfgHelper.getBoard(settings.includedBoard).package.pins) {
			for (cfg : pin.pinConfigurations.filter(ConfigurablePin)) {
				for (fctref : cfg.ref.functions) {
					val perDisplay = fctref.name.peripheralRef.label

					val periphName = fctref.name.peripheralRef.name
					var Set<String> funcList = functionsMap.get(periphName)
					if (funcList === null) {
						funcList = new HashSet<String>
						functionsMap.put(periphName, funcList)
					}
					val validFunctions = cfg.ref.getFunctions(fctref.name.peripheralRef)
					for (f : validFunctions) {
						funcList.add(f.name)
					}

					if (validFunctions.size > 0) {
						// Get the list of peripherals associated to the peripheral (create it if needed)
						peripheralNameSet = peripheralMap.get(perDisplay)
						if (peripheralNameSet === null) {
							peripheralNameSet = new HashSet<String>
							peripheralMap.put(perDisplay, peripheralNameSet)
						}
						peripheralNameSet.add(periphName)
					}
				}
			}
		}
		var peripherals = peripheralMap.keySet.sort

		val pinmapView = genPinmapView.generatePackage(PinCfgHelper.getBoard(settings.includedBoard).package, pins)

		val pack = PinCfgHelper.getBoard(settings.includedBoard).package.name
		var family = PinCfgHelper.getBoard(settings.includedBoard).package.eContainer as Family
		var model = family.name
		model = model.substring(model.lastIndexOf(".") + 1);

		val legend = '''
			<div class="tooltipLegend">
				<button class="legend-title" onclick="toggleLegend()">
				Show legend</button>
			</div>
		'''
		val peripheralCombo = '''
		<div class="legend-container">
			<div class="legend" id="legend">
				<div class="legend-item">
					<div class="color-box" style="background-color: #e7017e;"
					onmouseenter="showtt('Board predefined pins (modifiable only in <b><em>.gpio_board</em></b> file).')" onmouseout="htt()"></div>
					<span>Board predefined pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #49b170;"
					onmouseenter="showtt('User configured pins (modifiable in <b><em>.gpio</em></b> file).')" onmouseout="htt()"></div>
					<span>User configured pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #3cb4e6;"
					onmouseenter="showtt('Pins that match the show pins for peripheral combo boxes')" onmouseout="htt()"></div>
					<span>Filtered pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #ffd200;"
					onmouseenter="showtt('Selected pin (result of Search PAD or when the mouse hovers a pin).')" onmouseout="htt()"></div>
					<span>Selected pin.</span>
				</div>
				<div class="legend-item">
					<div id="error-legend" class="color-box" style="background-color: #FF0000;"
					onmouseenter="showtt('Pins with configuration errors.')" onmouseout="htt()"></div>
					<span>Error pins</span>
				</div>
				<div class="legend-item">
					<div id="warning-legend"  class="color-box" style="background-color: rgb(255, 153, 0);"
					onmouseenter="showtt('Pins with configuration warnings')" onmouseout="htt()"></div>
					<span>Warning pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #cccccc;"
					onmouseenter="showtt('Not configurable pins')" onmouseout="htt()"></div>
					<span>Not configurable pins</span>
				</div>
				<div class="legend-item">
					<div class="color-box" style="background-color: #ffffff;"
					onmouseenter="showtt('Pins not configured yet')" onmouseout="htt()"></div>
					<span>Unused pins</span>
				</div>
			</div>
		</div>
		<div class="grid-container">
			<div class="container">
			       <div class="left">
					<label class="left">Model: <em>«model.toUpperCase(Locale.ENGLISH)»</em>, Package: <em>«pack»</em>, Board: <em>«PinCfgHelper.getBoard(settings.includedBoard).name»</em></label>
					     </div>
					     <div class="right">
					            «legend»
					     </div>
					 </div>
			<div style="display:inline" class="cell1">
				<label>Show pins for peripheral <select id="comboPeriph" onChange="comboPeriph()">
					<option>None</option>
			«FOR p : peripherals.sort»
				<option>«p»</option>
			«ENDFOR»
			</select></label>
		
			<label>Instance
			<select name="instance" id="instance" onChange="comboPeriphInstance()">
				<option>None</option>
			</select>
			</label>
		
			<label>Function
				<select name="function" id="function" onChange="comboFunction()">
					<option>None</option>
					</select>
				</label>
		
			</div>
				<div style="display:block" class="cell2">
				<label id="searchPad">Search PAD <input type="search" id="padToSelect" onsearch="reset()" onkeyup="selectPad()" placeholder="Enter PAD name..."></label>
				</div>
			</div>
		</div>'''

		val instancesOfPeripherals = '''
			var instanceOfPeripherals = {
			'None': [],
			«FOR p : peripherals.sort»
				'«p»': [«peripheralMap.get(p).map(it | '"'+it+'"').sort.join(",")»],
			«ENDFOR»
			}
		'''
		val functionsOfPeripherals = '''
			var functionsOfPeripherals = {
			«FOR p : functionsMap.keySet.sort»
				'«p»': [«functionsMap.get(p).map(it | '"'+it+'"').sort.join(",")»],
			«ENDFOR»
			}
		'''

		val tooltipsArray = '''
			var tooltipsArray = {
			«FOR p : PinCfgHelper.getBoard(settings.includedBoard).package.pins»
				«IF getTooltipNotConfigured(p).length > 0»
					'«p.name»': "«getTooltipNotConfigured(p)»",
				«ENDIF»
			«ENDFOR»
			}
		'''
		val fileContent = '''
		<!DOCTYPE HTML>
		<html lang="en">
		
		<head>
			<meta charset="UTF-8">
			<title>«settings.name»</title>
		<style>
			.st0 {
				fill: #03234b;
			}
		
			.st1 {
			fill: #ffffff;
			}
		
			grid-container {
			display: grid;
			grid-template-columns: auto auto;
			grid-template-rows: auto;
			grid-gap: 10px;
			padding: 10px;
			}
		
			.grid-container > div {
			text-align: left;
			padding: 20px 0;
			}
		
			#tooltip {
			background: #fff8dc;
			border: 1px solid #03234b;
			border-radius: 5px;
			padding: 5px;
			font-size: 0.8em;
			}
		
			.pinText {
			fill: #03234b;
			text-anchor: middle;
			}
		
			.pinText_start {
			font-size: 0.5em;
			text-anchor: start;
			}
		
			.pinText_end {
			font-size: 0.5em;
			text-anchor: end;
			}
		
			text,
			label {
			stroke: #03234b;
			stroke-width: 0.5px;
			font-family: Verdana;
			font-size: 0.8em;
			}
		
			.cPin rect {
			fill: #49b170;
			stroke: #03234b;
			stroke-width: 0.5px;
			}
		
			.cPin > text:nth-child(2) {
			stroke: #03234b;
			fill: #03234b;
			stroke-width: 0.5px;
			}
		
			.cPin > text:nth-child(3) {
			stroke: #49b170;
			fill: #49b170;
			stroke-width: 0.5px;
			}
		
			.cPin.error > rect {
			    stroke: black;
			    fill: #ff0000;
			    animation: blink 500ms infinite;
			}
			.cPin.error > text:nth-child(2) {
			    stroke: red;
			    animation: blink 500ms infinite;
			}
			.cPin.error > text:nth-child(3) {
			    stroke: red;
			    animation: blink 500ms infinite;
			}
		
			.cPin.warning > rect {
			    stroke: black;
			    fill: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
			.cPin.warning > text:nth-child(2) {
			    stroke: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
			.cPin.warning > text:nth-child(3) {
			    stroke: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
		
			.cPin:hover rect {
			fill: #ffd200;
			fill-opacity: 1;
			stroke: #03234b;
			stroke-width: 2px;
			}
		
			.pin {
			stroke: #03234b;
			stroke-width: 0.5px;
			fill-opacity: 1;
			}
		
			.nPin:hover rect {
			fill: #ffd200;
			fill-opacity: 1;
			stroke: #03234b;
			stroke-width: 2px;
			}
			
			.nPin text {
				fill: #03234b;
				fill-opacity: 1;
				stroke: #03234b;
			}
		
			.pinNone {
			fill: #ffffff;
			width: 24px;
			height: 12px;
			}
		
			.layerPin {
			fill: #3cb4e6;
			stroke: #03234b;
			stroke-width: 0.5px;
			fill-opacity: 1;
			}
		
			.nonConfigurablePin {
			fill: #03234b;
			stroke: #03234b;
			}
		
			.nonConfigurablePin rect {
			fill: #cccccc;
			stroke: #03234b;
			}
		
			.nonConfigurablePin > text:nth-child(2) {
			fill: #03234b;
			stroke: #03234b;
			stroke-width: 0.5px;
			}
		
			.nonConfigurablePin > text:nth-child(3) {
			fill: #03234b;
			stroke: #03234b;
			stroke-width: 0.5px;
			}
		
			.nonConfigurablePin:hover rect {
			fill: #ffd200;
			fill-opacity: 1;
			stroke: #03234b;
			stroke-width: 2px;
			}
		
			.board rect {
			fill: #e7017e;
			stroke: #03234b;
			stroke-width: 0.5px;
			}
		
			.board > text:nth-child(1) {
			fill: #03234b;
			stroke: #03234b;
			stroke-width: 0.5px;
			}
		
			.board > text:nth-child(3) {
			fill: #e7017e;
			stroke: #e7017e;
			stroke-width: 0.5px;
			}
		
			.board:hover rect {
			fill: #ffd200;
			fill-opacity: 1;
			stroke: #03234b;
			stroke-width: 2px;
			}
			
			.board.error > rect {
			    stroke: black;
			    fill: #ff0000;
			    animation: blink 500ms infinite;
			}
			.board.error > text:nth-child(1) {
			    stroke: red;
			    animation: blink 500ms infinite;
			}
			.board.error > text:nth-child(3) {
			    stroke: red;
			    animation: blink 500ms infinite;
			}
			
			.board.warning > rect {
			    stroke: black;
			    fill: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
			.board.warning > text:nth-child(1) {
			    stroke: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
			.board.warning > text:nth-child(3) {
			    stroke: rgb(255, 153, 0);
			    animation: blink 500ms infinite;
			}
		
			.cPin.error {
		    stroke: black;
		    fill: #ff0000;
		    animation: blink 500ms infinite;
			}
			.board.error {
			    stroke: red;
			    fill: #ff0000;
			    animation: blink 500ms infinite;
			}
			@keyframes blink {
			    0% {
			        opacity: 0.4;
			    }
			    100% {
			        opacity: 1;
			    }
			}
			.legend-container {
				font-family: Arial, sans-serif;
				border-radius: 5px; /* Optional: Add rounded corners */
				background-color: #c8e0f9; /* Optional: Add background color */
				overflow: hidden; /* Ensure the button stays within the border */
				margin-left: auto;
			}
			.legend-title {
				cursor: pointer;
				padding: 10px 20px;
				/*background-color: #007BFF;*/
				/*color: white;*/
				border: none;
				border-radius: 5px 5px 0 0; /* Rounded corners for the top of the button */
				font-size: 16px;
				width: 100%;
				text-align: left; /* Align text to the left */
				box-sizing: border-box; /* Ensure padding is included in the width */
			}
			.legend {
				display: none;
				padding: 10px;
			}
			.legend-item {
				display: flex;
				align-items: center;
				margin-bottom: 5px;
			}
			#error-legend {
				display: flex;
				align-items: center;
				margin-bottom: 5px;
				stroke: red;
				fill: #ff0000;
				animation: blink 500ms infinite;
			}
			#warning-legend {
				display: flex;
				align-items: center;
				margin-bottom: 5px;
				stroke: rgb(255, 153, 0);
				fill: rgb(255, 153, 0);
				animation: blink 500ms infinite;
			}
			.color-box {
				width: 20px;
				height: 20px;
				margin-right: 10px;
				border: 1px solid #03234b;
			}
			
			.container {
				display: flex;
				justify-content: space-between;
				align-items: center;
				padding: 10px;
			}
			.left {
				display: flex;
				gap: 10px; /* Space between the first two strings */
			}
			.right {
				margin-left: auto; /* Pushes the third string to the right */
			}
			
			.tooltipLegend {
				position: relative;
				display: inline-block;
			}
			
			.legend-item:hover .tooltip {
				visibility: visible;
				opacity: 1;
			}
			.legend-item:hover .tooltip {
				visibility: visible;
				opacity: 1;
			}
			.tooltip {
				visibility: hidden;
				width: 200px;
				background-color: #000;
				color: #fff;
				text-align: center;
				border-radius: 5px;
				padding: 5px;
				position: absolute;
				z-index: 1;
				bottom: 125%; /* Position the tooltip above the text */
				left: 50%;
				margin-left: -100px;
				opacity: 0;
				transition: opacity 0.3s;
			}
		</style>
		
		</head>
		<header>
		«peripheralCombo»
		</header>
		
		<body onload="init();">
			<div id="tooltip" display="none" style="position: absolute; display: none;"></div>
			«pinmapView»
			«script(instancesOfPeripherals, functionsOfPeripherals, tooltipsArray)»
		</body>
		
		</html>'''
		fileContent
	}

	def String getTooltipNotConfigured(Pin pin) {
		val pinMap = new HashMap<Pin, HashMap<String, String>>

		var tooltipMap = pinMap.get(pin)
		if (tooltipMap === null) {
			pinMap.put(pin, new HashMap<String, String>)
			tooltipMap = pinMap.get(pin)
		}

		var tooltips = ""
		for (cfg : pin.pinConfigurations) {
			var tooltip = ""
			var periph = ""
			if (cfg instanceof SystemFunctionPin) {
				val sfp = cfg as SystemFunctionPin
				periph = (sfp.ref.peripheralRef !== null) ? sfp.ref.peripheralRef.name : "System function"

				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sfp.ref.label + " (" + sfp.direction.getName + ")" + "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof SpecialPin) {
				val sp = cfg as SpecialPin
				periph = sp.direction.getName
				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sp.ref.label
				tooltip += "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof ConfigurablePin) {
				val sfp = cfg as ConfigurablePin
				if (tooltips.length < 1) {
					tooltips = "<b>" + pin.name + ": " + sfp.ref.label + "</b><br/><pre>"
				}
				for (c : sfp.ref.functions) {
					periph = c.name.peripheralRef.name
					var t = tooltipMap.get(periph)
					if (t === null) {
						tooltipMap.put(periph, "")
						t = tooltipMap.get(periph)
					}
					t += "   " + c.name.name + "<br/>"
					tooltipMap.put(periph, t)
				}
				tooltip += tooltipMap.get(periph)
				tooltip += "</pre>"

			} else {
				tooltip += "   " + cfg.toString + "<br/>"
			}

		}

		for (key : tooltipMap.keySet) {
			tooltips += "<em>" + key + "</em><br/>"
			tooltips += tooltipMap.get(key) // + "<br/>"
		}
		tooltips
	}

	def String getTooltipConfigured(PinSetting ps) {
		val pinMap = new HashMap<Pin, HashMap<String, String>>

		val Pin pin = PinCfgHelper.getPinForConfiguration(ps)

		var psPeriph = ""
		var psFct = ""
		if (ps !== null) {
			val fct = ps.config.alt
			if (fct !== null) {
				psFct = fct.name
				psPeriph = fct.peripheralRef.name
			}
		}
		var tooltipMap = pinMap.get(pin)
		if (tooltipMap === null) {
			pinMap.put(pin, new HashMap<String, String>)
			tooltipMap = pinMap.get(pin)
		}

		var tooltips = ""
		for (cfg : pin.pinConfigurations) {
			var tooltip = ""
			var periph = ""
			if (cfg instanceof SystemFunctionPin) {
				val sfp = cfg as SystemFunctionPin
				periph = (sfp.ref.peripheralRef !== null) ? sfp.ref.peripheralRef.name : "System function"

				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sfp.ref.label + " (" + sfp.direction.getName + ")" + "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof SpecialPin) {
				val sp = cfg as SpecialPin
				periph = sp.direction.getName
				tooltip = tooltipMap.get(periph)
				if (tooltip === null) {
					tooltipMap.put(periph, "")
					tooltip = tooltipMap.get(periph)
				}
				tooltip += sp.ref.label
				tooltip += "<br/>"
				tooltipMap.put(periph, tooltip)
			} else if (cfg instanceof ConfigurablePin) {
				val sfp = cfg as ConfigurablePin
//				if (tooltips.length < 1) {
//					tooltips = "<b>" + pin.name + ": " + sfp.ref.label + "</b><br/><pre>"
//				}
				for (c : sfp.ref.functions) {
					periph = c.name.peripheralRef.name
					var t = tooltipMap.get(periph)
					if (t === null) {
						tooltipMap.put(periph, "")
						t = tooltipMap.get(periph)
					}
					val fctName = c.name.name
					if (fctName.equals(psFct)) {
						t += "   <b>" + c.name.name + "</b><br/>"
					} else {
						t += "   " + c.name.name + "<br/>"
					}
					tooltipMap.put(periph, t)
				}
				tooltip += tooltipMap.get(periph)
				tooltip += "</pre>"

			} else {
				tooltip += "   " + cfg.toString + "<br/>"
			}

		}

		for (key : tooltipMap.keySet) {
			if (key.equals(psPeriph)) {
				tooltips += "<b>" + key + "</b><br/>"
			} else {
				tooltips += "<em>" + key + "</em><br/>"
			}
			tooltips += tooltipMap.get(key) // + "<br/>"
		}
		tooltips
	}

	def String generatePin(PinSetting pinSetting, Map<EObject, Map<Integer, List<String>>> errorsMap) {
		_pinCfgHelper = PinCfgHelper.instance
		val util = Utils.instance
		val pin = PinCfgHelper.getPinForConfiguration(pinSetting)
		var tooltip = ""
		var portLabel = ""
		for (cfg : pin.pinConfigurations) {
			if (cfg instanceof ConfigurablePin) {
				portLabel = cfg.ref.label
			}
		}
		tooltip += "<b>" + pin.name + ": " + portLabel + " as " + pinSetting.name + "</b><br/>"
		tooltip += "<pre>Direction: " + pinSetting.config.direction + "<br/>"
		tooltip += "Function: " + _pinCfgHelper.getFunctionName(pinSetting) + "<br/><br/>"
		tooltip += getTooltipConfigured(pinSetting)

		_pinCfgHelper = PinCfgHelper.instance

		tooltip += "</pre><br/>"

		val tooltipElt = ''' onmouseenter="sttConfigured(evt,'«tooltip»');"'''
		val tooltipElt2 = ''' onmouseenter="sttConfigured(evt);"'''

		genPinmapView.createConfiguredPin(pin, "#00FF00", tooltipElt, tooltipElt2, pinSetting.name,
			getDirection(pinSetting.config.direction), pinSetting.isBoardPin, errorsMap)
	}

	def isBoardPin(PinSetting pin) {
		_pinCfgHelper = PinCfgHelper.instance
		if (pin.eContainer.eContainer instanceof Board) {
			return true
		} else {
			return false
		}
	}

	static def Direction getDirection(com.st.stellar.pinmap.pinCfg.Direction pinDirection) {
		var res = Direction.INPUT

		switch (pinDirection) {
			case INPUT: {
				res = Direction.INPUT
			}
			case OUTPUT: {
				res = Direction.OUTPUT
			}
			case INPUT_OUTPUT: {
				res = Direction.INPUT_OUTPUT
			}
		}
		res
	}

// LOW: (StellarERCR #1254100: SR6 functions proposed on C4 pinmap, but only present on C6
	def List<Function> getFunctions(Configuration config, Peripheral periph) {
		val list = newArrayList
		val functions = config.functions
		list.addAll(functions.filter [ it |
			it.name.peripheralRef !== null && it.name.peripheralRef.name.equals(periph.name)
		].map[name])
		list
	}
// )
}
