package com.st.stellar.pinmap.pincfg.htmlGenerator.runtime

import com.google.common.collect.HashMultimap
import com.google.common.collect.Multimap
import com.st.stellar.pinmap.validation.PinCfgValidationMessageAcceptor
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EStructuralFeature

class PinSettingsErrorManager extends PinCfgValidationMessageAcceptor {
		public val Multimap<EObject, String> errors
		public val Multimap<EObject, String> infos
		public val Multimap<EObject, String> warnings

		new() {
			super(null)
			errors = HashMultimap.create
			infos = HashMultimap.create
			warnings = HashMultimap.create
			acceptsExternalResource = true
		}

		override collectError(String message, EObject object, EStructuralFeature feature, int index, String code,
			String... issueData) {
			errors.put(object, message)
		}

		override collectError(String message, EObject object, int offset, int length, String code,
			String... issueData) {
			errors.put(object, message)
		}

		override collectInfo(String message, EObject object, EStructuralFeature feature, int index, String code,
			String... issueData) {
			infos.put(object, message)
		}

		override collectInfo(String message, EObject object, int offset, int length, String code, String... issueData) {
			infos.put(object, message)
		}

		override collectWarning(String message, EObject object, EStructuralFeature feature, int index, String code,
			String... issueData) {
			warnings.put(object, message)
		}

		override collectWarning(String message, EObject object, int offset, int length, String code,
			String... issueData) {
			warnings.put(object, message)
		}

	}
