package com.st.stellar.pinmap.pincfg.ui.handler

import com.google.inject.Inject
import com.google.inject.Provider
import org.eclipse.core.commands.AbstractHandler
import org.eclipse.core.commands.ExecutionEvent
import org.eclipse.core.commands.ExecutionException
import org.eclipse.core.resources.IContainer
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.IFolder
import org.eclipse.core.resources.IResource
import org.eclipse.core.runtime.CoreException
import org.eclipse.core.runtime.NullProgressMonitor
import org.eclipse.emf.common.util.URI
import org.eclipse.jface.viewers.IStructuredSelection
import org.eclipse.ui.IFileEditorInput
import org.eclipse.ui.PlatformUI
import org.eclipse.ui.handlers.HandlerUtil
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2
import org.eclipse.xtext.generator.GeneratorContext
import org.eclipse.xtext.generator.IGenerator2
import org.eclipse.xtext.generator.IOutputConfigurationProvider
import org.eclipse.xtext.ui.resource.IResourceSetProvider
import org.eclipse.xtext.util.CancelIndicator

class GenerateHTMLDiagram extends AbstractHandler {

	@Inject IGenerator2 generator;
	@Inject Provider<EclipseResourceFileSystemAccess2> fileAccessProvider;
	@Inject IResourceSetProvider resourceSetProvider;
	@Inject IOutputConfigurationProvider outputCfgProvider

	static class GenerateHTMLDiagramCancelIndicator implements CancelIndicator {

		override isCanceled() {
			return false;
		}

	}

	override execute(ExecutionEvent event) throws ExecutionException {
		val selection = HandlerUtil.getCurrentSelection(event)
		if (selection instanceof IStructuredSelection) {
			val structuredSelection = selection as IStructuredSelection
			val firstElement = structuredSelection.firstElement
			if (firstElement instanceof IFile) {
				val file = firstElement as IFile
				val project = file.project
				val folder = outputCfgProvider.outputConfigurations.toList.get(0).getOutputDirectory()
				val srcGenFolder = project.getFolder(folder)
				if (!srcGenFolder.exists()) {
					createRecursive(srcGenFolder);
				}
				val fsa = fileAccessProvider.get();
				fsa.setOutputPath('./src-gen');
				fsa.setOutputPath("PinCfgCode", './src-gen');
				fsa.monitor = new NullProgressMonitor
				fsa.project = project

				val uri = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
				val rs = resourceSetProvider.get(project);
				val r = rs.getResource(uri, true);

				val genContext = new GeneratorContext
				genContext.cancelIndicator = new GenerateHTMLDiagramCancelIndicator

				generator.doGenerate(r, fsa, genContext);
				refreshProject();
			}
		}
		return null;
	}

	def void createRecursive(IContainer resource) {
		if (!resource.exists()) {
			if (!resource.getParent().exists()) {
				createRecursive(resource.getParent());
			}
			if (resource instanceof IFolder) {
				try {
					(resource as IFolder).create(false, true, new NullProgressMonitor());
				} catch (CoreException e) {
				}
			}
		}
	}

	def refreshProject() {

		val iworkbench = PlatformUI.getWorkbench()
		if (iworkbench !== null) {
			val iworkbenchwindow = iworkbench.activeWorkbenchWindow
			if (iworkbenchwindow !== null) {
				val iworkbenchpage = iworkbenchwindow.activePage
				if (iworkbenchpage !== null) {
					val ieditorpart = iworkbenchpage.activeEditor
					if (ieditorpart !== null) {
						val editorinput = ieditorpart.editorInput

						if (IFileEditorInput.isInstance(editorinput)) {
							val fei = IFileEditorInput.cast(editorinput)
							val project = fei.file.project
							try {
								project.refreshLocal(IResource.DEPTH_INFINITE, null);
							} catch (CoreException ise) {
								// Ignore it...
							}
						}
					}
				}
			}
		}
	}

	override isEnabled() {
		true
	}

}
