/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.ui.autoedit;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.IOFields;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinmapDsl.Configuration;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.DefaultAutoEditStrategyProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PinCfgEditStrategyProvider
extends DefaultAutoEditStrategyProvider {
    @Inject
    private Provider<EObjectAtOffsetHelper> helper;
    @Inject
    private Provider<PinCfgHelper> cfgHelper;
    public static AdaptFieldInstance instance = null;

    protected void configureCurlyBracesBlock(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
    }

    public void configure(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        super.configure(acceptor);
        EObjectAtOffsetHelper _get = (EObjectAtOffsetHelper)this.helper.get();
        PinCfgHelper _get_1 = (PinCfgHelper)this.cfgHelper.get();
        AdaptFieldInstance _adaptFieldInstance = new AdaptFieldInstance(_get, _get_1);
        acceptor.accept((IAutoEditStrategy)_adaptFieldInstance, "__dftl_partition_content_type");
    }

    public static class AdaptFieldInstance
    implements IAutoEditStrategy {
        private EObjectAtOffsetHelper helper;
        private PinCfgHelper cfgHelper;

        public AdaptFieldInstance(EObjectAtOffsetHelper helper, PinCfgHelper cfgHelper) {
            this.helper = helper;
            this.cfgHelper = cfgHelper;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            if (document instanceof IXtextDocument) {
                this.modifyDocument((IXtextDocument)document, command);
            }
        }

        private void modifyDocument(final IXtextDocument document, final DocumentCommand command) {
            document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            IOFields ioFields = this.getIoFieldsAt(state, command.offset);
                            if (ioFields != null) {
                                EObject _eContainer = ioFields.eContainer();
                                PinSetting ps = (PinSetting)_eContainer;
                                this.adaptFieldInstances(ps, document);
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }

        public PinProperties getElementAt(XtextResource resource, int offsetStart) {
            int offset = offsetStart;
            EObject selectedElement = this.helper.resolveElementAt(resource, offset);
            while (selectedElement == null || !(selectedElement instanceof PinProperties)) {
                selectedElement = this.helper.resolveElementAt(resource, --offset);
            }
            if (selectedElement instanceof PinProperties) {
                return (PinProperties)selectedElement;
            }
            return null;
        }

        public XtextResource addComment(final IXtextDocument document, final DocumentCommand command) {
            return (XtextResource)document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression = null;
                    PinProperties config = this.getElementAt(state, command.offset);
                    if (config != null) {
                        int index = cfgHelper.getIndex(config);
                        String before = document.get(0, command.offset);
                        int _length = document.getLength();
                        int _minus = _length - command.offset;
                        String after = document.get(command.offset, _minus);
                        document.set(before + "// index = " + Integer.valueOf(index) + after);
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }

        public void adaptFieldInstances(PinSetting config, IXtextDocument xtextDocument) {
            try {
                if (config == null) {
                    return;
                }
                Configuration pad = config.getPad();
                if (pad == null) {
                    return;
                }
                String id = pad.getName();
                Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
                Matcher matcher = pattern.matcher(id);
                boolean _find = matcher.find();
                if (_find) {
                    int newIndex = Integer.parseInt(matcher.group(2));
                    ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)config.getIoFields());
                    int ioFieldOffset = node.getOffset();
                    int ioFieldLength = node.getLength();
                    String previousIOFieldText = node.getText();
                    Pattern patternIndex = Pattern.compile(".*IO[\n\r\\s]*([A-Z]+)([0-9]*) *=");
                    Matcher matcherIndex = patternIndex.matcher(previousIOFieldText);
                    boolean _find_1 = matcherIndex.find();
                    if (_find_1) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("\\d* *=");
                        String patternReplace = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)newIndex);
                        _builder_1.append(" =");
                        String newIOFieldText = previousIOFieldText.replaceAll(patternReplace, _builder_1.toString());
                        newIOFieldText = newIOFieldText.replaceAll("^\\s*IO", "IO");
                        xtextDocument.replace(ioFieldOffset, ioFieldLength, newIOFieldText);
                    }
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public XtextResource adaptFieldInstances(final IXtextDocument xtextDocument, final int offset, int length, final String pinName) {
            return (XtextResource)xtextDocument.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            IOFields ioFields;
                            Pin pin = this.getPinAt(state, offset);
                            if (pin != null && pin.getName() != null && !pin.getName().equals(pinName) && (ioFields = this.getIoFieldsAt(state, offset)) != null) {
                                EObject _eContainer = ioFields.eContainer();
                                PinSetting ps = (PinSetting)_eContainer;
                                this.adaptFieldInstances(ps, xtextDocument);
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }

        public Integer getPinSettingOffset(IXtextDocument xtextDocument, final int offset) {
            Integer ioFields;
            Integer _xblockexpression = null;
            _xblockexpression = ioFields = (Integer)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Integer, XtextResource>(){

                public Integer exec(XtextResource state) throws Exception {
                    Integer io;
                    Integer _xblockexpression;
                    block2: {
                        _xblockexpression = null;
                        io = null;
                        try {
                            io = this.getIoFieldsOffset(state, offset);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block2;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = io;
                    return _xblockexpression;
                }
            });
            return _xblockexpression;
        }

        public PinSetting getPinSetting(IXtextDocument xtextDocument, final int offset) {
            PinSetting ioFields;
            PinSetting _xblockexpression = null;
            _xblockexpression = ioFields = (PinSetting)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<PinSetting, XtextResource>(){

                public PinSetting exec(XtextResource state) throws Exception {
                    PinSetting io;
                    PinSetting _xblockexpression;
                    block2: {
                        _xblockexpression = null;
                        io = null;
                        try {
                            io = this.getPinSettingAt(state, offset);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block2;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = io;
                    return _xblockexpression;
                }
            });
            return _xblockexpression;
        }

        public PinSetting getPinSettingAt(XtextResource resource, int offsetStart) {
            int offset = offsetStart;
            EObject selectedElement = this.helper.resolveElementAt(resource, offset);
            if (selectedElement instanceof Pin) {
                while (offset > 0 && selectedElement == null || !(selectedElement instanceof PinSetting)) {
                    selectedElement = this.helper.resolveElementAt(resource, --offset);
                }
                if (selectedElement instanceof PinSetting) {
                    return (PinSetting)selectedElement;
                }
            }
            return null;
        }

        public IOFields getIoFieldsAt(XtextResource resource, int offsetStart) {
            int offset = offsetStart;
            EObject selectedElement = this.helper.resolveElementAt(resource, offset);
            if (selectedElement instanceof Pin) {
                while (!(offset >= offsetStart + 2000 || selectedElement != null && selectedElement instanceof IOFields)) {
                    selectedElement = this.helper.resolveElementAt(resource, ++offset);
                }
                if (selectedElement instanceof IOFields) {
                    return (IOFields)selectedElement;
                }
            }
            return null;
        }

        public Integer getIoFieldsOffset(XtextResource resource, int offsetStart) {
            int offset = offsetStart;
            EObject selectedElement = this.helper.resolveElementAt(resource, offset);
            if (selectedElement instanceof Pin) {
                while (selectedElement instanceof Pin) {
                    selectedElement = this.helper.resolveElementAt(resource, --offset);
                }
                return offset;
            }
            return null;
        }

        public Pin getPinAt(XtextResource resource, int offsetStart) {
            int offset = offsetStart;
            EObject selectedElement = this.helper.resolveElementAt(resource, offset);
            if (selectedElement instanceof Pin) {
                return (Pin)selectedElement;
            }
            return null;
        }
    }
}

