/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.pinCfg.Module;
import com.st.stellar.pinmap.pinCfg.PinProperties;
import com.st.stellar.pinmap.pinCfg.PinSetting;
import com.st.stellar.pinmap.pinCfg.provider.PinCfgItemProviderAdapterFactory;
import com.st.stellar.pinmap.pincfg.ui.autoedit.PinCfgEditStrategyProvider;
import com.st.stellar.pinmap.pinmapDsl.Function;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.provider.PinmapDslItemProviderAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.osgi.framework.Bundle;
import org.spiritconsorsium.xml.spiritmodel.Spirit.provider.SpiritItemProviderAdapterFactory;

public class PinCfgEditor
extends XtextEditor {
    static final Logger LOGGER = Logger.getLogger(PinCfgEditor.class);
    private static final String PLUGIN_ID = "com.st.stellar.pinmap.pincfg.ui";
    private static Image mcuImage = PinCfgEditor.getImageDescriptor("icons/mcu.png").createImage();
    private static Image boardImage = PinCfgEditor.getImageDescriptor("icons/board.png").createImage();
    private IPartListener partListener;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = PinCfgEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!PinCfgEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    PinCfgEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            PinCfgEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!PinCfgEditor.this.isDirty()) {
                                PinCfgEditor.this.getSite().getPage().closeEditor((IEditorPart)PinCfgEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    PinCfgEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            PinCfgEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (PinCfgEditor.this.getSite().getPage().getActiveEditor() == PinCfgEditor.this) {
                                PinCfgEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                LOGGER.error((Object)exception);
            }
        }
    };
    protected boolean updateProblemIndication = true;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    @Inject
    Provider<EObjectAtOffsetHelper> helper;
    static String CONFIG_EDITOR_ID = "com.st.stellar.pinmap.PinCfg.config";

    PinCfgEditor() {
        LOGGER.setLevel(Level.DEBUG);
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PinCfgItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PinmapDslItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SpiritItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void init(IEditorSite site, final IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput fei = (FileEditorInput)FileEditorInput.class.cast(input);
        final boolean enabled = fei.getPath().lastSegment().endsWith(".pincfg");
        if (enabled) {
            this.setTitleImage(mcuImage);
        } else {
            this.setTitleImage(boardImage);
        }
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart p) {
                if (p.equals((Object)PinCfgEditor.this)) {
                    Stream<ActionContributionItem> items = Arrays.stream(PinCfgEditor.this.getEditorSite().getActionBars().getToolBarManager().getItems()).filter(ActionContributionItem.class::isInstance).map(ActionContributionItem.class::cast);
                    Optional<ActionContributionItem> open = items.filter(item -> item.getId().equals("com.st.stellar.pinmap.pincfg.ui.editor.OpenDiagram")).findFirst();
                    FileEditorInput fei = (FileEditorInput)FileEditorInput.class.cast(input);
                    open.ifPresent(item -> item.getAction().setEnabled(enabled));
                    open.ifPresent(item -> item.setVisible(enabled));
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        site.getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void updatedTitleImage(Image image) {
        FileEditorInput fei = (FileEditorInput)FileEditorInput.class.cast(this.getEditorInput());
        boolean enabled = fei.getPath().lastSegment().endsWith(".pincfg");
        if (enabled) {
            this.setTitleImage(mcuImage);
        } else {
            this.setTitleImage(boardImage);
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return PinCfgEditor.imageDescriptorFromPlugin(PLUGIN_ID, path);
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor;
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        IWorkbench workbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
        ImageDescriptor imageDescriptor2 = imageDescriptor = workbench == null ? null : workbench.getSharedImages().getImageDescriptor(imageFilePath);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtility.isReady((Bundle)bundle)) {
            return null;
        }
        return ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)imageFilePath).orElse(null);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Conflict", (String)"There are unsaved changes that conflict with changes made outside the editor.  Do you wish to discard this editor's changes?");
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, PLUGIN_ID, 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, PLUGIN_ID, 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(resourceSet.getLoadOptions());
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "com.st.stellar.pinmap.glsp.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
        }
    }

    public PinSetting getPinSettingNearby(XtextResource resource, int startPosition) {
        int position = startPosition;
        EObject selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, position);
        if (selectedElement instanceof PinProperties) {
            return (PinSetting)selectedElement.eContainer();
        }
        if (selectedElement instanceof Function || selectedElement instanceof Pin || selectedElement instanceof Module) {
            while (!(position >= startPosition + 2000 || selectedElement != null && selectedElement instanceof PinSetting)) {
                selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, ++position);
            }
        }
        while (!(position <= 1 || selectedElement != null && selectedElement instanceof PinSetting)) {
            selectedElement = ((EObjectAtOffsetHelper)this.helper.get()).resolveElementAt(resource, --position);
        }
        if (selectedElement instanceof PinSetting) {
            return (PinSetting)selectedElement;
        }
        return null;
    }

    protected void updateStatusLine() {
        super.updateStatusLine();
        new UIJob("setFocus"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                int nbConfigEditors = 0;
                if (window != null && (page = window.getActivePage()) != null) {
                    IEditorReference[] editorReferences;
                    for (IEditorReference editorRef : editorReferences = page.getEditorReferences()) {
                        IEditorPart editorPart = editorRef.getEditor(false);
                        if (editorPart == null || !page.isPartVisible((IWorkbenchPart)editorPart) || !editorPart.getSite().getId().equals(CONFIG_EDITOR_ID)) continue;
                        ++nbConfigEditors;
                    }
                }
                if ((page = PinCfgEditor.this.getEditorSite().getPage()) != null && nbConfigEditors > 0) {
                    page.activate((IWorkbenchPart)PinCfgEditor.this);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    class MyDocumentListener
    implements IDocumentListener {
        MyDocumentListener(PinCfgEditor this$0) {
        }

        public void documentChanged(final DocumentEvent event) {
            IXtextDocument doc;
            PinSetting ps;
            if (event.fDocument instanceof IXtextDocument && event.fLength > 0 && event.fText.length() > 2 && (ps = PinCfgEditStrategyProvider.instance.getPinSetting(doc = (IXtextDocument)event.fDocument, event.getOffset())) != null && ps.getPad().getName().equals(event.getText())) {
                new UIJob(this, "showConsole"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PinCfgEditStrategyProvider.instance.adaptFieldInstances(doc, event.getOffset(), event.getLength(), event.getText() + " ");
                        return Status.OK_STATUS;
                    }
                }.schedule(100L);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }
}

