/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.ui.editor;

import com.st.stellar.pinmap.pincfg.ui.internal.PincfgActivator;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.osgi.framework.Bundle;

public class PinCfgTextEditorActionContributor
extends EditorActionBarContributor {
    private static Logger LOGGER = LogManager.getLogger(PinCfgTextEditorActionContributor.class);
    private ImageRegistry imageRegistry;
    public static final String IMG_MCU = "mcu";
    public static final String OPEN_DIAGRAM_ID = "com.st.stellar.pinmap.pincfg.ui.editor.OpenDiagram";

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        Action openDiagramAction = new Action(this, "OpenDiagram", 1){

            public void run() {
                String commandId = "com.st.stellar.pinmap.PinCfg.openPackageDiagram";
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand(commandId);
                EvaluationContext context = new EvaluationContext(null, (Object)"selection");
                try {
                    command.executeWithChecks(new ExecutionEvent(command, new HashMap(), null, (Object)context));
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {
                    // empty catch block
                }
            }
        };
        openDiagramAction.setId(OPEN_DIAGRAM_ID);
        openDiagramAction.setImageDescriptor(this.objectToImageDescriptor(this.getImage(IMG_MCU)));
        toolBarManager.add((IAction)openDiagramAction);
    }

    protected ImageDescriptor objectToImageDescriptor(Object object) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(object);
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)PincfgActivator.getInstance().getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        return null;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.registerImage(reg, IMG_MCU, "mcu.png");
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }
}

