/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.pincfg.ui.handler;

import com.google.inject.Inject;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.PinConfiguration;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.ConfigurablePin;
import com.st.stellar.pinmap.pinmapDsl.Package;
import com.st.stellar.pinmap.pinmapDsl.Pin;
import com.st.stellar.pinmap.pinmapDsl.PinConfig;
import com.st.stellar.pinmap.pinmapDsl.PinmapModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MigrateConfiguration {
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    private boolean canExecute = true;
    private static final Logger LOG = Logger.getLogger((String)MigrateConfiguration.class.toString());

    public static Object refreshProject() {
        Object _xblockexpression = null;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        Object _xifexpression = null;
        if (iworkbench != null) {
            Object _xblockexpression_1 = null;
            IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
            Object _xifexpression_1 = null;
            if (iworkbenchwindow != null) {
                Object _xblockexpression_2 = null;
                IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
                Object _xifexpression_2 = null;
                if (iworkbenchpage != null) {
                    Object _xblockexpression_3 = null;
                    IEditorPart ieditorpart = iworkbenchpage.getActiveEditor();
                    Object _xifexpression_3 = null;
                    if (ieditorpart != null) {
                        Object _xblockexpression_4 = null;
                        IEditorInput editorinput = ieditorpart.getEditorInput();
                        Object _xifexpression_4 = null;
                        boolean _isInstance = IFileEditorInput.class.isInstance(editorinput);
                        if (_isInstance) {
                            Object _xblockexpression_5 = null;
                            IFileEditorInput fei = (IFileEditorInput)IFileEditorInput.class.cast(editorinput);
                            IProject project = fei.getFile().getProject();
                            Object _xtrycatchfinallyexpression = null;
                            try {
                                project.refreshLocal(2, null);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof CoreException) {
                                    _xtrycatchfinallyexpression = null;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            _xifexpression_4 = _xblockexpression_5 = _xtrycatchfinallyexpression;
                        }
                        _xifexpression_3 = _xblockexpression_4 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Execute
    public void execute(EModelService modelService, EPartService partService, MApplication application) {
        this._pinCfgHelper = PinCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            _document.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block3: {
                        _xblockexpression = null;
                        try {
                            PinConfiguration config = MigrateConfiguration.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                MigrateConfiguration.migrateProject(config, "Pinmap configuration is going to be migrated to latest version. Do you agree?");
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block3;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
            IXtextDocument _document_1 = editor.getDocument();
            _document_1.modify((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(this){

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression = null;
                    IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        service.executeCommand("org.eclipse.xtext.ui.FormatAction", null);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            e.printStackTrace();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }
            });
        }
    }

    @CanExecute
    public boolean canExecute() {
        boolean _xblockexpression = false;
        this._pinCfgHelper = PinCfgHelper.instance;
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            final ITextSelection selection = (ITextSelection)_selection;
            IXtextDocument _document = editor.getDocument();
            abstract class __MigrateConfiguration_3
            implements IUnitOfWork<XtextResource, XtextResource> {
                __MigrateConfiguration_3(MigrateConfiguration this$0) {
                }

                public abstract String getPinSettingVersion(PinConfiguration var1);

                public abstract String getBoardVersion(PinConfiguration var1);
            }
            __MigrateConfiguration_3 ___MigrateConfiguration_3 = new __MigrateConfiguration_3(){
                {
                    super(MigrateConfiguration.this);
                }

                public XtextResource exec(XtextResource state) throws Exception {
                    XtextResource _xblockexpression;
                    block8: {
                        _xblockexpression = null;
                        try {
                            MigrateConfiguration.this.canExecute = false;
                            PinConfiguration config = MigrateConfiguration.this.getElementAt(state, selection.getOffset());
                            if (config != null) {
                                boolean _tripleNotEquals;
                                PinSettings _pinSetting = config.getPinSetting();
                                boolean bl = _tripleNotEquals = _pinSetting != null;
                                if (_tripleNotEquals) {
                                    MigrateConfiguration.this.canExecute = true;
                                    boolean _isIsSetVersion = config.getPinSetting().getIncludedBoard().isIsSetVersion();
                                    if (_isIsSetVersion) {
                                        boolean _not;
                                        String configVersion = config.getPinSetting().getIncludedBoard().getVersion();
                                        String boardVersion = this.getPinSettingVersion(config);
                                        boolean _equals = boardVersion.equals(configVersion);
                                        MigrateConfiguration.this.canExecute = _not = !_equals;
                                    }
                                } else {
                                    boolean _tripleNotEquals_1;
                                    Board _board = config.getBoard();
                                    boolean bl2 = _tripleNotEquals_1 = _board != null;
                                    if (_tripleNotEquals_1) {
                                        MigrateConfiguration.this.canExecute = true;
                                        boolean _isIsSetVersion_1 = config.getBoard().getIncludes().isIsSetVersion();
                                        if (_isIsSetVersion_1) {
                                            boolean _not_1;
                                            String pinmapModelVersion = this.getBoardVersion(config);
                                            Board board = config.getBoard();
                                            String _elvis = null;
                                            String _version = board.getIncludes().getVersion();
                                            _elvis = _version != null ? _version : "";
                                            String usedVersion = _elvis;
                                            boolean _equals_1 = usedVersion.equals(pinmapModelVersion);
                                            MigrateConfiguration.this.canExecute = _not_1 = !_equals_1;
                                        }
                                    }
                                }
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof BadLocationException) break block8;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    _xblockexpression = state;
                    return _xblockexpression;
                }

                @Override
                public String getPinSettingVersion(PinConfiguration config) {
                    String _xblockexpression = null;
                    PinSettings ps = config.getPinSetting();
                    Resource r = PinCfgHelper.getResource((Resource)config.eResource(), (String)ps.getIncludedBoard().getImportURI());
                    boolean _isInstance = PinConfiguration.class.isInstance(r.getContents().get(0));
                    if (_isInstance) {
                        PinConfiguration boardConfig = (PinConfiguration)PinConfiguration.class.cast(r.getContents().get(0));
                        return MigrateConfiguration.this._pinCfgHelper.getIncludes(boardConfig).getVersion();
                    }
                    _xblockexpression = "";
                    return _xblockexpression;
                }

                @Override
                public String getBoardVersion(PinConfiguration config) {
                    String _xblockexpression = null;
                    Board board = config.getBoard();
                    Resource r = PinCfgHelper.getResource((Resource)config.eResource(), (String)board.getIncludes().getImportURI());
                    boolean _isInstance = PinmapModel.class.isInstance(r.getContents().get(0));
                    if (_isInstance) {
                        PinmapModel pinmapModel = (PinmapModel)PinmapModel.class.cast(r.getContents().get(0));
                        String pinmapModelVersion = pinmapModel.getVersion();
                        return pinmapModelVersion;
                    }
                    _xblockexpression = "";
                    return _xblockexpression;
                }
            };
            _document.readOnly((IUnitOfWork)___MigrateConfiguration_3);
        }
        _xblockexpression = this.canExecute;
        return _xblockexpression;
    }

    public PinConfiguration getElementAt(XtextResource resource, int offsetStart) {
        boolean found;
        EObjectAtOffsetHelper eObjectAtOffsetHelper = new EObjectAtOffsetHelper();
        int offset = offsetStart;
        EObject selectedElement = eObjectAtOffsetHelper.resolveContainedElementAt(resource, offset);
        if (selectedElement != null) {
            selectedElement = this.getPinConfiguration(selectedElement);
        }
        if (found = PinConfiguration.class.isInstance(selectedElement)) {
            return (PinConfiguration)PinConfiguration.class.cast(selectedElement);
        }
        return null;
    }

    public PinConfiguration getPinConfiguration(EObject current) {
        EObject parent;
        for (parent = current; parent != null && !PinConfiguration.class.isInstance(parent); parent = parent.eContainer()) {
        }
        if (parent instanceof PinConfiguration) {
            return (PinConfiguration)parent;
        }
        return null;
    }

    public boolean isPlatformPlugin(PinSettings ps) {
        if (ps == null) {
            return false;
        }
        Board board = PinCfgHelper.getBoard((PinSettings)ps);
        URI sourceURI = board.eResource().getURI();
        return sourceURI.isPlatformPlugin();
    }

    public static IFile getGpioFile(PinConfiguration pinSettings) {
        IFile _xblockexpression = null;
        URI uri = pinSettings.eResource().getURI();
        uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
        IFile res = null;
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            String _platformString = uri.toPlatformString(true);
            Path _path = new Path(_platformString);
            res = _root.getFile((IPath)_path);
        } else {
            IWorkspaceRoot _root_1 = ResourcesPlugin.getWorkspace().getRoot();
            String _fileString = uri.toFileString();
            Path _path_1 = new Path(_fileString);
            res = _root_1.getFile((IPath)_path_1);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public static void migrateProject(PinConfiguration currentConfiguration, String title) {
        if (currentConfiguration == null) {
            return;
        }
        boolean _openQuestion = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Migrate configuration", (String)title);
        if (_openQuestion) {
            HashMap<String, String> pinToPadMap = new HashMap<String, String>();
            Package pack = PinCfgHelper.instance.getPack(currentConfiguration);
            Functions.Function1 _function = it -> it.getName();
            List _sortBy = IterableExtensions.sortBy((Iterable)pack.getPins(), (Functions.Function1)_function);
            for (Pin pin : _sortBy) {
                PinConfig pinConfig = (PinConfig)pin.getPinConfigurations().get(0);
                boolean _isInstance = ConfigurablePin.class.isInstance(pinConfig);
                if (!_isInstance) continue;
                ConfigurablePin config = (ConfigurablePin)ConfigurablePin.class.cast(pinConfig);
                pinToPadMap.put(pin.getName(), config.getRef().getName());
            }
            URI uri = currentConfiguration.eResource().getURI();
            uri = currentConfiguration.eResource().getResourceSet().getURIConverter().normalize(uri);
            IFile file = null;
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                String _platformString = uri.toPlatformString(true);
                Path _path = new Path(_platformString);
                file = _root.getFile((IPath)_path);
                IPath location = file.getLocation();
                String oldFile = location.toOSString();
                String newFile = MigrateConfiguration.replaceFileExtension(oldFile, "old");
                MigrateConfiguration.convertPinsToPads(oldFile, newFile, currentConfiguration, pinToPadMap);
            } else {
                IWorkspaceRoot _root_1 = ResourcesPlugin.getWorkspace().getRoot();
                String _fileString = uri.toFileString();
                Path _path_1 = new Path(_fileString);
                file = _root_1.getFile((IPath)_path_1);
                IPath location_1 = file.getFullPath();
                String oldFile_1 = location_1.toOSString();
                String newFile_1 = MigrateConfiguration.replaceFileExtension(oldFile_1, "old");
                MigrateConfiguration.convertPinsToPads(oldFile_1, newFile_1, currentConfiguration, pinToPadMap);
            }
            MigrateConfiguration.refreshProject();
        }
    }

    public static String replaceFileExtension(String filePath, String ext) {
        int lastPeriodIndex;
        boolean _not;
        Object newExtension = ext;
        boolean _startsWith = ((String)newExtension).startsWith(".");
        boolean bl = _not = !_startsWith;
        if (_not) {
            newExtension = "." + (String)newExtension;
        }
        if ((lastPeriodIndex = filePath.lastIndexOf(".")) <= 0) {
            return filePath + (String)newExtension;
        }
        String _substring = filePath.substring(0, lastPeriodIndex);
        return _substring + (String)newExtension;
    }

    public static String replacePinLine(String readLine, HashMap<String, String> pinTpPadMap) {
        String pinName;
        String pad;
        String _xblockexpression = null;
        String line = readLine;
        Pattern pattern = Pattern.compile("^(.*)\\s+([a-zA-Z_0-9]+)\\s*->\\s*([a-zA-Z_0-9]+)\\s*.*$");
        Matcher matcher = pattern.matcher(line);
        boolean _find = matcher.find();
        if (_find && (pad = pinTpPadMap.get(pinName = matcher.group(3))) != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(pinName);
            _builder.append(" replaced by ");
            _builder.append(pad);
            LOG.info((Object)_builder);
            line = line.replaceFirst(pinName, pad);
        }
        _xblockexpression = line;
        return _xblockexpression;
    }

    public static void convertPinsToPads(final String inputFilePath, final String outputFilePath, PinConfiguration configuration, HashMap<String, String> pinToPadMap) {
        IOException e;
        String line;
        BufferedWriter bw;
        BufferedReader br;
        try {
            br = new Functions.Function0<BufferedReader>(){

                public BufferedReader apply() {
                    try {
                        FileReader _fileReader = new FileReader(inputFilePath);
                        return new BufferedReader(_fileReader);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                bw = new Functions.Function0<BufferedWriter>(){

                    public BufferedWriter apply() {
                        try {
                            FileWriter _fileWriter = new FileWriter(outputFilePath);
                            return new BufferedWriter(_fileWriter);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                }.apply();
                try {
                    line = "";
                    while ((line = br.readLine()) != null) {
                        bw.write(line);
                        bw.newLine();
                    }
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            br = new Functions.Function0<BufferedReader>(){

                public BufferedReader apply() {
                    try {
                        FileReader _fileReader = new FileReader(outputFilePath);
                        return new BufferedReader(_fileReader);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                bw = new Functions.Function0<BufferedWriter>(){

                    public BufferedWriter apply() {
                        try {
                            FileWriter _fileWriter = new FileWriter(inputFilePath);
                            return new BufferedWriter(_fileWriter);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                }.apply();
                try {
                    line = "";
                    while ((line = br.readLine()) != null) {
                        line = MigrateConfiguration.replaceVersionLine(line);
                        line = MigrateConfiguration.replaceVersionBoardLine(line);
                        line = MigrateConfiguration.replacePinLine(line, pinToPadMap);
                        bw.write(line);
                        bw.newLine();
                    }
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static String replaceVersionLine(String readLine) {
        String _xblockexpression = null;
        Object line = readLine;
        Pattern pattern = Pattern.compile("^include.*version \"([0-9]*\\.[0-9]*\\.[0-9]*)\"$");
        Matcher matcher = pattern.matcher((CharSequence)line);
        boolean _find = matcher.find();
        if (_find) {
            String replacement = "2.0.0";
            StringConcatenation _builder = new StringConcatenation();
            String _group = matcher.group(1);
            _builder.append(_group);
            _builder.append(" replaced by ");
            _builder.append("2.0.0");
            InputOutput.println((Object)_builder.toString());
            line = ((String)line).replaceFirst(matcher.group(1), "2.0.0");
        } else {
            boolean _startsWith = ((String)line).startsWith("include");
            if (_startsWith) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                _builder_1.append("version \"2.0.0\"");
                String _plus = (String)line + String.valueOf(_builder_1);
                line = _plus;
            }
        }
        _xblockexpression = line;
        return _xblockexpression;
    }

    public static String replaceVersionBoardLine(String readLine) {
        String _xblockexpression = null;
        Object line = readLine;
        Pattern pattern = Pattern.compile("^Board.*version \"([0-9]*\\.[0-9]*\\.[0-9]*)\"$");
        Matcher matcher = pattern.matcher((CharSequence)line);
        boolean _find = matcher.find();
        if (_find) {
            String replacement = "2.0.0";
            StringConcatenation _builder = new StringConcatenation();
            String _group = matcher.group(1);
            _builder.append(_group);
            _builder.append(" replaced by ");
            _builder.append("2.0.0");
            InputOutput.println((Object)_builder.toString());
            line = ((String)line).replaceFirst(matcher.group(1), "2.0.0");
        } else {
            boolean _startsWith = ((String)line).startsWith("Board");
            if (_startsWith) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                _builder_1.append("version \"2.0.0\"");
                String _plus = (String)line + String.valueOf(_builder_1);
                line = _plus;
            }
        }
        _xblockexpression = line;
        return _xblockexpression;
    }
}

