/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.st.stellar.pinmap.helpers.PinCfgHelper;
import com.st.stellar.pinmap.pinCfg.Board;
import com.st.stellar.pinmap.pinCfg.IncludeBoard;
import com.st.stellar.pinmap.pinCfg.PinSettings;
import com.st.stellar.pinmap.pinmapDsl.Family;
import com.st.stellar.pinmap.ui.PinmapOverviewSelectionLinker;
import com.st.stellar.pinmap.ui.PinmapOverviewSelectionProvider;
import com.st.stellar.pinmap.ui.PinmapOverviewSynchronizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class PinmapOverview
extends ViewPart {
    public static final String ID = "com.st.stellar.pinmap.ui.pinmapoverview";
    @Inject
    private PinmapOverviewSynchronizer synchronizer;
    @Inject
    private PinmapOverviewSelectionProvider selectionProvider;
    private Label _label;
    private Image _image;
    private EObject contents;
    @Inject
    @Extension
    private PinCfgHelper _pinCfgHelper;
    @Inject
    private PinmapOverviewSelectionLinker selectionLinker;

    public void createPartControl(Composite parent) {
        this._label = new Label(parent, 16384);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.createActions();
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                PinmapOverview.this.setContents(PinmapOverview.this.contents);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createActions() {
        this.selectionLinker.activate();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.synchronizer.start((IWorkbenchPartSite)site);
    }

    public void dispose() {
        this.selectionLinker.deactivate();
        this.synchronizer.stop(this.getSite());
        super.dispose();
    }

    public void setContents(final EObject newContents) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PinmapOverview.this.contents = newContents;
                if (PinmapOverview.this.contents != null) {
                    if (PinmapOverview.this.contents instanceof PinSettings) {
                        PinSettings pinSettings = (PinSettings)PinmapOverview.this.contents;
                        PinCfgHelper cfr_ignored_0 = PinmapOverview.this._pinCfgHelper;
                        Board board = PinCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard());
                        String n = ((Family)board.getPackage().eContainer()).getName();
                        n = n.replaceAll("x", board.getPackage().getName());
                        String fileName = n + ".png";
                        Object fullPathString = "";
                        URI uri = PinmapOverview.this.contents.eResource().getURI();
                        uri = PinmapOverview.this.contents.eResource().getResourceSet().getURIConverter().normalize(uri);
                        String scheme = uri.scheme();
                        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                            StringBuffer platformResourcePath = new StringBuffer();
                            int size = uri.segmentCount();
                            for (int j = 1; j < size; ++j) {
                                platformResourcePath.append('/');
                                platformResourcePath.append(uri.segment(j));
                            }
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
                            fullPathString = file.getRawLocation().toString() + "/../data-gen/" + fileName;
                            System.out.println((String)fullPathString);
                            PinmapOverview.this._label.setText((String)fullPathString);
                            System.out.println((String)fullPathString);
                            PinmapOverview.this._label.setText((String)fullPathString);
                            ImageDescriptor desc = ImageDescriptor.createFromFile(null, (String)fullPathString);
                            int width = Integer.min(PinmapOverview.this._label.getParent().getSize().x, PinmapOverview.this._label.getParent().getSize().y);
                            ImageDescriptor scaledImage = PinmapOverview.this.scaleImage(Display.getCurrent(), desc, width, width);
                            if (scaledImage != null) {
                                if (PinmapOverview.this._image != null) {
                                    PinmapOverview.this._image.dispose();
                                }
                                PinmapOverview.this._image = scaledImage.createImage();
                                PinmapOverview.this._label.setImage(PinmapOverview.this._image);
                            }
                        }
                    } else {
                        if (PinmapOverview.this._image != null) {
                            PinmapOverview.this._image.dispose();
                        }
                        PinmapOverview.this._image = null;
                        PinmapOverview.this._label.setText("No pinmap image for this editor");
                    }
                }
            }
        });
    }

    ImageDescriptor scaleImage(Display display, ImageDescriptor imageDesc, int maxWidth, int maxHeight) {
        if (imageDesc == null) {
            return null;
        }
        ImageData imageData = imageDesc.getImageData(100);
        if (imageData == null) {
            return imageDesc;
        }
        int newHeight = maxHeight;
        int newWidth = imageData.width * newHeight / imageData.height;
        if (newWidth > maxWidth) {
            newWidth = maxWidth;
            newHeight = imageData.height * newWidth / imageData.width;
        }
        Image newImage = new Image((Device)display, newWidth, newHeight);
        GC gc = new GC((Drawable)newImage);
        Image oldImage = imageDesc.createImage();
        gc.drawImage(oldImage, 0, 0, imageData.width, imageData.height, 0, 0, newWidth, newHeight);
        ImageDescriptor result = ImageDescriptor.createFromImage((Image)newImage);
        oldImage.dispose();
        gc.dispose();
        return result;
    }

    public EObject getContents() {
        return this.contents;
    }

    public void setFocus() {
        this._label.setFocus();
    }

    public Control getControl() {
        return this._label;
    }
}

